/*
 * Decompiled with CFR 0.152.
 */
package com.HUD;

import com.HUD.Base.Text;
import com.HUD.GUIScreen;
import com.HUD.Menu;
import com.misc.Main;
import javax.microedition.lcdui.Graphics;

final class Help
extends GUIScreen {
    private int y0;
    private Main main;
    private Menu menu;
    private Text text;
    private static short toMove = 0;

    public Help(Main main, Menu menu) {
        this.main = main;
        this.menu = menu;
        this.setFont(Main.getFont());
        this.setSoftKeysNames(null, Main.getGameText().getString2("BACK"));
        int x = this.getWidth() / 15;
        int y = this.getHeight() / 13;
        int width = this.getWidth() - x * 2;
        int height = this.getHeight() - y * 2;
        String text = Main.getGameText().getString2("HELP_TEXT").replace('*', '\n');
        this.text = new Text(text, x, y, width, height, Main.getFont());
        this.text.setCentreAlign(true);
        toMove = 0;
        this.pointerPressed = false;
    }

    protected final void paint(Graphics g) {
        if (this.pressUp && toMove == 0 && !this.pointerPressed) {
            toMove = (short)(toMove + Main.getFont().height());
        }
        if (this.pressDown && toMove == 0 && !this.pointerPressed) {
            toMove = (short)(toMove - Main.getFont().height());
        }
        if (toMove != 0 && !this.pointerPressed) {
            this.text.move(Math.max(Math.min(3, toMove), -3));
            toMove = (short)(toMove - Math.max(Math.min(3, toMove), -3));
        }
        this.menu.drawBackground(g);
        this.text.draw(g);
        this.drawSoftKeys(g);
        if (!this.pointerPressed) {
            try {
                Thread.sleep(22L);
                this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final void onRightSoftKey() {
        Main.setCurrent(this.menu);
    }

    protected final void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        this.y0 = y;
    }

    protected final void pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        this.repaint();
    }

    protected final void pointerDragged(int x, int y) {
        x = y - this.y0;
        this.y0 = y;
        toMove = 0;
        this.serviceRepaints();
        this.text.move(x);
        this.repaint();
    }
}

