/*
 * Decompiled with CFR 0.152.
 */
package com.misc;

import com.AI.NPC;
import com.AI.Player;
import com.AI.misc.Blood;
import com.AI.misc.Splinter;
import com.Gameplay.Arsenal;
import com.Gameplay.GameScreen;
import com.Gameplay.Map.RoomObject;
import com.Gameplay.Map.Scene;
import com.Gameplay.Objects.NPCSpawner;
import com.Gameplay.Shop;
import com.Gameplay.Weapon;
import com.HUD.Base.Font;
import com.HUD.Base.Keyboard;
import com.HUD.DeveloperMenu;
import com.HUD.GameHelp;
import com.HUD.Menu;
import com.HUD.MyCanvas.MainCanvas;
import com.HUD.MyCanvas.MyCanvas;
import com.HUD.SplashScreen;
import com.Math.Matrix;
import com.Rendering.Fps;
import com.Rendering.Meshes.Mesh;
import com.Rendering.Meshes.MeshClone;
import com.Rendering.Meshes.MeshImage;
import com.Rendering.MultyTexture;
import com.Rendering.Texture;
import com.misc.Stringer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class Main
extends MIDlet {
    private boolean run = false;
    public static int lastLevel;
    private static Font font;
    public static Stringer gameText;
    public static boolean mipMapping;
    public static String Blood;
    private static String savename;
    public static boolean corpses;
    public static boolean hideHud;
    public static boolean blood;
    public static boolean frameskip;
    public static int displaySize;
    public static boolean fullScreenSight;
    public static float bloodscale;
    public static float splinterscale;
    public static MeshImage zombiemod;
    public static MultyTexture zombietex;
    public static MeshImage bigzombiemod;
    public static MultyTexture bigzombietex;
    public static int zombieanimspeed;
    public static int zombieattackanimspeed;
    public static int zombieprice;
    public static int zombiedamage;
    public static float zombieattackradius;
    public static int zombiejumpheight;
    public static float zombiejumpspeed;
    public static int zombiespeed;
    public static int zombiereacttimer;
    public static int zombieattacktimer;
    public static int zombieai;
    public static int zombieplayerreaction;
    public static int zombieattacktrigger;
    public static int bigzombieanimspeed;
    public static int bigzombieattackanimspeed;
    public static int bigzombiedamage;
    public static float bigzombieattackradius;
    public static int bigzombiejumpheight;
    public static float bigzombiejumpspeed;
    public static int bigzombiejumpheight2;
    public static float bigzombiejumpspeed2;
    public static int bigzombiespeed;
    public static int bigzombiereacttimer;
    public static int bigzombieattacktimer;
    public static int bigzombieai;
    public static int bigzombieplayerreaction;
    public static int bigzombieattacktrigger;
    public static int bigzombieprice;
    public static int offsetsz;
    public static int lang;
    public static int q;
    public static String life_icon;
    public static String hand_icon;
    public static String money_icon;
    public static String patron_icon;
    public static String sight_icon;
    public static String skull_icon;
    public static String background_logo;
    public static String background;
    public static String shop_patron;
    public static String shop_medkit;
    public static String low_life_icon;
    public static String low_patron_icon;
    public static String[] splash;
    public static String[] stepSound;
    public static String jumpSound;
    public static String menuMusic;
    public static boolean canSave;
    public static boolean canSelectLevel;
    public static boolean hasZoom;
    public static boolean levelSelectorLoadData;
    public static boolean pauseScreenSave;
    public static boolean saveState;
    public static int stdFov;
    public static int zoomFov;
    public static String[] langs;
    public static Image bcks;
    public static Image bcks2;
    public static boolean updateOnlyNear;
    public static Stringer settings;
    public static boolean hidesight;
    public static int fogQ;
    public static int pixelsQ;
    public static int persQ;
    public static int availableLevel;
    public static boolean forceLQFog;
    public static boolean originalSight;
    public static boolean originalUseIcon;
    public static int music;
    public static int sounds;
    public static int footsteps;
    public static int mouseSpeed;
    public static boolean isMusic;
    public static boolean isSounds;
    public static boolean isFootsteps;
    public static boolean verticalShopScroll;
    public static MainCanvas mainCanvas;
    public static final int s60Optimization = 0;
    public static boolean l2dRoomRendering;
    public static boolean arcadeJumpPhysics;
    public static boolean fallDamage;
    public static boolean levelCounter;
    public static boolean resizeWeapons;
    public static boolean symbian;

    public static boolean isExist(String file) {
        try {
            InputStream var2 = file.getClass().getResourceAsStream(file);
            if (var2 == null) {
                return false;
            }
            var2.close();
            return true;
        }
        catch (Exception var1) {
            return false;
        }
    }

    protected final void startApp() {
        if (!this.run) {
            this.init();
        }
    }

    private void init() {
        String tmp;
        block16: {
            this.run = true;
            settings = Stringer.createFromResourceWithKeys("/setting.txt");
            savename = settings.getString2("SAVE_NAME", "ZOMBIE");
            DeveloperMenu.debugMode = settings.getInt2("DEBUG", 0) == 1;
            splinterscale = settings.getFloat2("SPLINTER_SCALE", 1.0f);
            bloodscale = settings.getFloat2("BLOOD_SCALE", 1.0f);
            canSave = settings.getInt2("CANSAVE", 1) == 1;
            saveState = settings.getInt2("SAVESTATE", 0) == 1;
            canSelectLevel = settings.getInt2("CANSELECTLEVEL", 1) == 1;
            levelSelectorLoadData = settings.getInt2("LEVELSELECTOR_LOAD_DATA", 1) == 1;
            pauseScreenSave = settings.getInt2("PAUSE_SCREEN_SAVE", 0) == 1;
            tmp = settings.getString2("SHOPSCROLL");
            if (tmp != null) {
                verticalShopScroll = tmp.equals("VERTICAL");
            }
            hidesight = settings.getInt2("HIDESIGHT", 0) == 1;
            menuMusic = settings.getString2("MENU_MUSIC");
            this.setLanguage("/languages/english.txt");
            Splinter.texture = Texture.createTexture(settings.getString("SPLINTER_SPRITE", "/splinter.png"));
            Splinter.cache();
            com.AI.misc.Blood.blood = Texture.createTexture(settings.getString("BLOOD_SPRITE", "/blood.png"));
            tmp = settings.getString("TEXT_BCK");
            if (tmp != null) {
                try {
                    bcks = Image.createImage((String)tmp);
                }
                catch (Exception var3) {
                    System.out.println("No text background");
                }
            }
            if ((tmp = settings.getString("DIALOG_BCK")) != null) {
                try {
                    bcks2 = Image.createImage((String)tmp);
                }
                catch (Exception var3) {
                    System.out.println("No dialog background");
                }
            }
            life_icon = settings.getString("LIFE_ICON", "/life.png");
            low_life_icon = settings.getString("LOW_LIFE_ICON", null);
            money_icon = settings.getString("MONEY_ICON", "/money.png");
            patron_icon = settings.getString("PATRON_ICON", "/patron.png");
            low_patron_icon = settings.getString("LOW_PATRON_ICON", null);
            skull_icon = settings.getString("SKULL_ICON", "/skull.png");
            hand_icon = settings.getString("HAND_ICON", "/hand.png");
            background_logo = settings.getString("BACKGROUND_LOGO", "/background.png");
            background = settings.getString("BACKGROUND", "/background2.png");
            shop_patron = settings.getString("SHOP_PATRON_ICON", "/icon_patron.png");
            shop_medkit = settings.getString("SHOP_MEDKIT_ICON", "/icon_medicine_chest.png");
            splash = Mesh.cutOnStrings(settings.getString("SPLASH", "/splash.png"), ',', ';');
            levelCounter = settings.getInt("COUNT_LEVELS", 0) == 1;
            try {
                if (MeshClone.getNumRecords(savename) != 0) {
                    byte[] var2 = MeshClone.getRecord(savename, 1);
                    ByteArrayInputStream var5 = new ByteArrayInputStream(var2);
                    DataInputStream var6 = new DataInputStream(var5);
                    music = var6.readInt();
                    sounds = var6.readInt();
                    footsteps = var6.readInt();
                    displaySize = var6.readInt();
                    availableLevel = var6.readInt();
                    Main.setPersQ(var6.readInt());
                    fogQ = var6.readInt();
                    pixelsQ = var6.readInt();
                    frameskip = var6.readBoolean();
                    corpses = var6.readBoolean();
                    blood = var6.readBoolean();
                    mipMapping = var6.readBoolean();
                    DeveloperMenu.debugMode = var6.readBoolean();
                    lang = var6.readInt();
                    mouseSpeed = var6.readInt();
                    hideHud = var6.readBoolean();
                    resizeWeapons = var6.readBoolean();
                    lastLevel = var6.readInt();
                    try {
                        int codes = var6.readInt();
                        Keyboard.keyCodes = new int[codes];
                        Keyboard.hasKeyCodes = new boolean[codes];
                        for (int i = 0; i < codes; ++i) {
                            if (!var6.readBoolean()) continue;
                            Keyboard.hasKeyCodes[i] = true;
                            Keyboard.keyCodes[i] = var6.readInt();
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error in keycodes loading");
                        Keyboard.keyCodes = null;
                    }
                    if (Main.isExist("/level" + (lastLevel + 1) + ".txt") || !Main.isExist("/level" + lastLevel + ".txt")) {
                        Main.updateLevelCount();
                    }
                    break block16;
                }
                throw new Exception();
            }
            catch (Exception exc) {
                Main.defaultSettings();
            }
        }
        Shop.initShop();
        tmp = settings.getString2("OPEN_LEVELS");
        if (tmp != null) {
            availableLevel = tmp.equals("ALL") ? lastLevel : Math.max(availableLevel, Stringer.parseInt(tmp));
        }
        langs = Mesh.cutOnStrings(Mesh.getStringFromResource("/languages/languages.txt"), ',');
        if (lang != -1) {
            String path = "/languages/" + langs[lang].toLowerCase() + ".txt";
            this.setLanguage(path);
        }
        mainCanvas = new MainCanvas(this);
        Main.setCurrent(new SplashScreen(this));
    }

    private static void defaultSettings() {
        music = 100;
        sounds = 100;
        footsteps = 100;
        displaySize = 80;
        availableLevel = 1;
        persQ = 2;
        q = 24;
        pixelsQ = 2;
        fogQ = 2;
        corpses = false;
        blood = false;
        mipMapping = true;
        lang = -1;
        mouseSpeed = 66;
        hideHud = false;
        resizeWeapons = settings.getInt2("RESIZE_WEAPONS", 0) == 1;
        symbian = false;
        String platform = System.getProperty("microedition.platform");
        String osName = System.getProperty("os.name");
        if (osName != null) {
            osName = osName.toLowerCase();
            symbian = osName.equals("symbian");
        } else {
            String[] devicesS60 = new String[]{"NokiaE71", "NokiaE66", "NokiaE63", "Nokia6124", "NokiaN95", "NokiaN82", "NokiaN81", "NokiaN76", "NokiaE90", "NokiaE51", "Nokia6290", "Nokia6121", "Nokia6110", "Nokia5700", "NokiaN77", "NokiaE65", "NokiaE61", "NokiaN93", "NokiaN92", "NokiaN91", "NokiaN80", "NokiaN75", "NokiaN73", "NokiaN71", "NokiaE70", "NokiaE62", "NokiaE60", "NokiaE50", "Nokia3250", "NokiaN91", "NokiaN72", "NokiaN90", "NokiaN70", "Nokia6681", "Nokia6680", "Nokia6630"};
            for (int i = 0; i < devicesS60.length; ++i) {
                if (platform.indexOf(devicesS60[i]) <= -1) continue;
                symbian = true;
                break;
            }
        }
        frameskip = !symbian;
        boolean maxQuality = platform.equals("pstros");
        if (!maxQuality && osName != null) {
            boolean bl = maxQuality = osName.indexOf("win") > -1 || osName.indexOf("mac") > -1 || osName.indexOf("nix") > -1 || osName.indexOf("nux") > -1 || osName.indexOf("aix") > -1 || osName.indexOf("android") > -1;
        }
        if (maxQuality) {
            displaySize = 100;
            frameskip = true;
            Main.setPersQ(4);
        }
        Main.updateLevelCount();
    }

    private static void updateLevelCount() {
        lastLevel = 0;
        while (Main.isExist("/level" + (lastLevel + 1) + ".txt")) {
            ++lastLevel;
        }
    }

    protected final void pauseApp() {
        if (mainCanvas.getScreen() instanceof GameScreen) {
            GameScreen scr = (GameScreen)mainCanvas.getScreen();
            scr.openPause();
        }
    }

    protected final void destroyApp(boolean var1) {
    }

    public static final void setCurrent(MyCanvas canvas) {
        mainCanvas.setScreen(canvas);
    }

    public final void setCurrent(Displayable disp) {
        Display.getDisplay((MIDlet)this).setCurrent(disp);
    }

    public final void resetCanvas() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)mainCanvas);
    }

    public final void setCurrentRepaint(MyCanvas canvas) {
        mainCanvas.setScreen(canvas);
        canvas.repaint();
    }

    public final void setLanguage(String file) {
        gameText = Stringer.createFromResource(file);
        font = new Font(gameText.getString2("FONT"));
    }

    public static final Font getFont() {
        return font;
    }

    public static Stringer getGameText() {
        return gameText;
    }

    public static final boolean isFrameskip() {
        return frameskip;
    }

    public static final boolean isCorpses() {
        return corpses;
    }

    public static final boolean isMipMapping() {
        return mipMapping;
    }

    public final boolean isBlood() {
        return blood;
    }

    public static final void setDisplaySize(int size) {
        if (size < 50) {
            size = 50;
        }
        if (size > 100) {
            size = 100;
        }
        displaySize = size;
    }

    public static final int getDisplaySize() {
        return displaySize;
    }

    public final int getAvailableLevelCount() {
        return Math.min(availableLevel, lastLevel);
    }

    public final void setAvailableLevelCount(int i) {
        availableLevel = i;
        this.saveSettingToStore();
    }

    public final void addAvailableLevel(int level) {
        if (level + 1 > availableLevel && level + 1 <= lastLevel) {
            availableLevel = level + 1;
            this.saveSettingToStore();
        }
    }

    public static final boolean isLastLevel(int level) {
        return level >= lastLevel;
    }

    public final void saveSettingToStore() {
        try {
            try {
                RecordStore.deleteRecordStore((String)savename);
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(music);
            dos.writeInt(sounds);
            dos.writeInt(footsteps);
            dos.writeInt(displaySize);
            dos.writeInt(availableLevel);
            dos.writeInt(persQ);
            dos.writeInt(fogQ);
            dos.writeInt(pixelsQ);
            dos.writeBoolean(frameskip);
            dos.writeBoolean(corpses);
            dos.writeBoolean(blood);
            dos.writeBoolean(mipMapping);
            dos.writeBoolean(DeveloperMenu.debugMode);
            dos.writeInt(lang);
            dos.writeInt(mouseSpeed);
            dos.writeBoolean(hideHud);
            dos.writeBoolean(resizeWeapons);
            dos.writeInt(lastLevel);
            dos.writeInt(Keyboard.keyCodes.length);
            for (int i = 0; i < Keyboard.keyCodes.length; ++i) {
                if (Keyboard.hasKeyCodes[i]) {
                    dos.writeBoolean(true);
                    dos.writeInt(Keyboard.keyCodes[i]);
                    continue;
                }
                dos.writeBoolean(false);
            }
            byte[] data = baos.toByteArray();
            dos.close();
            baos.close();
            try {
                RecordStore rs = RecordStore.openRecordStore((String)savename, (boolean)true);
                rs.addRecord(data, 0, data.length);
                rs.closeRecordStore();
            }
            catch (RecordStoreException ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void drawBck(Graphics g, int beginy, int endy) {
        int y;
        if (bcks == null) {
            return;
        }
        int imgh = bcks.getHeight();
        int imgw = bcks.getWidth();
        int iy = 0;
        for (y = beginy - 1; y > beginy - imgh; --y) {
            g.drawRegion(bcks, 0, imgh - 2 - iy, imgw, 1, 0, 0, y, 0);
            ++iy;
        }
        for (y = beginy; y < endy; ++y) {
            g.drawRegion(bcks, 0, imgh - 1, imgw, 1, 0, 0, y, 0);
        }
        iy = imgh - 1;
        for (y = endy; y < endy + imgh; ++y) {
            g.drawRegion(bcks, 0, iy, imgw, 1, 0, 0, y, 0);
            --iy;
        }
    }

    public static void drawBckDialog(Graphics g, int beginy, int endy) {
        int y;
        if (bcks2 == null) {
            return;
        }
        int imgh = bcks2.getHeight();
        int imgw = bcks2.getWidth();
        int iy = 0;
        for (y = beginy - 1; y > beginy - imgh; --y) {
            g.drawRegion(bcks2, 0, imgh - 2 - iy, imgw, 1, 0, 0, y, 0);
            ++iy;
        }
        for (y = beginy; y < endy; ++y) {
            g.drawRegion(bcks2, 0, imgh - 1, imgw, 1, 0, 0, y, 0);
        }
        iy = imgh - 1;
        for (y = endy; y < endy + imgh; ++y) {
            g.drawRegion(bcks2, 0, iy, imgw, 1, 0, 0, y, 0);
            --iy;
        }
    }

    public static final void saveGame(int levelNum, Player player, Scene scene) {
        if (!canSave) {
            return;
        }
        try {
            boolean saveBots;
            int i;
            String savname = savename + "_Player";
            try {
                RecordStore.deleteRecordStore((String)savname);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(-2);
            dos.writeInt(levelNum + 1);
            Matrix pos = player.getCharacter().getTransform();
            dos.writeInt(pos.m03);
            dos.writeInt(pos.m13);
            dos.writeInt(pos.m23);
            player.updateMatrix();
            dos.writeInt((int)Player.rotateY << 12);
            dos.writeInt((int)Player.rotateX << 12);
            dos.writeInt(player.getCharacter().getSpeed().x);
            dos.writeInt(player.getCharacter().getSpeed().y);
            dos.writeInt(player.getCharacter().getSpeed().z);
            dos.writeInt(Player.money);
            dos.writeInt(player.getHp());
            dos.writeInt((int)player.fov);
            dos.writeInt(player.stdFov);
            dos.writeInt(player.zoomFov);
            dos.writeBoolean(player.zoom);
            int weapons = 0;
            int weapons2 = 0;
            Weapon[] weaps = Arsenal.getWeapons();
            if (weaps != null) {
                weapons = weaps.length;
            }
            for (i = 0; i < weapons; ++i) {
                if (weaps[i] == null) continue;
                ++weapons2;
            }
            System.out.println("write weapons count");
            dos.writeInt(weapons2);
            System.out.println("write weapon current");
            dos.writeInt(Arsenal.current);
            for (i = 0; i < weapons; ++i) {
                Weapon weapon = weaps[i];
                if (weapon == null) continue;
                dos.writeInt(i);
                dos.writeShort(weapon.magazine.ammo);
                dos.writeShort(weapon.magazine.rounds);
            }
            System.out.println("write keys");
            if (Player.usedPoints != null) {
                int el = Player.usedPoints.size();
                dos.writeInt(el);
                for (int i2 = 0; i2 < el; ++i2) {
                    dos.writeUTF((String)Player.usedPoints.elementAt(i2));
                }
            } else {
                dos.writeInt(0);
            }
            boolean bl = saveBots = scene.rmsBots != null;
            if (saveBots) {
                boolean bl2 = saveBots = !scene.rmsBots.isEmpty();
            }
            if (saveBots) {
                dos.writeInt(scene.rmsBots.size());
                for (int i3 = 0; i3 < scene.rmsBots.size(); ++i3) {
                    RoomObject obj = (RoomObject)scene.rmsBots.elementAt(i3);
                    if (obj instanceof NPC) {
                        dos.writeBoolean(((NPC)obj).isDead());
                        continue;
                    }
                    if (obj instanceof NPCSpawner) {
                        dos.writeBoolean(((NPCSpawner)obj).deathCheck());
                        continue;
                    }
                    dos.writeBoolean(false);
                }
            } else {
                dos.writeInt(0);
            }
            System.out.println("Game saved");
            byte[] var3 = baos.toByteArray();
            dos.close();
            baos.close();
            byte[] var8 = var3;
            RecordStore rs = RecordStore.openRecordStore((String)savname, (boolean)true);
            rs.addRecord(var8, 0, var8.length);
            rs.closeRecordStore();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final void loadGame(Player player, int w, int h, Scene scene) {
        if (!canSave) {
            return;
        }
        try {
            if (MeshClone.getNumRecords(savename + "_Player") != 0) {
                byte[] data = MeshClone.getRecord(savename + "_Player", 1);
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                DataInputStream dis = new DataInputStream(bais);
                int version = dis.readInt();
                if (version < 0) {
                    dis.readInt();
                }
                if (version >= 0) {
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                } else if (version <= -1) {
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                    dis.readInt();
                }
                Player.money = dis.readInt();
                player.setHp(dis.readInt());
                player.fov = dis.readInt();
                player.stdFov = dis.readInt();
                player.zoomFov = dis.readInt();
                player.zoom = dis.readBoolean();
                int weapc = dis.readInt();
                int current = dis.readInt();
                Arsenal.destroy();
                Arsenal.current = current;
                Weapon[] weapons = new Weapon[Shop.weapon_count];
                for (int i = 0; i < weapc; ++i) {
                    int tw = dis.readInt();
                    weapons[tw] = Stringer.createWeapon(tw);
                    weapons[tw].createSprite(w, h * displaySize / 100);
                    weapons[tw].magazine.set(dis.readShort(), dis.readShort());
                }
                Arsenal.weapons = weapons;
                Player.usedPoints.removeAllElements();
                int objs = dis.readInt();
                for (int i = 0; i < objs; ++i) {
                    Player.usedPoints.addElement(dis.readUTF());
                }
                if (version <= -2) {
                    int savedBots = dis.readInt();
                    if (savedBots == 0) {
                        scene.rmsBotsKilled = null;
                    } else {
                        scene.rmsBotsKilled = new boolean[savedBots];
                        for (int i = 0; i < savedBots; ++i) {
                            scene.rmsBotsKilled[i] = dis.readBoolean();
                        }
                    }
                }
                dis.close();
                bais.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error reading save file");
        }
    }

    public static final void loadPosition(Player player) {
        if (!canSave) {
            return;
        }
        try {
            if (MeshClone.getNumRecords(savename + "_Player") != 0) {
                byte[] data = MeshClone.getRecord(savename + "_Player", 1);
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                DataInputStream dis = new DataInputStream(bais);
                int version = dis.readInt();
                if (version < 0) {
                    dis.readInt();
                }
                if (version >= 0) {
                    player.getCharacter().getTransform().set(dis.readInt() * 0, dis.readInt() * 0, dis.readInt() * 0, dis.readInt(), dis.readInt() * 0, dis.readInt() * 0, dis.readInt() * 0, dis.readInt(), dis.readInt() * 0, dis.readInt() * 0, dis.readInt() * 0, dis.readInt());
                    player.getCharacter().getSpeed().set(dis.readInt(), dis.readInt(), dis.readInt());
                    player.updateMatrix();
                } else if (version <= -1) {
                    player.getCharacter().getTransform().setIdentity();
                    player.getCharacter().getTransform().setPosition(dis.readInt(), dis.readInt(), dis.readInt());
                    Player.rotateY = (float)dis.readInt() / 4096.0f;
                    Player.rotateX = (float)dis.readInt() / 4096.0f;
                    player.getCharacter().getSpeed().set(dis.readInt(), dis.readInt(), dis.readInt());
                    player.updateMatrix();
                }
                dis.close();
                bais.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error reading save file");
        }
    }

    public static final void loadLevel(boolean loadSave, boolean loadpos, int levelNumber, Object hudInfo, Main main, Menu menu) {
        Main.loadLevel(loadSave, loadpos, levelNumber, hudInfo, main, menu, 1);
    }

    public static final void loadLevel(boolean loadSave, boolean loadpos, int levelNumber, Object hudInfo, Main main, Menu menu, int helpState) {
        try {
            System.gc();
            Thread.sleep(5L);
            Fps.reset();
            String add = "";
            if (helpState > 1) {
                add = "_" + Integer.toString(helpState);
            }
            if (Main.getGameText().getString2("GAME_HELP_TEXT_" + Integer.toString(levelNumber) + add) == null && (levelNumber != 1 || !add.equals("") || Main.getGameText().getString2("GAME_HELP_TEXT") == null) && Main.getGameText().getString2("GAME_HELP_PREVIEW_" + Integer.toString(levelNumber) + add) == null && Main.getGameText().getString2("GAME_HELP_BACKGROUND_" + Integer.toString(levelNumber) + add) == null || RoomObject.containsSimple(Player.usedPoints, "GAME_HELP_SCREEN_" + Integer.toString(levelNumber) + add) && Main.getGameText().getInt2("GAME_HELP_VIEW_ONCLE_" + Integer.toString(levelNumber) + add, 0) == 1) {
                if (menu != null) {
                    menu.destroy();
                }
                GameScreen gs = new GameScreen(main, levelNumber, hudInfo);
                if (loadSave) {
                    Main.loadGame(gs.player, gs.getWidth(), gs.getHeight(), gs.scene);
                    if (loadpos) {
                        Main.loadPosition(gs.player);
                    }
                }
                Player.copyNewToUsed();
                gs.start();
                gs.scene.deleteUsedObjects();
                gs.scene.removeKilledBots();
                Main.setCurrent(gs);
            } else {
                Player.toAdd.addElement("GAME_HELP_SCREEN_" + Integer.toString(levelNumber) + add);
                GameHelp gh = new GameHelp(main, menu, levelNumber, hudInfo, helpState);
                GameHelp.loadSave = loadSave;
                GameHelp.loadpos = loadpos;
                Main.setCurrent(gh);
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public static final void removeSave() {
        if (!canSave) {
            return;
        }
        try {
            RecordStore.deleteRecordStore((String)(savename + "_Player"));
        }
        catch (RecordStoreException e) {
            System.out.println("Error removing save file");
        }
    }

    public static final int getContinueLevel() {
        if (!canSave) {
            return 1;
        }
        try {
            if (MeshClone.getNumRecords(savename + "_Player") != 0) {
                byte[] var2 = MeshClone.getRecord(savename + "_Player", 1);
                ByteArrayInputStream var5 = new ByteArrayInputStream(var2);
                DataInputStream var6 = new DataInputStream(var5);
                int lvl = var6.readInt();
                if (lvl < 0) {
                    lvl = var6.readInt();
                }
                return lvl - 1;
            }
            return 1;
        }
        catch (Exception e) {
            System.out.println("Error reading save file");
            return 1;
        }
    }

    public static final boolean hasSave() {
        if (!canSave) {
            return false;
        }
        try {
            if (MeshClone.getNumRecords(savename + "_Player") != 0) {
                byte[] var2 = MeshClone.getRecord(savename + "_Player", 1);
                ByteArrayInputStream var5 = new ByteArrayInputStream(var2);
                DataInputStream var6 = new DataInputStream(var5);
                int lvl = var6.readInt();
                if (lvl < 0) {
                    lvl = var6.readInt();
                }
                if (lvl != 0) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setPersQ(int pq) {
        persQ = pq;
        q = 12;
        if (persQ <= 2) {
            q = 24;
        }
    }

    static {
        mipMapping = true;
        Blood = "/blood.png";
        corpses = false;
        hideHud = false;
        blood = false;
        frameskip = false;
        displaySize = 80;
        fullScreenSight = false;
        zombieanimspeed = 140;
        zombieattackanimspeed = 700;
        zombieprice = 10;
        zombiedamage = 1;
        zombieattackradius = 1.2f;
        zombiejumpheight = 140;
        zombiejumpspeed = 1.2f;
        zombiespeed = 140;
        zombiereacttimer = 8;
        zombieattacktimer = 8;
        zombieai = 1;
        zombieplayerreaction = 2;
        zombieattacktrigger = 2;
        bigzombieanimspeed = 135;
        bigzombieattackanimspeed = 270;
        bigzombiedamage = 7;
        bigzombieattackradius = 1.2f;
        bigzombiejumpheight = 202;
        bigzombiejumpspeed = 1.2f;
        bigzombiejumpheight2 = 202;
        bigzombiejumpspeed2 = 1.5f;
        bigzombiespeed = 135;
        bigzombiereacttimer = 8;
        bigzombieattacktimer = 14;
        bigzombieai = 1;
        bigzombieplayerreaction = 2;
        bigzombieattacktrigger = 2;
        bigzombieprice = 30;
        offsetsz = 0;
        lang = -1;
        q = 24;
        stepSound = null;
        jumpSound = null;
        menuMusic = null;
        canSave = true;
        hasZoom = true;
        levelSelectorLoadData = false;
        pauseScreenSave = false;
        stdFov = 74;
        zoomFov = 44;
        langs = null;
        bcks = null;
        bcks2 = null;
        updateOnlyNear = false;
        fogQ = 2;
        pixelsQ = 2;
        persQ = 2;
        availableLevel = 1;
        forceLQFog = false;
        originalSight = false;
        originalUseIcon = false;
        music = 100;
        sounds = 100;
        footsteps = 100;
        mouseSpeed = 66;
        isMusic = true;
        isSounds = true;
        isFootsteps = true;
        verticalShopScroll = false;
        l2dRoomRendering = false;
        arcadeJumpPhysics = false;
        fallDamage = true;
        levelCounter = true;
        resizeWeapons = false;
        symbian = false;
    }
}

