/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.graphics.pnglib;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import malik.emulator.compression.zlib.CRC32;
import malik.emulator.compression.zlib.Zlib;
import malik.emulator.fileformats.DataEncoder;
import malik.emulator.fileformats.DataHolder;
import malik.emulator.fileformats.EmptyAdapterException;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.OutputAdapter;
import malik.emulator.fileformats.graphics.ImageEncoder;

public final class PNGEncoder
implements OutputAdapter,
DataHolder,
DataEncoder,
ImageEncoder {
    public static final long PNG_SIGNATURE = -8552249625308161526L;
    private static final int HEADER_SIGNATURE = 1229472850;
    private static final int TEXT_SIGNATURE = 1950701684;
    private static final int DATA_SIGNATURE = 1229209940;
    private static final int END_SIGNATURE = 1229278788;
    private boolean alphaSupported;
    private int width;
    private int height;
    private int[] pixels;

    public void saveToOutputStream(OutputStream stream) throws IOException, EmptyAdapterException {
        this.saveToDataStream(new DataOutputStream(stream));
    }

    public void saveToDataStream(DataOutputStream stream) throws IOException, EmptyAdapterException {
        int[] pixels = this.pixels;
        if (this.pixels == null) {
            throw new EmptyAdapterException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 PNG-\u0444\u0430\u0439\u043b\u043e\u0432: \u0430\u0434\u0430\u043f\u0442\u0435\u0440 \u043f\u0443\u0441\u0442.");
        }
        boolean alphaSupported = this.alphaSupported;
        int width = this.width;
        int height = this.height;
        CRC32 checksum = new CRC32();
        ByteArrayOutputStream chunk = new ByteArrayOutputStream(32);
        DataOutputStream chunkOutput = new DataOutputStream(chunk);
        stream.writeLong(-8552249625308161526L);
        chunk.reset();
        chunkOutput.writeInt(1229472850);
        chunkOutput.writeInt(width);
        chunkOutput.writeInt(height);
        chunkOutput.writeByte(8);
        chunkOutput.writeByte(alphaSupported ? 6 : 2);
        chunkOutput.writeByte(0);
        chunkOutput.writeByte(0);
        chunkOutput.writeByte(0);
        byte[] chunkBytes = chunk.toByteArray();
        int length = chunkBytes.length;
        checksum.reset();
        checksum.update(chunkBytes, 0, length);
        stream.writeInt(length - 4);
        stream.write(chunkBytes);
        stream.writeInt(checksum.getValue());
        chunk.reset();
        chunkOutput.writeInt(1950701684);
        chunkOutput.write("Software".getBytes());
        chunkOutput.write(0);
        chunkOutput.write("Malik Emulator https://malik-elaborarer.ru/emulator/".getBytes());
        chunkBytes = chunk.toByteArray();
        length = chunkBytes.length;
        checksum.reset();
        checksum.update(chunkBytes, 0, length);
        stream.writeInt(length - 4);
        stream.write(chunkBytes);
        stream.writeInt(checksum.getValue());
        int offset = alphaSupported ? 4 : 3;
        chunkBytes = new byte[height * (offset * width + 1)];
        int byteIndex = 0;
        int pixelIndex = 0;
        int j = 0;
        while (j < height) {
            chunkBytes[byteIndex++] = 1;
            int i = 0;
            while (i < width) {
                int pixel = pixels[pixelIndex++];
                chunkBytes[byteIndex++] = (byte)(pixel >> 16);
                chunkBytes[byteIndex++] = (byte)(pixel >> 8);
                chunkBytes[byteIndex++] = (byte)pixel;
                if (alphaSupported) {
                    chunkBytes[byteIndex++] = (byte)(pixel >> 24);
                }
                ++i;
            }
            int sbyteIndex = byteIndex - 1;
            i *= offset;
            while (i-- > offset) {
                int n = sbyteIndex;
                chunkBytes[n] = (byte)(chunkBytes[n] - chunkBytes[sbyteIndex - offset]);
                --sbyteIndex;
            }
            ++j;
        }
        chunk.reset();
        chunkOutput.writeInt(1229209940);
        chunkOutput.write(Zlib.compress(chunkBytes, 7));
        chunkBytes = chunk.toByteArray();
        length = chunkBytes.length;
        checksum.reset();
        checksum.update(chunkBytes, 0, length);
        stream.writeInt(length - 4);
        stream.write(chunkBytes);
        stream.writeInt(checksum.getValue());
        chunk.reset();
        chunkOutput.writeInt(1229278788);
        chunkBytes = chunk.toByteArray();
        length = chunkBytes.length;
        checksum.reset();
        checksum.update(chunkBytes, 0, length);
        stream.writeInt(length - 4);
        stream.write(chunkBytes);
        stream.writeInt(checksum.getValue());
    }

    public void clear() {
        this.alphaSupported = false;
        this.width = 0;
        this.height = 0;
        this.pixels = null;
    }

    public boolean isEmpty() {
        return this.pixels == null;
    }

    public void setPixels(boolean alphaSupported, int width, int height, int[] pixels) throws InvalidDataFormatException {
        if (width <= 0 || height <= 0) {
            throw new InvalidDataFormatException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 PNG-\u0444\u0430\u0439\u043b\u043e\u0432: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        if (pixels == null || (long)width * (long)height > (long)pixels.length) {
            throw new InvalidDataFormatException("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 PNG-\u0444\u0430\u0439\u043b\u043e\u0432: \u0434\u043b\u0438\u043d\u0430 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u043f\u0438\u043a\u0441\u0435\u043b\u043e\u0432 \u043c\u0435\u043d\u044c\u0448\u0435 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0445 \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u0432.");
        }
        this.alphaSupported = alphaSupported;
        this.width = width;
        this.height = height;
        this.pixels = pixels;
    }
}

