/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.ui;

import com.nokia.mid.ui.DirectGraphics;
import java.lang.ref.WeakReference;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import malik.emulator.media.graphics.GraphicBuffer;
import malik.emulator.media.graphics.RasterCanvas;

final class DirectGraphicsExtension
implements DirectGraphics {
    private static final int[] GRAPHICS_TO_DIRECT_GRAPHICS_TRANSFORM;
    private static final int[] RASTER_CANVAS_TO_DIRECT_GRAPHICS_TRANSFORM;
    private WeakReference render;
    private RasterCanvas canvas;

    static {
        int[] nArray = new int[16];
        nArray[1] = 24756;
        nArray[2] = 16384;
        nArray[3] = 8372;
        nArray[4] = 8192;
        nArray[5] = 16564;
        nArray[6] = 180;
        nArray[7] = 24576;
        nArray[8] = 16474;
        nArray[9] = 8462;
        nArray[10] = 270;
        nArray[11] = 24666;
        nArray[12] = 90;
        nArray[13] = 24846;
        nArray[14] = 8282;
        nArray[15] = 16654;
        GRAPHICS_TO_DIRECT_GRAPHICS_TRANSFORM = nArray;
        int[] nArray2 = new int[16];
        nArray2[1] = 24756;
        nArray2[2] = 270;
        nArray2[3] = 24666;
        nArray2[4] = 180;
        nArray2[5] = 24576;
        nArray2[6] = 90;
        nArray2[7] = 24846;
        nArray2[8] = 8192;
        nArray2[9] = 16564;
        nArray2[10] = 8282;
        nArray2[11] = 16654;
        nArray2[12] = 16384;
        nArray2[13] = 8372;
        nArray2[14] = 16474;
        nArray2[15] = 8462;
        RASTER_CANVAS_TO_DIRECT_GRAPHICS_TRANSFORM = nArray2;
    }

    private static int toGraphicsTransform(int manipulation) {
        int i = GRAPHICS_TO_DIRECT_GRAPHICS_TRANSFORM.length;
        while (i-- > 0) {
            if (GRAPHICS_TO_DIRECT_GRAPHICS_TRANSFORM[i] != manipulation) continue;
            return i >> 1;
        }
        return -1;
    }

    private static int toRasterCanvasTransform(int manipulation) {
        int i = RASTER_CANVAS_TO_DIRECT_GRAPHICS_TRANSFORM.length;
        while (i-- > 0) {
            if (RASTER_CANVAS_TO_DIRECT_GRAPHICS_TRANSFORM[i] != manipulation) continue;
            return i >> 1;
        }
        return -1;
    }

    DirectGraphicsExtension(Graphics render) {
        this.render = new WeakReference<Graphics>(render);
        this.canvas = render.getCanvas();
    }

    public void drawImage(Image src, int x, int y, int anchor, int manipulation) {
        if (src == null) {
            throw new NullPointerException("DirectGraphics.drawImage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        switch (anchor) {
            default: {
                throw new IllegalArgumentException("DirectGraphics.drawImage: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 anchor.");
            }
            case 0: 
            case 20: {
                break;
            }
            case 6: {
                y -= srcHeight / 2;
                break;
            }
            case 36: {
                y -= srcHeight;
                break;
            }
            case 17: {
                x -= srcWidth / 2;
                break;
            }
            case 3: {
                x -= srcWidth / 2;
                y -= srcHeight / 2;
                break;
            }
            case 33: {
                x -= srcWidth / 2;
                y -= srcHeight;
                break;
            }
            case 24: {
                x -= srcWidth;
                break;
            }
            case 10: {
                x -= srcWidth;
                y -= srcHeight / 2;
                break;
            }
            case 40: {
                x -= srcWidth;
                y -= srcHeight;
            }
        }
        manipulation = DirectGraphicsExtension.toGraphicsTransform(manipulation);
        if (manipulation < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawImage: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 manipulation.");
        }
        Graphics render = (Graphics)this.render.get();
        if (render == null) {
            return;
        }
        render.drawRegion(src, 0, 0, srcWidth, srcHeight, manipulation, x, y, 20);
    }

    public void drawPixels(byte[] src, byte[] transparencyMask, int offset, int scanlength, int left, int top, int width, int height, int manipulation, int format) {
        int dstHeight;
        int dstWidth;
        int[] pixels;
        int newScanlength;
        int newOffset;
        Graphics render;
        int srcLength;
        int srcOffset;
        if (src == null) {
            throw new NullPointerException("DirectGraphics.drawPixels: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        if ((manipulation = DirectGraphicsExtension.toRasterCanvasTransform(manipulation)) < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 manipulation.");
        }
        if (scanlength >= 0) {
            srcOffset = offset;
            srcLength = scanlength * (height - 1) + width;
        } else {
            srcOffset = offset + scanlength * (height - 1);
            srcLength = offset - srcOffset + width;
        }
        int lim = srcOffset + srcLength;
        int len = src.length;
        if (lim > len || lim < srcOffset || srcOffset > len || srcOffset < 0 || transparencyMask != null && (lim > (len = transparencyMask.length) || srcOffset > len)) {
            throw new ArrayIndexOutOfBoundsException("DirectGraphics.drawPixels: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        switch (format) {
            default: {
                throw new IllegalArgumentException("DirectGraphics.drawPixels: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 format.");
            }
            case -1: 
            case 1: 
            case 2: 
            case 4: {
                throw new IllegalArgumentException("DirectGraphics.drawPixels: \u044d\u0442\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0444\u043e\u0440\u043c\u0430\u0442\u044b \u043f\u0438\u043a\u0441\u0435\u043b\u043e\u0432, \u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0433\u043b\u0443\u0431\u0438\u043d\u0430 \u0446\u0432\u0435\u0442\u0430 \u043c\u0435\u043d\u044c\u0448\u0435 8 \u0431\u0438\u0442 \u043d\u0430 \u043f\u0438\u043a\u0441\u0435\u043b.");
            }
            case 8: {
                if (width == 0 || height == 0 || (render = (Graphics)this.render.get()) == null) {
                    return;
                }
                if (scanlength >= -width && scanlength <= width) {
                    newOffset = offset - srcOffset;
                    newScanlength = scanlength;
                    pixels = new int[srcLength];
                    int j = srcOffset;
                    int i = 0;
                    while (i < srcLength) {
                        int p = src[j] & 0xFF;
                        int t = transparencyMask == null ? -1 : transparencyMask[j];
                        pixels[i] = t << 24 | p << 16 | p << 8 | p;
                        ++j;
                        ++i;
                    }
                } else {
                    newOffset = 0;
                    newScanlength = width;
                    pixels = new int[width * height];
                    int i = 0;
                    int dj = scanlength - width;
                    int j = offset;
                    int y = height;
                    while (y-- > 0) {
                        int x = width;
                        while (x-- > 0) {
                            int p = src[j] & 0xFF;
                            int t = transparencyMask == null ? -1 : transparencyMask[j];
                            pixels[i] = t << 24 | p << 16 | p << 8 | p;
                            ++j;
                            ++i;
                        }
                        j += dj;
                    }
                }
                break;
            }
            case 332: {
                if (width == 0 || height == 0 || (render = (Graphics)this.render.get()) == null) {
                    return;
                }
                if (scanlength >= -width && scanlength <= width) {
                    newOffset = offset - srcOffset;
                    newScanlength = scanlength;
                    pixels = new int[srcLength];
                    int j = srcOffset;
                    int i = 0;
                    while (i < srcLength) {
                        byte p = src[j];
                        int t = transparencyMask == null ? -1 : transparencyMask[j];
                        pixels[i] = t << 24 | (p & 0xE0) << 16 | (p & 0x1C) << 11 | (p & 3) << 6;
                        ++j;
                        ++i;
                    }
                } else {
                    newOffset = 0;
                    newScanlength = width;
                    pixels = new int[width * height];
                    int i = 0;
                    int dj = scanlength - width;
                    int j = offset;
                    int y = height;
                    while (y-- > 0) {
                        int x = width;
                        while (x-- > 0) {
                            byte p = src[j];
                            int t = transparencyMask == null ? -1 : transparencyMask[j];
                            pixels[i] = t << 24 | (p & 0xE0) << 16 | (p & 0x1C) << 11 | (p & 3) << 6;
                            ++j;
                            ++i;
                        }
                        j += dj;
                    }
                    break block0;
                }
            }
        }
        if ((manipulation & 1) != 0) {
            dstWidth = height;
            dstHeight = width;
        } else {
            dstWidth = width;
            dstHeight = height;
        }
        int translateX = render.getTranslateX();
        int translateY = render.getTranslateY();
        this.canvas.drawPixelsArea(render.getClipX() + translateX, render.getClipY() + translateY, render.getClipWidth(), render.getClipHeight(), pixels, newOffset, newScanlength, width, height, manipulation, left + translateX, top + translateY, dstWidth, dstHeight, true);
    }

    public void drawPixels(short[] src, boolean transparency, int offset, int scanlength, int left, int top, int width, int height, int manipulation, int format) {
        int dstHeight;
        int dstWidth;
        int[] pixels;
        int newScanlength;
        int newOffset;
        Graphics render;
        int srcLength;
        int srcOffset;
        if (src == null) {
            throw new NullPointerException("DirectGraphics.drawPixels: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        if ((manipulation = DirectGraphicsExtension.toRasterCanvasTransform(manipulation)) < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 manipulation.");
        }
        if (scanlength >= 0) {
            srcOffset = offset;
            srcLength = scanlength * (height - 1) + width;
        } else {
            srcOffset = offset + scanlength * (height - 1);
            srcLength = offset - srcOffset + width;
        }
        int lim = srcOffset + srcLength;
        int len = src.length;
        if (lim > len || lim < srcOffset || srcOffset > len || srcOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("DirectGraphics.drawPixels: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        switch (format) {
            default: {
                throw new IllegalArgumentException("DirectGraphics.drawPixels: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 format.");
            }
            case 444: {
                if (width == 0 || height == 0 || (render = (Graphics)this.render.get()) == null) {
                    return;
                }
                if (scanlength >= -width && scanlength <= width) {
                    newOffset = offset - srcOffset;
                    newScanlength = scanlength;
                    pixels = new int[srcLength];
                    int j = srcOffset;
                    int i = 0;
                    while (i < srcLength) {
                        short p = src[j];
                        pixels[i] = 0xFF000000 | (p & 0xF00) << 12 | (p & 0xF0) << 8 | (p & 0xF) << 4;
                        ++j;
                        ++i;
                    }
                } else {
                    newOffset = 0;
                    newScanlength = width;
                    pixels = new int[width * height];
                    int i = 0;
                    int dj = scanlength - width;
                    int j = offset;
                    int y = height;
                    while (y-- > 0) {
                        int x = width;
                        while (x-- > 0) {
                            short p = src[j];
                            pixels[i] = 0xFF000000 | (p & 0xF00) << 12 | (p & 0xF0) << 8 | (p & 0xF) << 4;
                            ++j;
                            ++i;
                        }
                        j += dj;
                    }
                }
                break;
            }
            case 555: {
                if (width == 0 || height == 0 || (render = (Graphics)this.render.get()) == null) {
                    return;
                }
                if (scanlength >= -width && scanlength <= width) {
                    newOffset = offset - srcOffset;
                    newScanlength = scanlength;
                    pixels = new int[srcLength];
                    int j = srcOffset;
                    int i = 0;
                    while (i < srcLength) {
                        short p = src[j];
                        pixels[i] = 0xFF000000 | (p & 0x7C00) << 9 | (p & 0x3E0) << 6 | (p & 0x1F) << 3;
                        ++j;
                        ++i;
                    }
                } else {
                    newOffset = 0;
                    newScanlength = width;
                    pixels = new int[width * height];
                    int i = 0;
                    int dj = scanlength - width;
                    int j = offset;
                    int y = height;
                    while (y-- > 0) {
                        int x = width;
                        while (x-- > 0) {
                            short p = src[j];
                            pixels[i] = 0xFF000000 | (p & 0x7C00) << 9 | (p & 0x3E0) << 6 | (p & 0x1F) << 3;
                            ++j;
                            ++i;
                        }
                        j += dj;
                    }
                }
                break;
            }
            case 565: {
                if (width == 0 || height == 0 || (render = (Graphics)this.render.get()) == null) {
                    return;
                }
                if (scanlength >= -width && scanlength <= width) {
                    newOffset = offset - srcOffset;
                    newScanlength = scanlength;
                    pixels = new int[srcLength];
                    int j = srcOffset;
                    int i = 0;
                    while (i < srcLength) {
                        short p = src[j];
                        pixels[i] = 0xFF000000 | (p & 0xF800) << 8 | (p & 0x7E0) << 5 | (p & 0x1F) << 3;
                        ++j;
                        ++i;
                    }
                } else {
                    newOffset = 0;
                    newScanlength = width;
                    pixels = new int[width * height];
                    int i = 0;
                    int dj = scanlength - width;
                    int j = offset;
                    int y = height;
                    while (y-- > 0) {
                        int x = width;
                        while (x-- > 0) {
                            short p = src[j];
                            pixels[i] = 0xFF000000 | (p & 0xF800) << 8 | (p & 0x7E0) << 5 | (p & 0x1F) << 3;
                            ++j;
                            ++i;
                        }
                        j += dj;
                    }
                }
                break;
            }
            case 1555: {
                if (width == 0 || height == 0 || (render = (Graphics)this.render.get()) == null) {
                    return;
                }
                if (scanlength >= -width && scanlength <= width) {
                    newOffset = offset - srcOffset;
                    newScanlength = scanlength;
                    pixels = new int[srcLength];
                    int j = srcOffset;
                    int i = 0;
                    while (i < srcLength) {
                        short p = src[j];
                        pixels[i] = (p & Short.MIN_VALUE) << 9 | (p & 0x7C00) << 9 | (p & 0x3E0) << 6 | (p & 0x1F) << 3;
                        ++j;
                        ++i;
                    }
                } else {
                    newOffset = 0;
                    newScanlength = width;
                    pixels = new int[width * height];
                    int i = 0;
                    int dj = scanlength - width;
                    int j = offset;
                    int y = height;
                    while (y-- > 0) {
                        int x = width;
                        while (x-- > 0) {
                            short p = src[j];
                            pixels[i] = (p & Short.MIN_VALUE) << 9 | (p & 0x7C00) << 9 | (p & 0x3E0) << 6 | (p & 0x1F) << 3;
                            ++j;
                            ++i;
                        }
                        j += dj;
                    }
                }
                break;
            }
            case 4444: {
                if (width == 0 || height == 0 || (render = (Graphics)this.render.get()) == null) {
                    return;
                }
                if (scanlength >= -width && scanlength <= width) {
                    newOffset = offset - srcOffset;
                    newScanlength = scanlength;
                    pixels = new int[srcLength];
                    int j = srcOffset;
                    int i = 0;
                    while (i < srcLength) {
                        short p = src[j];
                        pixels[i] = (p & 0xF000) << 16 | (p & 0xF000) << 12 | (p & 0xF00) << 12 | (p & 0xF0) << 8 | (p & 0xF) << 4;
                        ++j;
                        ++i;
                    }
                } else {
                    newOffset = 0;
                    newScanlength = width;
                    pixels = new int[width * height];
                    int i = 0;
                    int dj = scanlength - width;
                    int j = offset;
                    int y = height;
                    while (y-- > 0) {
                        int x = width;
                        while (x-- > 0) {
                            short p = src[j];
                            pixels[i] = (p & 0xF000) << 16 | (p & 0xF000) << 12 | (p & 0xF00) << 12 | (p & 0xF0) << 8 | (p & 0xF) << 4;
                            ++j;
                            ++i;
                        }
                        j += dj;
                    }
                    break block0;
                }
            }
        }
        if ((manipulation & 1) != 0) {
            dstWidth = height;
            dstHeight = width;
        } else {
            dstWidth = width;
            dstHeight = height;
        }
        int translateX = render.getTranslateX();
        int translateY = render.getTranslateY();
        this.canvas.drawPixelsArea(render.getClipX() + translateX, render.getClipY() + translateY, render.getClipWidth(), render.getClipHeight(), pixels, newOffset, newScanlength, width, height, manipulation, left + translateX, top + translateY, dstWidth, dstHeight, transparency);
    }

    public void drawPixels(int[] src, boolean transparency, int offset, int scanlength, int left, int top, int width, int height, int manipulation, int format) {
        int dstHeight;
        int dstWidth;
        Graphics render;
        int srcLength;
        int srcOffset;
        if (src == null) {
            throw new NullPointerException("DirectGraphics.drawPixels: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        if ((manipulation = DirectGraphicsExtension.toRasterCanvasTransform(manipulation)) < 0) {
            throw new IllegalArgumentException("DirectGraphics.drawPixels: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 manipulation.");
        }
        if (scanlength >= 0) {
            srcOffset = offset;
            srcLength = scanlength * (height - 1) + width;
        } else {
            srcOffset = offset + scanlength * (height - 1);
            srcLength = offset - srcOffset + width;
        }
        int lim = srcOffset + srcLength;
        int len = src.length;
        if (lim > len || lim < srcOffset || srcOffset > len || srcOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("DirectGraphics.drawPixels: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        switch (format) {
            default: {
                throw new IllegalArgumentException("DirectGraphics.drawPixels: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 format.");
            }
            case 888: {
                transparency = false;
            }
            case 8888: 
        }
        if (width == 0 || height == 0 || (render = (Graphics)this.render.get()) == null) {
            return;
        }
        if ((manipulation & 1) != 0) {
            dstWidth = height;
            dstHeight = width;
        } else {
            dstWidth = width;
            dstHeight = height;
        }
        int translateX = render.getTranslateX();
        int translateY = render.getTranslateY();
        this.canvas.drawPixelsArea(render.getClipX() + translateX, render.getClipY() + translateY, render.getClipWidth(), render.getClipHeight(), src, offset, scanlength, width, height, manipulation, left + translateX, top + translateY, dstWidth, dstHeight, transparency);
    }

    public void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int colorARGB) {
        this.drawLine(x1, y1, x2, y2, colorARGB);
        this.drawLine(x2, y2, x3, y3, colorARGB);
        this.drawLine(x3, y3, x1, y1, colorARGB);
    }

    public void drawPolygon(int[] xCoords, int xOffset, int[] yCoords, int yOffset, int nPoints, int colorARGB) {
        int y2;
        int x2;
        if (xCoords == null) {
            throw new NullPointerException("DirectGraphics.drawPolygon: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 xCoords \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (yCoords == null) {
            throw new NullPointerException("DirectGraphics.drawPolygon: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 yCoords \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = xOffset + nPoints;
        int len = xCoords.length;
        if (lim > len || lim < xOffset || xOffset > len || xOffset < 0 || (lim = yOffset + nPoints) > (len = yCoords.length) || lim < yOffset || yOffset > len || yOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("DirectGraphics.drawPolygon: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (nPoints <= 0) {
            return;
        }
        int x0 = x2 = xCoords[xOffset];
        int y0 = y2 = yCoords[yOffset];
        int j = yOffset + nPoints - 1;
        int i = xOffset + nPoints - 1;
        int k = nPoints;
        while (k-- > 0) {
            int x1 = k > 0 ? xCoords[i] : x0;
            int y1 = k > 0 ? yCoords[j] : y0;
            this.drawLine(x1, y1, x2, y2, colorARGB);
            x2 = x1;
            y2 = y1;
            --j;
            --i;
        }
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int colorARGB) {
        int tmp;
        int clipHeight;
        int clipWidth;
        Graphics render = (Graphics)this.render.get();
        if (render == null || (clipWidth = render.getClipWidth()) <= 0 || (clipHeight = render.getClipHeight()) <= 0) {
            return;
        }
        int translateX = render.getTranslateX();
        int clipLeft = render.getClipX() + translateX;
        int translateY = render.getTranslateY();
        int clipTop = render.getClipY() + translateY;
        RasterCanvas canvas = this.canvas;
        x1 += translateX;
        x2 += translateX;
        x3 += translateX;
        y2 += translateY;
        if ((y1 += translateY) > (y3 += translateY)) {
            tmp = y1;
            y1 = y3;
            y3 = tmp;
            tmp = x1;
            x1 = x3;
            x3 = tmp;
        }
        if (y1 > y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y2 > y3) {
            tmp = y2;
            y2 = y3;
            y3 = tmp;
            tmp = x2;
            x2 = x3;
            x3 = tmp;
        }
        int ix = x1;
        int ixerr = 0;
        int iyerr = 0;
        int idx = x2 - x1;
        int iincx = idx == 0 ? 0 : (idx < 0 ? -1 : 1);
        int idy = y2 - y1;
        int iincy = idy == 0 ? 0 : (idy < 0 ? -1 : 1);
        idx = idx < 0 ? -idx : idx;
        idy = idy < 0 ? -idy : idy;
        int id = idx >= idy ? idx : idy;
        int jx = x1;
        int jxerr = 0;
        int jyerr = 0;
        int jdx = x3 - x1;
        int jincx = jdx == 0 ? 0 : (jdx < 0 ? -1 : 1);
        int jdy = y3 - y1;
        int jincy = jdy == 0 ? 0 : (jdy < 0 ? -1 : 1);
        jdx = jdx < 0 ? -jdx : jdx;
        jdy = jdy < 0 ? -jdy : jdy;
        int jd = jdx >= jdy ? jdx : jdy;
        int y = y1;
        while (y <= y3) {
            if (y == y2) {
                ix = x2;
                ixerr = 0;
                iyerr = 0;
                idx = x3 - x2;
                iincx = idx == 0 ? 0 : (idx < 0 ? -1 : 1);
                idy = y3 - y2;
                iincy = idy == 0 ? 0 : (idy < 0 ? -1 : 1);
                idx = idx < 0 ? -idx : idx;
                idy = idy < 0 ? -idy : idy;
                int n = id = idx >= idy ? idx : idy;
            }
            if (ix <= jx) {
                canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, ix, y, jx - ix + 1, colorARGB, true);
            } else {
                canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, jx, y, ix - jx + 1, colorARGB, true);
            }
            while (iincy > 0) {
                iyerr += idy;
                if ((ixerr += idx) > id) {
                    ixerr -= id;
                    ix += iincx;
                }
                if (iyerr <= id) continue;
                iyerr -= id;
                break;
            }
            while (jincy > 0) {
                jyerr += jdy;
                if ((jxerr += jdx) > jd) {
                    jxerr -= jd;
                    jx += jincx;
                }
                if (jyerr <= jd) continue;
                jyerr -= jd;
                break;
            }
            ++y;
        }
    }

    public void fillPolygon(int[] xCoords, int xOffset, int[] yCoords, int yOffset, int nPoints, int colorARGB) {
        int y;
        int ymax;
        int clipHeight;
        int clipWidth;
        Graphics render;
        if (xCoords == null) {
            throw new NullPointerException("DirectGraphics.fillPolygon: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 xCoords \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (yCoords == null) {
            throw new NullPointerException("DirectGraphics.fillPolygon: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 yCoords \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = xOffset + nPoints;
        int len = xCoords.length;
        if (lim > len || lim < xOffset || xOffset > len || xOffset < 0 || (lim = yOffset + nPoints) > (len = yCoords.length) || lim < yOffset || yOffset > len || yOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("DirectGraphics.fillPolygon: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (nPoints <= 2 || (render = (Graphics)this.render.get()) == null || (clipWidth = render.getClipWidth()) <= 0 || (clipHeight = render.getClipHeight()) <= 0) {
            return;
        }
        int translateX = render.getTranslateX();
        int clipLeft = render.getClipX() + translateX;
        int translateY = render.getTranslateY();
        int clipTop = render.getClipY() + translateY;
        RasterCanvas canvas = this.canvas;
        int[] px = new int[nPoints + 1];
        int[] py = new int[nPoints + 1];
        int[] ix = new int[nPoints & 0xFFFFFFFE];
        Array.copy((int[])xCoords, (int)xOffset, (int[])px, (int)0, (int)nPoints);
        Array.copy((int[])yCoords, (int)yOffset, (int[])py, (int)0, (int)nPoints);
        px[nPoints] = px[0];
        py[nPoints] = py[0];
        int ymin = ymax = py[0];
        int i = nPoints;
        while (i-- > 0) {
            y = py[i];
            if (ymin > y) {
                ymin = y;
            }
            if (ymax >= y) continue;
            ymax = y;
        }
        y = ymin;
        while (y < ymax) {
            int j;
            int x2;
            int ixnm = 0;
            int x1 = px[nPoints];
            int y1 = py[nPoints];
            i = nPoints;
            block6: while (i-- > 0) {
                x2 = x1;
                int y2 = y1;
                x1 = px[i];
                y1 = py[i];
                if (y < (y1 <= y2 ? y1 : y2) || y >= (y1 >= y2 ? y1 : y2)) continue;
                int x = x1 + (x2 - x1) * (y - y1) / (y2 - y1);
                block0 : switch (ixnm) {
                    default: {
                        if (x > ix[ixnm - 1]) {
                            ix[ixnm++] = x;
                            break;
                        }
                        j = 0;
                        while (j < ixnm) {
                            if (x < ix[j]) {
                                Array.copy((int[])ix, (int)j, (int[])ix, (int)(j + 1), (int)(ixnm++ - j));
                                ix[j] = x;
                                break block0;
                            }
                            ++j;
                        }
                        continue block6;
                    }
                    case 1: {
                        if (x < ix[0]) {
                            ix[ixnm++] = ix[0];
                            ix[0] = x;
                            break;
                        }
                    }
                    case 0: {
                        ix[ixnm++] = x;
                    }
                }
            }
            j = ixnm;
            while ((j -= 2) >= 0) {
                x1 = ix[j];
                x2 = ix[j + 1];
                if (x1 >= x2) continue;
                canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, x1 + translateX, y + translateY, x2 - x1, colorARGB, true);
            }
            ++y;
        }
    }

    public void setARGBColor(int colorARGB) {
        Graphics render = (Graphics)this.render.get();
        if (render != null) {
            render.setColor(colorARGB);
        }
    }

    public void getPixels(byte[] dst, byte[] transparencyMask, int offset, int scanlength, int left, int top, int width, int height, int format) {
        RasterCanvas canvas;
        GraphicBuffer buffer;
        int dstLength;
        int dstOffset;
        if (dst == null) {
            throw new NullPointerException("DirectGraphics.getPixels: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (scanlength > -width && scanlength < width) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0434\u043b\u0438\u043d\u0430 \u043b\u0438\u043d\u0438\u0438 \u0441\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0448\u0438\u0440\u0438\u043d\u044b.");
        }
        if (scanlength >= 0) {
            dstOffset = offset;
            dstLength = scanlength * (height - 1) + width;
        } else {
            dstOffset = offset + scanlength * (height - 1);
            dstLength = offset - dstOffset + width;
        }
        int lim = dstOffset + dstLength;
        int len = dst.length;
        if (lim > len || lim < dstOffset || dstOffset > len || dstOffset < 0 || transparencyMask != null && (lim > (len = transparencyMask.length) || dstOffset > len)) {
            throw new ArrayIndexOutOfBoundsException("DirectGraphics.getPixels: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        Graphics render = (Graphics)this.render.get();
        if (render != null) {
            left += render.getTranslateX();
            top += render.getTranslateY();
        }
        if ((lim = left + width) > (len = (buffer = (canvas = this.canvas).getBuffer()).getWidth()) || lim < left || left > len || left < 0 || (lim = top + height) > (len = buffer.getHeight()) || lim < top || top > len || top < 0) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0439 \u043a\u0430\u043d\u0432\u044b.");
        }
        if (width == 0 || height == 0) {
            return;
        }
        boolean opaque = canvas.isScreenCanvas();
        int[] src = buffer.getPixels();
        int srcOffset = buffer.getOffset();
        int srcScanlength = buffer.getScanlength();
        switch (format) {
            default: {
                throw new IllegalArgumentException("DirectGraphics.getPixels: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 format.");
            }
            case -1: 
            case 1: 
            case 2: 
            case 4: {
                throw new IllegalArgumentException("DirectGraphics.getPixels: \u044d\u0442\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0444\u043e\u0440\u043c\u0430\u0442\u044b \u043f\u0438\u043a\u0441\u0435\u043b\u043e\u0432, \u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0433\u043b\u0443\u0431\u0438\u043d\u0430 \u0446\u0432\u0435\u0442\u0430 \u043c\u0435\u043d\u044c\u0448\u0435 8 \u0431\u0438\u0442 \u043d\u0430 \u043f\u0438\u043a\u0441\u0435\u043b.");
            }
            case 8: {
                int dj = srcScanlength - width;
                int j = srcOffset + srcScanlength * top + left;
                int di = scanlength - width;
                int i = offset;
                int y = height;
                while (y-- > 0) {
                    int x = width;
                    while (x-- > 0) {
                        int p = src[j];
                        dst[i] = (byte)(76 * (p >> 16 & 0xFF) + 152 * (p >> 8 & 0xFF) + 28 * (p & 0xFF) >> 8);
                        if (transparencyMask != null) {
                            transparencyMask[i] = (byte)(opaque ? -1 : (byte)(p >> 24));
                        }
                        ++j;
                        ++i;
                    }
                    j += dj;
                    i += di;
                }
                break;
            }
            case 332: {
                int dj = srcScanlength - width;
                int j = srcOffset + srcScanlength * top + left;
                int di = scanlength - width;
                int i = offset;
                int y = height;
                while (y-- > 0) {
                    int x = width;
                    while (x-- > 0) {
                        int p = src[j];
                        dst[i] = (byte)((p & 0xE00000) >> 16 | (p & 0xE000) >> 11 | (p & 0xC0) >> 6);
                        if (transparencyMask != null) {
                            transparencyMask[i] = (byte)(opaque ? -1 : (byte)(p >> 24));
                        }
                        ++j;
                        ++i;
                    }
                    j += dj;
                    i += di;
                }
                break block0;
            }
        }
    }

    public void getPixels(short[] dst, int offset, int scanlength, int left, int top, int width, int height, int format) {
        RasterCanvas canvas;
        GraphicBuffer buffer;
        int dstLength;
        int dstOffset;
        if (dst == null) {
            throw new NullPointerException("DirectGraphics.getPixels: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (scanlength > -width && scanlength < width) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0434\u043b\u0438\u043d\u0430 \u043b\u0438\u043d\u0438\u0438 \u0441\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0448\u0438\u0440\u0438\u043d\u044b.");
        }
        if (scanlength >= 0) {
            dstOffset = offset;
            dstLength = scanlength * (height - 1) + width;
        } else {
            dstOffset = offset + scanlength * (height - 1);
            dstLength = offset - dstOffset + width;
        }
        int lim = dstOffset + dstLength;
        int len = dst.length;
        if (lim > len || lim < dstOffset || dstOffset > len || dstOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("DirectGraphics.getPixels: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        Graphics render = (Graphics)this.render.get();
        if (render != null) {
            left += render.getTranslateX();
            top += render.getTranslateY();
        }
        if ((lim = left + width) > (len = (buffer = (canvas = this.canvas).getBuffer()).getWidth()) || lim < left || left > len || left < 0 || (lim = top + height) > (len = buffer.getHeight()) || lim < top || top > len || top < 0) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0439 \u043a\u0430\u043d\u0432\u044b.");
        }
        if (width == 0 || height == 0) {
            return;
        }
        boolean opaque = canvas.isScreenCanvas();
        int[] src = buffer.getPixels();
        int srcOffset = buffer.getOffset();
        int srcScanlength = buffer.getScanlength();
        switch (format) {
            default: {
                throw new IllegalArgumentException("DirectGraphics.getPixels: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 format.");
            }
            case 444: {
                int dj = srcScanlength - width;
                int j = srcOffset + srcScanlength * top + left;
                int di = scanlength - width;
                int i = offset;
                int y = height;
                while (y-- > 0) {
                    int x = width;
                    while (x-- > 0) {
                        int p = src[j];
                        dst[i] = (short)((p & 0xF00000) >> 12 | (p & 0xF000) >> 8 | (p & 0xF0) >> 4);
                        ++j;
                        ++i;
                    }
                    j += dj;
                    i += di;
                }
                break;
            }
            case 555: {
                int dj = srcScanlength - width;
                int j = srcOffset + srcScanlength * top + left;
                int di = scanlength - width;
                int i = offset;
                int y = height;
                while (y-- > 0) {
                    int x = width;
                    while (x-- > 0) {
                        int p = src[j];
                        dst[i] = (short)((p & 0xF80000) >> 9 | (p & 0xF800) >> 6 | (p & 0xF8) >> 3);
                        ++j;
                        ++i;
                    }
                    j += dj;
                    i += di;
                }
                break;
            }
            case 565: {
                int dj = srcScanlength - width;
                int j = srcOffset + srcScanlength * top + left;
                int di = scanlength - width;
                int i = offset;
                int y = height;
                while (y-- > 0) {
                    int x = width;
                    while (x-- > 0) {
                        int p = src[j];
                        dst[i] = (short)((p & 0xF80000) >> 8 | (p & 0xFC00) >> 5 | (p & 0xF8) >> 3);
                        ++j;
                        ++i;
                    }
                    j += dj;
                    i += di;
                }
                break;
            }
            case 1555: {
                int dj = srcScanlength - width;
                int j = srcOffset + srcScanlength * top + left;
                int di = scanlength - width;
                int i = offset;
                int y = height;
                while (y-- > 0) {
                    int x = width;
                    while (x-- > 0) {
                        int p = src[j];
                        dst[i] = (short)((opaque || p >>> 24 >= 128 ? 32768 : 0) | (p & 0xF80000) >> 9 | (p & 0xF800) >> 6 | (p & 0xF8) >> 3);
                        ++j;
                        ++i;
                    }
                    j += dj;
                    i += di;
                }
                break;
            }
            case 4444: {
                int dj = srcScanlength - width;
                int j = srcOffset + srcScanlength * top + left;
                int di = scanlength - width;
                int i = offset;
                int y = height;
                while (y-- > 0) {
                    int x = width;
                    while (x-- > 0) {
                        int p = src[j];
                        dst[i] = (short)((opaque ? 61440 : (p & 0xF0000000) >> 16) | (p & 0xF00000) >> 12 | (p & 0xF000) >> 8 | (p & 0xF0) >> 4);
                        ++j;
                        ++i;
                    }
                    j += dj;
                    i += di;
                }
                break block0;
            }
        }
    }

    public void getPixels(int[] dst, int offset, int scanlength, int left, int top, int width, int height, int format) {
        RasterCanvas canvas;
        GraphicBuffer buffer;
        int dstLength;
        int dstOffset;
        if (dst == null) {
            throw new NullPointerException("DirectGraphics.getPixels: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (scanlength > -width && scanlength < width) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0434\u043b\u0438\u043d\u0430 \u043b\u0438\u043d\u0438\u0438 \u0441\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435 \u0448\u0438\u0440\u0438\u043d\u044b.");
        }
        if (scanlength >= 0) {
            dstOffset = offset;
            dstLength = scanlength * (height - 1) + width;
        } else {
            dstOffset = offset + scanlength * (height - 1);
            dstLength = offset - dstOffset + width;
        }
        int lim = dstOffset + dstLength;
        int len = dst.length;
        if (lim > len || lim < dstOffset || dstOffset > len || dstOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("DirectGraphics.getPixels: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        Graphics render = (Graphics)this.render.get();
        if (render != null) {
            left += render.getTranslateX();
            top += render.getTranslateY();
        }
        if ((lim = left + width) > (len = (buffer = (canvas = this.canvas).getBuffer()).getWidth()) || lim < left || left > len || left < 0 || (lim = top + height) > (len = buffer.getHeight()) || lim < top || top > len || top < 0) {
            throw new IllegalArgumentException("DirectGraphics.getPixels: \u0437\u0430\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0430\u044f \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0439 \u043a\u0430\u043d\u0432\u044b.");
        }
        if (width == 0 || height == 0) {
            return;
        }
        boolean opaque = canvas.isScreenCanvas();
        int[] src = buffer.getPixels();
        int srcOffset = buffer.getOffset();
        int srcScanlength = buffer.getScanlength();
        switch (format) {
            default: {
                throw new IllegalArgumentException("DirectGraphics.getPixels: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 format.");
            }
            case 888: {
                int dj = srcScanlength - width;
                int j = srcOffset + srcScanlength * top + left;
                int di = scanlength - width;
                int i = offset;
                int y = height;
                while (y-- > 0) {
                    int x = width;
                    while (x-- > 0) {
                        int p = src[j];
                        dst[i] = p & 0xFFFFFF;
                        ++j;
                        ++i;
                    }
                    j += dj;
                    i += di;
                }
                break;
            }
            case 8888: {
                int dj = srcScanlength - width;
                int j = srcOffset + srcScanlength * top + left;
                int di = scanlength - width;
                int i = offset;
                int y = height;
                while (y-- > 0) {
                    int x = width;
                    while (x-- > 0) {
                        int p = src[j];
                        dst[i] = opaque ? p | 0xFF000000 : p;
                        ++j;
                        ++i;
                    }
                    j += dj;
                    i += di;
                }
                break block0;
            }
        }
    }

    public int getNativePixelFormat() {
        return this.canvas.isScreenCanvas() ? 888 : 8888;
    }

    public int getAlphaComponent() {
        return 255;
    }

    private void drawLine(int x1, int y1, int x2, int y2, int color) {
        int clipHeight;
        Graphics render = (Graphics)this.render.get();
        if (render == null) {
            return;
        }
        RasterCanvas canvas = this.canvas;
        int translateX = render.getTranslateX();
        int tmp = render.getClipX() + translateX;
        int clipLeft = Math.max(tmp, 0);
        int clipRight = Math.min(tmp + render.getClipWidth(), canvas.getWidth());
        int translateY = render.getTranslateY();
        tmp = render.getClipY() + translateY;
        int clipTop = Math.max(tmp, 0);
        int clipBottom = Math.min(tmp + render.getClipHeight(), canvas.getHeight());
        int clipWidth = clipRight - clipLeft;
        if (clipWidth <= 0 || (clipHeight = clipBottom - clipTop) <= 0) {
            return;
        }
        color = color & 0xFFFFFF | (canvas.isScreenCanvas() ? 0 : -16777216);
        y1 += translateY;
        y2 += translateY;
        if ((x1 += translateX) == (x2 += translateX)) {
            if (y1 <= y2) {
                canvas.drawVertLine(clipLeft, clipTop, clipWidth, clipHeight, x1, y1, y2 - y1 + 1, color, false);
                return;
            }
            canvas.drawVertLine(clipLeft, clipTop, clipWidth, clipHeight, x2, y2, y1 - y2 + 1, color, false);
            return;
        }
        if (y1 == y2) {
            if (x1 <= x2) {
                canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, x1, y1, x2 - x1 + 1, color, false);
                return;
            }
            canvas.drawHorzLine(clipLeft, clipTop, clipWidth, clipHeight, x2, y2, x1 - x2 + 1, color, false);
            return;
        }
        int x = x1;
        int y = y1;
        int xerr = 0;
        int yerr = 0;
        int dx = x2 - x1;
        int incx = dx == 0 ? 0 : (dx < 0 ? -1 : 1);
        int dy = y2 - y1;
        int incy = dy == 0 ? 0 : (dy < 0 ? -1 : 1);
        dx = dx < 0 ? -dx : dx;
        dy = dy < 0 ? -dy : dy;
        int d = dx >= dy ? dx : dy;
        GraphicBuffer buffer = canvas.getBuffer();
        int ofs = buffer.getOffset();
        int scan = buffer.getScanlength();
        int[] pixels = buffer.getPixels();
        int i = 0;
        while (i <= d) {
            yerr += dy;
            if ((xerr += dx) > d) {
                xerr -= d;
                x += incx;
            }
            if (yerr > d) {
                yerr -= d;
                y += incy;
            }
            if (x >= clipLeft && x < clipRight && y >= clipTop && y < clipBottom) {
                pixels[ofs + x + y * scan] = color;
            }
            ++i;
        }
    }
}

