/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected int pos;
    protected int mark;
    protected int count;
    protected byte[] buf;

    public ByteArrayInputStream(byte[] buffer) {
        this.pos = 0;
        this.mark = 0;
        this.count = buffer == null ? 0 : buffer.length;
        this.buf = buffer;
    }

    public ByteArrayInputStream(byte[] buffer, int offset, int length) {
        this.pos = offset;
        this.mark = offset;
        this.count = offset + length;
        this.buf = buffer;
    }

    public void close() throws IOException {
    }

    public void reset() {
        this.pos = this.mark;
    }

    public void mark(int readLimit) {
        this.mark = this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() {
        int p = this.pos;
        if (p < this.count) {
            this.pos = p + 1;
            return this.buf[p] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] dst) throws IOException {
        if (dst == null) {
            throw new NullPointerException("ByteArrayInputStream.read: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int length = dst.length;
        if (length <= 0) {
            return 0;
        }
        int p = this.pos;
        int c = this.count;
        if (p >= c) {
            return -1;
        }
        int avail = c - p;
        if (length > avail) {
            length = avail;
        }
        Array.copy(this.buf, p, dst, 0, length);
        this.pos = p + length;
        return length;
    }

    public int read(byte[] dst, int offset, int length) {
        if (dst == null) {
            throw new NullPointerException("ByteArrayInputStream.read: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("ByteArrayInputStream.read: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (length <= 0) {
            return 0;
        }
        int p = this.pos;
        int c = this.count;
        if (p >= c) {
            return -1;
        }
        int avail = c - p;
        if (length > avail) {
            length = avail;
        }
        Array.copy(this.buf, p, dst, offset, length);
        this.pos = p + length;
        return length;
    }

    public int available() {
        return this.count - this.pos;
    }

    public long skip(long bytesCount) {
        if (bytesCount <= 0L) {
            return 0L;
        }
        int p = this.pos;
        long avail = this.count - p;
        if (bytesCount > avail) {
            bytesCount = avail;
        }
        this.pos = (int)((long)p + bytesCount);
        return bytesCount;
    }
}

