/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Reader {
    private static final int MAX_SKIP_BUFFER_SIZE = 8192;
    protected Object lock;
    private char[] skipBuffer;

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object lock) {
        if (lock == null) {
            throw new NullPointerException("Reader: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 lock \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.lock = lock;
    }

    public abstract void close() throws IOException;

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    public void reset() throws IOException {
        throw new IOException("Reader.reset: \u043a\u043b\u0430\u0441\u0441 " + this.getClass().getName() + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043c\u0435\u0442\u043e\u0434 reset.");
    }

    public void mark(int readLimit) throws IOException {
        throw new IOException("Reader.mark: \u043a\u043b\u0430\u0441\u0441 " + this.getClass().getName() + " \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043c\u0435\u0442\u043e\u0434 mark.");
    }

    public boolean markSupported() {
        return false;
    }

    public boolean ready() throws IOException {
        return false;
    }

    public int read() throws IOException {
        char[] result = new char[1];
        return this.read(result, 0, 1) == -1 ? -1 : result[0];
    }

    public int read(char[] dst) throws IOException {
        if (dst == null) {
            throw new NullPointerException("Reader.read: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return this.read(dst, 0, dst.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long charsCount) throws IOException {
        long r;
        if (charsCount < 0L) {
            throw new IllegalArgumentException("Reader.skip: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 charsCount \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        int nn = charsCount <= 8192L ? (int)charsCount : 8192;
        Object object = this.lock;
        synchronized (object) {
            char[] c = this.skipBuffer;
            if (this.skipBuffer == null || c.length < nn) {
                this.skipBuffer = c = new char[nn];
            }
            r = charsCount;
            while (r > 0L) {
                int nc = this.read(c, 0, r <= (long)nn ? (int)r : nn);
                if (nc == -1) break;
                r -= (long)nc;
            }
        }
        return charsCount - r;
    }
}

