/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Queue;

public class QueueOfObjects
extends Queue {
    private static final int INITIAL_CAPACITY = 17;
    protected Object[] queue;

    public QueueOfObjects() {
        super(17);
        this.queue = new Object[17];
    }

    public QueueOfObjects(int capacity) {
        super(++capacity);
        this.queue = new Object[capacity];
    }

    public void removeTailElement() {
        this.queue[this.tail] = null;
        this.advanceTail();
    }

    public void clear() {
        int h = this.head;
        int c = this.capacity;
        Object[] q = this.queue;
        int i = this.tail;
        while (i != h) {
            q[i] = null;
            i = (i + 1) % c;
        }
        super.clear();
    }

    public void push(Object element) {
        Object[] q = this.queue;
        if (this.getFreeElements() == 0) {
            int nc = (this.capacity << 1) - 1;
            this.queue = this.expand(q, nc);
            q = this.queue;
            this.reset(nc);
        }
        q[this.head] = element;
        this.advanceHead();
    }

    public Object peek() {
        return this.queue[this.tail];
    }
}

