/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.TimerTask;
import java.util.TimerThread;

public class Timer {
    private TimerThread thread;

    public Timer() {
        TimerThread t;
        this.thread = t = new TimerThread();
        t.start();
    }

    public void schedule(TimerTask task, long delay) {
        long time;
        if (task == null) {
            throw new NullPointerException("Timer.schedule: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 task \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (delay < 0L || (time = System.currentTimeMillis() + delay) < 0L) {
            throw new IllegalArgumentException("Timer.schedule: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 delay.");
        }
        TimerThread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("Timer.schedule: \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u0434\u0430\u0447 \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        }
        thread.schedule(task, time);
    }

    public void schedule(TimerTask task, Date execTime) {
        if (task == null) {
            throw new NullPointerException("Timer.schedule: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 task \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (execTime == null) {
            throw new NullPointerException("Timer.schedule: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 execTime \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        long time = execTime.getTime();
        if (time < 0L) {
            throw new IllegalArgumentException("Timer.schedule: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f execTime.getTime().");
        }
        TimerThread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("Timer.schedule: \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u0434\u0430\u0447 \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        }
        thread.schedule(task, time);
    }

    public void schedule(TimerTask task, long delay, long period) {
        long time;
        if (task == null) {
            throw new NullPointerException("Timer.schedule: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 task \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (delay < 0L || (time = System.currentTimeMillis() + delay) < 0L) {
            throw new IllegalArgumentException("Timer.schedule: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 delay.");
        }
        TimerThread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("Timer.schedule: \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u0434\u0430\u0447 \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        }
        thread.schedule(task, time, period, false);
    }

    public void schedule(TimerTask task, Date firstTime, long period) {
        if (task == null) {
            throw new NullPointerException("Timer.schedule: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 task \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (firstTime == null) {
            throw new NullPointerException("Timer.schedule: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 firstTime \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        long time = firstTime.getTime();
        if (time < 0L) {
            throw new IllegalArgumentException("Timer.schedule: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f firstTime.getTime().");
        }
        TimerThread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("Timer.schedule: \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u0434\u0430\u0447 \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        }
        thread.schedule(task, time, period, false);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        long time;
        if (task == null) {
            throw new NullPointerException("Timer.scheduleAtFixedRate: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 task \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (delay < 0L || (time = System.currentTimeMillis() + delay) < 0L) {
            throw new IllegalArgumentException("Timer.scheduleAtFixedRate: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 delay.");
        }
        TimerThread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("Timer.scheduleAtFixedRate: \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u0434\u0430\u0447 \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        }
        thread.schedule(task, time, period, true);
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        if (task == null) {
            throw new NullPointerException("Timer.scheduleAtFixedRate: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 task \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (firstTime == null) {
            throw new NullPointerException("Timer.scheduleAtFixedRate: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 firstTime \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        long time = firstTime.getTime();
        if (time < 0L) {
            throw new IllegalArgumentException("Timer.scheduleAtFixedRate: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f firstTime.getTime().");
        }
        TimerThread thread = this.thread;
        if (thread == null) {
            throw new IllegalStateException("Timer.scheduleAtFixedRate: \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u0434\u0430\u0447 \u0431\u044b\u043b\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
        }
        thread.schedule(task, time, period, true);
    }

    public void cancel() {
        TimerThread thread = this.thread;
        if (thread == null) {
            return;
        }
        this.thread = null;
        thread.terminate();
    }
}

