/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.time;

import java.util.TimeZone;

public class LocaleTimeZone
extends TimeZone {
    private int offset;
    private String[] ids;
    private String id;
    private String name;

    public static char[] offsetToString(int offsetInMillis) {
        int ofs = offsetInMillis / 60000;
        boolean negative = ofs < 0;
        int hrs = negative ? -ofs : ofs;
        int min = hrs % 60;
        return new char[]{negative ? (char)'-' : '+', (char)((hrs /= 60) / 10 % 10 + 48), (char)(hrs % 10 + 48), ':', (char)(min / 10 + 48), (char)(min % 10 + 48)};
    }

    public LocaleTimeZone(int offsetInMillis, String id) {
        this(offsetInMillis, id, null, null);
    }

    public LocaleTimeZone(int offsetInMillis, String id, String name) {
        this(offsetInMillis, id, name, null);
    }

    public LocaleTimeZone(int offsetInMillis, String id, String name, String[] ids) {
        int len = ids != null ? ids.length : 0;
        this.offset = offsetInMillis;
        Object[] list = ids != null ? new String[len] : null;
        this.ids = list;
        this.id = id != null && id.length() != 0 ? id : "UTC".concat(String.valueOf(LocaleTimeZone.offsetToString(offsetInMillis)));
        this.name = name;
        if (list == null) {
            return;
        }
        Array.copy(ids, 0, list, 0, len);
    }

    public boolean equals(Object obj) {
        block2: {
            block3: {
                if (obj == this) break block2;
                if (!(obj instanceof LocaleTimeZone)) break block3;
                LocaleTimeZone zone = (LocaleTimeZone)obj;
                if (this.offset == zone.offset && this.id.equals(zone.id)) break block2;
            }
            return false;
        }
        return true;
    }

    public boolean useDaylightTime() {
        return false;
    }

    public int hashCode() {
        return this.offset ^ this.id.hashCode();
    }

    public int getOffset(int era, int year, int month, int day, int weekDay, int millis) {
        return this.offset;
    }

    public String toString() {
        StringBuffer result = new StringBuffer().append("(UTC");
        if (this.offset / 60000 != 0) {
            result.append(LocaleTimeZone.offsetToString(this.offset));
        }
        result.append(")");
        String name = this.getName();
        if (name != null && (name = name.trim()).length() > 0) {
            result.append(' ').append(name);
        }
        return result.toString();
    }

    public String toString(int era, int year, int month, int day, int weekday, int millis) {
        return this.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getName(int era, int year, int month, int day, int weekday, int millis) {
        return this.getName();
    }

    public final int getRawOffset() {
        return this.offset;
    }

    public final String getID() {
        return this.id;
    }

    public final boolean isID(String id) {
        if (id != null && id.equals(this.id)) {
            return true;
        }
        String[] ids = this.ids;
        if (this.ids == null) {
            return false;
        }
        int i = ids.length;
        while (i-- > 0) {
            if (!(id != null ? id.equals(ids[i]) : ids[i] == null)) continue;
            return true;
        }
        return false;
    }

    public final int getIDsCount() {
        String[] ids = this.ids;
        return this.ids == null ? 1 : ids.length + 1;
    }

    public final String getID(int index) {
        String[] ids;
        block3: {
            block2: {
                if (index < 0) break block2;
                ids = this.ids;
                if (index <= (this.ids == null ? 0 : ids.length)) break block3;
            }
            throw new IndexOutOfBoundsException("LocaleTimeZone.getID: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return index == 0 ? this.id : ids[index - 1];
    }
}

