/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.time;

import java.util.TimeZone;
import malik.emulator.time.DefaultFormat;
import malik.emulator.time.LocaleTimeZone;

public final class StandardFormat
extends DefaultFormat {
    private static final String[] DAYS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public String represent(int era, int year, int month, int day, int weekday, int hour, int minute, int second, int millis, TimeZone zone) {
        return String.valueOf(this.getWeekDayRepresentation(weekday)) + ' ' + this.getMonthRepresentation(month) + ' ' + String.valueOf(DefaultFormat.asTwoChars(day)) + ' ' + String.valueOf(DefaultFormat.asTwoChars(hour)) + ':' + String.valueOf(DefaultFormat.asTwoChars(minute)) + ':' + String.valueOf(DefaultFormat.asTwoChars(second)) + ' ' + (zone instanceof LocaleTimeZone ? ((LocaleTimeZone)zone).toString(era, year, month, day, weekday, 3600000 * hour + 60000 * minute + 1000 * second + millis) : zone.toString()) + ' ' + year;
    }

    protected String getWeekDayRepresentation(int weekday) {
        return DAYS[weekday - 1];
    }

    protected String getMonthRepresentation(int month) {
        return MONTHS[month];
    }
}

