/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.system.console;

import malik.emulator.microedition.system.Console;
import malik.emulator.microedition.system.ConsoleCommand;
import malik.emulator.util.StringBuilder;

public class MemoryConsoleCommand
extends ConsoleCommand {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long TB = 0x10000000000L;
    private static final long PB = 0x4000000000000L;
    private static final long EB = 0x1000000000000000L;

    private static String dataSizeToString(long size) {
        if (size >= 0L && size < 1024L) {
            return Integer.toString((int)size).concat(" \u0431\u0430\u0439\u0442");
        }
        if (size >= 1024L && size < 0x100000L) {
            return Integer.toString((int)(size >> 10)).concat(" \u041a\u0411");
        }
        if (size >= 0x100000L && size < 0x40000000L) {
            return Integer.toString((int)(size >> 20)).concat(" \u041c\u0411");
        }
        if (size >= 0x40000000L && size < 0x10000000000L) {
            return Integer.toString((int)(size >> 30)).concat(" \u0413\u0411");
        }
        if (size >= 0x10000000000L && size < 0x4000000000000L) {
            return Integer.toString((int)(size >> 40)).concat(" \u0422\u0411");
        }
        if (size >= 0x4000000000000L && size < 0x1000000000000000L) {
            return Integer.toString((int)(size >> 50)).concat(" \u041f\u0411");
        }
        return Integer.toString((int)(size >>> 60)).concat(" \u042d\u0411");
    }

    public MemoryConsoleCommand() {
        super("\u043f\u0430\u043c\u044f\u0442\u044c", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435:\n \u043f\u0430\u043c\u044f\u0442\u044c\n \u043f\u0430\u043c\u044f\u0442\u044c \u0442\u043e\u0447\u043d\u043e\n\u0412\u044b\u0432\u043e\u0434\u0438\u0442 \u043d\u0430 \u043a\u043e\u043d\u0441\u043e\u043b\u044c \u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043f\u0430\u043c\u044f\u0442\u0438.");
    }

    protected void execute(String[] arguments, Console console) {
        StringBuilder text = new StringBuilder();
        if (arguments.length > 0 && "\u0442\u043e\u0447\u043d\u043e".equals(arguments[0])) {
            text.append("\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u043e: ").append(Memory.getFree()).append(" \u0431\u0430\u0439\u0442\n\u041e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u043e: ").append(Memory.getCollected()).append(" \u0431\u0430\u0439\u0442\n\u0412\u0441\u0435\u0433\u043e: ").append(Memory.getTotal()).append(" \u0431\u0430\u0439\u0442");
        } else {
            text.append("\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u043e: ").append(MemoryConsoleCommand.dataSizeToString(Memory.getFree())).append("\n\u041e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0435\u043d\u043e: ").append(MemoryConsoleCommand.dataSizeToString(Memory.getCollected())).append("\n\u0412\u0441\u0435\u0433\u043e: ").append(MemoryConsoleCommand.dataSizeToString(Memory.getTotal()));
        }
        console.println(text.toString());
    }
}

