/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mid.ui;

import com.nokia.mid.ui.DirectGraphics;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import malik.emulator.fileformats.graphics.ImageDecoder;
import malik.emulator.microedition.DeviceManager;

public class DirectUtils {
    public static DirectGraphics getDirectGraphics(Graphics render) {
        return render;
    }

    public static Image createImage(int width, int height, int colorARGB) {
        if (width <= 0) {
            throw new IllegalArgumentException("DirectUtils.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (height <= 0) {
            throw new IllegalArgumentException("DirectUtils.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        int area = width * height;
        int[] pixels = new int[area];
        Array.fill((int[])pixels, (int)0, (int)area, (int)colorARGB);
        return Image.createRGBImage(pixels, width, height, true, true);
    }

    public static Image createImage(byte[] src, int offset, int length) {
        ImageDecoder decoder;
        if (src == null) {
            throw new NullPointerException("DirectUtils.createImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"DirectUtils.createImage", (int)src.length, (int)offset, (int)length);
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(src, offset, length);
            decoder = DeviceManager.getInstance().openImageDecoder(stream);
            decoder.loadFromInputStream((InputStream)stream);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("DirectUtils.createImage: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0434\u0435\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435.");
        }
        int width = decoder.getWidth();
        int height = decoder.getHeight();
        int[] pixels = decoder.getPixels();
        if (!decoder.alphaSupported()) {
            int i = width * height;
            while (i-- > 0) {
                int n = i;
                pixels[n] = pixels[n] | 0xFF000000;
            }
        }
        return Image.createRGBImage(pixels, width, height, true, true);
    }

    private DirectUtils() {
    }
}

