/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import malik.emulator.io.jar.ResourceNotFoundException;
import malik.emulator.util.StringBuilder;

public class AudioClip {
    public static final int TYPE_MMF = 1;
    public static final int TYPE_MP3 = 2;
    public static final int TYPE_MIDI = 3;
    private static final String[] MIME_TYPES = new String[]{"application/vnd.smaf", "audio/mpeg", "audio/midi"};
    private final Player implement;
    private final VolumeControl volume;

    public static boolean isSupported() {
        return true;
    }

    public AudioClip(int format, byte[] src, int offset, int length) {
        VolumeControl volume;
        Player implement;
        if (--format < 0 || format >= MIME_TYPES.length) {
            throw new IllegalArgumentException("AudioClip: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 format \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("AudioClip: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound((String)"AudioClip", (int)src.length, (int)offset, (int)length);
        try {
            implement = Manager.createPlayer(new ByteArrayInputStream(src, offset, length), MIME_TYPES[format]);
            implement.prefetch();
            volume = (VolumeControl)implement.getControl("VolumeControl");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.implement = implement;
        this.volume = volume;
    }

    public AudioClip(int format, String resourceName) throws IOException {
        VolumeControl volume;
        Player implement;
        InputStream stream;
        if (--format < 0 || format >= MIME_TYPES.length) {
            throw new IllegalArgumentException("AudioClip: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 format \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (resourceName == null) {
            throw new NullPointerException("AudioClip: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 resourceName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (resourceName.length() <= 0 || resourceName.charAt(0) != '/') {
            resourceName = "/".concat(resourceName);
        }
        if ((stream = this.getClass().getResourceAsStream(resourceName)) == null) {
            throw new ResourceNotFoundException(new StringBuilder().append("AudioClip: \u0440\u0435\u0441\u0443\u0440\u0441 ").append(resourceName).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.").toString(), resourceName);
        }
        try {
            implement = Manager.createPlayer(stream, MIME_TYPES[format]);
            implement.prefetch();
            volume = (VolumeControl)implement.getControl("VolumeControl");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.implement = implement;
        this.volume = volume;
    }

    public void resume() {
        try {
            this.implement.start();
        }
        catch (MediaException e) {
            e.printRealStackTrace();
        }
    }

    public void play(int loopCount, int volumeLevel) {
        if (loopCount < 0 || loopCount > 255) {
            throw new IllegalArgumentException("AudioClip.play: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 loopCount \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (volumeLevel < 0 || volumeLevel > 5) {
            throw new IllegalArgumentException("AudioClip.play: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 volumeLevel \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (loopCount == 0) {
            loopCount = -1;
        }
        try {
            Player implement = this.implement;
            implement.stop();
            VolumeControl volume = this.volume;
            if (volume != null) {
                volume.setLevel(20 * volumeLevel);
            }
            implement.setLoopCount(loopCount);
            implement.start();
        }
        catch (MediaException e) {
            e.printRealStackTrace();
        }
    }

    public void pause() {
        try {
            this.implement.stop();
        }
        catch (MediaException e) {
            e.printRealStackTrace();
        }
    }

    public void stop() {
        this.implement.close();
    }
}

