/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceElement;
import javax.microedition.lcdui.ChoiceElementViewer;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.FocusItem;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.InteractiveItem;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.ScrollBar;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.lcdui.ChoiceList;
import malik.emulator.microedition.lcdui.MultilinedStringBuilder;
import malik.emulator.microedition.lcdui.TextMenu;

public class ChoiceGroup
extends InteractiveItem
implements Choice {
    static final int ICON_WIDTH = 24;
    static final int ICON_HEIGHT = 24;
    private static final int MARGIN = 3;
    private static final int POPUP_ARROW_SIZE = 9;
    private static final String DEFAULT_EMPTY_LABEL = "(\u043f\u0443\u0441\u0442\u043e)";
    private static final int MARGIN1;
    private static final int MARGIN2;
    private static final int MARGIN3;
    private static final int ICON_TOP;
    private static final int CHECKBOX_TOP;
    private static final int CHECKBOX_WIDTH;
    private static final int CHECKBOX_HEIGHT;
    private static final int ELEMENT_HEIGHT;
    private static final Command[] MULTIPLE_ACTIONS;
    private static final Command CHECK_COMMAND;
    private static final Command SELECT_COMMAND;
    private final byte type;
    private int listWidth;
    private int listHeight;
    private int fitPolicy;
    private int selected;
    private int checked;
    private int focused;
    private int pressed;
    private int count;
    private ChoiceElement[] elements;
    private final ChoiceList popupMenu;
    private final String emptyLabel;
    private final ChoiceElementViewer monitor;

    static {
        int s = RasterCanvas.getGUIElementSize((int)15, (int)0, (int)0);
        int i = s;
        int w = i <= 0 ? 16 : (i > 24 ? 24 : (int)i);
        i = s >> 16;
        int h = i <= 0 ? 16 : (i > 24 ? 24 : i);
        int height1 = Font.getFont(0, 0, 0).getHeight();
        int height2 = Font.getFont(0, 0, 8).getHeight();
        int height3 = Font.getFont(0, 0, 16).getHeight();
        int heightMax = Math.max(Math.max(height1, height2), Math.max(height3, 24)) + 6;
        MARGIN1 = 6 + w;
        MARGIN2 = 27 + MARGIN1;
        MARGIN3 = 30;
        ICON_TOP = heightMax - 24 >> 1;
        CHECKBOX_TOP = heightMax - h >> 1;
        CHECKBOX_WIDTH = w;
        CHECKBOX_HEIGHT = h;
        ELEMENT_HEIGHT = heightMax;
        MULTIPLE_ACTIONS = new Command[]{new Command("\u041e\u0442\u043c\u0435\u0442\u0438\u0442\u044c \u0432\u0441\u0435", 8, Integer.MAX_VALUE), new Command("\u0421\u043d\u044f\u0442\u044c \u0432\u0441\u0435", 8, Integer.MAX_VALUE), new Command("\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u0441\u0435", 8, Integer.MAX_VALUE)};
        CHECK_COMMAND = new Command("\u2713", 4, 0);
        SELECT_COMMAND = new Command("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 4, 0);
    }

    public ChoiceGroup(String label, int type) {
        this(label, type, null, new String[0], null);
    }

    public ChoiceGroup(String label, int type, String[] elements, Image[] icons) {
        this(label, type, null, elements, icons);
    }

    public ChoiceGroup(String label, int type, String emptyLabel, String[] elements, Image[] icons) {
        super(label);
        if (type != 4 && type != 1 && type != 2) {
            throw new IllegalArgumentException("ChoiceGroup: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 type \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (elements == null) {
            throw new NullPointerException("ChoiceGroup: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elements \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int count = elements.length;
        Object[] copyElements = new String[count];
        Array.copy((Object[])elements, (int)0, (Object[])copyElements, (int)0, (int)count);
        if (Array.findf((Object[])copyElements, (int)0, null) < count) {
            throw new NullPointerException("ChoiceGroup: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elements \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b, \u0440\u0430\u0432\u043d\u044b\u0435 \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (icons != null && icons.length != count) {
            throw new IllegalArgumentException("ChoiceGroup: \u0434\u043b\u0438\u043d\u0430 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 icons \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u0434\u043b\u0438\u043d\u044b \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 elements.");
        }
        ChoiceElement[] choiceElements = new ChoiceElement[Displayable.getOptimalLength(count)];
        int i = count;
        while (i-- > 0) {
            choiceElements[i] = new ChoiceElement(type == 1 && i == 0, (String)copyElements[i], icons != null ? icons[i] : null);
        }
        int len = type == 2 ? MULTIPLE_ACTIONS.length : 0;
        int i2 = 0;
        while (i2 < len) {
            super.addCommand(MULTIPLE_ACTIONS[i2]);
            ++i2;
        }
        if (count > 0) {
            super.setDefaultCommand(type == 4 ? SELECT_COMMAND : CHECK_COMMAND);
        }
        this.type = (byte)type;
        this.fitPolicy = 0;
        this.focused = -1;
        this.pressed = -1;
        this.count = count;
        this.elements = choiceElements;
        this.popupMenu = type == 4 ? this.createPopupMenu() : null;
        this.emptyLabel = emptyLabel == null ? DEFAULT_EMPTY_LABEL : emptyLabel;
        this.monitor = new ChoiceElementViewer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int elementIndex, String text, Image icon) {
        if (text == null) {
            throw new NullPointerException("ChoiceGroup.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int len;
            if (elementIndex < 0 || elementIndex > (len = this.count)) {
                error = true;
            } else {
                byte t;
                Object[] list = this.elements;
                if (len == list.length) {
                    Object[] objectArray = list;
                    this.elements = new ChoiceElement[(len << 1) + 1];
                    list = this.elements;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
                }
                if (elementIndex < len) {
                    Array.copy((Object[])list, (int)elementIndex, (Object[])list, (int)(elementIndex + 1), (int)(len - elementIndex));
                }
                list[elementIndex] = new ChoiceElement((t = this.type) == 1 && len == 0, text, icon);
                this.focused = -1;
                this.pressed = -1;
                this.count = ++len;
                if (len > 1) {
                    int activeIndex;
                    if (t == 1 && (activeIndex = this.checked) >= elementIndex) {
                        this.checked = activeIndex + 1;
                    }
                    if ((activeIndex = this.selected) >= elementIndex) {
                        this.selected = activeIndex + 1;
                    }
                } else {
                    super.setDefaultCommand(t == 4 ? SELECT_COMMAND : CHECK_COMMAND);
                }
                if (t != 4) {
                    this.requestInvalidate();
                } else {
                    ChoiceList menu = this.popupMenu;
                    if (menu.isShown()) {
                        menu.insert(elementIndex, text, icon);
                    } else if (len <= 1) {
                        this.requestPaint();
                    }
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int elementIndex) {
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int len;
            if (elementIndex < 0 || elementIndex > (len = this.count - 1)) {
                error = true;
            } else {
                byte t;
                boolean needRepaint;
                Object[] list = this.elements;
                if (elementIndex < len) {
                    Array.copy((Object[])list, (int)(elementIndex + 1), (Object[])list, (int)elementIndex, (int)(len - elementIndex));
                }
                list[len] = null;
                this.focused = -1;
                this.pressed = -1;
                this.count = len;
                if (len > 0) {
                    int activeIndex;
                    needRepaint = false;
                    t = this.type;
                    if (t == 1) {
                        activeIndex = this.checked;
                        if (activeIndex == elementIndex) {
                            if (activeIndex >= len) {
                                activeIndex = len - 1;
                            }
                            ((ChoiceElement)list[activeIndex]).selected = true;
                            this.checked = activeIndex;
                        } else if (activeIndex > elementIndex) {
                            this.checked = activeIndex - 1;
                        }
                    }
                    if ((activeIndex = this.selected) == elementIndex) {
                        if (activeIndex >= len) {
                            activeIndex = len - 1;
                        }
                        needRepaint = true;
                        this.selected = activeIndex;
                    } else if (activeIndex > elementIndex) {
                        this.selected = activeIndex - 1;
                    }
                } else {
                    needRepaint = true;
                    t = this.type;
                    super.removeCommand(t == 4 ? SELECT_COMMAND : CHECK_COMMAND);
                }
                if (t != 4) {
                    this.requestInvalidate();
                } else {
                    ChoiceList menu = this.popupMenu;
                    if (menu.isShown()) {
                        menu.delete(elementIndex);
                    } else if (needRepaint) {
                        this.requestPaint();
                    }
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.delete: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int len = this.count;
            if (len > 0) {
                this.selected = 0;
                this.checked = 0;
                this.focused = -1;
                this.pressed = -1;
                this.count = 0;
                Array.fill((Object[])this.elements, (int)0, (int)len, null);
                byte t = this.type;
                super.removeCommand(t == 4 ? SELECT_COMMAND : CHECK_COMMAND);
                if (t != 4) {
                    this.requestInvalidate();
                } else {
                    ChoiceList menu = this.popupMenu;
                    if (menu.isShown()) {
                        menu.deleteAll();
                    } else {
                        this.requestPaint();
                    }
                }
            }
        }
    }

    public void setFitPolicy(int fitPolicy) {
        if (fitPolicy != 0 && fitPolicy != 1 && fitPolicy != 2) {
            throw new IllegalArgumentException("ChoiceGroup.setFitPolicy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fitPolicy \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.fitPolicy = fitPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int elementIndex, boolean selected) {
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
            } else {
                ChoiceElement[] list = this.elements;
                switch (this.type) {
                    case 1: {
                        int activeIndex;
                        if (!selected || (activeIndex = this.checked) == elementIndex) break;
                        list[activeIndex].selected = false;
                        list[elementIndex].selected = true;
                        this.checked = elementIndex;
                        this.requestPaint();
                        break;
                    }
                    case 2: {
                        ChoiceElement item = list[elementIndex];
                        if (item.selected == selected) break;
                        item.selected = selected;
                        this.requestPaint();
                        break;
                    }
                    default: {
                        if (!selected || this.selected == elementIndex) break;
                        this.selected = elementIndex;
                        ChoiceList menu = this.popupMenu;
                        if (menu.isShown()) {
                            menu.setSelectedIndex(elementIndex);
                            break;
                        }
                        this.requestPaint();
                    }
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.setSelectedIndex: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedFlags(boolean[] src) {
        if (src == null) {
            throw new NullPointerException("ChoiceGroup.setSelectedFlags: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int len = this.count;
            if (src.length < len) {
                error = true;
            } else {
                ChoiceElement[] list = this.elements;
                switch (this.type) {
                    case 1: {
                        int activeIndex;
                        int elementIndex = Array.findf((boolean[])src, (int)0, (boolean)true);
                        if (elementIndex >= len || (activeIndex = this.checked) == elementIndex) break;
                        list[activeIndex].selected = false;
                        list[elementIndex].selected = true;
                        this.checked = elementIndex;
                        this.requestPaint();
                        break;
                    }
                    case 2: {
                        boolean needRepaint = false;
                        int i = len;
                        while (i-- > 0) {
                            ChoiceElement item = list[i];
                            boolean selected = src[i];
                            if (item.selected == selected) continue;
                            needRepaint = true;
                            item.selected = selected;
                        }
                        if (!needRepaint) break;
                        this.requestPaint();
                        break;
                    }
                    default: {
                        int elementIndex = Array.findf((boolean[])src, (int)0, (boolean)true);
                        if (elementIndex >= len || this.selected == elementIndex) break;
                        this.selected = elementIndex;
                        ChoiceList menu = this.popupMenu;
                        if (menu.isShown()) {
                            menu.setSelectedIndex(elementIndex);
                            break;
                        }
                        this.requestPaint();
                    }
                }
            }
        }
        if (error) {
            throw new IllegalArgumentException("ChoiceGroup.setSelectedFlags: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u043a\u043e\u0440\u043e\u0447\u0435 \u0441\u043f\u0438\u0441\u043a\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(int elementIndex, Font font) {
        boolean error = false;
        if (font == null) {
            font = Font.getDefaultFont();
        }
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
            } else {
                this.elements[elementIndex].font = font;
                ChoiceList menu = this.popupMenu;
                if (menu != null && menu.isShown()) {
                    menu.setFont(elementIndex, font);
                } else if (this.type != 4 || this.selected == elementIndex) {
                    this.requestPaint();
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.setFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int elementIndex, String text, Image icon) {
        if (text == null) {
            throw new NullPointerException("ChoiceGroup.set: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
            } else {
                ChoiceElement item = this.elements[elementIndex];
                this.elements[elementIndex].text = text;
                item.icon = icon;
                ChoiceList menu = this.popupMenu;
                if (menu != null && menu.isShown()) {
                    menu.setString(elementIndex, text, icon);
                } else if (this.type != 4 || this.selected == elementIndex) {
                    this.requestPaint();
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.set: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(int elementIndex) {
        boolean result;
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
                result = false;
            } else {
                result = this.type != 4 ? this.elements[elementIndex].selected : elementIndex == this.selected;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.isSelected: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append(String text, Image icon) {
        int result;
        if (text == null) {
            throw new NullPointerException("ChoiceGroup.append: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            byte t;
            int len;
            result = len = this.count;
            Object[] list = this.elements;
            if (len == this.elements.length) {
                Object[] objectArray = list;
                this.elements = new ChoiceElement[(len << 1) + 1];
                list = this.elements;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
            }
            list[len] = new ChoiceElement((t = this.type) == 1 && len == 0, text, icon);
            this.focused = -1;
            this.pressed = -1;
            this.count = ++len;
            if (len <= 1) {
                super.setDefaultCommand(t == 4 ? SELECT_COMMAND : CHECK_COMMAND);
            }
            if (t != 4) {
                this.requestInvalidate();
            } else {
                ChoiceList menu = this.popupMenu;
                if (menu.isShown()) {
                    menu.append(text, icon);
                } else if (len <= 1) {
                    this.requestPaint();
                }
            }
        }
        return result;
    }

    public int size() {
        return this.count;
    }

    public int getFitPolicy() {
        return this.fitPolicy;
    }

    public int getSelectedIndex() {
        switch (this.type) {
            case 1: {
                return this.count > 0 ? this.checked : -1;
            }
            case 2: {
                return -1;
            }
        }
        return this.count > 0 ? this.selected : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedFlags(boolean[] dst) {
        int result;
        if (dst == null) {
            throw new NullPointerException("ChoiceGroup.getSelectedFlags: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int dstlen = dst.length;
            int len = this.count;
            if (dstlen < len) {
                error = true;
                result = 0;
            } else {
                Array.fill((boolean[])dst, (int)0, (int)dstlen, (boolean)false);
                ChoiceElement[] list = this.elements;
                if (this.type != 4) {
                    result = 0;
                    int i = len;
                    while (i-- > 0) {
                        dst[i] = list[i].selected;
                        if (!dst[i]) continue;
                        ++result;
                    }
                } else {
                    result = 1;
                    dst[this.selected] = true;
                }
            }
        }
        if (error) {
            throw new IllegalArgumentException("ChoiceGroup.getSelectedFlags: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u043a\u043e\u0440\u043e\u0447\u0435 \u0441\u043f\u0438\u0441\u043a\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(int elementIndex) {
        Font result;
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].font;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.getFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(int elementIndex) {
        Image result;
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].icon;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.getImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int elementIndex) {
        String result;
        boolean error = false;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].text;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceGroup.getString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics render, int contentWidth, int contentHeight) {
        byte type = this.type;
        int top1 = render.getClipY();
        int top2 = render.getClipHeight() + top1 - 1;
        int element1 = top1 / ELEMENT_HEIGHT;
        int element2 = top2 / ELEMENT_HEIGHT;
        this.listWidth = contentWidth;
        this.listHeight = contentHeight;
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int count = this.count;
            if (count <= 0) {
                render.setColor(RasterCanvas.getSystemColor((int)40));
                Font font = Font.getFont(0, 1, 8);
                render.setFont(font);
                render.drawString(MultilinedStringBuilder.truncate(this.emptyLabel, font, contentWidth), contentWidth >> 1, 0, 17);
            } else if (type == 4) {
                int y;
                int x;
                boolean f = ((FocusItem)this).focused;
                boolean p = this.pressed == 0;
                ChoiceElement item = this.elements[this.selected];
                Font font = item.font;
                render.setFont(font);
                render.setColor(RasterCanvas.getSystemColor((int)(f ? (p ? 37 : 39) : 36)));
                render.drawElement(4, f ? (p ? 1 : 3) : 0, 0, 0, 0, contentWidth, contentHeight);
                Image icon = item.icon;
                if (icon != null) {
                    x = MARGIN3 + (p ? 1 : 0);
                    y = (ELEMENT_HEIGHT - font.getHeight() >> 1) + (p ? 1 : 0);
                    render.drawStretch(icon, 3 + (p ? 1 : 0), ICON_TOP + (p ? 1 : 0), 24, 24, 0);
                    render.drawString(MultilinedStringBuilder.truncate(item.text, font, contentWidth - (15 + MARGIN3)), x, y, 0);
                } else {
                    x = 3 + (p ? 1 : 0);
                    y = (ELEMENT_HEIGHT - font.getHeight() >> 1) + (p ? 1 : 0);
                    render.drawString(MultilinedStringBuilder.truncate(item.text, font, contentWidth - 18), x, y, 0);
                }
                x = contentWidth - 12 + (p ? 1 : 0);
                y = (ELEMENT_HEIGHT - 9 >> 1) + (p ? 2 : 1);
                render.fillTriangle(x, y, x + 8, y, x + 4, y + 8);
            } else {
                int sel = ((FocusItem)this).focused ? this.selected : -1;
                ChoiceElement[] list = this.elements;
                int press = this.pressed;
                render.translate(0, ELEMENT_HEIGHT * element1);
                render.setColor(RasterCanvas.getSystemColor((int)40));
                int i = element1;
                while (i <= element2 && i < count) {
                    ChoiceElement item = list[i];
                    Font font = item.font;
                    Image icon = item.icon;
                    String text = item.text;
                    boolean check = item.selected;
                    int textTop = ELEMENT_HEIGHT - font.getHeight() >> 1;
                    if (i == sel) {
                        render.drawElement(1, 0, 0, 0, 0, this.width, ELEMENT_HEIGHT);
                    }
                    render.setFont(font);
                    render.drawElement(type == 1 ? 12 : 15, check ? 1 : 0, i == press ? 1 : 0, 3, CHECKBOX_TOP, CHECKBOX_WIDTH, CHECKBOX_HEIGHT);
                    if (icon != null) {
                        render.drawStretch(icon, MARGIN1, 3, 24, 24, 0);
                        render.drawString(MultilinedStringBuilder.truncate(text, font, this.width - (MARGIN2 + 3)), MARGIN2, textTop, 0);
                    } else {
                        render.drawString(MultilinedStringBuilder.truncate(text, font, this.width - (MARGIN1 + 3)), MARGIN1, textTop, 0);
                    }
                    render.translate(0, ELEMENT_HEIGHT);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCommandAction(Command command) {
        ChoiceElement item;
        int i;
        ChoiceElement[] list;
        boolean needRepaint;
        ChoiceElementViewer choiceElementViewer;
        if (command == SELECT_COMMAND) {
            ChoiceElementViewer choiceElementViewer2 = this.monitor;
            synchronized (choiceElementViewer2) {
                this.showPopupMenu();
            }
            return;
        }
        if (command == CHECK_COMMAND) {
            ChoiceElementViewer choiceElementViewer3 = this.monitor;
            synchronized (choiceElementViewer3) {
                switch (this.type) {
                    case 1: {
                        int previousIndex;
                        int activeIndex = this.selected;
                        if (activeIndex < 0 || activeIndex >= this.count || activeIndex == (previousIndex = this.checked)) break;
                        ChoiceElement[] list2 = this.elements;
                        this.elements[previousIndex].selected = false;
                        this.checked = activeIndex;
                        list2[activeIndex].selected = true;
                        super.notifyStateChanged();
                        super.requestPaint();
                        break;
                    }
                    case 2: {
                        int activeIndex = this.selected;
                        if (activeIndex < 0 || activeIndex >= this.count) break;
                        ChoiceElement item2 = this.elements[activeIndex];
                        this.elements[activeIndex].selected = !item2.selected;
                        super.notifyStateChanged();
                        super.requestPaint();
                    }
                }
            }
            return;
        }
        if (command == MULTIPLE_ACTIONS[0]) {
            choiceElementViewer = this.monitor;
            synchronized (choiceElementViewer) {
                needRepaint = false;
                list = this.elements;
                i = this.count;
                while (i-- > 0) {
                    item = list[i];
                    if (item.selected) continue;
                    needRepaint = true;
                    item.selected = true;
                }
                if (needRepaint) {
                    super.notifyStateChanged();
                    super.requestPaint();
                }
            }
        }
        if (command == MULTIPLE_ACTIONS[1]) {
            choiceElementViewer = this.monitor;
            synchronized (choiceElementViewer) {
                needRepaint = false;
                list = this.elements;
                i = this.count;
                while (i-- > 0) {
                    item = list[i];
                    if (!item.selected) continue;
                    needRepaint = true;
                    item.selected = false;
                }
                if (needRepaint) {
                    super.notifyStateChanged();
                    super.requestPaint();
                }
            }
        }
        if (command == MULTIPLE_ACTIONS[2]) {
            choiceElementViewer = this.monitor;
            synchronized (choiceElementViewer) {
                int len = this.count;
                if (len > 0) {
                    list = this.elements;
                    i = len;
                    while (i-- > 0) {
                        item = list[i];
                        boolean bl = list[i].selected = !item.selected;
                    }
                    super.notifyStateChanged();
                    super.requestPaint();
                }
            }
        }
        super.onCommandAction(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onKeyboardEvent(KeyboardEvent event) {
        DeviceSettings settings;
        int key = event.getKey();
        if (key == (settings = DeviceManager.getInstance().getSettings()).getKeyUsedAs(35)) {
            ChoiceElementViewer screen;
            if (event.getAction() != 6) return;
            ChoiceElementViewer choiceElementViewer = screen = this.monitor;
            synchronized (screen) {
                if (this.count <= 0) return;
                ChoiceElement element = this.elements[this.selected];
                String text = element.text;
                Font font = element.font;
                // ** MonitorExit[var9_5] (shouldn't be in output)
                if (text == null) return;
                Screen owner = this.owner;
                if (owner == null) return;
                Display parent = owner.getParentDisplay();
                if (parent == null) return;
                screen.getScrollBar().setPosition(0);
                screen.setFont(font);
                screen.setText(text);
                parent.setCurrent(screen);
                return;
            }
        }
        if (key != 32) return;
        switch (event.getAction()) {
            case 6: {
                this.pressed = this.type == 4 ? 0 : this.selected;
                this.requestPaint();
                return;
            }
            case 7: {
                switch (this.type) {
                    case 4: {
                        ChoiceElementViewer choiceElementViewer = this.monitor;
                        synchronized (choiceElementViewer) {
                            if (this.count > 0) {
                                this.showPopupMenu();
                            }
                            break;
                        }
                    }
                    case 1: {
                        ChoiceElementViewer choiceElementViewer = this.monitor;
                        synchronized (choiceElementViewer) {
                            int previousIndex;
                            int activeIndex = this.pressed;
                            if (activeIndex >= 0 && activeIndex < this.count && activeIndex != (previousIndex = this.checked)) {
                                ChoiceElement[] list = this.elements;
                                this.elements[previousIndex].selected = false;
                                this.checked = activeIndex;
                                list[activeIndex].selected = true;
                                super.notifyStateChanged();
                            }
                            break;
                        }
                    }
                    case 2: {
                        ChoiceElementViewer choiceElementViewer = this.monitor;
                        synchronized (choiceElementViewer) {
                            int activeIndex = this.pressed;
                            if (activeIndex >= 0 && activeIndex < this.count) {
                                ChoiceElement item = this.elements[activeIndex];
                                this.elements[activeIndex].selected = !item.selected;
                                super.notifyStateChanged();
                            }
                            break;
                        }
                    }
                }
                this.pressed = -1;
                this.requestPaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPointerEvent(PointerEvent event) {
        switch (event.getAction()) {
            case 10: 
            case 14: {
                int f;
                if (event.getButton() != 0) break;
                if (this.type == 4) {
                    this.focused = this.getFocusedElement(event.getX(), event.getY());
                    if (this.focused != -2) break;
                    this.pressed = 0;
                    this.requestPaint();
                    break;
                }
                int y = event.getY();
                this.focused = f = this.getFocusedElement(event.getX(), y);
                if (f >= 0) {
                    this.pressed = f;
                    ChoiceElementViewer choiceElementViewer = this.monitor;
                    synchronized (choiceElementViewer) {
                        int c = this.count;
                        int i = f;
                        if (i >= c) {
                            i = c - 1;
                        }
                        if (i < 0) {
                            i = 0;
                        }
                        this.selected = i;
                        this.requestInvalidate();
                        break;
                    }
                }
                if (f != -2) break;
                ChoiceElementViewer choiceElementViewer = this.monitor;
                synchronized (choiceElementViewer) {
                    int c = this.count;
                    int i = y / ELEMENT_HEIGHT;
                    if (i >= c) {
                        i = c - 1;
                    }
                    if (i < 0) {
                        i = 0;
                    }
                    if (this.selected != i) {
                        this.selected = i;
                        this.requestInvalidate();
                    }
                    break;
                }
            }
            case 9: {
                if (this.type == 4) {
                    if (this.focused != -2 || this.pressed == (this.pressed = this.getFocusedElement(event.getX(), event.getY()) == -2 ? 0 : -1)) break;
                    this.requestPaint();
                    break;
                }
                int f = this.focused;
                if (f >= 0) {
                    this.pressed = this.getFocusedElement(event.getX(), event.getY()) == f ? f : -1;
                    if (this.pressed == this.pressed) break;
                    this.requestPaint();
                    break;
                }
                if (f != -2) break;
                ChoiceElementViewer choiceElementViewer = this.monitor;
                synchronized (choiceElementViewer) {
                    int c = this.count;
                    int i = event.getY() / ELEMENT_HEIGHT;
                    if (i >= c) {
                        i = c - 1;
                    }
                    if (i < 0) {
                        i = 0;
                    }
                    if (this.selected != i) {
                        this.selected = i;
                        this.requestInvalidate();
                    }
                    break;
                }
            }
            case 11: 
            case 15: {
                int f;
                if (event.getButton() != 0 || (f = this.focused) == -1) break;
                int p = this.pressed;
                this.focused = -1;
                this.pressed = -1;
                if (this.type == 4) {
                    if (f != -2 || p != 0) break;
                    ChoiceElementViewer choiceElementViewer = this.monitor;
                    synchronized (choiceElementViewer) {
                        if (this.count > 0) {
                            this.showPopupMenu();
                        } else {
                            this.requestPaint();
                        }
                        break;
                    }
                }
                ChoiceElementViewer choiceElementViewer = this.monitor;
                synchronized (choiceElementViewer) {
                    if (f == -2) {
                        int c = this.count;
                        int i = event.getY() / ELEMENT_HEIGHT;
                        if (i >= c) {
                            i = c - 1;
                        }
                        if (i < 0) {
                            i = 0;
                        }
                        if (this.selected != i) {
                            this.selected = i;
                            this.requestInvalidate();
                        }
                    }
                    if (p >= 0) {
                        switch (this.type) {
                            case 1: {
                                int s;
                                if (p >= this.count || p == (s = this.checked)) break;
                                ChoiceElement[] list = this.elements;
                                this.elements[s].selected = false;
                                this.checked = p;
                                list[p].selected = true;
                                super.notifyStateChanged();
                                break;
                            }
                            case 2: {
                                if (p >= this.count) break;
                                ChoiceElement item = this.elements[p];
                                this.elements[p].selected = !item.selected;
                                super.notifyStateChanged();
                            }
                        }
                    }
                }
                this.requestPaint();
            }
        }
    }

    void onFocusLost() {
        this.focused = -1;
        this.pressed = -1;
        super.onFocusLost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onFocusMove(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        int elementIndex;
        if (!super.onFocusMove(direction, viewportWidth, viewportHeight, visibleRectangle)) {
            int elementIndex2 = 0;
            if (this.type != 4) {
                ChoiceElementViewer choiceElementViewer = this.monitor;
                synchronized (choiceElementViewer) {
                    if (direction == 1) {
                        int len = this.count;
                        if (len > 0) {
                            this.selected = elementIndex2 = len - 1;
                        }
                    } else {
                        this.selected = 0;
                    }
                }
            }
            visibleRectangle[0] = 0;
            visibleRectangle[1] = elementIndex2 * ELEMENT_HEIGHT;
            visibleRectangle[2] = this.listWidth;
            visibleRectangle[3] = ELEMENT_HEIGHT;
            return true;
        }
        if (this.type == 4) {
            return false;
        }
        switch (direction) {
            case 0: {
                elementIndex = this.selected;
                break;
            }
            case 1: {
                boolean stay;
                ChoiceElementViewer choiceElementViewer = this.monitor;
                synchronized (choiceElementViewer) {
                    elementIndex = this.selected;
                    stay = elementIndex > 0;
                    if (stay) {
                        this.selected = --elementIndex;
                    }
                }
                if (!stay) {
                    return false;
                }
                this.requestPaint();
                break;
            }
            case 6: {
                boolean stay;
                ChoiceElementViewer choiceElementViewer = this.monitor;
                synchronized (choiceElementViewer) {
                    elementIndex = this.selected;
                    stay = elementIndex < this.count - 1;
                    if (stay) {
                        this.selected = ++elementIndex;
                    }
                }
                if (!stay) {
                    return false;
                }
                this.requestPaint();
                break;
            }
            default: {
                return false;
            }
        }
        visibleRectangle[0] = 0;
        visibleRectangle[1] = elementIndex * ELEMENT_HEIGHT;
        visibleRectangle[2] = this.listWidth;
        visibleRectangle[3] = ELEMENT_HEIGHT;
        return true;
    }

    int getMinimumContentWidth() {
        return 100;
    }

    int getMinimumContentHeight() {
        return ELEMENT_HEIGHT * (this.type == 4 ? 1 : Math.max(1, this.count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setSelected(int elementIndex) {
        ChoiceElementViewer choiceElementViewer = this.monitor;
        synchronized (choiceElementViewer) {
            int lim = this.count - 1;
            if (elementIndex > lim) {
                elementIndex = lim;
            }
            if (elementIndex < 0) {
                elementIndex = 0;
            }
            if (this.selected != elementIndex) {
                this.selected = elementIndex;
                super.notifyStateChanged();
                super.requestPaint();
            }
        }
    }

    private void showPopupMenu() {
        Display parent;
        int len = this.count;
        Screen screen = this.owner;
        if (screen == null || (parent = screen.getParentDisplay()) == null) {
            return;
        }
        ChoiceList menu = this.popupMenu;
        ScrollBar scroll = menu.getScrollBar();
        int position = scroll.getPosition();
        menu.deleteAll();
        ChoiceElement[] list = this.elements;
        int i = 0;
        while (i < len) {
            ChoiceElement item = list[i];
            menu.append(item.text, item.icon, item.font);
            ++i;
        }
        if (len > 0) {
            menu.setSelectedIndex(this.selected);
        }
        scroll.setPosition(position);
        parent.setCurrent(menu);
    }

    private int getFocusedElement(int x, int y) {
        return x >= 0 && x < this.listWidth && y >= 0 && y < this.listHeight ? (this.type != 4 && x < MARGIN1 ? y / ELEMENT_HEIGHT : -2) : -1;
    }

    private ChoiceList createPopupMenu() {
        final Command select = SELECT_COMMAND;
        Command back = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        ChoiceList result = new ChoiceList(null, null);
        result.setCommandListener(new CommandListener(){

            public void commandAction(Command command, Displayable screen) {
                Display parent;
                if (command == select) {
                    ChoiceGroup.this.setSelected(((TextMenu)((Object)screen)).getSelectedIndex());
                }
                if ((parent = screen.getParentDisplay()) != null) {
                    parent.hideSurfaceScreen();
                }
            }
        });
        result.addCommand(select);
        result.addCommand(back);
        return result;
    }
}

