/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.ScreenGraphics;
import javax.microedition.lcdui.SurfaceScreen;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.lcdui.FastMultilinedStringBuilder;
import malik.emulator.microedition.lcdui.MultilinedStringBuilder;
import malik.emulator.microedition.lcdui.ScrollBarStyle;
import malik.emulator.util.StringBuilder;

public class SurfaceTextViewer
extends SurfaceScreen {
    private char[] buffer;
    private String text;
    private Font font;
    private final MultilinedStringBuilder builder;

    public SurfaceTextViewer(String text) {
        this(text, null, null);
    }

    public SurfaceTextViewer(String text, Font font) {
        this(text, font, null);
    }

    public SurfaceTextViewer(String text, Font font, ScrollBarStyle style) {
        super(null, 0, true, style);
        FastMultilinedStringBuilder builder = new FastMultilinedStringBuilder();
        builder.append(text);
        this.text = text;
        this.font = font;
        this.builder = builder;
        this.correctScrollBarRange(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font font) {
        MultilinedStringBuilder builder;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.builder;
        synchronized (builder) {
            this.font = font;
            this.correctScrollBarRange(builder);
            this.requestPaintAll();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        MultilinedStringBuilder builder;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.builder;
        synchronized (builder) {
            this.text = text;
            builder.clear();
            builder.append(text);
            this.correctScrollBarRange(builder);
            this.requestPaintAll();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(ScreenGraphics render) {
        MultilinedStringBuilder builder;
        int clipTop = render.getClipY();
        int clipHeight = render.getClipHeight();
        MultilinedStringBuilder multilinedStringBuilder = builder = this.builder;
        synchronized (builder) {
            char[] lbuf = this.buffer;
            Font font = this.font;
            int line = font.getHeight();
            int srow = clipTop / line;
            int frow = (clipTop + clipHeight - 1) / line;
            render.setFont(font);
            render.setColor(RasterCanvas.getSystemColor((int)40));
            int len = builder.lines();
            int lhei = font.getHeight() * len;
            int top = clipHeight < lhei ? srow * line : clipHeight - lhei >> 1;
            int index = srow;
            while (index <= frow && index < len) {
                int lofs = builder.lineOffset(index);
                int llen = builder.lineLength(index);
                if (lbuf == null || lbuf.length < llen) {
                    lbuf = this.buffer = new char[StringBuilder.optimalCapacity((int)llen)];
                }
                builder.copy(lofs, lofs + llen, lbuf, 0);
                render.drawChars(lbuf, 0, llen, 0, top, 20);
                top += line;
                ++index;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSizeChanged(int width, int height) {
        MultilinedStringBuilder builder;
        MultilinedStringBuilder multilinedStringBuilder = builder = this.builder;
        synchronized (builder) {
            this.correctScrollBarRange(builder);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            super.onSizeChanged(width, height);
            return;
        }
    }

    void onClientKeyboardEvent(KeyboardEvent event) {
        int key = event.getKey();
        DeviceSettings settings = DeviceManager.getInstance().getSettings();
        switch (event.getAction()) {
            case 5: 
            case 6: {
                Font font;
                if (key == settings.getKeyUsedAs(36)) {
                    Font font2;
                    super.getScrollBar().scroll(((font2 = this.font) == null ? Font.getDefaultFont() : font2).getHeight());
                    break;
                }
                if (key != settings.getKeyUsedAs(38)) break;
                super.getScrollBar().scroll(-((font = this.font) == null ? Font.getDefaultFont() : font).getHeight());
            }
        }
    }

    private void correctScrollBarRange(MultilinedStringBuilder builder) {
        Font font = this.font;
        if (font == null) {
            font = Font.getDefaultFont();
        }
        builder.split(font, super.getWidth());
        super.getScrollBar().setRange(font.getHeight() * builder.lines());
    }
}

