/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connection;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.MIDletDisplay;
import javax.microedition.lcdui.SystemDisplay;
import javax.microedition.lcdui.VisibleElement;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.TimeBase;
import javax.microedition.media.protocol.DataSource;
import malik.emulator.application.AppProxy;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.fileformats.graphics.ImageDecoder;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.media.sound.SoundPlayerException;
import malik.emulator.media.sound.SyntheticSoundPlayer;
import malik.emulator.microedition.DeviceControl;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.EmptyDeviceControl;
import malik.emulator.microedition.media.SystemTimeBase;

public abstract class DeviceManager
extends AppProxy {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    public static final String TONE_DEVICE_LOCATOR = "device://tone";
    public static final String MIDI_DEVICE_LOCATOR = "device://midi";
    private static DeviceManager INSTANCE;
    private boolean paused;
    private Display current;
    private final Display main;
    private final DeviceSettings settings;
    private final DeviceControl vibrator;
    private final DeviceControl backlight;
    private final TimeBase systemTimeBase;
    private SyntheticSoundPlayer tonePlayer;

    public static DeviceManager getInstance() {
        return INSTANCE;
    }

    protected DeviceManager() {
        if (INSTANCE != null) {
            throw new InstantiationError("DeviceManager: \u043d\u0435\u043b\u044c\u0437\u044f \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0435\u0449\u0451 \u043e\u0434\u0438\u043d \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440 DeviceManager. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 DeviceManager.getInstance().");
        }
        INSTANCE = this;
        EmptyDeviceControl empty = new EmptyDeviceControl();
        DeviceSettings settings = this.createSettings();
        if (settings == null) {
            settings = new DeviceSettings();
        }
        this.settings = settings;
        settings.loadMIDletDescriptor();
        settings.loadMIDletProperties();
        SystemDisplay display = this.createMainDisplay();
        if (display == null) {
            RasterCanvas screen = RasterCanvas.screen;
            display = new SystemDisplay(false, screen.getWidth(), screen.getHeight());
        }
        this.main = display;
        this.current = display;
        DeviceControl vibrator = this.createVibrator();
        if (vibrator == null) {
            vibrator = empty;
        }
        this.vibrator = vibrator;
        DeviceControl backlight = this.createBacklight();
        if (backlight == null) {
            backlight = empty;
        }
        this.backlight = backlight;
        TimeBase systemTimeBase = this.createSystemTimeBase();
        if (systemTimeBase == null) {
            systemTimeBase = new SystemTimeBase();
        }
        this.systemTimeBase = systemTimeBase;
    }

    public abstract String[] getSupportedContentTypes(String var1);

    public abstract String[] getSupportedProtocols(String var1);

    public abstract Player createPlayer(String var1) throws IOException, MediaException;

    public abstract Player createPlayer(DataSource var1) throws IOException, MediaException;

    public abstract Player createPlayer(InputStream var1, String var2) throws IOException, MediaException;

    public abstract Connection openConnection(String var1, int var2, boolean var3) throws IOException;

    public abstract ImageDecoder openImageDecoder(InputStream var1) throws IOException;

    public void playTone(int note, int duration, int volume) throws MediaException {
        SyntheticSoundPlayer tonePlayer;
        if (note < 0 || note > 127) {
            throw new IllegalArgumentException("Manager.playTone: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 note \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (duration <= 0) {
            throw new IllegalArgumentException("manager.playTone: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 duration \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c.");
        }
        if (volume < 0) {
            volume = 0;
        }
        if (volume > 100) {
            volume = 100;
        }
        volume = volume * 127 / 100;
        final int noteOffMessage = 0x900000 | note << 8;
        int noteOnMessage = noteOffMessage | volume;
        try {
            SyntheticSoundPlayer player = this.tonePlayer;
            if (player == null) {
                player = this.tonePlayer = SyntheticSoundPlayer.open();
            }
            tonePlayer = player;
            tonePlayer.sendMessage(noteOnMessage);
        }
        catch (SoundPlayerException e) {
            throw new MediaException(e.getRealMessage());
        }
        Scheduler.schedule((Scheduler.Task)new Scheduler.Task(){

            public void run() {
                try {
                    tonePlayer.sendMessage(noteOffMessage);
                }
                catch (SoundPlayerException e) {
                    e.printRealStackTrace();
                }
            }
        }, (long)duration, (int)2);
    }

    public void applicationStarted(Display display) {
        if (display != null) {
            this.setCurrent(display);
        }
    }

    public void applicationStopped(Display display) {
        this.setCurrent(this.main);
    }

    public void setCurrentDisplay(Display current) {
        if (current != null) {
            this.setCurrent(current);
        }
    }

    public final boolean isPaused() {
        return this.paused;
    }

    public final Display getCurrentDisplay() {
        return this.current;
    }

    public final Display getMainDisplay() {
        return this.main;
    }

    public final DeviceSettings getSettings() {
        return this.settings;
    }

    public final DeviceControl getVibrator() {
        return this.vibrator;
    }

    public final DeviceControl getBacklight() {
        return this.backlight;
    }

    public final TimeBase getSystemTimeBase() {
        return this.systemTimeBase;
    }

    protected abstract void showStartScreen(Display var1);

    protected abstract void showConsoleScreen(Display var1);

    protected abstract void showExitAppScreen(Display var1);

    protected void appLaunch() {
        Display display = this.main;
        this.setCurrent(display);
        this.showStartScreen(display);
    }

    protected void keyboardEvent(KeyboardEvent event) {
        Display current = this.current;
        if (current instanceof MIDletDisplay) {
            int key = event.getKey();
            Display main = this.main;
            DeviceSettings settings = this.settings;
            switch (event.getAction()) {
                case 5: 
                case 6: {
                    if (key != settings.getKeyUsedAs(44) && key != settings.getKeyUsedAs(46)) break;
                    return;
                }
                case 7: {
                    boolean console = key == settings.getKeyUsedAs(44);
                    if (!console && key != settings.getKeyUsedAs(46)) break;
                    if (console) {
                        this.showConsoleScreen(main);
                    } else {
                        this.showExitAppScreen(main);
                    }
                    this.setCurrent(main);
                    return;
                }
            }
        }
        current.handleKeyboardEvent(event);
    }

    protected void pointerEvent(PointerEvent event) {
        Display current = this.current;
        event.translateTo(current.getLeft(), current.getTop());
        current.handlePointerEvent(event);
    }

    protected void windowShow() {
        this.paused = false;
        ((VisibleElement)this.current).show();
    }

    protected void windowHide() {
        this.paused = true;
        ((VisibleElement)this.current).hide();
    }

    protected SystemDisplay createMainDisplay() {
        return null;
    }

    protected DeviceSettings createSettings() {
        return null;
    }

    protected DeviceControl createVibrator() {
        return null;
    }

    protected DeviceControl createBacklight() {
        return null;
    }

    protected TimeBase createSystemTimeBase() {
        return null;
    }

    private void setCurrent(Display current) {
        Display previous = this.current;
        this.current = current;
        ((VisibleElement)previous).hide();
        ((VisibleElement)current).show();
    }
}

