/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.media;

import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.TimeBase;
import malik.emulator.microedition.media.ControlList;
import malik.emulator.util.RunnableQueue;

public abstract class CustomPlayer
extends ControlList
implements Player {
    private static final EventThread EVENT;
    private static final Long MINUS_ONE;
    private static final Long ZERO;
    private boolean realizing;
    private int state = 100;
    PlayerListener[] listeners;
    private Long duration = ZERO;
    protected TimeBase master = Manager.getSystemTimeBase();
    protected String contentType;
    protected final Object monitor = new Object();

    static {
        EventThread event = new EventThread();
        event.start();
        EVENT = event;
        MINUS_ONE = new Long(-1L);
        ZERO = new Long(0L);
    }

    private static Long toLongCover(long value) {
        return value == 0L ? ZERO : (value == -1L ? MINUS_ONE : new Long(value));
    }

    protected CustomPlayer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Control[] getControls() {
        Control[] result;
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            int state = this.state;
            if (state == 100) {
                error = 1;
                result = null;
            } else if (state == 0) {
                error = 2;
                result = null;
            } else {
                result = super.getControls();
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.getControls: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0434\u0430\u043d\u043d\u044b\u043c\u0438.");
            }
            case 2: {
                throw new IllegalStateException("Player.getControls: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Control getControl(String controlTypeName) {
        Control result;
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            int state = this.state;
            if (state == 100) {
                error = 1;
                result = null;
            } else if (state == 0) {
                error = 2;
                result = null;
            } else if (controlTypeName == null) {
                error = 3;
                result = null;
            } else {
                result = super.getControl(controlTypeName);
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.getControl: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0434\u0430\u043d\u043d\u044b\u043c\u0438.");
            }
            case 2: {
                throw new IllegalStateException("Player.getControl: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 3: {
                throw new IllegalArgumentException("Player.getControl: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 controlTypeName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.state != 0) {
                this.playerClose();
                this.controls = null;
                this.state = 0;
                this.duration = ZERO;
                this.master = null;
                this.contentType = null;
                this.postEvent("closed", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deallocate() {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int state = this.state;
            if (state == 0) {
                error = true;
            } else if (state == 100 && this.realizing) {
                this.playerUnrealize();
            } else {
                if (state == 400) {
                    state = 300;
                    this.postEvent("stopped", CustomPlayer.toLongCover(this.playerGetMediaTime()));
                }
                if (state == 300) {
                    this.playerUnprefetch();
                    this.state = 200;
                    this.postEvent("deviceUnavailable", this.playerGetDeviceName());
                }
            }
        }
        if (error) {
            throw new IllegalStateException("Player.deallocate: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void realize() throws MediaException {
        Object monitor;
        int error = 0;
        Object object = monitor = this.monitor;
        synchronized (monitor) {
            int state = this.state;
            if (state == 100 && this.realizing) {
                error = 1;
            } else if (state == 0) {
                error = 2;
            } else if (state == 200 || state == 300 || state == 400) {
                error = 3;
            } else {
                this.realizing = true;
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            switch (error) {
                case 1: {
                    throw new MediaException("Player.realize: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0443\u0436\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u0442\u0441\u044f \u0434\u0430\u043d\u043d\u044b\u043c\u0438.");
                }
                case 2: {
                    throw new IllegalStateException("Player.realize: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
                }
                case 3: {
                    return;
                }
            }
            boolean realized = false;
            MediaException exception = null;
            try {
                this.playerRealize();
                realized = true;
            }
            catch (MediaException e) {
                exception = e;
            }
            catch (Exception exception2) {}
            object = monitor;
            synchronized (object) {
                if (this.state == 100 && realized) {
                    this.state = 200;
                }
                this.realizing = false;
            }
            if (exception != null) {
                throw exception;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void prefetch() throws MediaException {
        switch (this.state) {
            case 0: {
                throw new IllegalStateException("Player.prefetch: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 100: {
                this.realize();
                if (this.state == 200) break;
                throw new MediaException("Player.prefetch: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0441\u0435\u0439\u0447\u0430\u0441 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c.");
            }
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.state == 200) {
                this.playerPrefetch();
                this.state = 300;
                this.postEvent("deviceAvailable", this.playerGetDeviceName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws MediaException {
        switch (this.state) {
            case 0: {
                throw new IllegalStateException("Player.start: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 100: {
                this.realize();
                if (this.state != 200) {
                    throw new MediaException("Player.start: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0441\u0435\u0439\u0447\u0430\u0441 \u043d\u0430\u0447\u0430\u0442\u044c \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445.");
                }
            }
            case 200: {
                this.prefetch();
                if (this.state == 300) break;
                throw new MediaException("Player.start: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0441\u0435\u0439\u0447\u0430\u0441 \u043d\u0430\u0447\u0430\u0442\u044c \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445.");
            }
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.state == 300) {
                long mediaTime = this.playerGetMediaTime();
                this.playerStart();
                this.state = 400;
                this.postEvent("started", CustomPlayer.toLongCover(mediaTime));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws MediaException {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int state = this.state;
            if (state == 0) {
                error = true;
            } else if (state == 400) {
                this.playerStop();
                this.state = 300;
                this.postEvent("stopped", CustomPlayer.toLongCover(this.playerGetMediaTime()));
            }
        }
        if (error) {
            throw new IllegalStateException("Player.stop: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPlayerListener(PlayerListener listener) {
        if (this.state == 0) {
            throw new IllegalStateException("Player.addPlayerListener: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        if (listener == null) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            Object[] listeners = this.listeners;
            if (this.listeners == null) {
                this.listeners = new PlayerListener[3];
                listeners = this.listeners;
            }
            int len = listeners.length;
            if (Array.findf((Object[])listeners, (int)0, (Object)listener) >= len) {
                int index = Array.findf((Object[])listeners, (int)0, null);
                if (index >= len) {
                    Object[] objectArray = listeners;
                    listeners = new PlayerListener[(len << 1) + 1];
                    Array.copy((Object[])objectArray, (int)0, (Object[])listeners, (int)0, (int)len);
                    this.listeners = listeners;
                }
                listeners[index] = listener;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePlayerListener(PlayerListener listener) {
        if (this.state == 0) {
            throw new IllegalStateException("Player.removePlayerListener: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        if (listener == null) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            int index;
            Object[] listeners = this.listeners;
            if (this.listeners != null && (index = Array.findf((Object[])listeners, (int)0, (Object)listener)) < listeners.length) {
                listeners[index] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLoopCount(int loopCount) {
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            int state = this.state;
            if (state == 400) {
                error = 1;
            } else if (state == 0) {
                error = 2;
            } else if (loopCount == 0) {
                error = 3;
            } else {
                this.playerSetLoopCount(loopCount);
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.setLoopCount: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043d\u044f\u0442.");
            }
            case 2: {
                throw new IllegalStateException("Player.setLoopCount: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 3: {
                throw new IllegalArgumentException("Player.setLoopCount: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 loopCount \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u044e.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTimeBase(TimeBase master) throws MediaException {
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            int state = this.state;
            if (state == 100) {
                error = 1;
            } else if (state == 400) {
                error = 2;
            } else if (state == 0) {
                error = 3;
            } else {
                this.playerSetTimeBase(master);
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.setTimeBase: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0434\u0430\u043d\u043d\u044b\u043c\u0438.");
            }
            case 2: {
                throw new IllegalStateException("Player.setTimeBase: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043d\u044f\u0442.");
            }
            case 3: {
                throw new IllegalStateException("Player.setTimeBase: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
        }
    }

    public final int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long setMediaTime(long mediaTime) throws MediaException {
        long result;
        int error = 0;
        Object object = this.monitor;
        synchronized (object) {
            int state = this.state;
            if (state == 100) {
                error = 1;
                result = 0L;
            } else if (state == 0) {
                error = 2;
                result = 0L;
            } else {
                result = this.playerSetMediaTime(mediaTime);
            }
        }
        switch (error) {
            case 1: {
                throw new IllegalStateException("Player.setMediaTime: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0434\u0430\u043d\u043d\u044b\u043c\u0438.");
            }
            case 2: {
                throw new IllegalStateException("Player.setMediaTime: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getMediaTime() {
        long result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (this.state == 0) {
                error = true;
                result = 0L;
            } else {
                result = this.playerGetMediaTime();
            }
        }
        if (error) {
            throw new IllegalStateException("Player.getMediaTime: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    public final long getDuration() {
        if (this.state == 0) {
            throw new IllegalStateException("Player.getDuration: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return this.duration;
    }

    public final TimeBase getTimeBase() {
        switch (this.state) {
            case 0: {
                throw new IllegalStateException("Player.getTimeBase: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 100: {
                throw new IllegalStateException("Player.getTimeBase: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0434\u0430\u043d\u043d\u044b\u043c\u0438.");
            }
        }
        return this.master;
    }

    public final String getContentType() {
        switch (this.state) {
            case 0: {
                throw new IllegalStateException("Player.getContentType: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 100: {
                throw new IllegalStateException("Player.getContentType: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0434\u0430\u043d\u043d\u044b\u043c\u0438.");
            }
        }
        return this.contentType;
    }

    public final boolean isRealizing() {
        return this.realizing;
    }

    protected abstract void playerUnrealize();

    protected abstract void playerUnprefetch();

    protected abstract void playerRealize() throws MediaException, InterruptedException;

    protected abstract void playerPrefetch() throws MediaException;

    protected abstract void playerStart() throws MediaException;

    protected abstract void playerStop() throws MediaException;

    protected abstract void playerSetLoopCount(int var1);

    protected abstract long playerSetMediaTime(long var1) throws MediaException;

    protected abstract long playerGetMediaTime();

    protected void postEvent(String event, Object data) {
        EVENT.post(this, event, data);
    }

    protected void playerClose() {
    }

    protected void playerRestart() {
        this.postEvent("endOfMedia", this.duration);
        this.postEvent("started", ZERO);
    }

    protected void playerEndOfMedia() {
        this.state = 300;
        this.postEvent("endOfMedia", this.duration);
    }

    protected void playerSetTimeBase(TimeBase master) throws MediaException {
        if (master != Manager.getSystemTimeBase()) {
            throw new MediaException("Player.setTimeBase: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0431\u0430\u0437\u044b \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }
    }

    protected String playerGetDeviceName() {
        return "\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0439 \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c";
    }

    protected final void setDuration(long duration) {
        Long newDuration;
        this.duration = newDuration = CustomPlayer.toLongCover(duration);
        this.postEvent("durationUpdated", newDuration);
    }

    private final class EventData
    implements Runnable {
        private final String event;
        private final Object data;

        public EventData(String event, Object data) {
            this.event = event;
            this.data = data;
        }

        public void run() {
            CustomPlayer player = CustomPlayer.this;
            String event = this.event;
            Object data = this.data;
            PlayerListener[] listeners = player.listeners;
            int i = player.listeners != null ? listeners.length : 0;
            while (i-- > 0) {
                PlayerListener listener = listeners[i];
                if (listener == null) continue;
                try {
                    listener.playerUpdate(player, event, data);
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
            }
            if ("closed".equals(event)) {
                player.listeners = null;
            }
        }
    }

    private static final class EventThread
    extends Thread {
        private final RunnableQueue queue = new RunnableQueue();

        public EventThread() {
            super("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u043e\u0442 \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u0435\u0439");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RunnableQueue monitor = this.queue;
            while (true) {
                Runnable event = null;
                RunnableQueue runnableQueue = monitor;
                synchronized (runnableQueue) {
                    try {
                        monitor.wait();
                    }
                    catch (InterruptedException e) {
                        e.printRealStackTrace();
                    }
                    if (!monitor.isEmpty()) {
                        event = monitor.peekHeadRunnable();
                        monitor.removeHeadElement();
                    }
                }
                if (event == null) continue;
                event.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void post(CustomPlayer player, String event, Object data) {
            RunnableQueue monitor;
            RunnableQueue runnableQueue = monitor = this.queue;
            synchronized (monitor) {
                CustomPlayer customPlayer = player;
                customPlayer.getClass();
                monitor.addTailElement((Runnable)customPlayer.new EventData(event, data));
                monitor.notify();
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        }
    }
}

