/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

public class UUID {
    private long low64bit;
    private long high64bit;

    public static char getDigitRepresentation(int digit) {
        if (digit >= 0 && digit < 10) {
            return (char)(digit + 48);
        }
        if (digit >= 10 && digit < 36) {
            return (char)(digit + 87);
        }
        throw new ArrayIndexOutOfBoundsException(digit);
    }

    public UUID(long value) {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("UUID: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 value.");
        }
        this.low64bit = value;
        this.high64bit = 0L;
    }

    public UUID(String value, boolean shortType) {
        if (value == null) {
            throw new NullPointerException("UUID: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 value \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = value.length();
        if (len <= 0 || len > (shortType ? 8 : 32)) {
            throw new IllegalArgumentException("UUID: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 value \u0438\u043c\u0435\u0435\u0442 \u043e\u0447\u0435\u043d\u044c \u0431\u043e\u043b\u044c\u0448\u0443\u044e \u0434\u043b\u0438\u043d\u0443.");
        }
        char[] ac = value.toCharArray();
        long high64bit = 0L;
        long low64bit = 0L;
        int j = 0;
        int i = len;
        while (i-- > 0) {
            int d;
            char c = ac[i];
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                throw new NumberFormatException("UUID: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 value \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0437 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 0-9, A-F, a-f.");
            }
            int n = c >= 'A' && c <= 'F' ? c - 55 : (d = c >= 'a' && c <= 'f' ? c - 87 : c - 48);
            if (j >= 16) {
                high64bit |= (long)d << j - 16;
            } else {
                low64bit |= (long)d << j;
            }
            j += 4;
        }
        this.low64bit = low64bit;
        this.high64bit = high64bit;
    }

    public boolean equals(Object ref) {
        block2: {
            block3: {
                if (ref == this) break block2;
                if (!(ref instanceof UUID)) break block3;
                UUID other = (UUID)ref;
                if (this.low64bit == other.low64bit && this.high64bit == other.high64bit) break block2;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        long tmp = this.low64bit;
        int n = (int)tmp ^ (int)(tmp >> 32);
        tmp = this.high64bit;
        return n ^ (int)tmp ^ (int)(tmp >> 32);
    }

    public String toString() {
        int i = 32;
        int len = 32;
        long qword0 = this.low64bit;
        long qword1 = this.high64bit;
        char[] buf = new char[len];
        do {
            buf[--i] = Character.toUpperCase(UUID.getDigitRepresentation((int)qword0 & 0xF));
        } while ((qword0 = qword0 >>> 4 | qword1 << 60) != 0L | (qword1 >>>= 4) != 0L);
        return new String(buf, i, len - i);
    }

    public final boolean isRealEquals(UUID other) {
        return other != null && this.low64bit == other.low64bit && this.high64bit == other.high64bit;
    }

    public final long getLow64bit() {
        return this.low64bit;
    }

    public final long getHigh64bit() {
        return this.high64bit;
    }
}

