/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.graphics;

import malik.emulator.media.graphics.GraphicBuffer;
import malik.emulator.util.SystemDescriptor;

class GraphicBufferDescriptor
extends SystemDescriptor {
    public int base;
    public int scan;
    public int sizes;

    GraphicBufferDescriptor() {
    }

    public final void assign(int base, int scanlength, int width, int height) {
        this.base = base;
        this.scan = scanlength;
        this.sizes = width & 0xFFFF | height << 16;
    }

    public final void assign(int[] pixels, int offset, int scanlength, int width, int height) {
        this.base = Array.getFirstElementAddress((Object)pixels) + (offset << 2);
        this.scan = scanlength;
        this.sizes = width & 0xFFFF | height << 16;
    }

    public final void assign(GraphicBuffer buffer, int cleft, int ctop, int cwidth, int cheight) {
        int s = buffer.getScanlength();
        this.base = buffer.getBase() + (cleft + ctop * s << 2);
        this.scan = s;
        this.sizes = cwidth & 0xFFFF | cheight << 16;
    }
}

