/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.text;

import malik.emulator.media.text.StringDrawDescriptor;

public final class RasterFont {
    private static final RasterFont[] FONTS;
    private boolean bold;
    private boolean italic;
    private int handle;
    private int height;
    private int baselineHeight;
    private int baselinePosition;
    private StringDrawDescriptor stringDescriptor;
    private String name;

    static {
        int count = 0;
        Object[] fonts = new RasterFont[1];
        int handle = RasterFont.findNextFontHandle(0);
        while (handle != 0) {
            if (count == fonts.length) {
                Object[] objectArray = fonts;
                fonts = new RasterFont[count << 1];
                Array.copy((Object[])objectArray, (int)0, (Object[])fonts, (int)0, (int)count);
            }
            fonts[count++] = new RasterFont(handle);
            handle = RasterFont.findNextFontHandle(handle);
        }
        if (count < fonts.length) {
            Object[] objectArray = fonts;
            fonts = new RasterFont[count];
            Array.copy((Object[])objectArray, (int)0, (Object[])fonts, (int)0, (int)count);
        }
        FONTS = fonts;
    }

    public static int getRasterFontsCount() {
        return FONTS.length;
    }

    public static RasterFont getRasterFontAtIndex(int index) {
        return index >= 0 && index < FONTS.length ? FONTS[index] : null;
    }

    public static RasterFont getRasterFontAtName(String name) {
        if (name == null) {
            return FONTS[0];
        }
        int i = FONTS.length;
        while (i-- > 0) {
            RasterFont font = FONTS[i];
            if (!name.equals(font.name)) continue;
            return font;
        }
        return FONTS[0];
    }

    private static int findNextFontHandle(int handle) {
        return (int)MalikSystem.syscall((long)handle, (int)40);
    }

    private RasterFont(int handle) {
        int b;
        int h;
        int i = (int)MalikSystem.syscall((long)handle, (int)42);
        char[] name = new char[(int)MalikSystem.syscall((int)handle, (int)0, (int)41)];
        MalikSystem.syscall((int)handle, (int)Array.getFirstElementAddress((Object)name), (int)41);
        this.bold = (i & 1) != 0;
        this.italic = (i & 2) != 0;
        this.handle = handle;
        this.height = h = i >> 8 & 0xFF;
        this.baselineHeight = b = i >> 16 & 0xFF;
        this.baselinePosition = h - b;
        this.stringDescriptor = new StringDrawDescriptor(handle);
        this.name = new String(name);
    }

    public String toString() {
        return "\u0428\u0440\u0438\u0444\u0442[" + this.name + ", \u0440\u0430\u0437\u043c\u0435\u0440=" + this.height + (this.bold ? ", \u0436\u0438\u0440\u043d\u044b\u0439" : "") + (this.italic ? ", \u043a\u0443\u0440\u0441\u0438\u0432" : "") + "]";
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean charSupported(int charCode) {
        return (int)MalikSystem.syscall((int)this.handle, (int)charCode, (int)43) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int charWidth(int charCode) {
        StringDrawDescriptor s;
        StringDrawDescriptor stringDrawDescriptor = s = this.stringDescriptor;
        synchronized (s) {
            s.style = 0;
            s.length = 1;
            s.chars = MalikSystem.getLocalVariableAddress((int)charCode);
            int result = (int)MalikSystem.syscall((long)s.getDescriptorAddress(), (int)44);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int charsWidth(int[] src) {
        StringDrawDescriptor s;
        if (src == null) {
            throw new NullPointerException("RasterFont.charsWidth: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        StringDrawDescriptor stringDrawDescriptor = s = this.stringDescriptor;
        synchronized (s) {
            s.style = 0;
            s.length = src.length;
            s.chars = Array.getFirstElementAddress((Object)src);
            int result = (int)MalikSystem.syscall((long)s.getDescriptorAddress(), (int)44);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int charsWidth(int[] src, int offset, int length) {
        StringDrawDescriptor s;
        if (src == null) {
            throw new NullPointerException("RasterFont.charsWidth: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new IndexOutOfBoundsException("RasterFont.charsWidth: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        StringDrawDescriptor stringDrawDescriptor = s = this.stringDescriptor;
        synchronized (s) {
            s.style = 0;
            s.length = length;
            s.chars = Array.getFirstElementAddress((Object)src) + (offset << 2);
            int result = (int)MalikSystem.syscall((long)s.getDescriptorAddress(), (int)44);
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int charsWidth(char[] src) {
        StringDrawDescriptor s;
        if (src == null) {
            throw new NullPointerException("RasterFont.charsWidth: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        StringDrawDescriptor stringDrawDescriptor = s = this.stringDescriptor;
        synchronized (s) {
            s.style = Integer.MIN_VALUE;
            s.length = src.length;
            s.chars = Array.getFirstElementAddress((Object)src);
            int result = (int)MalikSystem.syscall((long)s.getDescriptorAddress(), (int)44);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int charsWidth(char[] src, int offset, int length) {
        StringDrawDescriptor s;
        if (src == null) {
            throw new NullPointerException("RasterFont.charsWidth: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new IndexOutOfBoundsException("RasterFont.charsWidth: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        StringDrawDescriptor stringDrawDescriptor = s = this.stringDescriptor;
        synchronized (s) {
            s.style = Integer.MIN_VALUE;
            s.length = length;
            s.chars = Array.getFirstElementAddress((Object)src) + (offset << 1);
            int result = (int)MalikSystem.syscall((long)s.getDescriptorAddress(), (int)44);
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stringWidth(String src) {
        StringDrawDescriptor s;
        if (src == null) {
            throw new NullPointerException("RasterFont.stringWidth: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        StringDrawDescriptor stringDrawDescriptor = s = this.stringDescriptor;
        synchronized (s) {
            s.style = Integer.MIN_VALUE;
            s.length = src.length();
            s.chars = Array.getFirstElementAddress((String)src);
            int result = (int)MalikSystem.syscall((long)s.getDescriptorAddress(), (int)44);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int substringWidth(String src, int offset, int length) {
        StringDrawDescriptor s;
        if (src == null) {
            throw new NullPointerException("RasterFont.substringWidth: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = src.length();
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new IndexOutOfBoundsException("RasterFont.substringWidth: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        StringDrawDescriptor stringDrawDescriptor = s = this.stringDescriptor;
        synchronized (s) {
            s.style = Integer.MIN_VALUE;
            s.length = length;
            s.chars = Array.getFirstElementAddress((String)src) + (offset << 1);
            int result = (int)MalikSystem.syscall((long)s.getDescriptorAddress(), (int)44);
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return result;
        }
    }

    public int getHandle() {
        return this.handle;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBaselineHeight() {
        return this.baselineHeight;
    }

    public int getBaselinePosition() {
        return this.baselinePosition;
    }

    public String getName() {
        return this.name;
    }
}

