/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.lang.ref.WeakReference;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandEnumeration;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Container;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.GraphicsClipRestricted;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.ScrollBar;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.Ticker;

public class Form
extends Container {
    private static final int LEFT = 0;
    private static final int TOP = 1;
    private static final int WIDTH = 2;
    private static final int HEIGHT = 3;
    private static final int DIR_NONE = 0;
    private static final int DIR_UP = 1;
    private static final int DIR_LEFT = 2;
    private static final int DIR_RIGHT = 5;
    private static final int DIR_DOWN = 6;
    private boolean needPlaceItems;
    private boolean stayPlaceItems;
    private boolean firstSizeChanged;
    private int focusedIndex;
    private int count;
    private int[] rect;
    private Item[] items;
    private ItemStateListener listener;
    private Helper helper;
    private Object lock;

    private static int keyToDirection(int key) {
        MIDletProxy proxy = MIDletProxy.getInstance();
        int keyCode = proxy.getKeyCode(key);
        if (keyCode == 0) {
            return 0;
        }
        if (proxy.getKeyCodeFor(38) == keyCode) {
            return 1;
        }
        if (proxy.getKeyCodeFor(40) == keyCode) {
            return 2;
        }
        if (proxy.getKeyCodeFor(41) == keyCode) {
            return 5;
        }
        if (proxy.getKeyCodeFor(36) == keyCode) {
            return 6;
        }
        return 0;
    }

    public Form(String title) {
        this(false, title, null, null, null, null, null);
    }

    public Form(String title, Item[] items) {
        this(false, title, null, null, null, items, null);
    }

    public Form(String title, Ticker ticker, Command[] commands, CommandListener listener, Item[] items, ItemStateListener itemlistener) {
        this(true, title, ticker, commands, listener, items, itemlistener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Form(boolean system, String title, Ticker ticker, Command[] commands, CommandListener listener, Item[] items, ItemStateListener itemlistener) {
        super(system, title, ticker, commands, null, listener, 3);
        Item[] list;
        int len;
        int error = 0;
        Object object = Container.getOwningLock();
        synchronized (object) {
            block13: {
                len = items == null ? 0 : items.length;
                list = new Item[Math.max(len, 1)];
                int i = len;
                while (i-- > 0) {
                    Item item = items[i];
                    if (item == null) {
                        error = 1;
                        break block13;
                    }
                    if (item.getOwner() != null) {
                        error = 2;
                        break block13;
                    }
                    int j = i + 1;
                    while (j < len) {
                        if (item == list[j]) {
                            error = 2;
                            break block13;
                        }
                        ++j;
                    }
                    list[i] = item;
                }
                i = len;
                while (i-- > 0) {
                    list[i].setOwner(this);
                }
            }
        }
        switch (error) {
            case 1: {
                throw new NullPointerException("Form: \u043e\u0434\u0438\u043d \u0438\u0437 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 items \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
            }
            case 2: {
                throw new IllegalStateException("Form: \u043e\u0434\u0438\u043d \u0438\u0437 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0443\u0436\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u0443.");
            }
        }
        this.needPlaceItems = true;
        this.firstSizeChanged = true;
        this.count = len;
        this.rect = new int[4];
        this.items = list;
        this.listener = itemlistener;
        this.helper = new Helper(this);
        this.lock = new Object();
    }

    public int getWidth() {
        return super.getWidth();
    }

    public int getHeight() {
        return super.getHeight();
    }

    public void setItemStateListener(ItemStateListener listener) {
        this.listener = listener == this ? this.helper : listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int itemIndex, Item item) {
        if (item == null) {
            throw new NullPointerException("Form.set: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 item \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            if (itemIndex < 0 || itemIndex >= this.count) {
                error = 1;
            } else {
                Item[] list = this.items;
                Item old = this.items[itemIndex];
                Object object2 = Container.getOwningLock();
                synchronized (object2) {
                    if (item.getOwner() != null) {
                        error = 2;
                    } else {
                        old.setOwner(null);
                        item.setOwner(this);
                    }
                }
                if (error != 2) {
                    list[itemIndex] = item;
                    boolean focused = this.focusedIndex == itemIndex;
                    if (focused) {
                        this.focusedIndex = -1;
                    }
                    this.callSerially(new RefocusItemEvent(this, focused, old, focused ? item : null));
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IndexOutOfBoundsException("Form.set: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 itemIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 2: {
                throw new IllegalStateException("Form.set: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 item \u0443\u0436\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u0443.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int itemIndex, Item item) {
        if (item == null) {
            throw new NullPointerException("Form.insert: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 item \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int error = 0;
        Object object = this.lock;
        synchronized (object) {
            int len;
            if (itemIndex < 0 || itemIndex > (len = this.count)) {
                error = 1;
            } else {
                Object object2 = Container.getOwningLock();
                synchronized (object2) {
                    if (item.getOwner() != null) {
                        error = 2;
                    } else {
                        item.setOwner(this);
                    }
                }
                if (error != 2) {
                    int i;
                    Object[] list = this.items;
                    if (len == this.items.length) {
                        Object[] objectArray = list;
                        this.items = new Item[(len << 1) + 1];
                        list = this.items;
                        Array.copy((Object[])objectArray, (int)0, (Object[])this.items, (int)0, (int)len);
                    }
                    if ((i = len - itemIndex) > 0) {
                        Array.copy((Object[])list, (int)itemIndex, (Object[])list, (int)(itemIndex + 1), (int)i);
                    }
                    list[itemIndex] = item;
                    this.count = ++len;
                    boolean empty = len == 1;
                    if (empty) {
                        this.focusedIndex = -1;
                    } else {
                        i = this.focusedIndex;
                        if (i >= itemIndex) {
                            this.focusedIndex = i + 1;
                        }
                    }
                    this.callSerially(new RefocusItemEvent(this, false, null, empty ? item : null));
                }
            }
        }
        switch (error) {
            case 1: {
                throw new IndexOutOfBoundsException("Form.insert: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 itemIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            case 2: {
                throw new IllegalStateException("Form.insert: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 item \u0443\u0436\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u0443.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int itemIndex) {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int len;
            if (itemIndex < 0 || itemIndex >= (len = this.count)) {
                error = true;
            } else {
                Object[] list = this.items;
                Item old = this.items[itemIndex];
                Object object2 = Container.getOwningLock();
                synchronized (object2) {
                    old.setOwner(null);
                }
                int i = len - itemIndex - 1;
                if (i > 0) {
                    Array.copy((Object[])list, (int)(itemIndex + 1), (Object[])list, (int)itemIndex, (int)i);
                }
                list[--len] = null;
                this.count = len;
                Object item = null;
                i = this.focusedIndex;
                boolean focused = i == itemIndex;
                if (focused) {
                    this.focusedIndex = -1;
                    item = len > 0 ? list[Math.min(i, len - 1)] : null;
                } else if (i > itemIndex) {
                    this.focusedIndex = i - 1;
                }
                this.callSerially(new RefocusItemEvent(this, focused, old, (Item)item));
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("Form.delete: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 itemIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Object object = this.lock;
        synchronized (object) {
            int len = this.count;
            if (len > 0) {
                int i = this.focusedIndex;
                Item[] list = this.items;
                this.focusedIndex = 0;
                this.count = 0;
                this.items = new Item[1];
                this.callSerially(new DeleteAllItemsEvent(this, list, len, i));
            }
        }
    }

    public int append(Item item) {
        return this.appendHelper(item);
    }

    public int append(Image image) {
        return this.appendHelper(new ImageItem(null, image, 0, null, 0));
    }

    public int append(String text) {
        return this.appendHelper(new StringItem(null, text, 0));
    }

    public int size() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item get(int itemIndex) {
        Item result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (itemIndex < 0 || itemIndex >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.items[itemIndex];
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("Form.get: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 itemIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(GraphicsClipRestricted render, ScrollBar horzScrollBar, ScrollBar vertScrollBar) {
        int tx = render.getTranslateX();
        int ty = render.getTranslateY();
        int cl = render.getClipX();
        int ct = render.getClipY();
        int cw = render.getClipWidth();
        int ch = render.getClipHeight();
        Object object = this.lock;
        synchronized (object) {
            Item[] list = this.items;
            int i = this.count;
            while (i-- > 0) {
                Item item = list[i];
                if (!item.isVisible()) continue;
                render.reset();
                render.translate(tx, ty);
                render.restrictClipRect(cl, ct, cw, ch);
                render.translate(item.getLeft(), item.getTop());
                render.restrictClipRect(0, 0, item.getWidth(), item.getHeight());
                item.onPaint(render);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onShow() {
        super.onShow();
        int viewportWidth = this.getClientWidth();
        ScrollBar horz = this.getHorzScrollBar();
        ScrollBar vert = this.getVertScrollBar();
        Object object = this.lock;
        synchronized (object) {
            if (this.needPlaceItems) {
                this.needPlaceItems = false;
                this.place(viewportWidth, horz, vert);
            }
            this.showAll(horz.getPosition(), vert.getPosition(), viewportWidth, this.getClientHeight());
            this.focus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onHide() {
        Object object = this.lock;
        synchronized (object) {
            this.defocus();
            this.showAll(0, 0, 0, 0);
        }
        super.onHide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSizeChanged(int width, int height) {
        if (this.firstSizeChanged) {
            this.firstSizeChanged = false;
        } else {
            Object object = this.lock;
            synchronized (object) {
                ScrollBar horz = this.getHorzScrollBar();
                ScrollBar vert = this.getVertScrollBar();
                this.place(width, horz, vert);
                this.showAll(horz.getPosition(), vert.getPosition(), width, height);
            }
        }
        super.onSizeChanged(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onScroll(ScrollBar horzScrollBar, ScrollBar vertScrollBar) {
        Object object = this.lock;
        synchronized (object) {
            this.showAll(horzScrollBar.getPosition(), vertScrollBar.getPosition(), this.getClientWidth(), this.getClientHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onKeyPressed(int key, int charCode) {
        int direction = Form.keyToDirection(key);
        if (direction != 0) {
            Object object = this.lock;
            synchronized (object) {
                this.traverse(direction);
            }
            return;
        }
        if (this.keyPressedHandled(key, charCode)) {
            return;
        }
        super.onKeyPressed(key, charCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onKeyRepeated(int key, int charCode) {
        int direction = Form.keyToDirection(key);
        if (direction != 0) {
            Object object = this.lock;
            synchronized (object) {
                this.traverse(direction);
            }
            return;
        }
        if (this.keyRepeatedHandled(key, charCode)) {
            return;
        }
        super.onKeyRepeated(key, charCode);
    }

    void onKeyReleased(int key) {
        if (Form.keyToDirection(key) != 0 || this.keyReleasedHandled(key)) {
            return;
        }
        super.onKeyReleased(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientPointerPressed(int x, int y, int button) {
        Object object = this.lock;
        synchronized (object) {
            int next = this.getItemIndexUnderPointer(x, y);
            if (next >= 0) {
                this.focus(next);
                Item nextItem = this.items[next];
                nextItem.onPointerPressed(x - nextItem.getLeft(), y - nextItem.getTop(), button);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientPointerDragged(int x, int y) {
        Object object = this.lock;
        synchronized (object) {
            int curr = this.focusedIndex;
            if (curr >= 0 && curr < this.count) {
                Item currItem = this.items[curr];
                currItem.onPointerDragged(x - currItem.getLeft(), y - currItem.getTop());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientPointerReleased(int x, int y, int button) {
        Object object = this.lock;
        synchronized (object) {
            int curr = this.focusedIndex;
            if (curr >= 0 && curr < this.count) {
                Item currItem = this.items[curr];
                currItem.onPointerReleased(x - currItem.getLeft(), y - currItem.getTop(), button);
            }
        }
    }

    void onCommandAction(Command command) {
        if (this.commandActionHandled(command)) {
            return;
        }
        super.onCommandAction(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFocused(Item item) {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            int curr = this.focusedIndex;
            result = curr >= 0 && curr < this.count && this.items[curr] == item;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CommandEnumeration getCommands() {
        CommandEnumeration result;
        Object lock = this.lock;
        if (lock == null) {
            return super.getCommands();
        }
        Object object = lock;
        synchronized (object) {
            int curr = this.focusedIndex;
            result = curr < 0 || curr >= this.count ? super.getCommands() : new ItemCommandEnumerator(super.getCommands(), this.items[curr].getCommands());
        }
        return result;
    }

    final void setCurrent(Item item, Display display) {
        display.setCurrent(this);
        display.callSeriallyEvent(this, new FocusItemEvent(this, item));
    }

    final void notifyPlaceItems() {
        if (this.stayPlaceItems) {
            return;
        }
        this.stayPlaceItems = true;
        this.callSerially(this.helper);
    }

    final void notifyItemStateChanged(Item item) {
        ItemStateListener listener = this.listener;
        if (listener == null) {
            return;
        }
        this.callSerially(new ItemStateChangedEvent(listener, item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void focusItem(Item item) {
        Object object = this.lock;
        synchronized (object) {
            int next = this.indexOf(item);
            if (next >= 0) {
                if (this.isReallyShown()) {
                    this.focus(next);
                } else {
                    this.focusedIndex = next;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void placeItems() {
        int viewportWidth = this.getClientWidth();
        ScrollBar horz = this.getHorzScrollBar();
        ScrollBar vert = this.getVertScrollBar();
        Object object = this.lock;
        synchronized (object) {
            this.place(viewportWidth, horz, vert);
            if (this.isReallyShown()) {
                this.showAll(horz.getPosition(), vert.getPosition(), viewportWidth, this.getClientHeight());
                this.traverse();
            }
        }
    }

    private void defocus() {
        int curr = this.focusedIndex;
        if (curr < 0 || curr >= this.count) {
            return;
        }
        try {
            this.items[curr].onTraverseOut();
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    private void focus() {
        int curr = this.focusedIndex;
        if (curr < 0 || curr >= this.count) {
            return;
        }
        int viewportWidth = this.getClientWidth();
        int viewportHeight = this.getClientHeight();
        Item currItem = this.items[curr];
        try {
            currItem.onTraverseNeedStayOn(0, viewportWidth, viewportHeight, this.getVisibleRectangle(currItem, false, 0, viewportWidth, viewportHeight));
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        this.updateCommands();
        this.callSeriallyPaintScreen(4);
    }

    private void focus(int next) {
        Item[] list = this.items;
        int curr = this.focusedIndex;
        if (curr == next) {
            return;
        }
        if (curr >= 0 && curr < this.count) {
            try {
                list[curr].onTraverseOut();
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
        int viewportWidth = this.getClientWidth();
        int viewportHeight = this.getClientHeight();
        Item nextItem = list[next];
        this.focusedIndex = next;
        try {
            nextItem.onTraverseNeedStayOn(0, viewportWidth, viewportHeight, this.getVisibleRectangle(nextItem, false, 0, viewportWidth, viewportHeight));
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        this.updateVisibleRectangle(nextItem, viewportWidth, viewportHeight);
        this.updateCommands();
        this.callSeriallyPaintScreen(4);
    }

    private void traverse() {
        int curr = this.focusedIndex;
        if (curr < 0 || curr >= this.count) {
            return;
        }
        int viewportWidth = this.getClientWidth();
        int viewportHeight = this.getClientHeight();
        Item currItem = this.items[curr];
        try {
            currItem.onTraverseNeedStayOn(0, viewportWidth, viewportHeight, this.getVisibleRectangle(currItem, false, 0, viewportWidth, viewportHeight));
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        this.updateVisibleRectangle(currItem, viewportWidth, viewportHeight);
        this.updateCommands();
        this.callSeriallyPaintScreen(4);
    }

    private void traverse(int direction) {
        int next;
        boolean needStayOn;
        int curr = this.focusedIndex;
        if (curr < 0 || curr >= this.count) {
            return;
        }
        int viewportWidth = this.getClientWidth();
        int viewportHeight = this.getClientHeight();
        Item[] list = this.items;
        Item currItem = this.items[curr];
        try {
            needStayOn = currItem.onTraverseNeedStayOn(direction, viewportWidth, viewportHeight, this.getVisibleRectangle(currItem, true, direction, viewportWidth, viewportHeight));
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
            needStayOn = false;
        }
        if (needStayOn || (next = this.getItemIndexForFocus(curr, direction)) < 0) {
            this.updateVisibleRectangle(currItem, viewportWidth, viewportHeight);
            return;
        }
        try {
            currItem.onTraverseOut();
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        Item nextItem = list[next];
        this.focusedIndex = next;
        try {
            nextItem.onTraverseNeedStayOn(direction, viewportWidth, viewportHeight, this.getVisibleRectangle(nextItem, false, direction, viewportWidth, viewportHeight));
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        this.updateVisibleRectangle(nextItem, viewportWidth, viewportHeight);
        this.updateCommands();
        this.callSeriallyPaintScreen(4);
    }

    private void showAll(int viewportLeft, int viewportTop, int viewportWidth, int viewportHeight) {
        boolean formVisible = viewportWidth > 0 && viewportHeight > 0;
        int left = viewportLeft;
        int right = left + viewportWidth;
        int top = viewportTop;
        int bottom = top + viewportHeight;
        Item[] list = this.items;
        int i = this.count;
        while (i-- > 0) {
            int tmp;
            Item item = list[i];
            boolean visible = formVisible && (tmp = item.getLeft()) + item.getWidth() > left && tmp < right && (tmp = item.getTop()) + item.getHeight() > top && tmp < bottom;
            boolean realVisible = item.isVisible();
            item.setVisible(visible);
            if (realVisible && !visible) {
                item.setVisible(false);
                try {
                    item.onHide();
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
            }
            if (!visible || realVisible) continue;
            item.setVisible(true);
            try {
                item.onShow();
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
    }

    private void place(int containerClientWidth, ScrollBar horzScrollBar, ScrollBar vertScrollBar) {
        int len;
        this.stayPlaceItems = false;
        Item[] list = this.items;
        int i = len = this.count;
        while (i-- > 0) {
            list[i].computeSizes(containerClientWidth);
        }
        int formWidth = 0;
        int formHeight = 0;
        int rowTop = 0;
        i = 0;
        while (i < len) {
            Item item;
            int width = 0;
            int j = i;
            while (j < len) {
                int p;
                int c;
                item = list[j];
                int iwidth = item.getWidth();
                if (j > i && (((c = item.getRealLayout()) & 0x100) != 0 || ((p = list[j - 1].getRealLayout()) & 0x200) != 0 || width + iwidth > containerClientWidth || (p &= 3) == 3 && ((c &= 3) == 1 || c == 0) || p == 2 && c != 2)) break;
                width += iwidth;
                ++j;
            }
            int rowFinish = j;
            int rowHeight = 0;
            j = i;
            while (j < rowFinish) {
                int tmp = list[j].getHeight();
                if (rowHeight < tmp) {
                    rowHeight = tmp;
                }
                ++j;
            }
            if (formWidth < width) {
                formWidth = width;
            }
            formHeight += rowHeight;
            int centerIndex = rowFinish;
            int leftWidth = 0;
            j = i;
            block14: while (j < rowFinish) {
                item = list[j];
                switch (item.getRealLayout() & 3) {
                    default: {
                        leftWidth += item.getWidth();
                        break;
                    }
                    case 2: 
                    case 3: {
                        centerIndex = j;
                        break block14;
                    }
                }
                ++j;
            }
            int rightIndex = rowFinish;
            int centerWidth = 0;
            block15: while (j < rowFinish) {
                item = list[j];
                switch (item.getRealLayout() & 3) {
                    case 3: {
                        centerWidth += item.getWidth();
                        break;
                    }
                    default: {
                        rightIndex = j;
                        break block15;
                    }
                }
                ++j;
            }
            int rightWidth = 0;
            while (j < rowFinish) {
                rightWidth += list[j].getWidth();
                ++j;
            }
            int centerLeft = Math.max(leftWidth + (containerClientWidth - (leftWidth + centerWidth + rightWidth)) / 2, leftWidth);
            int rightLeft = Math.max(containerClientWidth - rightWidth, leftWidth + centerWidth);
            int left = 0;
            j = i;
            while (j < rowFinish) {
                int top;
                if (j == centerIndex) {
                    left = centerLeft;
                }
                if (j == rightIndex) {
                    left = rightLeft;
                }
                item = list[j];
                switch ((item.getRealLayout() & 0x30) >> 4) {
                    default: {
                        top = rowTop;
                        break;
                    }
                    case 3: {
                        top = rowTop + (rowHeight - item.getHeight() >> 1);
                        break;
                    }
                    case 2: {
                        top = rowTop + rowHeight - item.getHeight();
                    }
                }
                item.setPosition(left, top);
                left += item.getWidth();
                ++j;
            }
            rowTop += rowHeight;
            i = rowFinish;
        }
        horzScrollBar.setVisible(formWidth > containerClientWidth);
        horzScrollBar.setRange(formWidth);
        vertScrollBar.setVisible(true);
        vertScrollBar.setRange(formHeight);
    }

    private void updateVisibleRectangle(Item item, int viewportWidth, int viewportHeight) {
        int[] visibleRectangle = this.rect;
        ScrollBar horz = this.getHorzScrollBar();
        ScrollBar vert = this.getVertScrollBar();
        int tmp = visibleRectangle[2];
        int vrw = tmp < 0 ? 0 : (tmp > viewportWidth ? viewportWidth : tmp);
        visibleRectangle[2] = vrw;
        tmp = visibleRectangle[3];
        int vrh = tmp < 0 ? 0 : (tmp > viewportHeight ? viewportHeight : tmp);
        visibleRectangle[3] = vrh;
        int l = item.getLeft();
        int x = horz.getPosition() - l;
        int t = item.getTop();
        int y = vert.getPosition() - t;
        tmp = visibleRectangle[0];
        x = x > tmp ? tmp : (x < (tmp += vrw - viewportWidth) ? tmp : x);
        tmp = visibleRectangle[1];
        y = y > tmp ? tmp : (y < (tmp += vrh - viewportHeight) ? tmp : y);
        horz.setPosition(x + l);
        vert.setPosition(y + t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean keyPressedHandled(int key, int charCode) {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            Item currItem;
            int curr = this.focusedIndex;
            if (curr < 0 || curr >= this.count || !(currItem = this.items[curr]).keyHandling(key)) {
                result = false;
            } else {
                try {
                    currItem.onKeyPressed(key, charCode);
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean keyRepeatedHandled(int key, int charCode) {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            Item currItem;
            int curr = this.focusedIndex;
            if (curr < 0 || curr >= this.count || !(currItem = this.items[curr]).keyHandling(key)) {
                result = false;
            } else {
                try {
                    currItem.onKeyRepeated(key, charCode);
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean keyReleasedHandled(int key) {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            Item currItem;
            int curr = this.focusedIndex;
            if (curr < 0 || curr >= this.count || !(currItem = this.items[curr]).keyHandling(key)) {
                result = false;
            } else {
                try {
                    currItem.onKeyReleased(key);
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commandActionHandled(Command command) {
        boolean result;
        Object object = this.lock;
        synchronized (object) {
            Item currItem;
            int curr = this.focusedIndex;
            if (curr < 0 || curr >= this.count || !(currItem = this.items[curr]).getCommands().hasCommand(command)) {
                result = false;
            } else {
                try {
                    currItem.onCommandAction(command);
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int appendHelper(Item item) {
        int result;
        if (item == null) {
            throw new NullPointerException("Form.append: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 item \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int len;
            result = len = this.count;
            Object object2 = Container.getOwningLock();
            synchronized (object2) {
                if (item.getOwner() != null) {
                    error = true;
                } else {
                    item.setOwner(this);
                }
            }
            if (!error) {
                Object[] list = this.items;
                if (len == this.items.length) {
                    Object[] objectArray = list;
                    this.items = new Item[(len << 1) + 1];
                    list = this.items;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.items, (int)0, (int)len);
                }
                list[len] = item;
                this.count = ++len;
                boolean empty = len == 1;
                if (empty) {
                    this.focusedIndex = -1;
                }
                this.callSerially(new RefocusItemEvent(this, false, null, empty ? item : null));
            }
        }
        if (error) {
            throw new IllegalStateException("Form.append: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 item \u0443\u0436\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u0443.");
        }
        return result;
    }

    private int indexOf(Item item) {
        Item[] list = this.items;
        int i = this.count;
        while (i-- > 0) {
            if (list[i] != item) continue;
            return i;
        }
        return -1;
    }

    private int getItemIndexForFocus(int focusedItemIndex, int direction) {
        int result = -1;
        Item[] list = this.items;
        Item current = this.items[focusedItemIndex];
        block0 : switch (direction) {
            case 1: {
                int pos = current.getTop();
                int i = focusedItemIndex;
                while (i-- > 0) {
                    Item item = list[i];
                    if (item.getTop() + item.getHeight() > pos) continue;
                    result = i;
                    break block0;
                }
                break;
            }
            case 2: {
                result = focusedItemIndex - 1;
                break;
            }
            case 5: {
                if (focusedItemIndex >= this.count - 1) break;
                result = focusedItemIndex + 1;
                break;
            }
            case 6: {
                int pos = current.getTop() + current.getHeight();
                int len = this.count;
                int i = focusedItemIndex + 1;
                while (i < len) {
                    if (list[i].getTop() >= pos) {
                        result = i;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
        }
        return result;
    }

    private int getItemIndexUnderPointer(int x, int y) {
        Item[] list = this.items;
        int i = this.count;
        while (i-- > 0) {
            Item item = list[i];
            int tmp = item.getLeft();
            if (x < tmp || x >= tmp + item.getWidth() || y < (tmp = item.getTop()) || y >= tmp + item.getHeight()) continue;
            return i;
        }
        return -1;
    }

    private int[] getVisibleRectangle(Item item, boolean focused, int direction, int viewportWidth, int viewportHeight) {
        int itemWidth = item.getWidth();
        int itemHeight = item.getHeight();
        int[] result = this.rect;
        if (!focused && itemWidth <= viewportWidth && itemHeight <= viewportHeight) {
            result[0] = 0;
            result[1] = 0;
            result[2] = itemWidth;
            result[3] = itemHeight;
        } else {
            int hpos = this.getHorzScrollBar().getPosition();
            int vpos = this.getVertScrollBar().getPosition();
            if (focused || direction == 0) {
                int t1;
                int l1;
                int l = hpos - item.getLeft();
                result[0] = l1 = Math.max(l, 0);
                int t = vpos - item.getTop();
                result[1] = t1 = Math.max(t, 0);
                result[2] = Math.min(l + viewportWidth, itemWidth) - l1;
                result[3] = Math.min(t + viewportHeight, itemHeight) - t1;
            } else {
                switch (direction) {
                    case 1: {
                        int tmp;
                        result[0] = tmp = Math.max(hpos - item.getLeft(), 0);
                        result[1] = Math.max(itemHeight - viewportHeight, 0);
                        result[2] = Math.min(viewportWidth, itemWidth - tmp);
                        result[3] = Math.min(viewportHeight, itemHeight);
                        break;
                    }
                    case 2: {
                        int tmp;
                        result[0] = Math.max(itemWidth - viewportWidth, 0);
                        result[1] = tmp = Math.max(vpos - item.getTop(), 0);
                        result[2] = Math.min(viewportWidth, itemWidth);
                        result[3] = Math.min(viewportHeight, itemHeight - tmp);
                        break;
                    }
                    case 5: {
                        int tmp;
                        result[0] = 0;
                        result[1] = tmp = Math.max(vpos - item.getTop(), 0);
                        result[2] = Math.min(viewportWidth, itemWidth);
                        result[3] = Math.min(viewportHeight, itemHeight - tmp);
                        break;
                    }
                    case 6: {
                        int tmp;
                        result[0] = tmp = Math.max(hpos - item.getLeft(), 0);
                        result[1] = 0;
                        result[2] = Math.min(viewportWidth, itemWidth - tmp);
                        result[3] = Math.min(viewportHeight, itemHeight);
                    }
                }
            }
        }
        return result;
    }

    private static final class DeleteAllItemsEvent
    implements Runnable {
        private int focusedIndex;
        private int count;
        private Item[] items;
        private Form form;

        DeleteAllItemsEvent(Form form, Item[] items, int count, int focusedIndex) {
            this.focusedIndex = focusedIndex;
            this.count = count;
            this.items = items;
            this.form = form;
        }

        public void run() {
            int curr = this.focusedIndex;
            Item[] list = this.items;
            int i = this.count;
            while (i-- > 0) {
                Item item = list[i];
                if (curr == i) {
                    try {
                        item.onTraverseOut();
                    }
                    catch (RuntimeException e) {
                        e.printRealStackTrace();
                    }
                }
                if (!item.isVisible()) continue;
                item.setVisible(false);
                try {
                    item.onHide();
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
            }
            this.form.placeItems();
        }
    }

    private static final class FocusItemEvent
    implements Runnable {
        private Form form;
        private Item item;

        FocusItemEvent(Form form, Item item) {
            this.form = form;
            this.item = item;
        }

        public void run() {
            this.form.focusItem(this.item);
        }
    }

    private static final class Helper
    extends WeakReference
    implements ItemStateListener,
    Runnable {
        Helper(Form thisForm) {
            super(thisForm);
        }

        public void itemStateChanged(Item item) {
            Object thisForm = this.get();
            if (!(thisForm instanceof ItemStateListener)) {
                return;
            }
            ((ItemStateListener)thisForm).itemStateChanged(item);
        }

        public void run() {
            Form thisForm = (Form)this.get();
            if (thisForm == null) {
                return;
            }
            thisForm.placeItems();
        }
    }

    private static final class ItemCommandEnumerator
    implements CommandEnumeration {
        private CommandEnumeration formCommands;
        private CommandEnumeration itemCommands;

        ItemCommandEnumerator(CommandEnumeration formCommands, CommandEnumeration itemCommands) {
            this.formCommands = formCommands;
            this.itemCommands = itemCommands;
        }

        public int getCommandsCount() {
            return this.formCommands.getCommandsCount() + this.itemCommands.getCommandsCount();
        }

        public Command getCommand(int index) {
            CommandEnumeration result;
            int itemCommandsCount;
            CommandEnumeration itemCommands;
            CommandEnumeration formCommands;
            block6: {
                block5: {
                    if (index < 0) break block5;
                    formCommands = this.formCommands;
                    itemCommands = this.itemCommands;
                    itemCommandsCount = itemCommands.getCommandsCount();
                    if (index < formCommands.getCommandsCount() + itemCommandsCount) break block6;
                }
                throw new IndexOutOfBoundsException("Form.getCommands: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            if (index < itemCommandsCount) {
                result = itemCommands;
            } else {
                result = formCommands;
                index -= itemCommandsCount;
            }
            return result.getCommand(index);
        }

        public Command getDefaultCommand() {
            Command result = this.itemCommands.getDefaultCommand();
            return result != null ? result : this.formCommands.getDefaultCommand();
        }

        public Object getMonitor() {
            return this.itemCommands.getMonitor();
        }
    }

    private static final class ItemStateChangedEvent
    implements Runnable {
        private ItemStateListener listener;
        private Item item;

        ItemStateChangedEvent(ItemStateListener listener, Item item) {
            this.listener = listener;
            this.item = item;
        }

        public void run() {
            this.listener.itemStateChanged(this.item);
        }
    }

    private static final class RefocusItemEvent
    implements Runnable {
        private boolean focused;
        private Item oldItem;
        private Item newItem;
        private Form form;

        RefocusItemEvent(Form form, boolean deletedItemIsFocused, Item deletedItem, Item itemForFocus) {
            this.focused = deletedItemIsFocused;
            this.oldItem = deletedItem;
            this.newItem = itemForFocus;
            this.form = form;
        }

        public void run() {
            Item item = this.oldItem;
            if (item != null) {
                if (this.focused) {
                    try {
                        item.onTraverseOut();
                    }
                    catch (RuntimeException e) {
                        e.printRealStackTrace();
                    }
                }
                if (item.isVisible()) {
                    item.setVisible(false);
                    try {
                        item.onHide();
                    }
                    catch (RuntimeException e) {
                        e.printRealStackTrace();
                    }
                }
            }
            Form form = this.form;
            form.placeItems();
            item = this.newItem;
            if (item != null) {
                form.focusItem(item);
            }
        }
    }
}

