/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.ChoiceElement;
import javax.microedition.lcdui.ChoiceElementDetailsScreen;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.MIDletProxy;
import javax.microedition.lcdui.ScrollBar;
import javax.microedition.lcdui.ScrollingScreen;
import javax.microedition.lcdui.Ticker;
import malik.emulator.media.graphics.RasterCanvas;

public class List
extends ScrollingScreen
implements Choice {
    public static final Command SELECT_COMMAND;
    static final int CHECKBOX_WIDTH;
    static final int CHECKBOX_HEIGHT;
    static final Command CHECK_COMMAND;
    private static final int ELEMENT_HEIGHT = 38;
    private static final Command[] SELECT;
    private static final String DEFAULT_EMPTY_LABEL = "(\u043f\u0443\u0441\u0442\u043e)";
    private int type;
    private int fitPolicy;
    private int checkboxFocused;
    private int checkboxPressed;
    private int checkedElementIndex;
    private int focusedElementIndex;
    private int elementsCount;
    private Element[] elements;
    private Command selectCommand;
    private String emptyLabel;
    private Object lock;

    static {
        int s = RasterCanvas.getElementOfGUISizes((int)15, (int)0, (int)0);
        SELECT_COMMAND = new Command("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 4, 0);
        int i = s;
        CHECKBOX_WIDTH = i <= 0 ? 16 : (int)i;
        i = s >> 16;
        CHECKBOX_HEIGHT = i <= 0 ? 16 : i;
        CHECK_COMMAND = new Command("\u2713", 4, 0);
        SELECT = new Command[]{new Command("\u041e\u0442\u043c\u0435\u0442\u0438\u0442\u044c \u0432\u0441\u0435", 1, 0), new Command("\u0421\u043d\u044f\u0442\u044c \u0432\u0441\u0435", 1, 0), new Command("\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0432\u0441\u0435", 1, 0)};
    }

    public List(String title, int type) {
        this(false, false, title, null, null, SELECT_COMMAND, null, type, new String[0], null, DEFAULT_EMPTY_LABEL);
    }

    public List(String title, int type, String[] elements, Image[] icons) {
        this(false, false, title, null, null, SELECT_COMMAND, null, type, elements, icons, DEFAULT_EMPTY_LABEL);
    }

    public List(boolean fullScreenMode, String title, Ticker ticker, Command[] commands, Command selectCommand, CommandListener listener, int type, String[] elements, Image[] icons) {
        this(true, fullScreenMode, title, ticker, commands, selectCommand, listener, type, elements, icons, DEFAULT_EMPTY_LABEL);
    }

    public List(boolean fullScreenMode, String title, Ticker ticker, Command[] commands, Command selectCommand, CommandListener listener, int type, String[] elements, Image[] icons, String emptyLabel) {
        this(true, fullScreenMode, title, ticker, commands, selectCommand, listener, type, elements, icons, emptyLabel);
    }

    private List(boolean system, boolean fullScreenMode, String title, Ticker ticker, Command[] commands, Command selectCommand, CommandListener listener, int type, String[] elements, Image[] icons, String emptyLabel) {
        super(system, fullScreenMode, title, ticker, type == 2 ? Displayable.concatCommands(SELECT, commands) : commands, elements == null || elements.length == 0 ? null : (type == 3 ? selectCommand : CHECK_COMMAND), listener, 2);
        if (type != 1 && type != 2 && type != 3) {
            throw new IllegalArgumentException("List: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 type.");
        }
        if (elements == null) {
            throw new NullPointerException("List: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elements \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = elements.length;
        Object[] lines = new String[len];
        Array.copy((Object[])elements, (int)0, (Object[])lines, (int)0, (int)len);
        int i = len;
        while (i-- > 0) {
            if (lines[i] != null) continue;
            throw new NullPointerException("List: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elements \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0443\u043b\u0435\u0432\u044b\u0435 \u0441\u0441\u044b\u043b\u043a\u0438.");
        }
        if (icons != null && icons.length != len) {
            throw new IllegalArgumentException("List: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 icons \u0438\u043c\u0435\u0435\u0442 \u0434\u043b\u0438\u043d\u0443, \u043e\u0442\u043b\u0438\u0447\u043d\u0443\u044e \u043e\u0442 \u0434\u043b\u0438\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 elements.");
        }
        this.getVertScrollBar().setRange(38 * len);
        Font font = Font.getFont(0, 0, 0);
        i = len;
        Element[] list = new Element[i];
        while (i-- > 0) {
            list[i] = new Element(type == 1 && i == 0, font, (String)lines[i], icons == null ? null : icons[i]);
        }
        this.type = type;
        this.fitPolicy = 0;
        this.checkboxFocused = -1;
        this.checkboxPressed = -1;
        this.checkedElementIndex = 0;
        this.focusedElementIndex = 0;
        this.elementsCount = len;
        this.elements = list;
        this.selectCommand = type == 3 ? selectCommand : null;
        this.emptyLabel = emptyLabel;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Command command) {
        Object object = this.lock;
        synchronized (object) {
            if (command == this.selectCommand) {
                this.selectCommand = null;
            }
        }
        super.removeCommand(command);
    }

    public void setFitPolicy(int policy) {
        if (policy != 0 && policy != 1 && policy != 2) {
            throw new IllegalArgumentException("List.setFitPolicy: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 policy.");
        }
        this.fitPolicy = policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int elementIndex, boolean selected) {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
            } else {
                switch (this.type) {
                    case 1: {
                        int checked = this.checkedElementIndex;
                        if (elementIndex == checked) break;
                        this.checkedElementIndex = elementIndex;
                        Element[] list = this.elements;
                        Element elem = this.elements[elementIndex];
                        this.elements[elementIndex].selected = true;
                        Element prev = list[checked];
                        list[checked].selected = false;
                        if (!elem.visible && !prev.visible) break;
                        this.callSeriallyPaintScreen(4);
                        break;
                    }
                    case 2: {
                        Element elem = this.elements[elementIndex];
                        if (elem.selected == selected) break;
                        elem.selected = selected;
                        if (!elem.visible) break;
                        this.callSeriallyPaintScreen(4);
                        break;
                    }
                    case 3: {
                        if (elementIndex == this.focusedElementIndex) break;
                        this.focusedElementIndex = elementIndex;
                        this.correctScrollBarPositionToItem();
                    }
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.setSelectedIndex: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedFlags(boolean[] selected) {
        if (selected == null) {
            throw new NullPointerException("List.setSelectedFlags: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 selected \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int len = this.elementsCount;
            if (selected.length < len) {
                error = true;
            } else {
                switch (this.type) {
                    case 1: {
                        int checked;
                        int elementIndex = -1;
                        int i = 0;
                        while (i < len) {
                            if (selected[i]) {
                                elementIndex = i;
                                break;
                            }
                            ++i;
                        }
                        if (elementIndex < 0 || elementIndex == (checked = this.checkedElementIndex)) break;
                        this.checkedElementIndex = elementIndex;
                        Element[] list = this.elements;
                        Element elem = this.elements[elementIndex];
                        this.elements[elementIndex].selected = true;
                        Element prev = list[checked];
                        list[checked].selected = false;
                        if (!elem.visible && !prev.visible) break;
                        this.callSeriallyPaintScreen(4);
                        break;
                    }
                    case 2: {
                        boolean needRepaint = false;
                        Element[] list = this.elements;
                        int i = len;
                        while (i-- > 0) {
                            Element elem = list[i];
                            boolean sel = selected[i];
                            if (elem.selected == sel) continue;
                            elem.selected = sel;
                            if (!elem.visible) continue;
                            needRepaint = true;
                        }
                        if (!needRepaint) break;
                        this.callSeriallyPaintScreen(4);
                        break;
                    }
                    case 3: {
                        int elementIndex = -1;
                        int i = 0;
                        while (i < len) {
                            if (selected[i]) {
                                elementIndex = i;
                                break;
                            }
                            ++i;
                        }
                        if (elementIndex < 0 || elementIndex == this.focusedElementIndex) break;
                        this.focusedElementIndex = elementIndex;
                        this.correctScrollBarPositionToItem();
                    }
                }
            }
        }
        if (error) {
            throw new IllegalArgumentException("List.setSelectedFlags: \u0434\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 selected \u043c\u0435\u043d\u044c\u0448\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0438\u0441\u043a\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(int elementIndex, Font font) {
        if (font == null) {
            font = Font.getFont(0, 0, 0);
        }
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
            } else {
                Element elem = this.elements[elementIndex];
                if (font != elem.font) {
                    elem.font = font;
                    this.correctTruncated(elem);
                    if (elem.visible) {
                        this.callSeriallyPaintScreen(4);
                    }
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.setFont: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int elementIndex, String text, Image icon) {
        if (text == null) {
            throw new NullPointerException("List.set: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
            } else {
                Element elem = this.elements[elementIndex];
                this.elements[elementIndex].text = text;
                elem.icon = icon;
                this.correctTruncated(elem);
                if (elem.visible) {
                    this.callSeriallyPaintScreen(4);
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.set: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(int elementIndex, String text, Image icon) {
        if (text == null) {
            throw new NullPointerException("List.insert: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int len;
            if (elementIndex < 0 || elementIndex > (len = this.elementsCount)) {
                error = true;
            } else {
                int t;
                int i;
                Object[] list = this.elements;
                if (len == this.elements.length) {
                    Object[] objectArray = list;
                    this.elements = new Element[(len << 1) + 1];
                    list = this.elements;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
                }
                if ((i = len - elementIndex) > 0) {
                    Array.copy((Object[])list, (int)elementIndex, (Object[])list, (int)(elementIndex + 1), (int)i);
                }
                Element elem = new Element((t = this.type) == 1 && len == 0, Font.getFont(0, 0, 0), text, icon);
                list[elementIndex] = elem;
                this.correctTruncated(elem);
                this.elementsCount = ++len;
                this.checkboxPressed = -1;
                this.checkboxFocused = -1;
                if (len > 1) {
                    i = this.checkedElementIndex;
                    if (i >= elementIndex) {
                        this.checkedElementIndex = i + 1;
                    }
                    if ((i = this.focusedElementIndex) >= elementIndex) {
                        this.focusedElementIndex = i + 1;
                    }
                } else {
                    this.setDefaultCommand(t == 3 ? this.selectCommand : CHECK_COMMAND);
                }
                this.getVertScrollBar().setRange(38 * len);
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.insert: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int elementIndex) {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int len;
            if (elementIndex < 0 || elementIndex >= (len = this.elementsCount)) {
                error = true;
            } else {
                Object[] list = this.elements;
                int i = len - elementIndex - 1;
                if (i > 0) {
                    Array.copy((Object[])list, (int)(elementIndex + 1), (Object[])list, (int)elementIndex, (int)i);
                }
                list[--len] = null;
                this.elementsCount = len;
                this.checkboxPressed = -1;
                this.checkboxFocused = -1;
                if (len > 0) {
                    i = this.checkedElementIndex;
                    if (i > elementIndex) {
                        this.checkedElementIndex = i - 1;
                    } else if (i == elementIndex) {
                        i = i == len ? i - 1 : i;
                        this.checkedElementIndex = i;
                        if (this.type == 1) {
                            ((ChoiceElement)list[i]).selected = true;
                        }
                    }
                    i = this.focusedElementIndex;
                    if (i == elementIndex && i == len || i > elementIndex) {
                        this.focusedElementIndex = i - 1;
                    }
                } else {
                    this.setDefaultCommand(null);
                }
                this.getVertScrollBar().setRange(38 * len);
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.delete: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Object object = this.lock;
        synchronized (object) {
            int len = this.elementsCount;
            if (len > 0) {
                Element[] list = this.elements;
                int i = len;
                while (i-- > 0) {
                    list[i] = null;
                }
                this.elementsCount = 0;
                this.checkboxPressed = -1;
                this.checkboxFocused = -1;
                this.checkedElementIndex = 0;
                this.focusedElementIndex = 0;
                this.setDefaultCommand(null);
                this.getVertScrollBar().setRange(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSelected(int elementIndex) {
        boolean result = false;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
            } else {
                switch (this.type) {
                    case 1: {
                        result = this.checkedElementIndex == elementIndex;
                        break;
                    }
                    case 2: {
                        result = this.elements[elementIndex].selected;
                        break;
                    }
                    case 3: {
                        result = this.focusedElementIndex == elementIndex;
                    }
                }
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.isSelected: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int append(String text, Image icon) {
        int result;
        if (text == null) {
            throw new NullPointerException("List.append: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            int len = this.elementsCount;
            Object[] list = this.elements;
            if (len == this.elements.length) {
                Object[] objectArray = list;
                this.elements = new Element[(len << 1) + 1];
                list = this.elements;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
            }
            result = len;
            int t = this.type;
            Element elem = new Element(t == 1 && len == 0, Font.getFont(0, 0, 0), text, icon);
            list[result] = elem;
            this.correctTruncated(elem);
            this.elementsCount = ++len;
            this.checkboxPressed = -1;
            this.checkboxFocused = -1;
            if (len == 1) {
                this.setDefaultCommand(t == 3 ? this.selectCommand : CHECK_COMMAND);
            }
            this.getVertScrollBar().setRange(38 * len);
        }
        return result;
    }

    public int size() {
        return this.elementsCount;
    }

    public int getFitPolicy() {
        return this.fitPolicy;
    }

    public int getSelectedIndex() {
        if (this.elementsCount == 0) {
            return -1;
        }
        switch (this.type) {
            default: {
                return -1;
            }
            case 1: {
                return this.checkedElementIndex;
            }
            case 3: 
        }
        return this.focusedElementIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectedFlags(boolean[] selected) {
        if (selected == null) {
            throw new NullPointerException("List.getSelectedFlags: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 selected \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int result = 0;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int len = this.elementsCount;
            if (selected.length < len) {
                error = true;
            } else {
                switch (this.type) {
                    case 1: {
                        result = len > 0 ? 1 : 0;
                        int f = this.checkedElementIndex;
                        int i = len;
                        while (i-- > 0) {
                            boolean bl = selected[i] = i == f;
                        }
                        break;
                    }
                    case 2: {
                        result = 0;
                        Element[] list = this.elements;
                        int i = len;
                        while (i-- > 0) {
                            selected[i] = list[i].selected;
                            if (!selected[i]) continue;
                            ++result;
                        }
                        break;
                    }
                    case 3: {
                        result = len > 0 ? 1 : 0;
                        int f = this.focusedElementIndex;
                        int i = len;
                        while (i-- > 0) {
                            boolean bl = selected[i] = i == f;
                        }
                        break;
                    }
                }
            }
        }
        if (error) {
            throw new IllegalArgumentException("List.getSelectedFlags: \u0434\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 selected \u043c\u0435\u043d\u044c\u0448\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0441\u043f\u0438\u0441\u043a\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(int elementIndex) {
        Font result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].font;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.getFont: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(int elementIndex) {
        Image result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].icon;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.getImage: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int elementIndex) {
        String result;
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.elementsCount) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].text;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("List.getString: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectCommand(Command selectCommand) {
        boolean f;
        if (this.type != 3) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            f = false;
            if (this.selectCommand != selectCommand) {
                this.selectCommand = selectCommand;
                f = this.elementsCount > 0;
            }
        }
        if (!f) {
            return;
        }
        this.setDefaultCommand(selectCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics render, ScrollBar horzScrollBar, ScrollBar vertScrollBar) {
        int clientWidth = this.getClientWidth();
        render.setColor(RasterCanvas.getSystemColor((int)40));
        Object object = this.lock;
        synchronized (object) {
            int len = this.elementsCount;
            if (len == 0) {
                Font font = Font.getFont(0, 1, 8);
                render.setFont(font);
                render.drawString(Displayable.truncate(this.emptyLabel, font, clientWidth), clientWidth / 2, 0, 17);
            } else {
                int top = vertScrollBar.getPosition();
                int bottom = top + vertScrollBar.getPage();
                int pressed = this.checkboxPressed;
                int focused = this.focusedElementIndex;
                int leftMarginCheckbox = 3;
                int t = this.type;
                int leftMarginIcon = 3 + (t == 3 ? 0 : CHECKBOX_WIDTH + 3);
                int leftMarginText = leftMarginIcon + 35;
                int topMarginCheckbox = 38 - CHECKBOX_HEIGHT >> 1;
                int topMarginElement = 0;
                Element[] list = this.elements;
                int i = 0;
                while (i < len) {
                    Element elem = list[i];
                    list[i].visible = topMarginElement < bottom && topMarginElement + 38 > top;
                    if (list[i].visible) {
                        if (i == focused) {
                            render.drawElementOfGUI(1, 0, 0, 0, 0, clientWidth, 38);
                        }
                        switch (t) {
                            case 1: {
                                render.drawElementOfGUI(12, elem.selected ? 1 : 0, i == pressed ? 1 : 0, leftMarginCheckbox, topMarginCheckbox, CHECKBOX_WIDTH, CHECKBOX_HEIGHT);
                                break;
                            }
                            case 2: {
                                render.drawElementOfGUI(15, elem.selected ? 1 : 0, i == pressed ? 1 : 0, leftMarginCheckbox, topMarginCheckbox, CHECKBOX_WIDTH, CHECKBOX_HEIGHT);
                            }
                        }
                        Image icon = elem.icon;
                        if (icon != null) {
                            render.drawStretchRegion(icon, 0, 0, icon.getWidth(), icon.getHeight(), 0, leftMarginIcon, 3, 32, 32, 0);
                        }
                        Font font = elem.font;
                        render.setFont(font);
                        render.drawString(elem.truncated, icon != null ? leftMarginText : leftMarginIcon, 38 - font.getHeight() >> 1, 0);
                    }
                    render.translate(0, 38);
                    topMarginElement += 38;
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSizeChanged(int width, int height) {
        Object object = this.lock;
        synchronized (object) {
            Element[] list = this.elements;
            int i = this.elementsCount;
            while (i-- > 0) {
                this.correctTruncated(list[i]);
            }
        }
        super.onSizeChanged(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onKeyPressed(int key, int charCode) {
        MIDletProxy proxy = MIDletProxy.getInstance();
        if (key == proxy.getKeyUsedAs(35)) {
            Object object = this.lock;
            synchronized (object) {
                int i = this.focusedElementIndex;
                if (i >= 0 && i < this.elementsCount) {
                    ChoiceElementDetailsScreen.show(proxy.getEmulatorScreen(), super.getTitle(), this.elements[i], this);
                }
            }
            return;
        }
        if (!super.keyHandling(key)) {
            this.moveCursor(key);
            return;
        }
        super.onKeyPressed(key, charCode);
    }

    void onKeyRepeated(int key, int charCode) {
        if (!super.keyHandling(key)) {
            this.moveCursor(key);
            return;
        }
        super.onKeyRepeated(key, charCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientPointerPressed(int x, int y, int button) {
        Object object = this.lock;
        synchronized (object) {
            int i;
            if (button == 0 && (i = y / 38) < this.elementsCount) {
                if (this.type != 3 && x < CHECKBOX_WIDTH + 6) {
                    this.checkboxFocused = i;
                    this.checkboxPressed = i;
                }
                this.focusedElementIndex = i;
                this.correctScrollBarPositionToItem();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientPointerDragged(int x, int y) {
        Object object = this.lock;
        synchronized (object) {
            int f = this.checkboxFocused;
            if (f >= 0) {
                this.checkboxPressed = f == (x < CHECKBOX_WIDTH + 6 ? y / 38 : -1) ? f : -1;
                if (this.checkboxPressed != this.checkboxPressed) {
                    this.callSeriallyPaintScreen(4);
                }
            } else {
                int i = y / 38;
                if (i < this.elementsCount) {
                    this.focusedElementIndex = i;
                    this.correctScrollBarPositionToItem();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientPointerReleased(int x, int y, int button) {
        Object object = this.lock;
        synchronized (object) {
            if (button == 0) {
                int f = this.checkboxPressed;
                this.checkboxFocused = -1;
                this.checkboxPressed = -1;
                if (f >= 0 && f < this.elementsCount) {
                    switch (this.type) {
                        case 1: {
                            Element[] list = this.elements;
                            this.elements[this.checkedElementIndex].selected = false;
                            this.checkedElementIndex = f;
                            list[f].selected = true;
                            break;
                        }
                        case 2: {
                            Element elem = this.elements[f];
                            this.elements[f].selected = !elem.selected;
                        }
                    }
                    this.callSeriallyPaintScreen(4);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCommandAction(Command command) {
        if (command == SELECT[0]) {
            Object object = this.lock;
            synchronized (object) {
                Element[] list = this.elements;
                int i = this.elementsCount;
                while (i-- > 0) {
                    list[i].selected = true;
                }
                this.callSeriallyPaintScreen(4);
            }
            return;
        }
        if (command == SELECT[1]) {
            Object object = this.lock;
            synchronized (object) {
                Element[] list = this.elements;
                int i = this.elementsCount;
                while (i-- > 0) {
                    list[i].selected = false;
                }
                this.callSeriallyPaintScreen(4);
            }
            return;
        }
        if (command == SELECT[2]) {
            Object object = this.lock;
            synchronized (object) {
                Element[] list = this.elements;
                int i = this.elementsCount;
                while (i-- > 0) {
                    Element elem = list[i];
                    boolean bl = list[i].selected = !elem.selected;
                }
                this.callSeriallyPaintScreen(4);
            }
            return;
        }
        if (command == CHECK_COMMAND) {
            Object object = this.lock;
            synchronized (object) {
                int f = this.focusedElementIndex;
                if (f >= 0 && f < this.elementsCount) {
                    switch (this.type) {
                        case 1: {
                            Element[] list = this.elements;
                            this.elements[this.checkedElementIndex].selected = false;
                            this.checkedElementIndex = f;
                            list[f].selected = true;
                            break;
                        }
                        case 2: {
                            Element elem = this.elements[f];
                            this.elements[f].selected = !elem.selected;
                        }
                    }
                    this.callSeriallyPaintScreen(4);
                }
            }
            return;
        }
        super.onCommandAction(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveCursor(int key) {
        MIDletProxy proxy = MIDletProxy.getInstance();
        if (key == proxy.getKeyUsedAs(38)) {
            Object object = this.lock;
            synchronized (object) {
                int len = this.elementsCount;
                if (len > 0) {
                    this.focusedElementIndex = (this.focusedElementIndex + len - 1) % len;
                    this.correctScrollBarPositionToItem();
                }
            }
            return;
        }
        if (key == proxy.getKeyUsedAs(36)) {
            Object object = this.lock;
            synchronized (object) {
                int len = this.elementsCount;
                if (len > 0) {
                    this.focusedElementIndex = (this.focusedElementIndex + 1) % len;
                    this.correctScrollBarPositionToItem();
                }
            }
        }
    }

    private void correctTruncated(Element elem) {
        elem.truncated = Displayable.truncate(elem.text, elem.font, this.getClientWidth() - (this.type != 3 ? CHECKBOX_WIDTH + 3 : 0) - (elem.icon != null ? 35 : 0) - 6);
    }

    private void correctScrollBarPositionToItem() {
        int need;
        ScrollBar scrollbar = this.getVertScrollBar();
        int pos = scrollbar.getPosition();
        if (pos > (need = this.focusedElementIndex * 38)) {
            scrollbar.setPosition(need);
        } else if (pos < (need -= scrollbar.getPage() - 38)) {
            scrollbar.setPosition(need);
        }
        this.callSeriallyPaintScreen(4);
    }

    private static final class Element
    extends ChoiceElement {
        public boolean visible;
        public String truncated;

        Element(boolean selected, Font font, String text, Image icon) {
            super(selected, font, text, icon);
        }
    }
}

