/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.TextOutput;

public class TextOutputMultilined
extends TextOutput {
    public static final char LINE_SEPARATOR = '\n';
    public static final char WHITE_SPACE = ' ';
    protected int linesCount;
    protected int[] linesBounds;

    public TextOutputMultilined() {
    }

    public TextOutputMultilined(int capacity) {
        super(capacity);
    }

    public void split(Font font, int width) {
        int line = 0;
        int len = this.length;
        char[] c = this.chars;
        int[] l = new int[17];
        int s = 0;
        int i = 0;
        while (i <= len) {
            int n;
            int e;
            int j;
            char ch;
            boolean ending;
            int w = 0;
            while (!(ending = i >= len) && !(ending = (ch = c[i]) == '\n') && (j = w + font.charWidth(ch)) <= width) {
                w = j;
                ++i;
            }
            if (ending) {
                e = i;
                n = e + 1;
            } else if (i == s) {
                n = e = s + 1;
            } else {
                n = e = i;
                j = i - 1;
                while (j > s) {
                    ch = c[j];
                    if (ch == ' ') {
                        e = j;
                        n = e + 1;
                        break;
                    }
                    if (this.isWordSeparator(ch)) {
                        n = e = j + 1;
                        break;
                    }
                    --j;
                }
            }
            if (l.length == line + 1) {
                int[] nArray = l;
                l = new int[(line << 1) - 1];
                Array.copy((int[])nArray, (int)0, (int[])l, (int)0, (int)line);
            }
            l[line++] = s;
            l[line++] = e - s;
            i = s = n;
        }
        l[line] = len;
        this.linesCount = line >> 1;
        this.linesBounds = l;
    }

    public boolean isWordSeparator(char c) {
        return c >= '\u0000' && c <= ' ' || c == '!' || c == '%' || c == '&' || c >= ')' && c <= '/' || c >= ':' && c <= '@' || c >= '\\' && c <= '`' || c >= '|' && c <= '~';
    }

    public final int getLinesCount() {
        return this.linesCount;
    }

    public final int getLineStart(int lineIndex) {
        int linesCount = this.linesCount;
        return linesCount > 0 && lineIndex >= 0 && lineIndex <= linesCount ? this.linesBounds[lineIndex << 1] : -1;
    }

    public final int getLineLength(int lineIndex) {
        return lineIndex >= 0 && lineIndex < this.linesCount ? this.linesBounds[(lineIndex << 1) + 1] : 0;
    }

    public final int getLineAt(int position) {
        int a2;
        int a1;
        int b;
        int count;
        int a;
        block4: {
            int[] bounds = this.linesBounds;
            a = 0;
            count = this.linesCount;
            b = count >> 1;
            int c = count;
            while (true) {
                a1 = bounds[a << 1];
                a2 = bounds[b << 1];
                int a3 = bounds[c << 1];
                if (b - a <= 1 && c - b <= 1) break block4;
                if (position >= a1 && position < a2) {
                    c = b;
                    b = a + c >> 1;
                    continue;
                }
                if (position < a2 || position > a3) break;
                a = b;
                b = a + c >> 1;
            }
            return -1;
        }
        if (position >= a2 && b >= 0 && b <= count) {
            return b;
        }
        if (position >= a1 && a >= 0 && a <= count) {
            return a;
        }
        return -1;
    }
}

