/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;

public class TiledLayer
extends Layer {
    private int cols;
    private int rows;
    private int tileWidth;
    private int tileHeight;
    private int tilesCount;
    private int tilesPerRow;
    private int animatedTilesCount;
    private int[] animatedTiles;
    private int[] cells;
    private Image tileSet;

    public TiledLayer(int columns, int rows, Image tileSet, int tileWidth, int tileHeight) {
        super(columns * tileWidth, rows * tileHeight);
        int height;
        if (tileSet == null) {
            throw new NullPointerException("TiledLayer: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 tileSet \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (columns < 1 || rows < 1) {
            throw new IllegalArgumentException("TiledLayer: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0437\u0430\u043c\u043e\u0449\u0451\u043d\u043d\u043e\u0433\u043e \u0441\u043b\u043e\u044f \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        if (tileWidth < 1 || tileHeight < 1) {
            throw new IllegalArgumentException("TiledLayer: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043f\u043b\u0438\u0442\u043e\u043a \u0437\u0430\u043c\u043e\u0449\u0451\u043d\u043d\u043e\u0433\u043e \u0441\u043b\u043e\u044f \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        int width = tileSet.getWidth();
        if (width % tileWidth != 0 || (height = tileSet.getHeight()) % tileHeight != 0) {
            throw new IllegalArgumentException("TiledLayer: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0430\u0431\u043e\u0440\u0430 \u043f\u043b\u0438\u0442\u043e\u043a \u043c\u043e\u0433\u0443\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430\u0446\u0435\u043b\u043e \u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0441\u0430\u043c\u0438\u0445 \u043f\u043b\u0438\u0442\u043e\u043a.");
        }
        this.cols = columns;
        this.rows = rows;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        int tmp = width / tileWidth;
        this.tilesCount = tmp * (height / tileHeight);
        this.tilesPerRow = tmp;
        this.cells = new int[columns * rows];
        this.tileSet = tileSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStaticTileSet(Image tileSet, int tileWidth, int tileHeight) {
        int height;
        if (tileSet == null) {
            throw new NullPointerException("TiledLayer.setStaticTileSet: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 tileSet \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (tileWidth < 1 || tileHeight < 1) {
            throw new IllegalArgumentException("TiledLayer.setStaticTileSet: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043f\u043b\u0438\u0442\u043e\u043a \u0437\u0430\u043c\u043e\u0449\u0451\u043d\u043d\u043e\u0433\u043e \u0441\u043b\u043e\u044f \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c\u0438.");
        }
        int width = tileSet.getWidth();
        if (width % tileWidth != 0 || (height = tileSet.getHeight()) % tileHeight != 0) {
            throw new IllegalArgumentException("TiledLayer.setStaticTileSet: \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u043d\u0430\u0431\u043e\u0440\u0430 \u043f\u043b\u0438\u0442\u043e\u043a \u043c\u043e\u0433\u0443\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430\u0446\u0435\u043b\u043e \u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0440\u0430\u0437\u043c\u0435\u0440\u044b \u0441\u0430\u043c\u0438\u0445 \u043f\u043b\u0438\u0442\u043e\u043a.");
        }
        int[] cls = this.cells;
        int[] nArray = this.cells;
        synchronized (nArray) {
            int newTilesCount;
            int oldTilesCount = this.tilesCount;
            this.setSize(this.cols * tileWidth, this.rows * tileHeight);
            this.tileWidth = tileWidth;
            this.tileHeight = tileHeight;
            int tmp = width / tileWidth;
            this.tilesCount = newTilesCount = tmp * (height / tileHeight);
            this.tilesPerRow = tmp;
            this.tileSet = tileSet;
            if (newTilesCount < oldTilesCount) {
                this.animatedTilesCount = 0;
                this.animatedTiles = null;
                int i = cls.length;
                while (i-- > 0) {
                    cls[i] = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnimatedTile(int animatedTileIndex, int staticTileIndex) {
        if (staticTileIndex < 0 || staticTileIndex > this.tilesCount) {
            throw new IndexOutOfBoundsException("TiledLayer.setAnimatedTile: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 staticTileIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        boolean error = false;
        int[] nArray = this.cells;
        synchronized (this.cells) {
            int[] animated = this.animatedTiles;
            if (this.animatedTiles == null || (animatedTileIndex ^= 0xFFFFFFFF) < 0 || animatedTileIndex >= this.animatedTilesCount) {
                error = true;
            } else {
                animated[animatedTileIndex] = staticTileIndex;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (error) {
                throw new IndexOutOfBoundsException("TiledLayer.setAnimatedTile: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 animatedTileIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            return;
        }
    }

    public void setCell(int col, int row, int tileIndex) {
        int c;
        if (col < 0 || col >= (c = this.cols)) {
            throw new IndexOutOfBoundsException("TiledLayer.setCell: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 col \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("TiledLayer.setCell: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 row \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (tileIndex < -this.animatedTilesCount || tileIndex > this.tilesCount) {
            throw new IndexOutOfBoundsException("TiledLayer.setCell: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 tileIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        this.cells[col + row * c] = tileIndex;
    }

    public void fillCells(int col, int row, int numCols, int numRows, int tileIndex) {
        int b;
        int c;
        int r;
        block7: {
            block6: {
                int lim = r = col + numCols;
                int len = c = this.cols;
                if (r > c || lim < col || col > len || col < 0) break block6;
                lim = b = row + numRows;
                len = this.rows;
                if (b <= len && lim >= row && row <= len && row >= 0) break block7;
            }
            throw new IndexOutOfBoundsException("TiledLayer.fillCells: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (tileIndex < -this.animatedTilesCount || tileIndex > this.tilesCount) {
            throw new IndexOutOfBoundsException("TiledLayer.fillCells: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 tileIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] cls = this.cells;
        int d = row * c;
        int j = row;
        while (j < b) {
            int i = col;
            while (i < r) {
                cls[i + d] = tileIndex;
                ++i;
            }
            d += c;
            ++j;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createAnimatedTile(int staticTileIndex) {
        if (staticTileIndex < 0 || staticTileIndex > this.tilesCount) {
            throw new IndexOutOfBoundsException("TiledLayer.createAnimatedTile: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 staticTileIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] nArray = this.cells;
        synchronized (this.cells) {
            int result = this.animatedTilesCount;
            int[] animated = this.animatedTiles;
            if (this.animatedTiles == null) {
                animated = this.animatedTiles = new int[4];
            } else if (result == animated.length) {
                int[] nArray2 = animated;
                animated = this.animatedTiles = new int[result << 1];
                Array.copy((int[])nArray2, (int)0, (int[])this.animatedTiles, (int)0, (int)result);
            }
            animated[result++] = staticTileIndex;
            this.animatedTilesCount = result;
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return -result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAnimatedTile(int animatedTileIndex) {
        boolean error = false;
        int[] nArray = this.cells;
        synchronized (this.cells) {
            int result;
            int[] animated = this.animatedTiles;
            if (this.animatedTiles == null || (animatedTileIndex ^= 0xFFFFFFFF) < 0 || animatedTileIndex >= this.animatedTilesCount) {
                error = true;
                result = 0;
            } else {
                result = animated[animatedTileIndex];
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (error) {
                throw new IndexOutOfBoundsException("TiledLayer.getAnimatedTile: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 animatedTileIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
            return result;
        }
    }

    public int getCell(int col, int row) {
        int c;
        if (col < 0 || col >= (c = this.cols)) {
            throw new IndexOutOfBoundsException("TiledLayer.getCell: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 col \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (row < 0 || row >= this.rows) {
            throw new IndexOutOfBoundsException("TiledLayer.getCell: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 row \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return this.cells[col + row * c];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics render) {
        if (render == null) {
            throw new NullPointerException("TiledLayer.paint: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 render \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!this.isVisible()) {
            return;
        }
        int[] cls = this.cells;
        int[] nArray = this.cells;
        synchronized (nArray) {
            int clipLeft = render.getClipX();
            int clipTop = render.getClipY();
            int layerLeft = this.getX();
            int layerTop = this.getY();
            int tileWidth = this.tileWidth;
            int tileHeight = this.tileHeight;
            int tilesCount = this.tilesCount;
            int tilesPerRow = this.tilesPerRow;
            int[] animated = this.animatedTiles;
            Image tileSet = this.tileSet;
            int l = Math.max(0, (clipLeft - layerLeft) / tileWidth);
            int t = Math.max(0, (clipTop - layerTop) / tileHeight);
            int c = this.cols;
            int r = Math.min(c - 1, (clipLeft + render.getClipWidth() - layerLeft - 1) / tileWidth);
            int b = Math.min(this.rows - 1, (clipTop + render.getClipHeight() - layerTop - 1) / tileHeight);
            int d = t * c;
            int j = t;
            while (j <= b) {
                int i = l;
                while (i <= r) {
                    int cell = cls[i + d];
                    if (cell < 0) {
                        cell = animated[~cell];
                    }
                    if (cell != 0 && cell <= tilesCount) {
                        render.drawRegion(tileSet, --cell % tilesPerRow * tileWidth, cell / tilesPerRow * tileHeight, tileWidth, tileHeight, 0, layerLeft + i * tileWidth, layerTop + j * tileHeight, 20);
                    }
                    ++i;
                }
                d += c;
                ++j;
            }
        }
    }

    public final int getColumns() {
        return this.cols;
    }

    public final int getRows() {
        return this.rows;
    }

    public final int getCellWidth() {
        return this.tileWidth;
    }

    public final int getCellHeight() {
        return this.tileHeight;
    }

    final int getTilesPerRow() {
        return this.tilesPerRow;
    }

    final int getTileIndex(int col, int row) {
        int result = this.cells[col + row * this.cols];
        if (result < 0) {
            result = this.animatedTiles[~result];
        }
        return result;
    }

    final Image getTileSet() {
        return this.tileSet;
    }

    final Object getMonitor() {
        return this.cells;
    }
}

