/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.rms.DefaultFilterAndComparator;
import javax.microedition.rms.Enumerator;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.Record;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;
import malik.emulator.io.cloud.CloudFileSystem;
import malik.emulator.io.cloud.FileInputStream;
import malik.emulator.io.cloud.FileOutputStream;
import malik.emulator.io.vfs.FileEnumerator;

public class RecordStore {
    public static final int AUTHMODE_PRIVATE = 0;
    public static final int AUTHMODE_ANY = 1;
    public static final int STATE_ERROR = -1;
    public static final int STATE_RESERV = 0;
    public static final int STATE_OPENED = 1;
    public static final int STATE_CLOSED = 2;
    private static int COUNT;
    private static RecordStore[] OPENED;
    private static final char RMS_HEX_PREFIX = '$';
    private static final int RMS_MAX_LENGTH = 32;
    private static final long RMS_SIGNATURE = 7883943055650352499L;
    private static final String RMS_DIRECTORY = "/rms/";
    private static final String RMS_EXTENSION = ".rms";
    private static final RecordFilter DEFAULT_FILTER;
    private static final RecordComparator DEFAULT_COMPARATOR;
    private static final Object LOCK;
    private int openedCount;
    private int nextID;
    private int version;
    private int count;
    private long lastModified;
    private Record[] records;
    private RecordListener[] listeners;
    private String recordStoreName;
    private String fileName;

    static {
        DefaultFilterAndComparator obj = new DefaultFilterAndComparator();
        DEFAULT_FILTER = obj;
        DEFAULT_COMPARATOR = obj;
        LOCK = obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllRecordStores() {
        Object object = LOCK;
        synchronized (object) {
            int i = COUNT;
            while (i-- > 0) {
                RecordStore store = OPENED[i];
                if (store == null || store.openedCount == 0) continue;
                if (!store.saveData()) {
                    System.err.println("RecordStore.closeRecordStore: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435.");
                }
                store.openedCount = 0;
                store.count = 0;
                store.records = null;
                store.listeners = null;
                System.out.println("RecordStore: \u0432\u043d\u0435\u0441\u0435\u043d\u044b \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 \u0437\u0430\u043f\u0438\u0441\u044c ".concat(store.recordStoreName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRecordStore(String recordStoreName) throws RecordStoreException, RecordStoreNotFoundException {
        RecordStore.checkName(recordStoreName);
        boolean error = false;
        Object object = LOCK;
        synchronized (object) {
            int i = RecordStore.indexOfRecordStore(recordStoreName);
            if (i >= 0) {
                if (RecordStore.OPENED[i].openedCount != 0) {
                    error = true;
                } else {
                    RecordStore.OPENED[i] = null;
                }
            }
        }
        if (error) {
            throw new RecordStoreException("RecordStore.deleteRecordStore: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u0442\u043a\u0440\u044b\u0442\u043e\u0435 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + recordStoreName + ".");
        }
        try {
            CloudFileSystem.getInstance().deleteFile(RMS_DIRECTORY + RecordStore.toFileName(recordStoreName) + RMS_EXTENSION);
        }
        catch (IOException iOException) {
            throw new RecordStoreNotFoundException("RecordStore.deleteRecordStore: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + recordStoreName + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
        }
    }

    public static int getState(String recordStoreName) {
        RecordStore store;
        int i;
        return recordStoreName == null || (i = recordStoreName.length()) < 1 || i > 32 ? -1 : ((store = RecordStore.getRecordStore(recordStoreName)) == null ? 0 : (store.openedCount != 0 ? 1 : 2));
    }

    public static String[] listRecordStores() {
        Vector<String> list;
        block7: {
            int extlen = RMS_EXTENSION.length();
            list = new Vector<String>(COUNT);
            int i = COUNT;
            while (i-- > 0) {
                RecordStore store = OPENED[i];
                if (store == null) continue;
                list.addElement(store.recordStoreName);
            }
            try {
                FileEnumerator fe = CloudFileSystem.getInstance().findFirst(RMS_DIRECTORY);
                if (fe == null) break block7;
                try {
                    do {
                        int fnlen;
                        String name;
                        if (fe.isDirectory() || (name = fe.getFileName()) == null || !name.regionMatches(true, fnlen = name.length() - extlen, RMS_EXTENSION, 0, extlen) || list.contains(name = RecordStore.toRecordStoreName(name.substring(0, fnlen)))) continue;
                        list.addElement(name);
                    } while (fe.findNext());
                }
                finally {
                    fe.close();
                }
            }
            catch (IOException e) {
                e.printRealStackTrace();
            }
        }
        Object[] result = new String[list.size()];
        list.copyInto(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary) throws RecordStoreException, RecordStoreNotFoundException, RecordStoreFullException {
        RecordStore result;
        RecordStore.checkName(recordStoreName);
        int error = 0;
        Object object = LOCK;
        synchronized (object) {
            int i = RecordStore.indexOfRecordStore(recordStoreName);
            if (i >= 0) {
                result = OPENED[i];
                i = result.openedCount;
                if (i == 0 && !result.loadData() && !createIfNecessary) {
                    error = 1;
                } else {
                    result.openedCount = i + 1;
                }
            } else {
                result = new RecordStore(recordStoreName);
                if (!result.loadData() && !createIfNecessary) {
                    error = 2;
                } else {
                    RecordStore.register(result);
                    result.openedCount = 1;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreException("RecordStore.openRecordStore: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435.");
            }
            case 2: {
                throw new RecordStoreNotFoundException("RecordStore.openRecordStore: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + recordStoreName + ".");
            }
        }
        return result;
    }

    public static RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary, int authmode, boolean writable) throws RecordStoreException, RecordStoreNotFoundException, RecordStoreFullException {
        return RecordStore.openRecordStore(recordStoreName, createIfNecessary);
    }

    public static RecordStore openRecordStore(String recordStoreName, String vendor, String suite) throws RecordStoreException, RecordStoreNotFoundException {
        return RecordStore.openRecordStore(recordStoreName, false);
    }

    static Object getMonitor() {
        return LOCK;
    }

    private static void checkName(String recordStoreName) {
        int len;
        if (recordStoreName == null || (len = recordStoreName.length()) < 1 || len > 32) {
            throw new IllegalArgumentException("RecordStore: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0438\u043c\u044f \u0434\u043b\u044f \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430 \u0437\u0430\u043f\u0438\u0441\u0435\u0439.");
        }
    }

    private static void register(RecordStore store) {
        if (OPENED == null) {
            OPENED = new RecordStore[2];
        }
        int i = COUNT;
        while (i-- > 0) {
            if (OPENED[i] != null) continue;
            RecordStore.OPENED[i] = store;
            return;
        }
        if (COUNT == OPENED.length) {
            Object[] objectArray = OPENED;
            OPENED = new RecordStore[COUNT << 1];
            Array.copy((Object[])objectArray, (int)0, (Object[])OPENED, (int)0, (int)COUNT);
        }
        RecordStore.OPENED[RecordStore.COUNT++] = store;
    }

    private static char getDigitRepresentation(int digit) {
        if (digit >= 0 && digit < 10) {
            return (char)(digit + 48);
        }
        if (digit >= 10 && digit < 16) {
            return (char)(digit + 55);
        }
        throw new ArrayIndexOutOfBoundsException(digit);
    }

    private static int indexOfRecordStore(String recordStoreName) {
        int i = COUNT;
        while (i-- > 0) {
            RecordStore store = OPENED[i];
            if (store == null || !recordStoreName.equals(store.recordStoreName)) continue;
            return i;
        }
        return -1;
    }

    private static RecordStore getRecordStore(String recordStoreName) {
        int i = COUNT;
        while (i-- > 0) {
            RecordStore store = OPENED[i];
            if (store == null || !recordStoreName.equals(store.recordStoreName)) continue;
            return store;
        }
        return null;
    }

    private static String toFileName(String recordStoreName) {
        int len = recordStoreName.length();
        int length = 0;
        char[] result = new char[160];
        int i = 0;
        while (i < len) {
            char c;
            if ((c = recordStoreName.charAt(i++)) >= '0' && c <= '9' || c >= 'a' && c <= 'z') {
                result[length++] = c;
                continue;
            }
            result[length++] = 36;
            result[length++] = RecordStore.getDigitRepresentation(c >> 12 & 0xF);
            result[length++] = RecordStore.getDigitRepresentation(c >> 8 & 0xF);
            result[length++] = RecordStore.getDigitRepresentation(c >> 4 & 0xF);
            result[length++] = RecordStore.getDigitRepresentation(c & 0xF);
        }
        return new String(result, 0, length);
    }

    private static String toRecordStoreName(String fileName) {
        int len = fileName.length();
        int length = 0;
        char[] result = new char[32];
        int i = 0;
        while (i < len && length < 32) {
            char c;
            if ((c = fileName.charAt(i++)) == '$') {
                c = '\u0000';
                int j = 0;
                while (i < len) {
                    char d;
                    if ((d = fileName.charAt(i++)) >= '0' && d <= '9') {
                        c = (char)((c << 4) + (d - 48));
                    } else {
                        if (d < 'A' || d > 'F') break;
                        c = (char)((c << 4) + (d - 55));
                    }
                    if (++j < 4) continue;
                }
            }
            result[length++] = c;
        }
        return new String(result, 0, length);
    }

    private RecordStore(String recordStoreName) {
        this.recordStoreName = recordStoreName;
        this.fileName = RMS_DIRECTORY + RecordStore.toFileName(recordStoreName) + RMS_EXTENSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecordListener(RecordListener listener) {
        if (listener == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            Object[] listeners = this.listeners;
            if (this.listeners == null) {
                this.listeners = new RecordListener[2];
                listeners = this.listeners;
            }
            if (this.indexOfListener(listener) < 0) {
                int i = this.indexOfListener(null);
                if (i < 0) {
                    Object[] objectArray = listeners;
                    i = listeners.length;
                    this.listeners = new RecordListener[i << 1];
                    listeners = this.listeners;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.listeners, (int)0, (int)i);
                }
                listeners[i] = listener;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecordListener(RecordListener listener) {
        if (listener == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            int i;
            RecordListener[] listeners = this.listeners;
            if (this.listeners != null && (i = this.indexOfListener(listener)) >= 0) {
                listeners[i] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRecordStore() throws RecordStoreException, RecordStoreNotOpenException {
        int error = 0;
        Object object = LOCK;
        synchronized (object) {
            int i = this.openedCount;
            if (i == 0) {
                error = 1;
            } else {
                this.openedCount = i - 1;
                if (this.openedCount == 0) {
                    if (!this.saveData()) {
                        error = 2;
                    } else {
                        this.count = 0;
                        this.records = null;
                        this.listeners = null;
                        System.out.println("RecordStore: \u0432\u043d\u0435\u0441\u0435\u043d\u044b \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 \u0437\u0430\u043f\u0438\u0441\u044c ".concat(this.recordStoreName));
                    }
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreNotOpenException("RecordStore.closeRecordStore: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
            }
            case 2: {
                throw new RecordStoreException("RecordStore.closeRecordStore: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435.");
            }
        }
    }

    public void setMode(int authmode, boolean writable) throws RecordStoreException {
        if (authmode != 1 && authmode != 0) {
            throw new IllegalArgumentException("RecordStore.setMode: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 authmode.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecord(int recordId, byte[] src, int offset, int length) throws RecordStoreException, RecordStoreFullException, RecordStoreNotOpenException, InvalidRecordIDException {
        int len;
        int lim;
        if (src != null && ((lim = offset + length) > (len = src.length) || lim < offset || offset > len || offset < 0)) {
            throw new ArrayIndexOutOfBoundsException("RecordStore.setRecord: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int error = 0;
        Object object = LOCK;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = 1;
            } else {
                int index = this.indexOfRecord(recordId);
                if (index < 0) {
                    error = 2;
                } else {
                    byte[] data;
                    if (src != null) {
                        data = new byte[length];
                        Array.copy((byte[])src, (int)offset, (byte[])data, (int)0, (int)length);
                    } else {
                        data = new byte[]{};
                    }
                    this.records[index].setData(data);
                    ++this.version;
                    this.lastModified = System.currentTimeMillis();
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreNotOpenException("RecordStore.setRecord: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
            }
            case 2: {
                throw new InvalidRecordIDException("RecordStore.setRecord: \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0438\u0441\u0438: " + recordId + ".");
            }
        }
        this.notifyListenersChanged(recordId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(int recordId) throws RecordStoreException, RecordStoreNotOpenException, InvalidRecordIDException {
        int error = 0;
        Object object = LOCK;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = 1;
            } else {
                int index = this.indexOfRecord(recordId);
                if (index < 0) {
                    error = 2;
                } else {
                    Object[] r = this.records;
                    int c = this.count - 1;
                    int i = c - index;
                    if (i > 0) {
                        Array.copy((Object[])r, (int)(index + 1), (Object[])r, (int)index, (int)i);
                    }
                    this.count = c;
                    r[this.count] = null;
                    ++this.version;
                    this.lastModified = System.currentTimeMillis();
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreNotOpenException("RecordStore.deleteRecord: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
            }
            case 2: {
                throw new InvalidRecordIDException("RecordStore.deleteRecord: \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0438\u0441\u0438: " + recordId + ".");
            }
        }
        this.notifyListenersDeleted(recordId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addRecord(byte[] src, int offset, int length) throws RecordStoreException, RecordStoreNotOpenException, RecordStoreFullException {
        int result;
        int len;
        int lim;
        if (src != null && ((lim = offset + length) > (len = src.length) || lim < offset || offset > len || offset < 0)) {
            throw new ArrayIndexOutOfBoundsException("RecordStore.addRecord: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        boolean error = false;
        Object object = LOCK;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = true;
                result = 0;
            } else {
                byte[] data;
                int c;
                Object[] r = this.records;
                if (this.records == null || r.length == 0) {
                    this.records = new Record[1];
                    r = this.records;
                }
                if ((c = this.count) == r.length) {
                    Object[] objectArray = r;
                    this.records = new Record[c << 1];
                    r = this.records;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.records, (int)0, (int)c);
                }
                if (src != null) {
                    data = new byte[length];
                    Array.copy((byte[])src, (int)offset, (byte[])data, (int)0, (int)length);
                } else {
                    data = new byte[]{};
                }
                result = this.nextID++;
                r[c] = new Record(result, data);
                this.count = c + 1;
                ++this.version;
                this.lastModified = System.currentTimeMillis();
            }
        }
        if (error) {
            throw new RecordStoreNotOpenException("RecordStore.addRecord: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
        }
        this.notifyListenersAdded(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecord(int recordId, byte[] dst, int offset) throws RecordStoreException, RecordStoreNotOpenException, InvalidRecordIDException {
        int length;
        if (dst == null) {
            throw new NullPointerException("RecordStore.getRecord: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int error = 0;
        Object object = LOCK;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = 1;
                length = 0;
            } else {
                int index = this.indexOfRecord(recordId);
                if (index < 0) {
                    error = 2;
                    length = 0;
                } else {
                    int len;
                    byte[] data = this.records[index].getData();
                    length = data.length;
                    int lim = offset + length;
                    if (lim > (len = dst.length) || lim < offset || offset > len || offset < 0) {
                        error = 3;
                    } else {
                        Array.copy((byte[])data, (int)0, (byte[])dst, (int)offset, (int)length);
                    }
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreNotOpenException("RecordStore.getRecord: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
            }
            case 2: {
                throw new InvalidRecordIDException("RecordStore.getRecord: \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0438\u0441\u0438: " + recordId + ".");
            }
            case 3: {
                throw new ArrayIndexOutOfBoundsException("RecordStore.getRecord: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordSize(int recordId) throws RecordStoreException, RecordStoreNotOpenException, InvalidRecordIDException {
        int result;
        int error = 0;
        Object object = LOCK;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = 1;
                result = 0;
            } else {
                int index = this.indexOfRecord(recordId);
                if (index < 0) {
                    error = 2;
                    result = 0;
                } else {
                    result = this.records[index].getDataSize();
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreNotOpenException("RecordStore.getRecordSize: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
            }
            case 2: {
                throw new InvalidRecordIDException("RecordStore.getRecordSize: \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0438\u0441\u0438: " + recordId + ".");
            }
        }
        return result;
    }

    public int getSizeAvailable() throws RecordStoreNotOpenException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException("RecordStore.getSizeAvailable: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
        }
        return (int)Runtime.getRuntime().freeMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws RecordStoreNotOpenException {
        int result;
        boolean error = false;
        Object object = LOCK;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = true;
                result = 0;
            } else {
                result = 32;
                Record[] r = this.records;
                int i = this.count;
                while (i-- > 0) {
                    if (((result += r[i].getDataSize() + 8) & 3) == 0) continue;
                    result = result + 4 & 0xFFFFFFFC;
                }
            }
        }
        if (error) {
            throw new RecordStoreNotOpenException("RecordStore.getSize: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
        }
        return result;
    }

    public int getVersion() throws RecordStoreNotOpenException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException("RecordStore.getVersion: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
        }
        return this.version;
    }

    public int getNumRecords() throws RecordStoreNotOpenException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException("RecordStore.getNumRecords: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
        }
        return this.count;
    }

    public int getNextRecordID() throws RecordStoreException, RecordStoreNotOpenException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException("RecordStore.getNextRecordID: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
        }
        return this.nextID;
    }

    public long getLastModified() throws RecordStoreNotOpenException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException("RecordStore.getLastModified: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
        }
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRecord(int recordId) throws RecordStoreException, RecordStoreNotOpenException, InvalidRecordIDException {
        byte[] result;
        int error = 0;
        Object object = LOCK;
        synchronized (object) {
            if (this.openedCount == 0) {
                error = 1;
                result = null;
            } else {
                int index = this.indexOfRecord(recordId);
                if (index < 0) {
                    error = 2;
                    result = null;
                } else {
                    byte[] data = this.records[index].getData();
                    int length = data.length;
                    result = new byte[length];
                    Array.copy((byte[])data, (int)0, (byte[])result, (int)0, (int)length);
                }
            }
        }
        switch (error) {
            case 1: {
                throw new RecordStoreNotOpenException("RecordStore.getRecord: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
            }
            case 2: {
                throw new InvalidRecordIDException("RecordStore.getRecord: \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0438\u0441\u0438: " + recordId + ".");
            }
        }
        return result;
    }

    public String getName() throws RecordStoreNotOpenException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException("RecordStore.getName: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
        }
        return this.recordStoreName;
    }

    public RecordEnumeration enumerateRecords(RecordFilter filter, RecordComparator comparator, boolean autoRebuild) throws RecordStoreNotOpenException {
        if (this.openedCount == 0) {
            throw new RecordStoreNotOpenException("RecordStore.enumerateRecords: \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 " + this.recordStoreName + " \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442\u043e.");
        }
        return new Enumerator(this, filter == null ? DEFAULT_FILTER : filter, comparator == null ? DEFAULT_COMPARATOR : comparator, autoRebuild);
    }

    boolean isRecordStoreOpened() {
        return this.openedCount != 0;
    }

    int getRecordsCount() {
        return this.count;
    }

    Record[] getRecords() {
        return this.records;
    }

    String getRecordStoreName() {
        return this.recordStoreName;
    }

    private void notifyListenersAdded(int recordId) {
        RecordListener[] listeners = this.listeners;
        int i = this.listeners != null ? listeners.length : 0;
        while (i-- > 0) {
            RecordListener listener = listeners[i];
            if (listener == null) continue;
            try {
                listener.recordAdded(this, recordId);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
    }

    private void notifyListenersChanged(int recordId) {
        RecordListener[] listeners = this.listeners;
        int i = this.listeners != null ? listeners.length : 0;
        while (i-- > 0) {
            RecordListener listener = listeners[i];
            if (listener == null) continue;
            try {
                listener.recordChanged(this, recordId);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
    }

    private void notifyListenersDeleted(int recordId) {
        RecordListener[] listeners = this.listeners;
        int i = this.listeners != null ? listeners.length : 0;
        while (i-- > 0) {
            RecordListener listener = listeners[i];
            if (listener == null) continue;
            try {
                listener.recordDeleted(this, recordId);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
    }

    private boolean saveData() {
        boolean result;
        FileOutputStream file = new FileOutputStream(this.fileName);
        if (file.hasOpenError()) {
            return false;
        }
        try {
            try {
                DataOutputStream stream = new DataOutputStream((OutputStream)file);
                stream.writeLong(7883943055650352499L);
                int c = this.count;
                stream.writeInt(c);
                stream.writeInt(this.version);
                stream.writeLong(this.lastModified);
                stream.writeInt(this.nextID);
                stream.writeInt(0);
                Record[] r = this.records;
                int i = 0;
                while (i < c) {
                    Record rec = r[i];
                    stream.writeInt(rec.getRecordID());
                    byte[] data = rec.getData();
                    int length = data.length;
                    stream.writeInt(length);
                    stream.write(data);
                    switch (length & 3) {
                        case 1: {
                            stream.writeByte(0);
                        }
                        case 2: {
                            stream.writeByte(0);
                        }
                        case 3: {
                            stream.writeByte(0);
                        }
                    }
                    ++i;
                }
            }
            finally {
                file.close();
            }
            result = true;
        }
        catch (IOException e) {
            e.printRealStackTrace();
            result = false;
        }
        return result;
    }

    private boolean loadData() {
        boolean result;
        FileInputStream file = new FileInputStream(this.fileName);
        if (file.hasOpenError()) {
            this.nextID = 1;
            this.version = 1;
            this.count = 0;
            this.lastModified = System.currentTimeMillis();
            this.records = null;
            return false;
        }
        try {
            try {
                DataInputStream stream = new DataInputStream((InputStream)file);
                if (stream.readLong() != 7883943055650352499L) {
                    this.nextID = 1;
                    this.version = 1;
                    this.count = 0;
                    this.lastModified = System.currentTimeMillis();
                    this.records = null;
                    result = false;
                } else {
                    int c;
                    this.count = c = stream.readInt();
                    this.version = stream.readInt();
                    this.lastModified = stream.readLong();
                    this.nextID = stream.readInt();
                    Record[] r = new Record[c];
                    this.records = r;
                    stream.skipBytes(4);
                    int i = 0;
                    while (i < c) {
                        int id = stream.readInt();
                        int length = stream.readInt();
                        byte[] data = new byte[length];
                        stream.read(data);
                        if ((length &= 3) != 0) {
                            stream.skipBytes(4 - length);
                        }
                        r[i] = new Record(id, data);
                        ++i;
                    }
                    result = true;
                }
            }
            finally {
                file.close();
            }
        }
        catch (IOException e) {
            this.nextID = 1;
            this.version = 1;
            this.count = 0;
            this.lastModified = System.currentTimeMillis();
            this.records = null;
            e.printRealStackTrace();
            result = false;
        }
        return result;
    }

    private int indexOfRecord(int recordId) {
        Record[] r = this.records;
        int i = this.count;
        while (i-- > 0) {
            if (r[i].getRecordID() != recordId) continue;
            return i;
        }
        return -1;
    }

    private int indexOfListener(RecordListener listener) {
        RecordListener[] listeners = this.listeners;
        int i = this.listeners.length;
        while (i-- > 0) {
            if (listeners[i] != listener) continue;
            return i;
        }
        return -1;
    }
}

