/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.j2me;

import javax.microedition.media.Control;
import javax.microedition.media.Controllable;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.TimeBase;
import malik.emulator.io.j2me.PlayerEventsListenerThread;
import malik.emulator.io.j2me.SystemTimeBase;

public abstract class CustomPlayer
implements Control,
Controllable,
Player {
    private static final PlayerEventsListenerThread EVENTS_LISTENER;
    private static final TimeBase SYSTEM_TIME_BASE;
    protected int state = 100;
    protected Object lock = new Object();
    private PlayerListener[] listeners;

    static {
        PlayerEventsListenerThread t;
        EVENTS_LISTENER = t = new PlayerEventsListenerThread();
        SYSTEM_TIME_BASE = new SystemTimeBase();
        t.start();
    }

    public static final TimeBase getSystemTimeBase() {
        return SYSTEM_TIME_BASE;
    }

    protected CustomPlayer() {
    }

    public abstract void close();

    public abstract void start() throws MediaException;

    public abstract void stop() throws MediaException;

    public abstract void setLoopCount(int var1);

    public abstract long setMediaTime(long var1) throws MediaException;

    public abstract long getMediaTime();

    public abstract long getDuration();

    public void realize() throws MediaException {
    }

    public void prefetch() throws MediaException {
    }

    public void deallocate() {
        switch (this.state) {
            default: {
                return;
            }
            case 0: {
                throw new IllegalStateException("Player.deallocate: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 100: {
                this.unrealize();
                return;
            }
            case 300: 
            case 400: 
        }
        this.unprefetch();
    }

    public void setTimeBase(TimeBase master) throws MediaException {
        if (master != null && !(master instanceof SystemTimeBase)) {
            throw new MediaException("Player.setTimeBase: \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0434\u0440\u0443\u0433\u0438\u0445 \u0441\u043f\u043e\u0441\u043e\u0431\u043e\u0432 \u0438\u0441\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
        }
    }

    public TimeBase getTimeBase() {
        return SYSTEM_TIME_BASE;
    }

    public final Control[] getControls() {
        switch (this.state) {
            case 100: {
                this.deliverEvent("error", "Player.getControls: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u00ab\u0440\u044b\u0447\u0430\u0433\u0438\u00bb \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044f.");
            }
            case 0: {
                throw new IllegalStateException("Player.getControls: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u00ab\u0440\u044b\u0447\u0430\u0433\u0438\u00bb \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044f.");
            }
        }
        return this.getPlayerControls();
    }

    public final Control getControl(String type) {
        switch (this.state) {
            case 100: {
                this.deliverEvent("error", "Player.getControl: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u00ab\u0440\u044b\u0447\u0430\u0433\u0438\u00bb \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044f.");
            }
            case 0: {
                throw new IllegalStateException("Player.getControl: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u00ab\u0440\u044b\u0447\u0430\u0433\u0438\u00bb \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044f.");
            }
        }
        return this.getPlayerControl(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPlayerListener(PlayerListener listener) {
        if (this.state == 0) {
            throw new IllegalStateException("Player.addPlayerListener: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        if (listener == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            Object[] listeners = this.listeners;
            if (this.listeners == null) {
                this.listeners = new PlayerListener[2];
                listeners = this.listeners;
            }
            if (this.indexOfListener(listener) < 0) {
                int i = this.indexOfListener(null);
                if (i < 0) {
                    Object[] objectArray = listeners;
                    i = listeners.length;
                    this.listeners = new PlayerListener[i << 1];
                    listeners = this.listeners;
                    Array.copy((Object[])objectArray, (int)0, (Object[])this.listeners, (int)0, (int)i);
                }
                listeners[i] = listener;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePlayerListener(PlayerListener listener) {
        if (this.state == 0) {
            throw new IllegalStateException("Player.removePlayerListener: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        if (listener == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int i;
            PlayerListener[] listeners = this.listeners;
            if (this.listeners != null && (i = this.indexOfListener(listener)) >= 0) {
                listeners[i] = null;
            }
        }
    }

    public final int getState() {
        return this.state;
    }

    public final String getContentType() {
        switch (this.state) {
            case 100: {
                this.deliverEvent("error", "Player.getContentType: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0442\u0438\u043f \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044f.");
            }
            case 0: {
                throw new IllegalStateException("Player.getContentType: \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0442\u0438\u043f \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044f.");
            }
        }
        return this.getPlayerContentType();
    }

    protected abstract String getPlayerContentType();

    protected void unrealize() {
    }

    protected void unprefetch() {
        this.state = 200;
    }

    protected Control[] getPlayerControls() {
        return new Control[]{this};
    }

    protected Control getPlayerControl(String type) {
        CustomPlayer result;
        if (type.indexOf(46) < 0) {
            type = "javax.microedition.media.control.".concat(type);
        }
        try {
            Class<?> controlClass = Class.forName(type);
            result = Class.forName("javax.microedition.media.Control").isAssignableFrom(controlClass) && controlClass.isAssignableFrom(this.getClass()) ? this : null;
        }
        catch (ClassNotFoundException e) {
            e.printRealStackTrace();
            result = null;
        }
        return result;
    }

    protected final void deliverEvent(String event, Object data) {
        if (this.listeners != null) {
            EVENTS_LISTENER.pushEvent(this, event, data);
        }
    }

    private int indexOfListener(PlayerListener listener) {
        PlayerListener[] listeners = this.listeners;
        int i = this.listeners.length;
        while (i-- > 0) {
            if (listeners[i] != listener) continue;
            return i;
        }
        return -1;
    }

    final class Event {
        private String event;
        private Object data;

        public Event(String event, Object data) {
            this.event = event;
            this.data = data;
        }

        public void invokePlayerUpdateFromListeners() {
            CustomPlayer player = CustomPlayer.this;
            String event = this.event;
            Object data = this.data;
            PlayerListener[] listeners = player.listeners;
            int i = listeners != null ? listeners.length : 0;
            while (i-- > 0) {
                PlayerListener listener = listeners[i];
                if (listener == null) continue;
                try {
                    listener.playerUpdate(player, event, data);
                }
                catch (RuntimeException e) {
                    e.printRealStackTrace();
                }
            }
            if ("closed".equals(event)) {
                player.listeners = null;
            }
        }
    }
}

