/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import malik.emulator.microedition.DeviceManager;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;

    public static Connection open(String url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Connector.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 url \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return DeviceManager.getInstance().openConnection(url, 3, false);
    }

    public static Connection open(String url, int mode) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Connector.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 url \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (mode < 1 || mode > 3) {
            throw new IllegalArgumentException("Connector.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 mode \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        return DeviceManager.getInstance().openConnection(url, mode, false);
    }

    public static Connection open(String url, int mode, boolean timeouts) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Connector.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 url \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (mode < 1 || mode > 3) {
            throw new IllegalArgumentException("Connector.open: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 mode \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        return DeviceManager.getInstance().openConnection(url, mode, timeouts);
    }

    public static InputStream openInputStream(String url) throws IOException {
        InputStream result;
        try {
            InputConnection connection = (InputConnection)Connector.open(url, 1);
            try {
                result = connection.openInputStream();
            }
            finally {
                connection.close();
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Connector.openInputStream: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0442\u043e\u043a\u043e\u043c \u0432\u0432\u043e\u0434\u0430.");
        }
        return result;
    }

    public static DataInputStream openDataInputStream(String url) throws IOException {
        DataInputStream result;
        try {
            InputConnection connection = (InputConnection)Connector.open(url, 1);
            try {
                result = connection.openDataInputStream();
            }
            finally {
                connection.close();
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Connector.openDataInputStream: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0442\u043e\u043a\u043e\u043c \u0432\u0432\u043e\u0434\u0430.");
        }
        return result;
    }

    public static OutputStream openOutputStream(String url) throws IOException {
        OutputStream result;
        try {
            OutputConnection connection = (OutputConnection)Connector.open(url, 2);
            try {
                result = connection.openOutputStream();
            }
            finally {
                connection.close();
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Connector.openOutputStream: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0442\u043e\u043a\u043e\u043c \u0432\u044b\u0432\u043e\u0434\u0430.");
        }
        return result;
    }

    public static DataOutputStream openDataOutputStream(String url) throws IOException {
        DataOutputStream result;
        try {
            OutputConnection connection = (OutputConnection)Connector.open(url, 2);
            try {
                result = connection.openDataOutputStream();
            }
            finally {
                connection.close();
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Connector.openDataOutputStream: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0442\u043e\u043a\u043e\u043c \u0432\u044b\u0432\u043e\u0434\u0430.");
        }
        return result;
    }

    private Connector() {
    }
}

