/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;

public abstract class CustomItem
extends Item {
    protected static final int NONE = 0;
    protected static final int TRAVERSE_HORIZONTAL = 1;
    protected static final int TRAVERSE_VERTICAL = 2;
    protected static final int KEY_PRESS = 4;
    protected static final int KEY_RELEASE = 8;
    protected static final int KEY_REPEAT = 16;
    protected static final int POINTER_PRESS = 32;
    protected static final int POINTER_RELEASE = 64;
    protected static final int POINTER_DRAG = 128;
    private boolean focused;
    private int contentWidth;
    private int contentHeight;

    protected CustomItem(String label) {
        super(label);
    }

    public int getGameAction(int keyCode) {
        return DeviceManager.getInstance().getSettings().keyCodeToGameAction(keyCode);
    }

    protected abstract void paint(Graphics var1, int var2, int var3);

    protected abstract int getMinContentWidth();

    protected abstract int getMinContentHeight();

    protected abstract int getPrefContentWidth(int var1);

    protected abstract int getPrefContentHeight(int var1);

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected void sizeChanged(int contentWidth, int contentHeight) {
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    protected void traverseOut() {
    }

    protected boolean traverse(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        return false;
    }

    protected final void invalidate() {
        this.requestInvalidate();
    }

    protected final void repaint() {
        this.requestPaint();
    }

    protected final void repaint(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        this.requestPaint();
    }

    protected final int getInteractionModes() {
        return DeviceManager.getInstance().getSettings().isKeyRepeatedEvent() ? 255 : 239;
    }

    void onShow() {
        try {
            this.showNotify();
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    void onHide() {
        try {
            this.hideNotify();
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    void onSizeChanged(int contentWidth, int contentHeight) {
        try {
            this.contentWidth = contentWidth;
            this.contentHeight = contentHeight;
            this.sizeChanged(this.contentWidth, this.contentHeight);
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    void onKeyboardEvent(KeyboardEvent event) {
        DeviceSettings settings = DeviceManager.getInstance().getSettings();
        switch (event.getAction()) {
            case 6: {
                int keyCode = settings.getKeyCode(event.getKey());
                if (keyCode == 0) break;
                this.keyPressed(keyCode);
                break;
            }
            case 5: {
                int keyCode;
                if (!settings.isKeyRepeatedEvent() || (keyCode = settings.getKeyCode(event.getKey())) == 0) break;
                this.keyRepeated(keyCode);
                break;
            }
            case 7: {
                int keyCode = settings.getKeyCode(event.getKey());
                if (keyCode == 0) break;
                this.keyReleased(keyCode);
            }
        }
    }

    void onPointerEvent(PointerEvent event) {
        switch (event.getAction()) {
            case 10: 
            case 14: {
                if (event.getButton() != 0) break;
                int x = event.getX();
                int y = event.getY();
                int w = this.contentWidth;
                int h = this.contentHeight;
                if (x < 0 || x >= w || y < 0 || y >= h) break;
                this.focused = true;
                this.pointerPressed(x, y);
                break;
            }
            case 9: {
                if (!this.focused) break;
                this.pointerDragged(event.getX(), event.getY());
                break;
            }
            case 11: 
            case 15: {
                if (!this.focused || event.getButton() != 0) break;
                this.focused = false;
                this.pointerReleased(event.getX(), event.getY());
            }
        }
    }

    void onFocusLost() {
        try {
            this.traverseOut();
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    boolean onFocusMove(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        boolean result = false;
        try {
            result = this.traverse(direction, viewportWidth, viewportHeight, visibleRectangle);
            if (result) {
                int h;
                int w = visibleRectangle[2];
                if (w < 0) {
                    w = 0;
                }
                if ((h = visibleRectangle[3]) < 0) {
                    h = 0;
                }
                if (w > viewportWidth) {
                    w = viewportWidth;
                }
                if (h > viewportHeight) {
                    h = viewportHeight;
                }
                visibleRectangle[2] = w;
                visibleRectangle[3] = h;
            }
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        return result;
    }

    int getDefaultLayout() {
        return 2048;
    }

    int getMinimumContentWidth() {
        int result = 0;
        try {
            result = this.getMinContentWidth();
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        return result < 0 ? 0 : result;
    }

    int getMinimumContentHeight() {
        int result = 0;
        try {
            result = this.getMinContentHeight();
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        return result < 0 ? 0 : result;
    }

    int getPreferredContentWidth(int contentHeight) {
        int result = 0;
        try {
            result = this.getPrefContentWidth(contentHeight);
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        return result < 0 ? 0 : result;
    }

    int getPreferredContentHeight(int contentWidth) {
        int result = 0;
        try {
            result = this.getPrefContentHeight(contentWidth);
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        return result < 0 ? 0 : result;
    }
}

