/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ScreenGraphics;
import javax.microedition.lcdui.Ticker;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.lcdui.MultilinedStringBuilder;

public abstract class Displayable {
    static final byte ALL = -1;
    static final byte NONE = 0;
    static final byte PANEL = 1;
    static final byte CLIENT = 2;
    static final byte TITLE = 4;
    static final byte TICKER = 8;
    private static final byte FULL_NO_LISTENER = 2;
    private static final byte FULL_WITH_LISTENER = 3;
    private static final byte NORMAL_NO_TIKER = 7;
    private static final byte NORMAL_WITH_TICKER = 15;
    private static final int MENU_DISTANCE = 13;
    private static final int MENU_SPIN_WIDTH = 16;
    private static final int MENU_SPIN_HEIGHT = 16;
    private static final int MENU_SPIN_MARGIN = 3;
    private static final int MENU_INNER_MARGIN = 5;
    private static final int MENU_OUTER_MARGIN = 8;
    private static final int MENU_MAXIMUM_COMMANDS = 7;
    private static final int[] COMMAND_TYPES_FOR_SOFT2;
    private static final Command[] PANEL_MENU;
    private static final Command MENU;
    private static final Command EXEC;
    private static final Command BACK;
    private static final Font MENU_FONT;
    private boolean fullScreen;
    private boolean menuOpened;
    private int menuScroll;
    private int menuIndex;
    private int focused;
    private int pressed;
    private Command[] menuCommands;
    private final Command[] panelCommands;
    private CommandListener listener;
    private Ticker ticker;
    private String title;
    private Display parent;
    final Helper helper;

    static {
        Command exec = Displayable.createScreenCommand("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 4, 0);
        Command back = Displayable.createScreenCommand("\u041d\u0430\u0437\u0430\u0434", 2, 0);
        Command menu = Displayable.createScreenCommand("\u041c\u0435\u043d\u044e", 1, 0);
        COMMAND_TYPES_FOR_SOFT2 = new int[]{2, 3, 6, 7};
        Command[] commandArray = new Command[3];
        commandArray[1] = exec;
        commandArray[2] = back;
        PANEL_MENU = commandArray;
        MENU = menu;
        EXEC = exec;
        BACK = back;
        MENU_FONT = Font.getFont(0, 0, 8);
    }

    static int getOptimalLength(int count) {
        if (count <= 0) {
            return 1;
        }
        int result = count;
        while (count > 1) {
            result |= (count >>>= 1);
        }
        return result;
    }

    static Command createDefaultCommand(String label, int type, int priority) {
        return new EmptyCommand(label, type, priority){

            public int getCommandType() {
                return 4;
            }
        };
    }

    static Command createScreenCommand(String label, int type, int priority) {
        return new EmptyCommand(label, type, priority){

            public int getCommandType() {
                return 1;
            }
        };
    }

    private static int getMenuItemsCount(int length, int height) {
        int max;
        int result = length;
        if (result > 7) {
            result = 7;
        }
        if (result > (max = (height - 23) / MENU_FONT.getHeight())) {
            result = max;
        }
        return result;
    }

    private static Command[] copy(Command[] commands) {
        int len = commands.length;
        Object[] result = new Command[len];
        Array.copy((Object[])commands, (int)0, (Object[])result, (int)0, (int)len);
        return result;
    }

    private static Command find(Command.Enumeration enumeration, int type, Command ignore) {
        Command result = null;
        int priority = Integer.MAX_VALUE;
        int i = enumeration.size();
        while (i-- > 0) {
            int p;
            Command command = enumeration.commandAt(i);
            if (command == null || command == ignore || command.type != type || (p = command.priority) > priority) continue;
            result = command;
            priority = p;
        }
        return result;
    }

    Displayable(String title, Ticker ticker, boolean fullscreen) {
        this.fullScreen = fullscreen;
        this.menuCommands = new Command[7];
        this.panelCommands = new Command[3];
        this.ticker = ticker;
        this.title = title;
        this.helper = this.createHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(Command command) {
        if (command == null) {
            throw new NullPointerException("Displayable.addCommand: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 command \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = Command.MONITOR;
        synchronized (object) {
            this.helper.addCommand(command);
        }
        this.placeCommands();
        this.requestPaintAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Command command) {
        if (command == null) {
            return;
        }
        Object object = Command.MONITOR;
        synchronized (object) {
            this.helper.removeCommand(command);
        }
        this.placeCommands();
        this.requestPaintAll();
    }

    public void setCommandListener(CommandListener listener) {
        this.listener = listener;
        this.requestPaint((byte)3);
    }

    public void setTicker(Ticker ticker) {
        this.ticker = ticker;
        this.requestPaint((byte)14);
    }

    public void setTitle(String title) {
        this.title = title;
        this.requestPaint((byte)4);
    }

    public boolean isShown() {
        return this.parent != null;
    }

    public int getWidth() {
        return this.getApplicationWidth();
    }

    public int getHeight() {
        return this.getApplicationHeight();
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public String getTitle() {
        return this.title;
    }

    protected void sizeChanged(int width, int height) {
    }

    abstract void paint(ScreenGraphics var1);

    void paintBackground(ScreenGraphics render, int width, int height, byte visibleElements, byte drawingElements) {
        int elementHeight;
        int elementTop = 0;
        if ((visibleElements & 8) != 0) {
            elementHeight = this.getTickerHeight();
            if ((drawingElements & 8) != 0) {
                render.drawElement(13, 0, 0, 0, elementTop, width, elementHeight);
            }
            elementTop += elementHeight;
        }
        if ((visibleElements & 4) != 0) {
            elementHeight = this.getTitleHeight();
            if ((drawingElements & 4) != 0) {
                render.drawElement(6, 1, 0, 0, elementTop, width, elementHeight);
            }
            elementTop += elementHeight;
        }
        if ((drawingElements = (byte)(drawingElements & 3)) == 0) {
            return;
        }
        if ((visibleElements = (byte)(visibleElements & 3)) == 3) {
            if (drawingElements == 2) {
                render.setClip(0, elementTop, width, height - elementTop - this.getPanelHeight());
            } else if (drawingElements == 1) {
                elementHeight = this.getPanelHeight();
                render.setClip(0, height - elementHeight, width, elementHeight);
            }
        }
        render.drawElement(6, 5, 0, 0, elementTop, width, height - elementTop);
    }

    void paintTicker(ScreenGraphics render, int width, int height, Ticker ticker) {
        render.setColor(RasterCanvas.getSystemColor((int)41));
        render.drawString(ticker.getDisplayedString(), ticker.getPosition(), 2, 0);
    }

    void paintTitle(ScreenGraphics render, int width, int height, String title) {
        render.setColor(RasterCanvas.getSystemColor((int)9));
        render.drawString(MultilinedStringBuilder.truncate(title, render.getFont(), width - 4), 2, 2, 0);
    }

    void paintClient(ScreenGraphics render, int width, int height, int clipLeft, int clipTop, int clipWidth, int clipHeight, Image clipBuffer) {
        int marginLeft = this.getMarginLeft();
        int marginTop = this.getMarginTop();
        int restrictedWidth = width - marginLeft - this.getMarginRight();
        int restrictedHeight = height - marginTop - this.getMarginBottom();
        render.translate(marginLeft, marginTop);
        int translatedX = render.getTranslateX();
        int translatedY = render.getTranslateY();
        render.restricts(translatedX, translatedY, restrictedWidth, restrictedHeight);
        render.setStartPoint(translatedX, translatedY);
        render.setClip(0, 0, restrictedWidth, restrictedHeight);
        if (!this.menuOpened) {
            render.clipRect(clipLeft, clipTop, clipWidth, clipHeight);
        }
        if (clipBuffer != null) {
            render.drawImage(clipBuffer, 0, 0, 0);
            return;
        }
        this.paint(render);
    }

    void paintPanel(ScreenGraphics render, int width, int height, Command[] commands, int pressedCommandIndex) {
        int p1 = width / 3;
        int p2 = width - p1;
        this.paintCommand(render, 0, 0, p1, height, commands[0], false, pressedCommandIndex == 0);
        this.paintCommand(render, p1, 0, p2 - p1, height, commands[1], true, pressedCommandIndex == 1);
        this.paintCommand(render, p2, 0, width - p2, height, commands[2], false, pressedCommandIndex == 2);
    }

    void paintCommand(ScreenGraphics render, int left, int top, int width, int height, Command command, boolean asDefault, boolean asPressed) {
        if (command == null) {
            return;
        }
        int ofs = asPressed ? 1 : (asDefault ? 3 : 0);
        int x = left + (width >> 1) + (asPressed ? 1 : 0);
        int y = top + (asDefault ? 0 : 1) + (asPressed ? 3 : 2);
        Font font = asDefault ? this.getDefaultCommandFont() : this.getNormalCommandFont();
        render.setFont(font);
        render.setColor(RasterCanvas.getSystemColor((int)(36 + ofs)));
        render.drawElement(4, ofs, 0, left, top, width, height);
        render.drawString(command.getTruncatedLabel(width - 4, font), x, y, 17);
    }

    void setFullScreenMode(boolean fullScreen) {
        this.fullScreen = fullScreen;
        this.requestPaintAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDefaultCommand(Command command) {
        Object object = Command.MONITOR;
        synchronized (object) {
            this.helper.setDefaultCommand(command);
        }
        this.placeCommands();
        this.requestPaintAll();
    }

    void onShow() {
    }

    void onHide() {
    }

    void onSizeChanged(int width, int height) {
        this.sizeChanged(width, height);
    }

    void onCommandAction(Command command) {
        if (command == null) {
            return;
        }
        if (command == MENU) {
            this.menuOpened = true;
            this.requestPaintAll();
            return;
        }
        if (command == BACK) {
            this.menuOpened = false;
            this.requestPaintAll();
            return;
        }
        CommandListener listener = this.listener;
        if (listener != null) {
            if (command == EXEC) {
                this.menuOpened = false;
                this.requestPaintAll();
                command = this.menuCommands[this.menuIndex];
                if (command != null) {
                    this.requestCommandAction(command);
                }
            } else {
                listener.commandAction(command, this);
            }
            return;
        }
        if (command == EXEC) {
            this.menuOpened = false;
            this.requestPaintAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPaint(ScreenGraphics render, byte drawingElements, int clipLeft, int clipTop, int clipWidth, int clipHeight, Image clipBuffer) {
        Font font;
        String title = this.title;
        Ticker ticker = this.ticker;
        byte visibleElements = this.fullScreen ? (this.listener == null ? (byte)2 : 3) : (ticker == null ? (byte)7 : 15);
        drawingElements = (byte)(drawingElements & visibleElements);
        if (drawingElements == 0) {
            return;
        }
        Display parent = this.parent;
        int totalWidth = parent.getWidth();
        int totalHeight = parent.getHeight();
        int tickerHeight = (visibleElements & 8) != 0 ? this.getTickerHeight() : 0;
        int titleHeight = (visibleElements & 4) != 0 ? this.getTitleHeight() : 0;
        int panelHeight = (visibleElements & 1) != 0 ? this.getPanelHeight() : 0;
        int clientHeight = totalHeight - tickerHeight - titleHeight - panelHeight;
        try {
            render.reset();
            this.paintBackground(render, totalWidth, totalHeight, visibleElements, drawingElements);
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        if ((drawingElements & 8) != 0 && ticker != null) {
            try {
                font = this.getTickerFont();
                render.reset();
                render.translate(0, 0);
                render.setClip(0, 0, totalWidth, tickerHeight);
                render.setFont(font);
                ticker.scroll(this.getTickerScroll(), totalWidth, font);
                this.paintTicker(render, totalWidth, tickerHeight, ticker);
                this.requestPaint((byte)8);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
        if ((drawingElements & 4) != 0 && title != null) {
            try {
                font = this.getTitleFont();
                render.reset();
                render.translate(0, tickerHeight);
                render.setClip(0, 0, totalWidth, titleHeight);
                render.setFont(font);
                this.paintTitle(render, totalWidth, titleHeight, title);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
        if ((drawingElements & 1) != 0) {
            try {
                Command[] commands;
                Object object = Command.MONITOR;
                synchronized (object) {
                    commands = Displayable.copy(this.panelCommands);
                }
                render.reset();
                render.translate(0, totalHeight - panelHeight);
                render.setClip(0, 0, totalWidth, panelHeight);
                this.paintPanel(render, totalWidth, panelHeight, commands, this.menuOpened ? -1 : this.pressed - 1);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
        if ((drawingElements & 2) != 0) {
            try {
                render.reset();
                render.translate(0, tickerHeight + titleHeight);
                render.setClip(0, 0, totalWidth, clientHeight);
                this.paintClient(render, totalWidth, clientHeight, clipLeft, clipTop, clipWidth, clipHeight, clipBuffer);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
    }

    boolean onKeyboardEvent(KeyboardEvent event) {
        int key = event.getKey();
        int action = event.getAction();
        DeviceSettings settings = DeviceManager.getInstance().getSettings();
        if ((this.getElements() & 1) == 0) {
            return false;
        }
        if (key == settings.getKeyUsedAs(37)) {
            block0 : switch (action) {
                case 6: {
                    if (this.pressed != 0 || this.panelCommands[0] == null) break;
                    this.pressed = 1;
                    this.requestPaint((byte)1);
                    break;
                }
                case 7: {
                    switch (this.pressed) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            this.pressed = 0;
                            this.requestPaint((byte)1);
                            this.requestCommandAction(this.panelCommands[0]);
                            break block0;
                        }
                    }
                    this.pressed = 0;
                    this.requestPaint((byte)1);
                }
            }
            return true;
        }
        if (key == settings.getKeyUsedAs(43)) {
            block8 : switch (action) {
                case 6: {
                    if (this.pressed != 0 || this.panelCommands[1] == null) break;
                    this.pressed = 2;
                    this.requestPaint((byte)1);
                    break;
                }
                case 7: {
                    switch (this.pressed) {
                        case 0: {
                            break block8;
                        }
                        case 2: {
                            this.pressed = 0;
                            this.requestPaint((byte)1);
                            this.requestCommandAction(this.panelCommands[1]);
                            break block8;
                        }
                    }
                    this.pressed = 0;
                    this.requestPaint((byte)1);
                }
            }
            return true;
        }
        if (key == settings.getKeyUsedAs(39)) {
            block16 : switch (action) {
                case 6: {
                    if (this.pressed != 0 || this.panelCommands[2] == null) break;
                    this.pressed = 3;
                    this.requestPaint((byte)1);
                    break;
                }
                case 7: {
                    switch (this.pressed) {
                        case 0: {
                            break block16;
                        }
                        case 3: {
                            this.pressed = 0;
                            this.requestPaint((byte)1);
                            this.requestCommandAction(this.panelCommands[2]);
                            break block16;
                        }
                    }
                    this.pressed = 0;
                    this.requestPaint((byte)1);
                }
            }
            return true;
        }
        return false;
    }

    boolean onPointerEvent(PointerEvent event) {
        switch (event.getAction()) {
            case 10: 
            case 14: {
                int e;
                if (event.getButton() != 0 || (e = this.getScreenFocusedElement(event.getX(), event.getY())) <= 0) break;
                this.focused = this.pressed = e;
                this.requestPaint((byte)1);
                return true;
            }
            case 9: {
                int f = this.focused;
                if (f <= 0) break;
                this.pressed = this.getScreenFocusedElement(event.getX(), event.getY()) != f ? 0 : f;
                if (this.pressed != this.pressed) {
                    this.requestPaint((byte)1);
                }
                return true;
            }
            case 11: 
            case 15: {
                Command command;
                if (event.getButton() != 0 || this.focused <= 0) break;
                int e = this.pressed;
                this.pressed = 0;
                this.focused = 0;
                if (e > 0 && e <= 3 && (this.getElements() & 1) != 0 && (command = this.panelCommands[e - 1]) != null) {
                    this.requestPaint((byte)1);
                    this.requestCommandAction(command);
                }
                return true;
            }
        }
        return false;
    }

    boolean isFullScreenMode() {
        return this.fullScreen;
    }

    float getTickerScroll() {
        return 60.0f / (float)DeviceManager.getInstance().getSettings().getMaximumFrequency();
    }

    int getCommandIndexAt(int x, int y, int panelWidth, int panelHeight) {
        if (x >= 0 && x < panelWidth && y >= 0 && y < panelHeight) {
            int p1 = panelWidth / 3;
            int p2 = panelWidth - p1;
            return x < p1 ? 0 : (x < p2 ? 1 : 2);
        }
        return -1;
    }

    int getMarginLeft() {
        return 0;
    }

    int getMarginTop() {
        return 0;
    }

    int getMarginRight() {
        return 0;
    }

    int getMarginBottom() {
        return 0;
    }

    int getTickerHeight() {
        return this.getTickerFont().getHeight() + 4;
    }

    int getTitleHeight() {
        return this.getTitleFont().getHeight() + 4;
    }

    int getPanelHeight() {
        return this.getDefaultCommandFont().getHeight() + 6;
    }

    Font getTickerFont() {
        return Font.getFont(0, 1, 8);
    }

    Font getTitleFont() {
        return Font.getFont(0, 0, 8);
    }

    Font getNormalCommandFont() {
        return Font.getFont(0, 0, 8);
    }

    Font getDefaultCommandFont() {
        return Font.getFont(0, 1, 8);
    }

    Helper createHelper() {
        return new Helper();
    }

    final void eventShow(Display parent) {
        try {
            this.onShow();
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
        this.parent = parent;
    }

    final void eventHide() {
        this.parent = null;
        try {
            this.onHide();
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    final void eventKeyboard(KeyboardEvent event) {
        try {
            if (this.menuOpened) {
                this.onKeyboardEventMenu(event);
            } else {
                this.onKeyboardEvent(event);
            }
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    final void eventPointer(PointerEvent event) {
        try {
            if (this.menuOpened) {
                this.onPointerEventMenu(event);
            } else {
                this.onPointerEvent(event);
            }
        }
        catch (RuntimeException e) {
            e.printRealStackTrace();
        }
    }

    final void eventPaint(ScreenGraphics render, byte elements, int clipLeft, int clipTop, int clipWidth, int clipHeight, Image clipBuffer) {
        block5: {
            try {
                Display parent = this.parent;
                if (this.menuOpened & this.updateMenu()) {
                    int panelHeight = this.getPanelHeight();
                    int screenWidth = parent.getWidth();
                    int screenHeight = parent.getHeight();
                    try {
                        this.onPaint(render, (byte)-1, clipLeft, clipTop, clipWidth, clipHeight, clipBuffer);
                    }
                    catch (RuntimeException e) {
                        e.printRealStackTrace();
                    }
                    render.reset();
                    render.setARGBColor(-1073741824);
                    render.fillRect(0, 0, screenWidth, screenHeight);
                    render.reset();
                    render.translate(0, screenHeight - panelHeight);
                    render.setClip(0, 0, screenWidth, panelHeight);
                    this.paintPanel(render, screenWidth, panelHeight, Displayable.copy(PANEL_MENU), this.pressed - 1);
                    render.reset();
                    render.setClip(0, 0, screenWidth, screenHeight -= panelHeight);
                    this.paintMenu(render, screenWidth, screenHeight);
                    break block5;
                }
                this.onPaint(render, elements, clipLeft, clipTop, clipWidth, clipHeight, clipBuffer);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }
    }

    final void requestAction(Runnable action) {
        Display parent;
        if (action != null && (parent = this.parent) != null) {
            parent.callSerially(action);
        }
    }

    final void requestCommandAction(final Command command) {
        this.requestAction(command == null ? null : new Runnable(){

            public void run() {
                Displayable.this.onCommandAction(command);
            }
        });
    }

    final void requestPaint(byte elements) {
        Displayable active;
        Display parent;
        if (elements != 0 && (parent = this.parent) != null && (active = parent.getActiveForeground()) != null) {
            active.helper.request(parent, elements);
        }
    }

    final void requestPaintAll() {
        Displayable active;
        Display parent = this.parent;
        if (parent != null && (active = parent.getActiveForeground()) != null) {
            active.helper.request(parent, (byte)-1);
        }
    }

    final void requestPaintClient(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
        Displayable active;
        Display parent = this.parent;
        if (parent != null && (active = parent.getActiveForeground()) != null) {
            active.helper.request(parent, (byte)2, clipLeft, clipTop, clipWidth, clipHeight, null);
        }
    }

    final void requestPaintClient(int clipLeft, int clipTop, int clipWidth, int clipHeight, Image clipBuffer) {
        Displayable active;
        Display parent = this.parent;
        if (parent != null && (active = parent.getActiveForeground()) != null) {
            active.helper.request(parent, (byte)2, clipLeft, clipTop, clipWidth, clipHeight, clipBuffer);
        }
    }

    final void servicePaint() {
        Displayable active;
        Display parent = this.parent;
        if (parent != null && (active = parent.getActiveForeground()) != null) {
            active.helper.service();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void placeCommands() {
        Object object = Command.MONITOR;
        synchronized (object) {
            Object[] c;
            int placed = 1;
            Helper list = this.helper;
            Command center = list.defaultCommand();
            if (center == null && (center = Displayable.find(list, 4, null)) != null) {
                ++placed;
            }
            Command right = null;
            int[] types = COMMAND_TYPES_FOR_SOFT2;
            int len = COMMAND_TYPES_FOR_SOFT2.length;
            int i = 0;
            while (i < len) {
                right = Displayable.find(list, types[i], center);
                if (right != null) {
                    ++placed;
                    break;
                }
                ++i;
            }
            Command left = null;
            len = list.size();
            if (len <= placed) {
                c = this.menuCommands;
                Array.fill((Object[])this.menuCommands, (int)0, (int)c.length, null);
                i = len == placed ? len : 0;
                while (i-- > 0) {
                    Command command = list.commandAt(i);
                    if (command == null || command == center || command == right) continue;
                    left = command;
                    break;
                }
            } else {
                c = this.menuCommands;
                int count = len - placed + 1;
                if (this.menuCommands.length < count) {
                    this.menuCommands = new Command[Displayable.getOptimalLength(count)];
                    c = this.menuCommands;
                }
                left = MENU;
                int i2 = 0;
                int index = 0;
                while (index < len) {
                    Command command = list.commandAt(index);
                    if (command != null && command != center && command != right) {
                        c[i2++] = command;
                    }
                    ++index;
                }
                count = i2;
                Array.fill((Object[])c, (int)count, (int)(c.length - count), null);
                int lim = count - 1;
                int i3 = 0;
                while (i3 < lim) {
                    int j = i3;
                    Object jcommand = c[j];
                    int jpriority = ((Command)jcommand).priority;
                    int k = i3 + 1;
                    while (k < count) {
                        Object kcommand = c[k];
                        int kpriority = ((Command)kcommand).priority;
                        if (kpriority < jpriority) {
                            j = k;
                            jpriority = kpriority;
                            jcommand = kcommand;
                        }
                        ++k;
                    }
                    if (i3 < j) {
                        Array.copy((Object[])c, (int)i3, (Object[])c, (int)(i3 + 1), (int)(j - i3));
                        c[i3] = jcommand;
                    }
                    ++i3;
                }
            }
            c = this.panelCommands;
            this.panelCommands[0] = left;
            c[1] = center;
            c[2] = right;
        }
    }

    final boolean isMenuOpened() {
        return this.menuOpened;
    }

    final byte getElements() {
        return this.fullScreen ? (this.listener == null ? (byte)2 : 3) : (this.ticker == null ? (byte)7 : 15);
    }

    final int getClientHeight() {
        byte elements = this.getElements();
        int result = this.getTotalHeight();
        if ((elements & 8) != 0) {
            result -= this.getTickerHeight();
        }
        if ((elements & 4) != 0) {
            result -= this.getTitleHeight();
        }
        if ((elements & 1) != 0) {
            result -= this.getPanelHeight();
        }
        return result;
    }

    final int getTotalWidth() {
        Display parent = this.parent;
        if (parent == null) {
            parent = DeviceManager.getInstance().getCurrentDisplay();
        }
        return parent.getWidth();
    }

    final int getTotalHeight() {
        Display parent = this.parent;
        if (parent == null) {
            parent = DeviceManager.getInstance().getCurrentDisplay();
        }
        return parent.getHeight();
    }

    final int getApplicationWidth() {
        return this.getTotalWidth() - this.getMarginLeft() - this.getMarginRight();
    }

    final int getApplicationHeight() {
        return this.getClientHeight() - this.getMarginTop() - this.getMarginBottom();
    }

    final Display getParentDisplay() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintMenu(Graphics render, int width, int height) {
        Object[] commands;
        Object object = Command.MONITOR;
        synchronized (object) {
            commands = Displayable.copy(this.menuCommands);
        }
        int menuIndex = this.menuIndex;
        int menuScroll = this.menuScroll;
        int menuLength = Array.findf((Object[])commands, (int)0, null);
        int itemsWidth = width - 45;
        int menuCount = Displayable.getMenuItemsCount(menuLength, height);
        int itemHeight = MENU_FONT.getHeight();
        int itemsHeight = menuCount * itemHeight;
        render.translate(8, height - itemsHeight - 23);
        height = itemsHeight + 10;
        render.setClip(0, 0, width -= 16, height);
        render.setColor(RasterCanvas.getSystemColor((int)4));
        render.fillRect(0, 0, width, height);
        render.translate(5, 5);
        render.setClip(0, 0, itemsWidth, itemsHeight);
        render.setFont(MENU_FONT);
        int itemTop = 0;
        int itemIndex = menuScroll;
        int i = menuCount;
        while (i-- > 0) {
            if (itemIndex != menuIndex) {
                render.setColor(RasterCanvas.getSystemColor((int)7));
            } else {
                render.setColor(RasterCanvas.getSystemColor((int)13));
                render.fillRect(0, itemTop, itemsWidth, itemHeight);
                render.setColor(RasterCanvas.getSystemColor((int)14));
            }
            render.drawString(((Command)commands[itemIndex]).getTruncatedLabel(itemsWidth - 4, MENU_FONT), 2, itemTop, 0);
            itemTop += itemHeight;
            ++itemIndex;
        }
        int menuPressed = this.pressed;
        render.translate(itemsWidth + 3, 0);
        render.setClip(0, 0, 16, itemsHeight);
        boolean upEnabled = menuScroll > 0;
        boolean downEnabled = menuScroll + menuCount < menuLength;
        if (upEnabled | downEnabled) {
            int menuFocused = this.focused;
            render.drawElement(14, 0, menuPressed != 4 ? (upEnabled || menuFocused == 4 ? 0 : 2) : 1, 0, itemsHeight - 32, 16, 16);
            render.drawElement(14, 1, menuPressed != 5 ? (downEnabled || menuFocused == 5 ? 0 : 2) : 1, 0, itemsHeight - 16, 16, 16);
        }
    }

    private void onKeyboardEventMenu(KeyboardEvent event) {
        boolean down;
        int key = event.getKey();
        int action = event.getAction();
        DeviceSettings settings = DeviceManager.getInstance().getSettings();
        if (action == 6 && ((down = key == settings.getKeyUsedAs(36)) || key == settings.getKeyUsedAs(38))) {
            int menuIndex = this.menuIndex;
            int menuScroll = this.menuScroll;
            int menuLength = Array.findf((Object[])this.menuCommands, (int)0, null);
            int count = Displayable.getMenuItemsCount(menuLength, this.getTotalHeight() - this.getPanelHeight());
            menuIndex = (down ? menuIndex + 1 : menuIndex + menuLength - 1) % menuLength;
            if (menuIndex < menuScroll) {
                menuScroll = menuIndex;
            }
            if (menuIndex >= menuScroll + count) {
                menuScroll = menuIndex - count + 1;
            }
            if (menuScroll + count > menuLength) {
                menuScroll = menuLength - count;
            }
            if (menuScroll < 0) {
                menuScroll = 0;
            }
            this.menuScroll = menuScroll;
            this.menuIndex = menuIndex;
            this.requestPaintAll();
            return;
        }
        if (key == settings.getKeyUsedAs(37)) {
            block0 : switch (action) {
                case 6: {
                    if (this.pressed != 0 || PANEL_MENU[0] == null) break;
                    this.pressed = 1;
                    this.requestPaint((byte)1);
                    break;
                }
                case 7: {
                    switch (this.pressed) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            this.pressed = 0;
                            this.requestPaint((byte)1);
                            this.requestCommandAction(PANEL_MENU[0]);
                            break block0;
                        }
                    }
                    this.pressed = 0;
                    this.requestPaint((byte)1);
                }
            }
            return;
        }
        if (key == settings.getKeyUsedAs(43)) {
            block8 : switch (action) {
                case 6: {
                    if (this.pressed != 0 || PANEL_MENU[1] == null) break;
                    this.pressed = 2;
                    this.requestPaint((byte)1);
                    break;
                }
                case 7: {
                    switch (this.pressed) {
                        case 0: {
                            break block8;
                        }
                        case 2: {
                            this.pressed = 0;
                            this.requestPaint((byte)1);
                            this.requestCommandAction(PANEL_MENU[1]);
                            break block8;
                        }
                    }
                    this.pressed = 0;
                    this.requestPaint((byte)1);
                }
            }
            return;
        }
        if (key == settings.getKeyUsedAs(39)) {
            block16 : switch (action) {
                case 6: {
                    if (this.pressed != 0 || PANEL_MENU[2] == null) break;
                    this.pressed = 3;
                    this.requestPaint((byte)1);
                    break;
                }
                case 7: {
                    switch (this.pressed) {
                        case 0: {
                            break block16;
                        }
                        case 3: {
                            this.pressed = 0;
                            this.requestPaint((byte)1);
                            this.requestCommandAction(PANEL_MENU[2]);
                            break block16;
                        }
                    }
                    this.pressed = 0;
                    this.requestPaint((byte)1);
                }
            }
            return;
        }
    }

    private void onPointerEventMenu(PointerEvent event) {
        block0 : switch (event.getAction()) {
            case 10: 
            case 14: {
                if (event.getButton() != 0) break;
                int e = this.getMenuFocusedElement(event.getX(), event.getY());
                if (e > 0 && e <= 5) {
                    int menuScroll = this.menuScroll;
                    int menuLength = Array.findf((Object[])this.menuCommands, (int)0, null);
                    int menuCount = this.getMenuPage(menuLength);
                    switch (e) {
                        case 4: {
                            if (menuScroll > 0) {
                                this.menuScroll = menuScroll - 1;
                                this.pressed = 4;
                                this.focused = 4;
                                this.requestPaintAll();
                                break block0;
                            }
                            this.focused = 9;
                            break block0;
                        }
                        case 5: {
                            if (menuScroll + menuCount < menuLength) {
                                this.menuScroll = menuScroll + 1;
                                this.pressed = 5;
                                this.focused = 5;
                                this.requestPaintAll();
                                break block0;
                            }
                            this.focused = 9;
                            break block0;
                        }
                    }
                    this.focused = this.pressed = e;
                    this.requestPaintAll();
                    break;
                }
                if (e == 9) {
                    this.focused = 9;
                    break;
                }
                if (e < 10) break;
                this.focused = 10;
                this.menuIndex = e - 10;
                if (this.menuIndex == this.menuIndex) break;
                this.requestPaintAll();
                break;
            }
            case 9: {
                int f = this.focused;
                if (f <= 0) break;
                int e = this.getMenuFocusedElement(event.getX(), event.getY());
                if ((f <= 0 || f > 5 || this.pressed == (this.pressed = e != f ? 0 : f)) && (f != 10 || e < 10 || (this.menuIndex = e - 10) == this.menuIndex)) break;
                this.requestPaintAll();
                break;
            }
            case 11: 
            case 15: {
                Command command;
                if (event.getButton() != 0) break;
                int e = this.pressed;
                int f = this.focused;
                this.pressed = 0;
                this.focused = 0;
                if (f == 0) {
                    this.menuOpened = false;
                    this.requestPaintAll();
                    break;
                }
                if (e > 0 && e <= 3 && (command = PANEL_MENU[e - 1]) != null) {
                    this.requestPaintAll();
                    this.requestCommandAction(command);
                    break;
                }
                this.requestPaintAll();
            }
        }
    }

    private boolean updateMenu() {
        int menuLength = Array.findf((Object[])this.menuCommands, (int)0, null);
        if (menuLength <= 0) {
            this.menuOpened = false;
            return false;
        }
        int count = this.getMenuPage(menuLength);
        int menuIndex = this.menuIndex;
        int menuScroll = this.menuScroll;
        if (menuIndex < 0) {
            menuIndex = 0;
        }
        if (menuIndex >= menuLength) {
            menuIndex = menuLength - 1;
        }
        if (menuScroll + count > menuLength) {
            menuScroll = menuLength - count;
        }
        if (menuScroll < 0) {
            menuScroll = 0;
        }
        this.menuScroll = menuScroll;
        this.menuIndex = menuIndex;
        return true;
    }

    private int getScreenFocusedElement(int x, int y) {
        int b;
        if ((this.getElements() & 1) == 0) {
            return 0;
        }
        int h = this.getPanelHeight();
        int w = this.getTotalWidth();
        int t = this.getTotalHeight() - h;
        return x >= 0 && x < w && y >= t && y < t + h && (b = this.getCommandIndexAt(x, y - t, w, h)) >= 0 && b < 3 && this.panelCommands[b] != null ? b + 1 : 0;
    }

    private int getMenuFocusedElement(int x, int y) {
        int w = this.getTotalWidth();
        int h = this.getPanelHeight();
        int t = this.getTotalHeight() - h;
        if (x >= 0 && x < w && y >= t && y < t + h) {
            int b = this.getCommandIndexAt(x, y - t, w, h);
            return b >= 0 && b < 3 && PANEL_MENU[b] != null ? b + 1 : 0;
        }
        h = t;
        int menuScroll = this.menuScroll;
        int menuLength = Array.findf((Object[])this.menuCommands, (int)0, null);
        int itemsWidth = w - 45;
        int itemHeight = MENU_FONT.getHeight();
        int itemsHeight = Displayable.getMenuItemsCount(menuLength, h) * itemHeight;
        int l = 8;
        h = itemsHeight + 10;
        if (x < l || x >= l + (w -= 16) || y < (t -= itemsHeight + 23) || y >= t + h) {
            return 0;
        }
        w = itemsWidth;
        h = itemsHeight;
        if (x >= (l += 5) && x < l + w && y >= (t += 5) && y < t + h) {
            return 10 + menuScroll + (y - t) / itemHeight;
        }
        l += w + 3;
        t += h - 32;
        w = 16;
        h = 16;
        if (x >= l && x < l + w && y >= t && y < t + h) {
            return 4;
        }
        if (x >= l && x < l + w && y >= (t += 16) && y < t + h) {
            return 5;
        }
        return 9;
    }

    private int getMenuPage(int menuLength) {
        return Displayable.getMenuItemsCount(menuLength, this.getTotalHeight() - this.getPanelHeight());
    }

    private static class EmptyCommand
    extends Command {
        public EmptyCommand(String label, int type, int priority) {
            super(label, type, priority);
        }

        public int getPriority() {
            return 0;
        }

        public String getLabel() {
            return "";
        }
    }

    class Helper
    extends Display.OneShotAction
    implements Command.Enumeration {
        private boolean paintNoUpdate;
        private byte paintElements;
        private int paintLeft;
        private int paintTop;
        private int paintWidth;
        private int paintHeight;
        private int sizeWidth;
        private int sizeHeight;
        private int commandSize;
        private Command[] commandList = new Command[7];
        private Command commandDefault;
        private Image paintBuffer;

        public int size() {
            return this.commandSize;
        }

        public Command commandAt(int index) {
            return index >= 0 && index < this.commandSize ? this.commandList[index] : null;
        }

        public Command defaultCommand() {
            return this.commandDefault;
        }

        public final synchronized void justPaint() {
            Displayable owner = Displayable.this;
            this.paintNoUpdate = true;
            this.paintElements = (byte)-1;
            this.setPaintRectangle(0, 0, owner.getApplicationWidth(), owner.getApplicationHeight());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void request(Display parent, byte elements) {
            Helper helper = this;
            synchronized (helper) {
                byte prevElements = this.paintElements;
                this.paintElements = (byte)(elements | prevElements);
                if ((elements & 2) != 0) {
                    Displayable owner = Displayable.this;
                    if ((prevElements & 2) == 0) {
                        this.setPaintRectangle(0, 0, owner.getApplicationWidth(), owner.getApplicationHeight());
                    } else {
                        this.unionPaintRectangle(0, 0, owner.getApplicationWidth(), owner.getApplicationHeight());
                    }
                }
            }
            this.request(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void request(Display parent, byte elements, int clipLeft, int clipTop, int clipWidth, int clipHeight, Image clipBuffer) {
            Helper helper = this;
            synchronized (helper) {
                byte prevElements = this.paintElements;
                this.paintElements = (byte)(elements | prevElements);
                this.paintBuffer = clipBuffer;
                if ((elements & 2) != 0) {
                    if ((prevElements & 2) == 0) {
                        this.setPaintRectangle(clipLeft, clipTop, clipWidth, clipHeight);
                    } else {
                        this.unionPaintRectangle(clipLeft, clipTop, clipWidth, clipHeight);
                    }
                }
            }
            this.request(parent);
        }

        public final void addCommand(Command command) {
            int len;
            Object[] commands;
            block5: {
                block4: {
                    if (command == null || command == this.commandDefault) break block4;
                    commands = this.commandList;
                    len = this.commandSize;
                    if (Array.findf((Object[])this.commandList, (int)0, (Object)command) >= len) break block5;
                }
                return;
            }
            if (len == commands.length) {
                Object[] objectArray = commands;
                this.commandList = new Command[(len << 1) + 1];
                commands = this.commandList;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.commandList, (int)0, (int)len);
            }
            commands[len++] = command;
            this.commandSize = len;
        }

        public final void removeCommand(Command command) {
            int len;
            if (command == null) {
                return;
            }
            if (command == this.commandDefault) {
                this.commandDefault = null;
                return;
            }
            Object[] commands = this.commandList;
            int index = Array.findf((Object[])this.commandList, (int)0, (Object)command);
            if (index > (len = this.commandSize - 1)) {
                return;
            }
            if (index < len) {
                Array.copy((Object[])commands, (int)(index + 1), (Object[])commands, (int)index, (int)(len - index));
            }
            commands[len] = null;
            this.commandSize = len;
        }

        public final void setDefaultCommand(Command command) {
            this.removeCommand(command);
            this.commandDefault = command;
        }

        protected void execute() {
            this.serviceSizeChanged();
            this.servicePaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void servicePaint() {
            Image clipBuffer;
            int clipHeight;
            int clipWidth;
            int clipTop;
            int clipLeft;
            byte elements;
            boolean update;
            Displayable owner = Displayable.this;
            Display parent = owner.getParentDisplay();
            if (parent == null) {
                return;
            }
            Helper helper = this;
            synchronized (helper) {
                update = !this.paintNoUpdate;
                elements = this.paintElements;
                clipLeft = this.paintLeft;
                clipTop = this.paintTop;
                clipWidth = this.paintWidth;
                clipHeight = this.paintHeight;
                clipBuffer = this.paintBuffer;
                this.paintNoUpdate = false;
                this.paintElements = 0;
            }
            owner.eventPaint(parent.graphics(), elements, clipLeft, clipTop, clipWidth, clipHeight, clipBuffer);
            if (update) {
                parent.update();
            }
        }

        protected final void serviceSizeChanged() {
            Displayable owner = Displayable.this;
            if (owner.getParentDisplay() == null) {
                return;
            }
            int width = owner.getApplicationWidth();
            int height = owner.getApplicationHeight();
            if (this.sizeWidth == width && this.sizeHeight == height) {
                return;
            }
            try {
                this.sizeWidth = width;
                this.sizeHeight = height;
                owner.onSizeChanged(this.sizeWidth, this.sizeHeight);
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
        }

        protected final int availableWidth() {
            return this.sizeWidth;
        }

        protected final int availableHeight() {
            return this.sizeHeight;
        }

        private void setPaintRectangle(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
            this.paintLeft = clipLeft;
            this.paintTop = clipTop;
            this.paintWidth = clipWidth;
            this.paintHeight = clipHeight;
        }

        private void unionPaintRectangle(int clipLeft, int clipTop, int clipWidth, int clipHeight) {
            int tmp;
            int left = this.paintLeft;
            int top = this.paintTop;
            int right = left + this.paintWidth;
            int bottom = top + this.paintHeight;
            if (left > clipLeft) {
                left = clipLeft;
            }
            if (top > clipTop) {
                top = clipTop;
            }
            if (right < (tmp = clipLeft + clipWidth)) {
                right = tmp;
            }
            if (bottom < (tmp = clipTop + clipHeight)) {
                bottom = tmp;
            }
            this.paintLeft = left;
            this.paintTop = top;
            this.paintWidth = right - left;
            this.paintHeight = bottom - top;
        }
    }
}

