/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.InteractiveItem;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.util.StringBuilder;

public class Gauge
extends InteractiveItem {
    public static final int INDEFINITE = -1;
    public static final int CONTINUOUS_IDLE = 0;
    public static final int INCREMENTAL_IDLE = 1;
    public static final int CONTINUOUS_RUNNING = 2;
    public static final int INCREMENTAL_UPDATING = 3;
    private static final int THUMB_HEIGHT;
    private static final int TRACK_HEIGHT;
    private static final int THUMB_WIDTH;
    private static final Font FONT;
    final boolean interactive;
    private boolean newInput;
    private boolean pressed;
    private int frame;
    private int width;
    private int height;
    private long value;
    private final char[] buffer;
    private final StringBuilder text;
    private final Object monitor;

    static {
        int s = RasterCanvas.getGUIElementSize((int)11, (int)0, (int)0);
        int i = s;
        THUMB_WIDTH = i == -1 ? 8 : (int)i;
        i = s >> 16;
        THUMB_HEIGHT = i == -1 ? 16 : i;
        i = RasterCanvas.getGUIElementSize((int)11, (int)3, (int)0) >> 16;
        TRACK_HEIGHT = i == -1 ? 8 : i;
        FONT = Font.getFont(0, 0, 8);
    }

    public Gauge(String label, boolean interactive, int maximumValue, int initialValue) {
        super(label);
        if (interactive ? maximumValue <= 0 : maximumValue != -1 && maximumValue <= 0) {
            throw new IllegalArgumentException("Gauge: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 maximumValue \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (!(interactive || maximumValue != -1 || initialValue >= 0 && initialValue <= 3)) {
            throw new IllegalArgumentException("Gauge: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 initialValue \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        if (maximumValue > 0) {
            if (initialValue < 0) {
                initialValue = 0;
            }
            if (initialValue > maximumValue) {
                initialValue = maximumValue;
            }
        }
        this.interactive = interactive;
        this.newInput = true;
        this.buffer = interactive ? new char[23] : null;
        this.text = interactive ? new StringBuilder(23) : null;
        this.monitor = new Object();
        this.setValue(initialValue, maximumValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int currentValue) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int maximumValue = (int)(this.value >> 32);
            if (maximumValue == -1 && (currentValue < 0 || currentValue > 3)) {
                error = true;
            } else {
                if (maximumValue > 0) {
                    if (currentValue < 0) {
                        currentValue = 0;
                    }
                    if (currentValue > maximumValue) {
                        currentValue = maximumValue;
                    }
                } else if (currentValue == 3) {
                    ++this.frame;
                }
                this.newInput = true;
                this.setValue(currentValue, maximumValue);
            }
        }
        if (error) {
            throw new IllegalArgumentException("Gauge.setValue: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 currentValue \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        this.requestPaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxValue(int maximumValue) {
        if (this.interactive ? maximumValue <= 0 : maximumValue != -1 && maximumValue <= 0) {
            throw new IllegalArgumentException("Gauge.setMaxValue: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 maximumValue \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        Object object = this.monitor;
        synchronized (object) {
            long fields = this.value;
            int currentValue = (int)fields;
            int maximumPrevious = (int)(fields >> 32);
            if (maximumValue > 0) {
                if (maximumPrevious == -1) {
                    currentValue = 0;
                } else if (currentValue > maximumValue) {
                    currentValue = maximumValue;
                }
            } else if (maximumPrevious > 0) {
                currentValue = 0;
            }
            this.newInput = true;
            this.setValue(currentValue, maximumValue);
        }
        this.requestPaint();
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public int getValue() {
        return (int)this.value;
    }

    public int getMaxValue() {
        return (int)(this.value >> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    strictfp void paint(Graphics render, int contentWidth, int contentHeight) {
        Object monitor;
        Object object = monitor = this.monitor;
        synchronized (monitor) {
            int nframe;
            long fields = this.value;
            int current = (int)fields;
            int maximum = (int)(fields >> 32);
            // ** MonitorExit[var8_5] (shouldn't be in output)
            if (this.interactive) {
                char[] buf = this.buffer;
                StringBuilder builder = this.text;
                this.width = contentWidth;
                this.height = contentHeight;
                int top = TRACK_HEIGHT < THUMB_HEIGHT ? THUMB_HEIGHT - TRACK_HEIGHT >> 1 : 0;
                render.drawElement(11, 3, this.focused ? 1 : 0, 1, top, contentWidth - 2, TRACK_HEIGHT);
                int left = (int)((long)(contentWidth - THUMB_WIDTH) * (long)current / (long)maximum);
                int n = top = THUMB_HEIGHT < TRACK_HEIGHT ? TRACK_HEIGHT - THUMB_HEIGHT >> 1 : 0;
                render.drawElement(11, 0, this.focused ? (this.pressed ? 1 : 3) : 0, left, top, THUMB_WIDTH, THUMB_HEIGHT);
                top = TRACK_HEIGHT < THUMB_HEIGHT ? THUMB_HEIGHT : TRACK_HEIGHT;
                if (top < contentHeight) {
                    builder.clear();
                    int len = builder.length();
                    builder.append(current).append(" / ").append(maximum).copy(0, len, buf, 0);
                    render.setFont(FONT);
                    render.setColor(RasterCanvas.getSystemColor((int)40));
                    render.drawChars(buf, 0, len, contentWidth, top, 24);
                }
                return;
            }
            if (maximum > 0) {
                int width = (int)((long)(contentWidth - 4) * (long)current / (long)maximum);
                render.drawElement(9, 0, 0, 0, 0, contentWidth, contentHeight);
                if (width > 0) {
                    render.drawElement(9, 1, 0, 2, 2, width, contentHeight - 4);
                }
                return;
            }
            switch (current) {
                default: {
                    render.drawElement(9, 0, 0, 0, 0, contentWidth, contentHeight);
                    return;
                }
                case 2: {
                    Object width = monitor;
                    synchronized (width) {
                        nframe = this.frame++;
                    }
                    this.requestPaint();
                    break;
                }
                case 3: {
                    nframe = this.frame;
                }
            }
            render.drawElement(9, 0, 0, 0, 0, contentWidth, contentHeight);
            int width = (int)(0.23606798f * (float)(contentWidth - 4));
            int half = contentWidth - width - 4 >> 1;
            int left = (int)(Math.sin(0.19634954084936207 * (double)nframe) * (double)half) + half;
            render.drawElement(9, 1, 0, left + 2, 2, width, contentHeight - 4);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onKeyboardEvent(KeyboardEvent event) {
        int digit;
        if (this.interactive && (digit = event.getCharCode() - 48) >= 0 && digit <= 9) {
            long newcurr;
            int oldcurr;
            Object object = this.monitor;
            synchronized (object) {
                long fields = this.value;
                oldcurr = (int)fields;
                int maximum = (int)(fields >> 32);
                newcurr = this.newInput ? (long)digit : 10L * (long)oldcurr + (long)digit;
                this.newInput = newcurr < 0L || newcurr > (long)maximum;
                if (this.newInput) {
                    newcurr = maximum;
                }
                this.setValue((int)newcurr, maximum);
            }
            if ((long)oldcurr != newcurr) {
                super.notifyStateChanged();
                super.requestPaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onPointerEvent(PointerEvent event) {
        if (this.interactive) {
            int x = event.getX();
            int y = event.getY();
            switch (event.getAction()) {
                case 10: 
                case 14: {
                    int newcurr;
                    int oldcurr;
                    if (event.getButton() != 0 || y < 0 || y >= (THUMB_HEIGHT < TRACK_HEIGHT ? TRACK_HEIGHT : THUMB_HEIGHT)) break;
                    Object object = this.monitor;
                    synchronized (object) {
                        long fields = this.value;
                        oldcurr = (int)fields;
                        int maximum = (int)(fields >> 32);
                        int left = (int)((long)(this.width - THUMB_WIDTH) * (long)oldcurr / (long)maximum);
                        if (x >= left + THUMB_WIDTH) {
                            newcurr = oldcurr + (maximum >= 32 ? maximum / 16 : 1);
                            if (newcurr < 0 || newcurr > maximum) {
                                newcurr = maximum;
                            }
                            this.newInput = true;
                        } else if (x < left) {
                            newcurr = oldcurr - (maximum >= 32 ? maximum / 16 : 1);
                            if (newcurr < 0) {
                                newcurr = 0;
                            }
                            this.newInput = true;
                        } else {
                            newcurr = oldcurr;
                            this.pressed = true;
                        }
                        this.setValue(newcurr, maximum);
                    }
                    if (oldcurr != newcurr) {
                        super.notifyStateChanged();
                    }
                    this.requestPaint();
                    break;
                }
                case 9: {
                    if (!this.pressed) break;
                    this.computeValue(x);
                    this.requestPaint();
                    break;
                }
                case 11: 
                case 15: {
                    if (!this.pressed) break;
                    this.pressed = false;
                    this.computeValue(x);
                    this.requestPaint();
                }
            }
        }
    }

    void onFocusLost() {
        this.pressed = false;
        super.onFocusLost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onFocusMove(int direction, int viewportWidth, int viewportHeight, int[] visibleRectangle) {
        int newcurr;
        int oldcurr;
        if (!this.interactive) {
            return false;
        }
        int w = this.width;
        visibleRectangle[0] = viewportWidth >= w ? 0 : w - viewportWidth;
        int h = this.height;
        visibleRectangle[1] = viewportHeight >= h ? 0 : h - viewportHeight;
        visibleRectangle[2] = viewportWidth >= w ? w : viewportWidth;
        int n = visibleRectangle[3] = viewportHeight >= h ? h : viewportHeight;
        if (!super.onFocusMove(direction, viewportWidth, viewportHeight, visibleRectangle)) {
            this.pressed = false;
            return true;
        }
        switch (direction) {
            default: {
                return false;
            }
            case 2: {
                Object object = this.monitor;
                synchronized (object) {
                    long fields = this.value;
                    oldcurr = (int)fields;
                    int maximum = (int)(fields >> 32);
                    newcurr = oldcurr - 1;
                    if (newcurr < 0) {
                        newcurr = 0;
                    }
                    this.newInput = true;
                    this.setValue(newcurr, maximum);
                    break;
                }
            }
            case 5: {
                Object object = this.monitor;
                synchronized (object) {
                    long fields = this.value;
                    oldcurr = (int)fields;
                    int maximum = (int)(fields >> 32);
                    newcurr = oldcurr + 1;
                    if (newcurr > maximum) {
                        newcurr = maximum;
                    }
                    this.newInput = true;
                    this.setValue(newcurr, maximum);
                    break;
                }
            }
        }
        if (oldcurr != newcurr) {
            super.notifyStateChanged();
            super.requestPaint();
        }
        return true;
    }

    boolean hasRowBreakBefore(int layout, int alignment) {
        return this.interactive || super.hasRowBreakBefore(layout, alignment);
    }

    boolean hasRowBreakAfter(int layout, int alignment) {
        return this.interactive || super.hasRowBreakAfter(layout, alignment);
    }

    int getMinimumContentWidth() {
        return 100;
    }

    int getMinimumContentHeight() {
        return this.interactive ? (TRACK_HEIGHT < THUMB_HEIGHT ? THUMB_HEIGHT : TRACK_HEIGHT) + FONT.getHeight() : 24;
    }

    private void setValue(int currentValue, int maximumValue) {
        this.value = (long)maximumValue << 32 | (long)currentValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private strictfp void computeValue(int x) {
        int newcurr;
        int oldcurr;
        Object object = this.monitor;
        synchronized (object) {
            double position;
            long fields = this.value;
            oldcurr = (int)fields;
            int maximum = (int)(fields >> 32);
            int contentWidth = this.width - THUMB_WIDTH;
            if (contentWidth <= 0) {
                contentWidth = 1;
            }
            newcurr = 0.0 > (position = (double)(x - (THUMB_WIDTH >> 1)) * (double)maximum / (double)contentWidth) ? 0 : (position > (double)maximum ? maximum : (int)position);
            this.newInput = true;
            this.setValue(newcurr, maximum);
        }
        if (oldcurr != newcurr) {
            super.notifyStateChanged();
        }
    }
}

