/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.lcdui;

import javax.microedition.lcdui.CustomSurfaceScreen;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ScrollBar;
import malik.emulator.application.KeyboardEvent;
import malik.emulator.application.PointerEvent;
import malik.emulator.media.graphics.RasterCanvas;
import malik.emulator.microedition.DeviceManager;
import malik.emulator.microedition.DeviceSettings;
import malik.emulator.microedition.lcdui.MultilinedStringBuilder;
import malik.emulator.microedition.lcdui.ScrollBarStyle;
import malik.emulator.microedition.lcdui.TextImageMenu;
import malik.emulator.util.StringBuilder;

public class ChoiceList
extends CustomSurfaceScreen
implements TextImageMenu {
    private static final int ICON_WIDTH = 32;
    private static final int ICON_HEIGHT = 32;
    private static final int MARGIN = 3;
    private static final int ELEMENT_HEIGHT = 38;
    private static final int INITIAL_SCROLL = 32;
    private int selected;
    private int scroll;
    private int count;
    private Element[] elements;
    private final Object monitor;

    public static int getBestImageWidth() {
        return 32;
    }

    public static int getBestImageHeight() {
        return 32;
    }

    public ChoiceList(String title, ScrollBarStyle style) {
        this(title, style, new String[0], null);
    }

    public ChoiceList(String title, ScrollBarStyle style, String[] elements) {
        this(title, style, elements, null);
    }

    public ChoiceList(String title, ScrollBarStyle style, String[] elements, Image[] icons) {
        super(title, elements == null ? 0 : 38 * elements.length, true, style);
        if (elements == null) {
            throw new NullPointerException("ChoiceList: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elements \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int count = elements.length;
        Object[] copyElements = new String[count];
        Array.copy((Object[])elements, (int)0, (Object[])copyElements, (int)0, (int)count);
        if (Array.findf((Object[])copyElements, (int)0, null) < count) {
            throw new NullPointerException("ChoiceList: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elements \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b, \u0440\u0430\u0432\u043d\u044b\u0435 \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (icons != null && icons.length != count) {
            throw new IllegalArgumentException("ChoiceList: \u0434\u043b\u0438\u043d\u0430 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 icons \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u043e\u0442 \u0434\u043b\u0438\u043d\u044b \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u0430 elements.");
        }
        Element[] choiceElements = new Element[count <= 15 ? 15 : StringBuilder.optimalCapacity((int)count)];
        int i = count;
        while (i-- > 0) {
            choiceElements[i] = new Element((String)copyElements[i], icons == null ? null : icons[i], null);
        }
        this.scroll = 32;
        this.count = count;
        this.elements = choiceElements;
        this.monitor = new Object();
    }

    public void insert(int elementIndex, String text) {
        if (text == null) {
            throw new NullPointerException("ChoiceList.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.insert(elementIndex, new Element(text, null, null));
    }

    public void insert(int elementIndex, String text, Image icon) {
        if (text == null) {
            throw new NullPointerException("ChoiceList.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.insert(elementIndex, new Element(text, icon, null));
    }

    public void insert(int elementIndex, String text, Image icon, Font font) {
        if (text == null) {
            throw new NullPointerException("ChoiceList.insert: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        this.insert(elementIndex, new Element(text, icon, font));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int elementIndex) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            int len;
            if (elementIndex < 0 || elementIndex > (len = this.count - 1)) {
                error = true;
            } else {
                Object[] list = this.elements;
                if (elementIndex < len) {
                    Array.copy((Object[])list, (int)(elementIndex + 1), (Object[])list, (int)elementIndex, (int)(len - elementIndex));
                }
                this.count = len;
                list[this.count] = null;
                int sel = this.selected;
                if (len > 0) {
                    if (sel == elementIndex) {
                        if (sel >= len) {
                            sel = len - 1;
                        }
                        this.selected = sel;
                        this.scroll = 32;
                    } else if (sel > elementIndex) {
                        this.selected = --sel;
                    }
                } else {
                    this.scroll = 32;
                }
                super.getScrollBar().setRange(38 * len);
                this.correctScrollBarPosition(sel);
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceList.delete: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() {
        Object object = this.monitor;
        synchronized (object) {
            Array.fill((Object[])this.elements, (int)0, (int)this.count, null);
            this.selected = 0;
            this.scroll = 32;
            this.count = 0;
            super.getScrollBar().setRange(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int elementIndex) {
        Object object = this.monitor;
        synchronized (object) {
            int lim = this.count - 1;
            if (elementIndex > lim) {
                elementIndex = lim;
            }
            if (elementIndex < 0) {
                elementIndex = 0;
            }
            this.selected = elementIndex;
            this.correctScrollBarPosition(this.selected);
            this.scroll = 32;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int elementIndex, String text) {
        if (text == null) {
            throw new NullPointerException("ChoiceList.setString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
            } else {
                this.elements[elementIndex].text = text;
                this.repaint();
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceList.setString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int elementIndex, String text, Image icon) {
        if (text == null) {
            throw new NullPointerException("ChoiceList.setString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
            } else {
                Element element = this.elements[elementIndex];
                this.elements[elementIndex].text = text;
                element.icon = icon;
                this.repaint();
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceList.setString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setString(int elementIndex, String text, Image icon, Font font) {
        if (text == null) {
            throw new NullPointerException("ChoiceList.setString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
            } else {
                Element element = this.elements[elementIndex];
                this.elements[elementIndex].text = text;
                element.icon = icon;
                element.font = font;
                this.repaint();
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceList.setString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(int elementIndex, Image icon) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
            } else {
                this.elements[elementIndex].icon = icon;
                this.repaint();
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceList.setImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(int elementIndex, Font font) {
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
            } else {
                this.elements[elementIndex].font = font;
                this.repaint();
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceList.setFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font font) {
        Object object = this.monitor;
        synchronized (object) {
            Element[] list = this.elements;
            int i = this.count;
            while (i-- > 0) {
                list[i].font = font;
            }
            this.repaint();
        }
    }

    public int append(String text) {
        if (text == null) {
            throw new NullPointerException("ChoiceList.append: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return this.append(new Element(text, null, null));
    }

    public int append(String text, Image icon) {
        if (text == null) {
            throw new NullPointerException("ChoiceList.append: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return this.append(new Element(text, icon, null));
    }

    public int append(String text, Image icon, Font font) {
        if (text == null) {
            throw new NullPointerException("ChoiceList.append: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 text \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return this.append(new Element(text, icon, font));
    }

    public int getSize() {
        return this.count;
    }

    public int getSelectedIndex() {
        return this.count <= 0 ? -1 : this.selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSelectedString() {
        String result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (this.count <= 0) {
                error = true;
                result = null;
            } else {
                result = this.elements[this.selected].text;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceList.getSelectedString: \u0441\u043f\u0438\u0441\u043e\u043a \u043f\u0443\u0441\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int elementIndex) {
        String result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].text;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceList.getString: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(int elementIndex) {
        Image result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].icon;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceList.getImage: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(int elementIndex) {
        Font result;
        boolean error = false;
        Object object = this.monitor;
        synchronized (object) {
            if (elementIndex < 0 || elementIndex >= this.count) {
                error = true;
                result = null;
            } else {
                result = this.elements[elementIndex].font;
            }
        }
        if (error) {
            throw new IndexOutOfBoundsException("ChoiceList.getFont: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 elementIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return result;
    }

    public Font getFont() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics render) {
        int width = super.getWidth();
        int clipLeft = render.getClipX();
        int clipTop = render.getClipY();
        int clipWidth = render.getClipWidth();
        int clipHeight = render.getClipHeight();
        Object object = this.monitor;
        synchronized (object) {
            int length = this.count;
            int selected = this.selected;
            Element[] elements = this.elements;
            int srow = clipTop / 38;
            int frow = (clipTop + clipHeight - 1) / 38;
            int top = srow * 38;
            int index = srow;
            while (index <= frow && index < length) {
                int left = 3;
                Element element = elements[index];
                String text = element.text;
                Image icon = element.icon;
                Font font = element.font;
                if (font == null) {
                    font = Font.getDefaultFont();
                }
                if (index == selected) {
                    int wid = font.stringWidth(text);
                    int scroll = this.scroll;
                    render.setColor(RasterCanvas.getSystemColor((int)13));
                    render.fillRect(0, top, width, 38);
                    if (icon != null) {
                        render.drawStretch(icon, left, top + 3, 32, 32, 0);
                        left += 35;
                    }
                    render.setFont(font);
                    render.setColor(RasterCanvas.getSystemColor((int)14));
                    int pos = width - left - 3;
                    render.setClip(left, top, pos, 38);
                    render.drawString(text, wid > pos ? left + scroll : left, top + (38 - font.getHeight() >> 1), 0);
                    render.setClip(clipLeft, clipTop, clipWidth, clipHeight);
                    if ((scroll -= 2) < -wid || scroll >= pos) {
                        scroll = pos - 2;
                    }
                    if (wid > pos) {
                        this.repaint();
                    }
                    this.scroll = scroll;
                } else {
                    if (icon != null) {
                        render.drawStretch(icon, left, top + 3, 32, 32, 0);
                        left += 35;
                    }
                    render.setFont(font);
                    render.setColor(RasterCanvas.getSystemColor((int)7));
                    render.drawString(MultilinedStringBuilder.truncate(text, font, width - left - 3), left, top + (38 - font.getHeight() >> 1), 0);
                }
                top += 38;
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyboardNotify(KeyboardEvent event) {
        int key = event.getKey();
        DeviceSettings settings = DeviceManager.getInstance().getSettings();
        switch (event.getAction()) {
            case 5: 
            case 6: {
                if (settings.getKeyUsedAs(38) == key) {
                    Object object = this.monitor;
                    synchronized (object) {
                        int len = this.count;
                        if (len > 0) {
                            int sel;
                            this.selected = sel = (this.selected + len - 1) % len;
                            this.correctScrollBarPosition(this.selected);
                            this.scroll = 32;
                        }
                        break;
                    }
                }
                if (settings.getKeyUsedAs(36) != key) break;
                Object object = this.monitor;
                synchronized (object) {
                    int len = this.count;
                    if (len > 0) {
                        int sel;
                        this.selected = sel = (this.selected + 1) % len;
                        this.correctScrollBarPosition(this.selected);
                        this.scroll = 32;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pointerNotify(PointerEvent event) {
        int action = event.getAction();
        if (event.isButtonPressed(0) || (action == 15 || action == 11) && event.getButton() == 0) {
            Object object = this.monitor;
            synchronized (object) {
                int index = event.getY() / 38;
                int lim = this.count - 1;
                if (index > lim) {
                    index = lim;
                }
                if (index < 0) {
                    index = 0;
                }
                this.selected = index;
                this.correctScrollBarPosition(this.selected);
                if (action != 15 && action != 11) {
                    this.scroll = 32;
                }
            }
        }
    }

    private void correctScrollBarPosition(int selected) {
        int line = 38;
        int top1 = selected * line;
        int top2 = line + top1;
        ScrollBar scroll = super.getScrollBar();
        int pos = scroll.getPosition();
        if (top1 < pos) {
            scroll.setPosition(top1);
        } else {
            int page = scroll.getPage();
            if (top2 > pos + page) {
                scroll.setPosition(top2 - page);
            } else {
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(int index, Element element) {
        Object object = this.monitor;
        synchronized (object) {
            int len = this.count;
            if (index > len) {
                index = len;
            }
            if (index < 0) {
                index = 0;
            }
            Object[] list = this.elements;
            if (len == this.elements.length) {
                Object[] objectArray = list;
                this.elements = new Element[(len << 1) + 1];
                list = this.elements;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
            }
            if (index < len) {
                Array.copy((Object[])list, (int)index, (Object[])list, (int)(index + 1), (int)(len - index));
            }
            list[index] = element;
            this.count = ++len;
            int sel = this.selected;
            if (len > 1 && sel >= index) {
                this.selected = ++sel;
            }
            super.getScrollBar().setRange(38 * len);
            this.correctScrollBarPosition(sel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int append(Element element) {
        int result;
        Object object = this.monitor;
        synchronized (object) {
            int len;
            result = len = this.count;
            Object[] list = this.elements;
            if (len == this.elements.length) {
                Object[] objectArray = list;
                this.elements = new Element[(len << 1) + 1];
                list = this.elements;
                Array.copy((Object[])objectArray, (int)0, (Object[])this.elements, (int)0, (int)len);
            }
            list[len++] = element;
            this.count = len;
            super.getScrollBar().setRange(38 * len);
        }
        return result;
    }

    private static final class Element {
        public String text;
        public Image icon;
        public Font font;

        public Element(String text, Image icon, Font font) {
            this.text = text;
            this.icon = icon;
            this.font = font;
        }
    }
}

