/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.microedition.lcdui;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.ScrollBar;
import malik.emulator.application.PointerEvent;
import malik.emulator.microedition.lcdui.ScrollBarStyle;

public class ScreenScrollBarStyle
extends ScrollBarStyle {
    private static final int TRACK_MARGIN_EDGE = 3;
    private static final int TRACK_MARGIN_ENDS = 1;
    private static final int SLIDER_MARGIN_EDGE = 2;
    private static final int SLIDER_MINIMUM_LENGTH = 7;
    private static final int[] TRACK_COLORS = new int[]{6316191, 0x7A7AAF, 9803199, 0xAFAFCF};
    private static final int[] SLIDER_MARGINS_COLORS = new int[]{0x2FFFFFF, 0x1F3F3F3, 0xE7E7E7, 0xDBDBDB, 0xCFCFCF, 0x1C3C3C3, 0x2B7B7B7};
    private boolean focused;

    public ScreenScrollBarStyle() {
        super(11);
    }

    public void horizontalScrollBarPointerEvent(ScrollBar scrollbar, PointerEvent event, int width, int height) {
        switch (event.getAction()) {
            case 10: {
                int range;
                int page = scrollbar.getPage();
                if (page <= 0 || (range = scrollbar.getRange()) <= page) break;
                int x = event.getX();
                int sl = ScrollBarStyle.getSliderLength(page, range, width, 7);
                int x1 = ScrollBarStyle.getSliderPosition(page, range, scrollbar.getPosition(), width, sl);
                int x2 = sl + x1 - 1;
                if (x < x1) {
                    scrollbar.scroll(-page);
                    break;
                }
                if (x > x2) {
                    scrollbar.scroll(page);
                    break;
                }
                this.focused = true;
                break;
            }
            case 9: 
            case 14: 
            case 15: {
                int range;
                int page = scrollbar.getPage();
                if (page <= 0 || (range = scrollbar.getRange()) <= page || !this.focused) break;
                int x = event.getX();
                int p = event.historicalX(1);
                scrollbar.scroll((int)((double)(x - p) * (double)range / (double)width));
                break;
            }
            case 11: {
                int range;
                int page = scrollbar.getPage();
                if (page > 0 && (range = scrollbar.getRange()) > page && this.focused) {
                    int x = event.getX();
                    int p = event.historicalX(1);
                    scrollbar.scroll((int)((double)(x - p) * (double)range / (double)width));
                }
                this.focused = false;
            }
        }
    }

    public void horizontalScrollBarPaintEvent(ScrollBar scrollbar, Graphics render, int width, int height) {
        int range;
        int x2 = width - 2;
        int y = 3;
        int len = TRACK_COLORS.length;
        int i = 0;
        while (i < len) {
            render.setColor(TRACK_COLORS[i]);
            render.drawLine(1, y, x2, y);
            ++y;
            ++i;
        }
        int page = scrollbar.getPage();
        if (page <= 0 || (range = scrollbar.getRange()) <= page) {
            return;
        }
        int sl = ScrollBarStyle.getSliderLength(page, range, width, 7);
        int x1 = ScrollBarStyle.getSliderPosition(page, range, scrollbar.getPosition(), width, sl);
        x2 = sl + x1 - 1;
        y = 2;
        len = SLIDER_MARGINS_COLORS.length;
        i = 0;
        while (i < len) {
            int c = SLIDER_MARGINS_COLORS[i];
            render.setColor(c);
            render.drawLine(x1 + (c >>= 24), y, x2 - c, y);
            ++y;
            ++i;
        }
    }

    public void verticalScrollBarPointerEvent(ScrollBar scrollbar, PointerEvent event, int width, int height) {
        switch (event.getAction()) {
            case 10: {
                int range;
                int page = scrollbar.getPage();
                if (page <= 0 || (range = scrollbar.getRange()) <= page) break;
                int y = event.getY();
                int sl = ScrollBarStyle.getSliderLength(page, range, height, 7);
                int y1 = ScrollBarStyle.getSliderPosition(page, range, scrollbar.getPosition(), height, sl);
                int y2 = sl + y1 - 1;
                if (y < y1) {
                    scrollbar.scroll(-page);
                    break;
                }
                if (y > y2) {
                    scrollbar.scroll(page);
                    break;
                }
                this.focused = true;
                break;
            }
            case 9: 
            case 14: 
            case 15: {
                int range;
                int page = scrollbar.getPage();
                if (page <= 0 || (range = scrollbar.getRange()) <= page || !this.focused) break;
                int y = event.getY();
                int p = event.historicalY(1);
                scrollbar.scroll((int)((double)(y - p) * (double)range / (double)height));
                break;
            }
            case 11: {
                int range;
                int page = scrollbar.getPage();
                if (page > 0 && (range = scrollbar.getRange()) > page && this.focused) {
                    int y = event.getY();
                    int p = event.historicalY(1);
                    scrollbar.scroll((int)((double)(y - p) * (double)range / (double)height));
                }
                this.focused = false;
            }
        }
    }

    public void verticalScrollBarPaintEvent(ScrollBar scrollbar, Graphics render, int width, int height) {
        int range;
        int y2 = height - 2;
        int x = 3;
        int len = TRACK_COLORS.length;
        int i = 0;
        while (i < len) {
            render.setColor(TRACK_COLORS[i]);
            render.drawLine(x, 1, x, y2);
            ++x;
            ++i;
        }
        int page = scrollbar.getPage();
        if (page <= 0 || (range = scrollbar.getRange()) <= page) {
            return;
        }
        int sl = ScrollBarStyle.getSliderLength(page, range, height, 7);
        int y1 = ScrollBarStyle.getSliderPosition(page, range, scrollbar.getPosition(), height, sl);
        y2 = sl + y1 - 1;
        x = 2;
        len = SLIDER_MARGINS_COLORS.length;
        i = 0;
        while (i < len) {
            int c = SLIDER_MARGINS_COLORS[i];
            render.setColor(c);
            render.drawLine(x, y1 + (c >>= 24), x, y2 - c);
            ++x;
            ++i;
        }
    }
}

