/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;

public abstract class Writer {
    protected Object lock;

    protected Writer() {
        this.lock = this;
    }

    protected Writer(Object lock) {
        this.lock = lock;
    }

    public abstract void close() throws IOException;

    public abstract void flush() throws IOException;

    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    public void write(int charData) throws IOException {
        this.write(new char[]{(char)charData}, 0, 1);
    }

    public void write(char[] src) throws IOException {
        this.write(src, 0, src == null ? 0 : src.length);
    }

    public void write(String string) throws IOException {
        if (string == null) {
            return;
        }
        char[] c = string.toCharArray();
        this.write(c, 0, c.length);
    }

    public void write(String string, int offset, int length) throws IOException {
        if (string == null) {
            return;
        }
        long bounds = Array.intersectBound(string.length(), offset, length);
        offset = (int)bounds;
        length = (int)(bounds >> 32);
        char[] c = new char[length];
        string.getChars(offset, offset + length, c, 0);
        this.write(c, 0, length);
    }
}

