/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import malik.emulator.util.RealValueRepresenter;

public final class Float {
    public static final float NaN = 0.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    private static final RealValueRepresenter representer = new RealValueRepresenter(7, 2);
    private final float value;

    public static boolean isNaN(float value) {
        return value != value;
    }

    public static boolean isInfinite(float value) {
        return value == Float.POSITIVE_INFINITY || value == Float.NEGATIVE_INFINITY;
    }

    public static float parseFloat(String string) throws NumberFormatException {
        return representer.parseFloat(string);
    }

    public static strictfp float intBitsToFloat(int bits) {
        return MalikSystem.getFloatAt(MalikSystem.getLocalVariableAddress(bits));
    }

    public static strictfp int floatToIntBits(float value) {
        return MalikSystem.getIntAt(MalikSystem.getLocalVariableAddress(value));
    }

    public static Float valueOf(String string) throws NumberFormatException {
        float value = representer.parseFloat(string);
        return new Float(value);
    }

    public static String toString(float value) {
        return representer.toString(value);
    }

    public Float(float value) {
        this.value = value;
    }

    public Float(double value) {
        this.value = (float)value;
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof Float && Float.floatToIntBits(this.value) == Float.floatToIntBits(((Float)anot).value);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public String toString() {
        return representer.toString(this.value);
    }

    public boolean isNaN() {
        float value = this.value;
        return value != value;
    }

    public boolean isInfinite() {
        float value = this.value;
        return value == Float.POSITIVE_INFINITY || value == Float.NEGATIVE_INFINITY;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }
}

