/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import malik.emulator.util.StringBuilder;

public final class Integer {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    private final int value;

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseInt(string, 10);
    }

    public static int parseInt(String string, int radix) throws NumberFormatException {
        int digit;
        int limit;
        boolean negative;
        int len;
        if (string == null || (len = string.length()) <= 0) {
            throw new NumberFormatException("Integer.parseInt: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
        }
        if (radix > 36) {
            throw new NumberFormatException(new StringBuilder().append("Integer.parseInt: \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0441\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f (").append(radix).append(") \u0431\u043e\u043b\u044c\u0448\u0435, \u0447\u0435\u043c Character.MAX_RADIX.").toString());
        }
        if (radix < 2) {
            throw new NumberFormatException(new StringBuilder().append("Integer.parseInt: \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0441\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f (").append(radix).append(") \u043c\u0435\u043d\u044c\u0448\u0435, \u0447\u0435\u043c Character.MIN_RADIX.").toString());
        }
        int result = 0;
        int i = 0;
        if (string.charAt(0) == '-') {
            ++i;
            negative = true;
            limit = Integer.MIN_VALUE;
        } else {
            negative = false;
            limit = -2147483647;
        }
        int mulmin = limit / radix;
        if (i < len) {
            if ((digit = Character.digit(string.charAt(i++), radix)) < 0) {
                throw new NumberFormatException("Integer.parseInt: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
            }
            result = -digit;
        }
        while (i < len) {
            if ((digit = Character.digit(string.charAt(i++), radix)) < 0 || result < mulmin || (result *= radix) < limit + digit) {
                throw new NumberFormatException("Integer.parseInt: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
            }
            result -= digit;
        }
        if (negative) {
            if (i <= 1) {
                throw new NumberFormatException("Integer.parseInt: \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0447\u0438\u0441\u043b\u0430.");
            }
            return result;
        }
        return -result;
    }

    public static Integer valueOf(String string) throws NumberFormatException {
        int value = Integer.parseInt(string, 10);
        return new Integer(value);
    }

    public static Integer valueOf(String string, int radix) throws NumberFormatException {
        int value = Integer.parseInt(string, radix);
        return new Integer(value);
    }

    public static String toString(int value) {
        return Integer.toString(value, 10);
    }

    public static String toString(int value, int radix) {
        boolean negative = value < 0;
        int i = 32;
        int len = 32 + 1;
        char[] buf = new char[len];
        if (radix > 36 || radix < 2) {
            radix = 10;
        }
        if (!negative) {
            value = -value;
        }
        int negradix = -radix;
        while (value <= negradix) {
            buf[i--] = Character.getDigitRepresentation(-(value % radix));
            value /= radix;
        }
        buf[i] = Character.getDigitRepresentation(-value);
        if (negative) {
            buf[--i] = 45;
        }
        return new String(buf, i, len - i);
    }

    public static String toBinaryString(int value) {
        return Integer.toUnsignedString(value, 1);
    }

    public static String toOctalString(int value) {
        return Integer.toUnsignedString(value, 3);
    }

    public static String toHexString(int value) {
        return Integer.toUnsignedString(value, 4);
    }

    private static String toUnsignedString(int value, int shift) {
        int i = 32;
        int len = 32;
        int mask = (1 << shift) - 1;
        char[] buf = new char[len];
        do {
            buf[--i] = Character.getDigitRepresentation(value & mask);
        } while ((value >>>= shift) != 0);
        return new String(buf, i, len - i);
    }

    public Integer(int value) {
        this.value = value;
    }

    public boolean equals(Object anot) {
        return anot == this || anot instanceof Integer && this.value == ((Integer)anot).value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value, 10);
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }
}

