/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.application;

import malik.emulator.application.InputDevice;
import malik.emulator.application.InputEvent;

public class KeyboardEvent
extends InputEvent {
    public static final int KEY_BACKSPACE = 8;
    public static final int KEY_TAB = 9;
    public static final int KEY_ENTER = 13;
    public static final int KEY_SHIFT = 16;
    public static final int KEY_CTRL = 17;
    public static final int KEY_ALT = 18;
    public static final int KEY_PAUSE_BREAK = 19;
    public static final int KEY_CAPS_LOCK = 20;
    public static final int KEY_ESCAPE = 27;
    public static final int KEY_SPACE = 32;
    public static final int KEY_PAGE_UP = 33;
    public static final int KEY_PAGE_DOWN = 34;
    public static final int KEY_END = 35;
    public static final int KEY_HOME = 36;
    public static final int KEY_LEFT = 37;
    public static final int KEY_UP = 38;
    public static final int KEY_RIGHT = 39;
    public static final int KEY_DOWN = 40;
    public static final int KEY_INSERT = 45;
    public static final int KEY_DELETE = 46;
    public static final int KEY_0 = 48;
    public static final int KEY_1 = 49;
    public static final int KEY_2 = 50;
    public static final int KEY_3 = 51;
    public static final int KEY_4 = 52;
    public static final int KEY_5 = 53;
    public static final int KEY_6 = 54;
    public static final int KEY_7 = 55;
    public static final int KEY_8 = 56;
    public static final int KEY_9 = 57;
    public static final int KEY_A = 65;
    public static final int KEY_B = 66;
    public static final int KEY_C = 67;
    public static final int KEY_D = 68;
    public static final int KEY_E = 69;
    public static final int KEY_F = 70;
    public static final int KEY_G = 71;
    public static final int KEY_H = 72;
    public static final int KEY_I = 73;
    public static final int KEY_J = 74;
    public static final int KEY_K = 75;
    public static final int KEY_L = 76;
    public static final int KEY_M = 77;
    public static final int KEY_N = 78;
    public static final int KEY_O = 79;
    public static final int KEY_P = 80;
    public static final int KEY_Q = 81;
    public static final int KEY_R = 82;
    public static final int KEY_S = 83;
    public static final int KEY_T = 84;
    public static final int KEY_U = 85;
    public static final int KEY_V = 86;
    public static final int KEY_W = 87;
    public static final int KEY_X = 88;
    public static final int KEY_Y = 89;
    public static final int KEY_Z = 90;
    public static final int KEY_CONTEXT = 93;
    public static final int KEY_NUM_0 = 96;
    public static final int KEY_NUM_1 = 97;
    public static final int KEY_NUM_2 = 98;
    public static final int KEY_NUM_3 = 99;
    public static final int KEY_NUM_4 = 100;
    public static final int KEY_NUM_5 = 101;
    public static final int KEY_NUM_6 = 102;
    public static final int KEY_NUM_7 = 103;
    public static final int KEY_NUM_8 = 104;
    public static final int KEY_NUM_9 = 105;
    public static final int KEY_NUM_STAR = 106;
    public static final int KEY_NUM_PLUS = 107;
    public static final int KEY_NUM_SEPARATOR = 108;
    public static final int KEY_NUM_MINUS = 109;
    public static final int KEY_NUM_DECIMAL = 110;
    public static final int KEY_NUM_DIVIDE = 111;
    public static final int KEY_F1 = 112;
    public static final int KEY_F2 = 113;
    public static final int KEY_F3 = 114;
    public static final int KEY_F4 = 115;
    public static final int KEY_F5 = 116;
    public static final int KEY_F6 = 117;
    public static final int KEY_F7 = 118;
    public static final int KEY_F8 = 119;
    public static final int KEY_F9 = 120;
    public static final int KEY_F10 = 121;
    public static final int KEY_F11 = 122;
    public static final int KEY_F12 = 123;
    public static final int KEY_F13 = 124;
    public static final int KEY_F14 = 125;
    public static final int KEY_F15 = 126;
    public static final int KEY_F16 = 127;
    public static final int KEY_F17 = 128;
    public static final int KEY_F18 = 129;
    public static final int KEY_F19 = 130;
    public static final int KEY_F20 = 131;
    public static final int KEY_F21 = 132;
    public static final int KEY_F22 = 133;
    public static final int KEY_F23 = 134;
    public static final int KEY_F24 = 135;
    public static final int KEY_NUM_LOCK = 144;
    public static final int KEY_SCROLL_LOCK = 145;
    public static final int KEY_LSHIFT = 160;
    public static final int KEY_RSHIFT = 161;
    public static final int KEY_LCTRL = 162;
    public static final int KEY_RCTRL = 163;
    public static final int KEY_LALT = 164;
    public static final int KEY_RALT = 165;
    public static final int KEY_SEMICOLON = 186;
    public static final int KEY_EQUAL = 187;
    public static final int KEY_COMMA = 188;
    public static final int KEY_MINUS = 189;
    public static final int KEY_PERIOD = 190;
    public static final int KEY_SLASH = 191;
    public static final int KEY_GRAVE = 192;
    public static final int KEY_LBRACKET = 219;
    public static final int KEY_BACKSLASH = 220;
    public static final int KEY_RBRACKET = 221;
    public static final int KEY_APOSTROPHE = 222;
    public static final int ACTION_KEY_PRESSED = 6;
    public static final int ACTION_KEY_REPEATED = 5;
    public static final int ACTION_KEY_RELEASED = 7;
    private static final int OFFSET_KEY = 1;
    private static final int OFFSET_CHAR = 2;
    private static final int OFFSET_SOURCE = 3;
    private static final int OFFSET_KEY_PRESSED = 4;
    private static final int OFFSET_EVENT_TIME_LO = 12;
    private static final int OFFSET_EVENT_TIME_HI = 13;
    private static final int OFFSET_VIRTUAL_DATA_LO = 14;
    private static final int OFFSET_VIRTUAL_DATA_HI = 15;
    private static final int ELEMENTS_PER_STORY = 16;
    private int base;
    private int length;
    private final int[] history;

    public KeyboardEvent() {
        this(256);
    }

    public KeyboardEvent(int historyCapacity) {
        if (historyCapacity < 2) {
            historyCapacity = 2;
        }
        if (historyCapacity > 4096) {
            historyCapacity = 4096;
        }
        this.base = (historyCapacity <<= 4) - 16;
        this.length = 16;
        this.history = new int[historyCapacity];
    }

    public int getSource() {
        return this.history[this.base + 3];
    }

    public long getEventTime() {
        int b = this.base;
        int[] h = this.history;
        return (long)h[b + 12] & 0xFFFFFFFFL | (long)h[b + 13] << 32;
    }

    public long getVirtualData() {
        int b = this.base;
        int[] h = this.history;
        return (long)h[b + 14] & 0xFFFFFFFFL | (long)h[b + 15] << 32;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStory(int action, int key, int charCode, InputDevice device, int source, long virtualData) {
        if (action != 5 && action != 6 && action != 7) {
            throw new IllegalArgumentException("KeyboardEvent.addStory: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 action \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435.");
        }
        int[] history = this.history;
        int[] nArray = this.history;
        synchronized (nArray) {
            int capacity = history.length;
            int oldBase = this.base;
            int newBase = this.base = (oldBase + capacity - 16) % capacity;
            int length = this.length;
            long time = System.currentTimeMillis();
            if (length < capacity) {
                this.length = length + 16;
            }
            Array.copy(history, oldBase + 4, history, newBase + 4, 8);
            if (key >= 0 && key <= 255) {
                int index = newBase + 4 + (key >> 5);
                int bitkey = 1 << key;
                if (action == 7) {
                    int n = index;
                    history[n] = history[n] & ~bitkey;
                } else if ((history[index] & bitkey) != 0) {
                    action = 5;
                } else {
                    action = 6;
                    int n = index;
                    history[n] = history[n] | bitkey;
                }
            }
            this.device = device;
            history[newBase] = action;
            history[newBase + 1] = key;
            history[newBase + 2] = charCode;
            history[newBase + 3] = source;
            history[newBase + 12] = (int)time;
            history[newBase + 13] = (int)(time >> 32);
            history[newBase + 14] = (int)virtualData;
            history[newBase + 15] = (int)(virtualData >> 32);
        }
    }

    public boolean historicalFromSource(int storyIndex, int source) {
        if (storyIndex < 0 || storyIndex >= this.length >> 4) {
            throw new IndexOutOfBoundsException("KeyboardEvent.historicalFromSource: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 4)) % h.length;
        return (h[b + 3] & source) == source;
    }

    public int historicalSource(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 4) {
            throw new IndexOutOfBoundsException("KeyboardEvent.historicalSource: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 4)) % h.length;
        return h[b + 3];
    }

    public long historicalEventTime(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 4) {
            throw new IndexOutOfBoundsException("KeyboardEvent.historicalEventTime: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 4)) % h.length;
        return (long)h[b + 12] & 0xFFFFFFFFL | (long)h[b + 13] << 32;
    }

    public long historicalVirtualData(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 4) {
            throw new IndexOutOfBoundsException("KeyboardEvent.historicalVirtualData: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 4)) % h.length;
        return (long)h[b + 14] & 0xFFFFFFFFL | (long)h[b + 15] << 32;
    }

    public final boolean isKeyPressed(int key) {
        return key >= 0 && key <= 255 && (this.history[this.base + 4 + (key >> 5)] & 1 << key) != 0;
    }

    public final boolean historicalKeyPressed(int storyIndex, int key) {
        if (storyIndex < 0 || storyIndex >= this.length >> 4) {
            throw new IndexOutOfBoundsException("KeyboardEvent.historicalKeyPressed: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 4)) % h.length;
        return key >= 0 && key <= 255 && (h[b + 4 + (key >> 5)] & 1 << key) != 0;
    }

    public final int historicalCharCode(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 4) {
            throw new IndexOutOfBoundsException("KeyboardEvent.historicalCharCode: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 4)) % h.length;
        return h[b + 2];
    }

    public final int historicalAction(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 4) {
            throw new IndexOutOfBoundsException("KeyboardEvent.historicalAction: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 4)) % h.length;
        return h[b];
    }

    public final int historicalKey(int storyIndex) {
        if (storyIndex < 0 || storyIndex >= this.length >> 4) {
            throw new IndexOutOfBoundsException("KeyboardEvent.historicalKey: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 storyIndex \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int[] h = this.history;
        int b = (this.base + (storyIndex << 4)) % h.length;
        return h[b + 1];
    }

    public final int historyCapacity() {
        return this.history.length >> 4;
    }

    public final int historyLength() {
        return this.length >> 4;
    }

    public final int getCharCode() {
        return this.history[this.base + 2];
    }

    public final int getAction() {
        return this.history[this.base];
    }

    public final int getKey() {
        return this.history[this.base + 1];
    }
}

