/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import malik.emulator.fileformats.ExtendedDataOutput;

public class ExtendedDataOutputStream
extends DataOutputStream
implements ExtendedDataOutput {
    public ExtendedDataOutputStream(OutputStream stream) {
        super(stream);
    }

    public final void writeCharLE(int charData) throws IOException {
        OutputStream stream = this.out;
        stream.write(charData);
        stream.write(charData >> 8);
    }

    public final void writeFloatLE(float floatData) throws IOException {
        this.writeIntLE(Float.floatToIntBits(floatData));
    }

    public final void writeDoubleLE(double doubleData) throws IOException {
        this.writeLongLE(Double.doubleToLongBits(doubleData));
    }

    public final void writeShortLE(int shortData) throws IOException {
        OutputStream stream = this.out;
        stream.write(shortData);
        stream.write(shortData >> 8);
    }

    public final void writeIntLE(int intData) throws IOException {
        OutputStream stream = this.out;
        stream.write(intData);
        stream.write(intData >> 8);
        stream.write(intData >> 16);
        stream.write(intData >> 24);
    }

    public final void writeLongLE(long longData) throws IOException {
        OutputStream stream = this.out;
        stream.write((int)longData);
        stream.write((int)(longData >> 8));
        stream.write((int)(longData >> 16));
        stream.write((int)(longData >> 24));
        stream.write((int)(longData >> 32));
        stream.write((int)(longData >> 40));
        stream.write((int)(longData >> 48));
        stream.write((int)(longData >> 56));
    }

    public final void writeCharsLE(String charsData) throws IOException {
        if (charsData == null) {
            throw new NullPointerException("ExtendedDataOutputStream.writeCharsLE: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 charsData \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        OutputStream stream = this.out;
        char[] c = charsData.toCharArray();
        int len = c.length;
        int i = 0;
        while (i < len) {
            char charData = c[i];
            stream.write(charData);
            stream.write(charData >> 8);
            ++i;
        }
    }

    public final OutputStream getDestinationStream() {
        return this.out;
    }
}

