/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.fileformats.text.mapped;

import java.io.IOException;
import java.io.InputStream;
import malik.emulator.fileformats.ExtendedDataInputStream;
import malik.emulator.fileformats.InvalidDataFormatException;
import malik.emulator.fileformats.text.mapped.CustomKeyValueList;
import malik.emulator.i18n.Helper;
import malik.emulator.util.StringBuilder;

public final class PropertiesDecoder
extends CustomKeyValueList {
    public static final String ENCODING = "ISO 8859-1";
    private String parsed;
    private final Object monitor = new Object();

    private static int skipWhiteSpace(char[] stream, int offset) {
        char c;
        int i = offset;
        while ((c = stream[i]) > '\u0000' && c <= ' ' && c != '\r' && c != '\n') {
            ++i;
        }
        return i;
    }

    private static int skipEmptySpace(char[] stream, int offset) {
        char c;
        int i = offset;
        while ((c = stream[i]) > '\u0000' && c <= ' ') {
            ++i;
        }
        return i;
    }

    private static int skipComment(char[] stream, int offset) {
        char c;
        int i = offset + 1;
        while ((c = stream[i]) > '\u0000' && c != '\r' && c != '\n') {
            ++i;
        }
        if (c > '\u0000') {
            i += c == '\r' && stream[i + 1] == '\n' ? 2 : 1;
        }
        return i;
    }

    public void loadFromInputStream(InputStream stream) throws IOException {
        this.loadFromInputStream(stream, ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFromInputStream(InputStream stream, String encoding) throws IOException {
        int size = stream.available();
        byte[] b = new byte[size + 4];
        stream.read(b, 0, size);
        char[] s = Helper.byteToCharArray(b, 0, size + 4, encoding);
        size = s.length;
        Object object = this.monitor;
        synchronized (object) {
            block10: {
                this.clear();
                try {
                    int i;
                    int n = i = size >= 1 && s[0] == '\ufeff' ? 1 : 0;
                    while (s[i = PropertiesDecoder.skipEmptySpace(s, i)] != '\u0000') {
                        char c;
                        while (true) {
                            if ((c = s[i]) != '!' && c != '#') {
                                if (i >= size) return;
                                if (s[i] != '\u0000') break;
                                break block10;
                            }
                            i = PropertiesDecoder.skipEmptySpace(s, PropertiesDecoder.skipComment(s, i));
                        }
                        c = s[i = PropertiesDecoder.skipWhiteSpace(s, this.parseKey(s, i))];
                        if (c == ':' || c == '=') {
                            i = PropertiesDecoder.skipWhiteSpace(s, i + 1);
                        }
                        String key = this.parsed.intern();
                        i = this.parseValue(s, i);
                        String value = this.parsed.intern();
                        this.set(key, value);
                    }
                }
                finally {
                    this.parsed = null;
                }
            }
            return;
        }
    }

    public void loadFromDataStream(ExtendedDataInputStream stream) throws IOException {
        this.loadFromInputStream(stream, ENCODING);
    }

    public void loadFromDataStream(ExtendedDataInputStream stream, String encoding) throws IOException {
        this.loadFromInputStream(stream, encoding);
    }

    private int parseKey(char[] stream, int offset) throws InvalidDataFormatException {
        int i = offset;
        StringBuilder result = new StringBuilder();
        while (true) {
            char c;
            if ((c = stream[i]) > ' ' && c != '\\' && c != ':' && c != '=') {
                ++i;
                continue;
            }
            if (i > offset) {
                result.append(stream, offset, i - offset);
            }
            if (c != '\\') break;
            c = stream[++i];
            switch (c) {
                default: {
                    break;
                }
                case '\r': {
                    if (stream[i + 1] == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    i = PropertiesDecoder.skipWhiteSpace(stream, i + 1);
                    break;
                }
                case 'u': {
                    ++i;
                    int u = 0;
                    int j = 4;
                    while (j-- > 0) {
                        c = stream[i];
                        if (c >= '0' && c <= '9') {
                            u = (u << 4) + (c - 48);
                        } else if (c >= 'A' && c <= 'F') {
                            u = (u << 4) + (c - 55);
                        } else {
                            if (c < 'a' || c > 'f') break;
                            u = (u << 4) + (c - 87);
                        }
                        ++i;
                    }
                    result.append((char)u);
                    break;
                }
                case '0': {
                    result.append('\u0000');
                    break;
                }
                case 'b': {
                    ++i;
                    result.append('\b');
                    break;
                }
                case 't': {
                    ++i;
                    result.append('\t');
                    break;
                }
                case 'n': {
                    ++i;
                    result.append('\n');
                    break;
                }
                case 'f': {
                    ++i;
                    result.append('\f');
                    break;
                }
                case 'r': {
                    ++i;
                    result.append('\r');
                    break;
                }
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '\'': 
                case ':': 
                case '=': 
                case '\\': {
                    ++i;
                    result.append(c);
                }
            }
            offset = ++i;
        }
        this.parsed = result.toString();
        return i;
    }

    private int parseValue(char[] stream, int offset) {
        int i = offset;
        StringBuilder result = new StringBuilder();
        while (true) {
            char c;
            if ((c = stream[i]) >= ' ' && c != '\\') {
                ++i;
                continue;
            }
            if (i > offset) {
                result.append(stream, offset, i - offset);
            }
            if (c != '\\') break;
            c = stream[++i];
            switch (c) {
                default: {
                    break;
                }
                case '\r': {
                    if (stream[i + 1] == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    i = PropertiesDecoder.skipWhiteSpace(stream, i + 1);
                    break;
                }
                case 'u': {
                    ++i;
                    int u = 0;
                    int j = 4;
                    while (j-- > 0) {
                        c = stream[i];
                        if (c >= '0' && c <= '9') {
                            u = (u << 4) + (c - 48);
                        } else if (c >= 'A' && c <= 'F') {
                            u = (u << 4) + (c - 55);
                        } else {
                            if (c < 'a' || c > 'f') break;
                            u = (u << 4) + (c - 87);
                        }
                        ++i;
                    }
                    result.append((char)u);
                    break;
                }
                case '0': {
                    result.append('\u0000');
                    break;
                }
                case 'b': {
                    ++i;
                    result.append('\b');
                    break;
                }
                case 't': {
                    ++i;
                    result.append('\t');
                    break;
                }
                case 'n': {
                    ++i;
                    result.append('\n');
                    break;
                }
                case 'f': {
                    ++i;
                    result.append('\f');
                    break;
                }
                case 'r': {
                    ++i;
                    result.append('\r');
                    break;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    ++i;
                    result.append(c);
                }
            }
            offset = ++i;
        }
        this.parsed = result.toString();
        return i;
    }
}

