/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.graphics;

import malik.emulator.media.graphics.Rectangle;
import malik.emulator.util.StringBuilder;

public final class RasterBuffer {
    public static final int MAX_SIZE = Short.MAX_VALUE;
    private final boolean opaque;
    private final int base;
    private final int hash;
    private final int scan;
    private final int size;
    private final int width;
    private final int height;
    private final int offset;
    private final int[] pixels;

    public static RasterBuffer create(int width, int height, int colorARGB, boolean opaque) {
        if (width < 1 || width > Short.MAX_VALUE) {
            throw new IllegalArgumentException("RasterBuffer.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (height < 1 || height > Short.MAX_VALUE) {
            throw new IllegalArgumentException("RasterBuffer.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int len = width * height;
        int[] pixels = new int[len];
        Array.fill(pixels, 0, len, colorARGB);
        return new RasterBuffer(pixels, 0, width, width, height, opaque);
    }

    public static RasterBuffer create(int[] pixels, int offset, int scanlength, int width, int height, boolean opaque) {
        int pixelsLength;
        int pixelsOffset;
        if (pixels == null) {
            throw new NullPointerException("RasterBuffer.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 pixels \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (scanlength < -32767 || scanlength > Short.MAX_VALUE) {
            throw new IllegalArgumentException("RasterBuffer.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 scanlength \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (width < 1 || width > Short.MAX_VALUE) {
            throw new IllegalArgumentException("RasterBuffer.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (height < 1 || height > Short.MAX_VALUE) {
            throw new IllegalArgumentException("RasterBuffer.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (scanlength >= 0) {
            pixelsOffset = offset;
            pixelsLength = width + (height - 1) * scanlength;
        } else {
            pixelsOffset = offset + (height - 1) * scanlength;
            pixelsLength = width + offset - pixelsOffset;
        }
        Array.checkBound("RasterBuffer.create", pixels.length, pixelsOffset, pixelsLength);
        return new RasterBuffer(pixels, offset, scanlength, width, height, opaque);
    }

    public static RasterBuffer create(RasterBuffer source, int left, int top, int width, int height) {
        if (source == null) {
            throw new NullPointerException("RasterBuffer.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 source \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (width < 1 || width > Short.MAX_VALUE) {
            throw new IllegalArgumentException("RasterBuffer.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 width \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (height < 1 || height > Short.MAX_VALUE) {
            throw new IllegalArgumentException("RasterBuffer.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 height \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int lim = left + width;
        int srcWidth = source.width;
        if (lim > srcWidth || lim < left || left > srcWidth || left < 0) {
            throw new IllegalArgumentException("RasterBuffer.create: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0433\u043e \u0431\u0443\u0444\u0435\u0440\u0430.");
        }
        lim = top + height;
        int srcHeight = source.height;
        if (lim > srcHeight || lim < top || top > srcHeight || top < 0) {
            throw new IllegalArgumentException("RasterBuffer.create: \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u043e\u043d \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0440\u0430\u0441\u0442\u0440\u043e\u0432\u043e\u0433\u043e \u0431\u0443\u0444\u0435\u0440\u0430.");
        }
        if (left == 0 && top == 0 && width == srcWidth && height == srcHeight) {
            return source;
        }
        int s = source.scan;
        return new RasterBuffer(source.pixels, source.offset + left + top * s, s, width, height, source.opaque);
    }

    public static RasterBuffer create(RasterBuffer source, Rectangle region) {
        if (region == null) {
            throw new NullPointerException("RasterBuffer.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 region \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return RasterBuffer.create(source, region.getLeft(), region.getTop(), region.getWidth(), region.getHeight());
    }

    private RasterBuffer(int[] pixels, int offset, int scanlength, int width, int height, boolean opaque) {
        int base;
        this.opaque = opaque;
        this.base = base = Array.getFirstElementAddress(pixels) + (offset << 2);
        this.hash = base ^ scanlength << 8 ^ width ^ height << 16;
        this.scan = scanlength;
        this.size = width | height << 16;
        this.width = width;
        this.height = height;
        this.offset = offset;
        this.pixels = pixels;
    }

    public boolean equals(Object anot) {
        block2: {
            block3: {
                if (anot == this) break block2;
                if (!(anot instanceof RasterBuffer)) break block3;
                RasterBuffer b = (RasterBuffer)anot;
                if (this.opaque == b.opaque && this.base == b.base && this.scan == b.scan && this.size == b.size) break block2;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return new StringBuilder().append(this.opaque ? "\u0420\u0430\u0441\u0442\u0440\u043e\u0432\u044b\u0439 \u0431\u0443\u0444\u0435\u0440[\u043d\u0435\u043f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u044b\u0439, \u0431\u0430\u0437\u0430=" : "\u0420\u0430\u0441\u0442\u0440\u043e\u0432\u044b\u0439 \u0431\u0443\u0444\u0435\u0440[\u043f\u043e\u043b\u0443\u043f\u0440\u043e\u0437\u0440\u0430\u0447\u043d\u044b\u0439, \u0431\u0430\u0437\u0430=").append(this.base, 16, false).append(", \u0441\u043a\u0430\u043d=").append(this.scan).append(", \u0440\u0430\u0437\u043c\u0435\u0440=").append(this.width).append("\u00d7").append(this.height).append("]").toString();
    }

    public void putPixel(int x, int y, int colorARGB) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.pixels[this.offset + x + y * this.scan] = this.opaque ? colorARGB & 0xFFFFFF : colorARGB;
        }
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public int getPixel(int x, int y) {
        if (x < 0 || x >= this.width) {
            throw new IllegalArgumentException("RasterBuffer.getPixel: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 x \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (y < 0 || y >= this.height) {
            throw new IllegalArgumentException("RasterBuffer.getPixel: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 y \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        return this.pixels[this.offset + x + y * this.scan];
    }

    public int getBase() {
        return this.base;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getScanlength() {
        return this.scan;
    }

    public int getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getPixels() {
        return this.pixels;
    }
}

