/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.graphics;

import malik.emulator.media.graphics.RasterBuffer;
import malik.emulator.util.SystemDescriptor;

class RasterBufferDescriptor
extends SystemDescriptor {
    public int base;
    public int scan;
    public int size;
    public int alpha;

    public final void assignAlpha(boolean alpha) {
        this.alpha = alpha ? 1 : 0;
    }

    public final void assignBuffer(int base, int scan, int width, int height, boolean alpha) {
        this.base = base;
        this.scan = scan;
        this.size = width & 0xFFFF | height << 16;
        this.alpha = alpha ? 1 : 0;
    }

    public final void assignBuffer(RasterBuffer buffer) {
        this.base = buffer.getBase();
        this.scan = buffer.getScanlength();
        this.size = buffer.getSize();
        this.alpha = buffer.isOpaque() ? 0 : 1;
    }

    public final void assignBuffer(RasterBuffer buffer, int left, int top, int width, int height) {
        int s = buffer.getScanlength();
        this.base = buffer.getBase() + (left + top * s << 2);
        this.scan = s;
        this.size = width & 0xFFFF | height << 16;
        this.alpha = buffer.isOpaque() ? 0 : 1;
    }
}

