/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.graphics;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import malik.emulator.fileformats.font.UnicodeRasterFont;
import malik.emulator.media.graphics.StringDrawDescriptor;
import malik.emulator.media.graphics.UninstalledFontException;
import malik.emulator.util.StringBuilder;

public final class SystemFont {
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    private static final SystemFont FIRST_SYSTEM;
    private static final SystemFont LAST_SYSTEM;
    private static final Object MONITOR;
    private boolean installed;
    private final boolean system;
    private final int style;
    private final int handle;
    private final int height;
    private final int baselineHeight;
    private final int baselinePosition;
    private final StringDrawDescriptor descriptor;
    private final String name;
    private SystemFont prev;
    private SystemFont next;

    static {
        SystemFont last = null;
        SystemFont first = null;
        int handle = SystemFont.findNextHandle(0);
        while (handle != 0) {
            SystemFont systemFont;
            SystemFont font = new SystemFont(handle, true);
            if (last != null) {
                font.prev = last;
                systemFont = font;
                last.next = last.next;
            } else {
                systemFont = font;
            }
            last = systemFont;
            handle = SystemFont.findNextHandle(handle);
        }
        FIRST_SYSTEM = first;
        LAST_SYSTEM = last;
        MONITOR = new Object();
    }

    public static Enumeration systemFonts() {
        final SystemFont last = LAST_SYSTEM;
        return new Enumerator(FIRST_SYSTEM){

            public Object nextElement() {
                SystemFont result = this.current;
                if (result == null) {
                    throw new NoSuchElementException("Enumeration.nextElement: \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c.");
                }
                this.current = result == last ? null : result.getNext();
                return result;
            }
        };
    }

    public static Enumeration installedFonts() {
        return new Enumerator(SystemFont.LAST_SYSTEM.next);
    }

    public static Enumeration availableFonts() {
        return new Enumerator(FIRST_SYSTEM);
    }

    public static SystemFont get(String fontName) {
        SystemFont font = FIRST_SYSTEM;
        while (font != null) {
            if (fontName == null ? font.name == null : fontName.equals(font.name)) {
                return font;
            }
            font = font.next;
        }
        return FIRST_SYSTEM;
    }

    public static SystemFont getDefault() {
        return FIRST_SYSTEM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SystemFont install(String fontName, String fileName) throws IOException {
        if (fileName == null) {
            throw new NullPointerException("SystemFont.install: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 fileName \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (fontName == null) {
            int pos2;
            int pos1 = fileName.lastIndexOf(47) + 1;
            fontName = pos1 <= (pos2 = fileName.lastIndexOf(46)) ? fileName.substring(pos1, pos2) : fileName.substring(pos1);
        }
        int len = fileName.length();
        char[] nameOfFile = new char[len + 1];
        fileName.getChars(0, len, nameOfFile, 0);
        len = fontName.length();
        char[] nameOfFont = new char[len + 1];
        fontName.getChars(0, len, nameOfFont, 0);
        int handle = (int)MalikSystem.syscall(Array.getFirstElementAddress(nameOfFont), Array.getFirstElementAddress(nameOfFile), 46);
        if (handle == 0) {
            throw new IOException(new StringBuilder().append("SystemFont.install: \u043e\u0448\u0438\u0431\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0448\u0440\u0438\u0444\u0442\u0430 \u0438\u0437 ").append(fileName).append('.').toString());
        }
        SystemFont result = new SystemFont(handle, false);
        Object object = MONITOR;
        synchronized (object) {
            SystemFont sfont1 = LAST_SYSTEM;
            SystemFont sfont2 = sfont1.next;
            result.prev = sfont1;
            result.next = sfont2;
            sfont1.next = result;
            if (sfont2 != null) {
                sfont2.prev = result;
            }
        }
        return result;
    }

    public static SystemFont install(String fontName, UnicodeRasterFont font) throws IOException {
        if (font == null) {
            throw new NullPointerException("SystemFont.install: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 font \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        String fileName = font.getLastFileName();
        if (fileName == null) {
            throw new IllegalStateException("SystemFont.install: \u043e\u0431\u044a\u0435\u043a\u0442 font \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0438\u043c\u0435\u043d\u0438 \u0444\u0430\u0439\u043b\u0430.");
        }
        return SystemFont.install(fontName, fileName);
    }

    static Object monitor() {
        return MONITOR;
    }

    private static int findNextHandle(int handle) {
        return (int)MalikSystem.syscall((long)handle, 40);
    }

    private SystemFont(int handle, boolean system) {
        int b;
        int h;
        int s = (int)MalikSystem.syscall((long)handle, 42);
        char[] name = new char[(int)MalikSystem.syscall(handle, 0, 41)];
        MalikSystem.syscall(handle, Array.getFirstElementAddress(name), 41);
        this.installed = true;
        this.system = system;
        this.style = s & 3;
        this.handle = handle;
        this.height = h = s >> 8 & 0xFF;
        this.baselineHeight = b = s >> 16 & 0xFF;
        this.baselinePosition = h - b;
        this.descriptor = new StringDrawDescriptor();
        this.name = new String(name);
    }

    public String toString() {
        int s = this.style;
        return new StringBuilder().append("\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0439 \u0448\u0440\u0438\u0444\u0442[\"").append(this.name).append("\", \u0440\u0430\u0437\u043c\u0435\u0440=").append(this.height).append((s & 1) != 0 ? ", \u0436\u0438\u0440\u043d\u044b\u0439" : "").append((s & 2) != 0 ? ", \u043a\u0443\u0440\u0441\u0438\u0432" : "").append("]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        if (this.system) {
            throw new IllegalStateException("SystemFont.uninstall: \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0439 \u0448\u0440\u0438\u0444\u0442.");
        }
        Object object = MONITOR;
        synchronized (object) {
            if (this.installed) {
                MalikSystem.syscall((long)this.handle, 47);
                this.installed = false;
                SystemFont sfont1 = this.prev;
                SystemFont sfont2 = this.next;
                this.next = null;
                this.prev = null;
                sfont1.next = sfont2;
                if (sfont2 != null) {
                    sfont2.prev = sfont1;
                }
            }
        }
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public boolean isSystem() {
        return this.system;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean characterSupported(int charCode) {
        boolean result;
        if (this.system) {
            return (int)MalikSystem.syscall(this.handle, charCode, 43) != 0;
        }
        boolean error = false;
        Object object = MONITOR;
        synchronized (object) {
            if (!this.installed) {
                error = true;
                result = false;
            } else {
                result = (int)MalikSystem.syscall(this.handle, charCode, 43) != 0;
            }
        }
        if (error) {
            throw new UninstalledFontException("SystemFont.characterSupported: \u044d\u0442\u043e\u0442 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int characterWidth(int charCode) {
        int result;
        if (this.system) {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(false, MalikSystem.getLocalVariableAddress(charCode), 1, this.handle);
            int result2 = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
            return result2;
        }
        boolean error = false;
        Object object = MONITOR;
        // MONITORENTER : object
        if (!this.installed) {
            error = true;
            result = 0;
        } else {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(false, MalikSystem.getLocalVariableAddress(charCode), 1, this.handle);
            result = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
        }
        // MONITOREXIT : object
        if (!error) return result;
        throw new UninstalledFontException("SystemFont.characterWidth: \u044d\u0442\u043e\u0442 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int charactersWidth(char[] src) {
        int result;
        if (src == null) {
            throw new NullPointerException("SystemFont.charactersWidth: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (this.system) {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(true, Array.getFirstElementAddress(src), src.length, this.handle);
            int result2 = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
            return result2;
        }
        boolean error = false;
        Object object = MONITOR;
        // MONITORENTER : object
        if (!this.installed) {
            error = true;
            result = 0;
        } else {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(true, Array.getFirstElementAddress(src), src.length, this.handle);
            result = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
        }
        // MONITOREXIT : object
        if (!error) return result;
        throw new UninstalledFontException("SystemFont.charactersWidth: \u044d\u0442\u043e\u0442 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int charactersWidth(char[] src, int offset, int length) {
        int result;
        if (src == null) {
            throw new NullPointerException("SystemFont.charactersWidth: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("SystemFont.charactersWidth", src.length, offset, length);
        if (this.system) {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(true, Array.getFirstElementAddress(src) + (offset << 1), length, this.handle);
            int result2 = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
            return result2;
        }
        boolean error = false;
        Object object = MONITOR;
        // MONITORENTER : object
        if (!this.installed) {
            error = true;
            result = 0;
        } else {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(true, Array.getFirstElementAddress(src) + (offset << 1), length, this.handle);
            result = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
        }
        // MONITOREXIT : object
        if (!error) return result;
        throw new UninstalledFontException("SystemFont.charactersWidth: \u044d\u0442\u043e\u0442 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int charactersWidth(int[] src) {
        int result;
        if (src == null) {
            throw new NullPointerException("SystemFont.charactersWidth: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (this.system) {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(false, Array.getFirstElementAddress(src), src.length, this.handle);
            int result2 = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
            return result2;
        }
        boolean error = false;
        Object object = MONITOR;
        // MONITORENTER : object
        if (!this.installed) {
            error = true;
            result = 0;
        } else {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(false, Array.getFirstElementAddress(src), src.length, this.handle);
            result = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
        }
        // MONITOREXIT : object
        if (!error) return result;
        throw new UninstalledFontException("SystemFont.charactersWidth: \u044d\u0442\u043e\u0442 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int charactersWidth(int[] src, int offset, int length) {
        int result;
        if (src == null) {
            throw new NullPointerException("SystemFont.charactersWidth: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("SystemFont.charactersWidth", src.length, offset, length);
        if (this.system) {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(false, Array.getFirstElementAddress(src) + (offset << 2), length, this.handle);
            int result2 = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
            return result2;
        }
        boolean error = false;
        Object object = MONITOR;
        // MONITORENTER : object
        if (!this.installed) {
            error = true;
            result = 0;
        } else {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(false, Array.getFirstElementAddress(src) + (offset << 2), length, this.handle);
            result = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
        }
        // MONITOREXIT : object
        if (!error) return result;
        throw new UninstalledFontException("SystemFont.charactersWidth: \u044d\u0442\u043e\u0442 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int stringWidth(String string) {
        int result;
        if (string == null) {
            throw new NullPointerException("SystemFont.stringWidth: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 string \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (this.system) {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(true, Array.getFirstElementAddress(string), string.length(), this.handle);
            int result2 = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
            return result2;
        }
        boolean error = false;
        Object object = MONITOR;
        // MONITORENTER : object
        if (!this.installed) {
            error = true;
            result = 0;
        } else {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(true, Array.getFirstElementAddress(string), string.length(), this.handle);
            result = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
        }
        // MONITOREXIT : object
        if (!error) return result;
        throw new UninstalledFontException("SystemFont.stringWidth: \u044d\u0442\u043e\u0442 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int substringWidth(String string, int offset, int length) {
        int result;
        if (string == null) {
            throw new NullPointerException("SystemFont.substringWidth: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 string \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        String.checkBound("SystemFont.substringWidth", string.length(), offset, length);
        if (this.system) {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(true, Array.getFirstElementAddress(string) + (offset << 1), length, this.handle);
            int result2 = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
            return result2;
        }
        boolean error = false;
        Object object = MONITOR;
        // MONITORENTER : object
        if (!this.installed) {
            error = true;
            result = 0;
        } else {
            StringDrawDescriptor d;
            StringDrawDescriptor stringDrawDescriptor = d = this.descriptor;
            // MONITORENTER : d
            d.assignString(true, Array.getFirstElementAddress(string) + (offset << 1), length, this.handle);
            result = (int)MalikSystem.syscall((long)d.getDescriptorAddress(), 44);
            // MONITOREXIT : stringDrawDescriptor
        }
        // MONITOREXIT : object
        if (!error) return result;
        throw new UninstalledFontException("SystemFont.substringWidth: \u044d\u0442\u043e\u0442 \u0448\u0440\u0438\u0444\u0442 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d \u0438\u0437 \u0441\u0438\u0441\u0442\u0435\u043c\u044b.");
    }

    public int getHeight() {
        return this.height;
    }

    public int getBaselineHeight() {
        return this.baselineHeight;
    }

    public int getBaselinePosition() {
        return this.baselinePosition;
    }

    public int getStyle() {
        return this.style;
    }

    public String getName() {
        return this.name;
    }

    int getHandle() {
        return this.handle;
    }

    SystemFont getNext() {
        return this.next;
    }

    private static class Enumerator
    implements Enumeration {
        public SystemFont current;

        public Enumerator(SystemFont first) {
            this.current = first;
        }

        public boolean hasMoreElements() {
            return this.current != null;
        }

        public Object nextElement() {
            SystemFont result = this.current;
            if (result == null) {
                throw new NoSuchElementException("Enumeration.nextElement: \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c.");
            }
            this.current = result.getNext();
            return result;
        }
    }
}

