/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.media.sound;

import malik.emulator.application.MIDIPlayerListener;
import malik.emulator.application.Run;
import malik.emulator.media.sound.SoundPlayer;
import malik.emulator.media.sound.SoundPlayerException;
import malik.emulator.media.sound.SoundPlayerListener;
import malik.emulator.util.DataDescriptor;

public final class SyntheticSoundPlayer
extends SoundPlayer {
    int handle;
    private final DataDescriptor descriptor;

    public static SyntheticSoundPlayer open() throws SoundPlayerException {
        int handle = (int)MalikSystem.syscall(0L, 56);
        if (handle == 0) {
            throw new SoundPlayerException("SyntheticSoundPlayer.open: \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u043d\u0435 \u0445\u0432\u0430\u0442\u0430\u0435\u0442 \u043f\u0430\u043c\u044f\u0442\u0438 \u043d\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0433\u043e \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044f \u0438\u043b\u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442 \u0446\u0438\u0444\u0440\u043e\u0432\u043e\u0439 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u043c\u0443\u0437\u044b\u043a\u0430\u043b\u044c\u043d\u044b\u0445 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u043e\u0432.");
        }
        return new SyntheticSoundPlayer(handle);
    }

    private SyntheticSoundPlayer(int handle) {
        this.handle = handle;
        this.descriptor = new DataDescriptor();
        Run.instance.setMIDIPlayerListener(handle, new MIDIPlayerListener(){

            public void endOfTrack(int playerHandle) {
                SoundPlayerListener listener;
                SyntheticSoundPlayer parent = SyntheticSoundPlayer.this;
                if (playerHandle == parent.handle && (listener = parent.listener) != null) {
                    listener.endOfBlock(parent, -1);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h != 0) {
                this.handle = 0;
                this.listener = null;
                MalikSystem.syscall((long)h, 63);
                Run.instance.setMIDIPlayerListener(h, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadBlock(long[] midiMessages, int offset, int length) throws SoundPlayerException {
        DataDescriptor d;
        if (midiMessages == null) {
            throw new NullPointerException("SyntheticSoundPlayer.loadBlock: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 midiMessages \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("SyntheticSoundPlayer.loadBlock", midiMessages.length, offset, length);
        if (length <= 0) {
            return 0;
        }
        boolean error = false;
        DataDescriptor dataDescriptor = d = this.descriptor;
        synchronized (d) {
            int result;
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                d.setDataInfo(Array.getFirstElementAddress(midiMessages) + (offset << 3), length);
                result = (int)MalikSystem.syscall(h, d.getDescriptorAddress(), 57);
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            if (error) {
                throw new SoundPlayerException("SyntheticSoundPlayer.loadBlock: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reset() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, 0, 58);
            }
        }
        if (error) {
            throw new SoundPlayerException("SyntheticSoundPlayer.reset: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, 1, 58);
            }
        }
        if (error) {
            throw new SoundPlayerException("SyntheticSoundPlayer.start: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stop() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, 2, 58);
            }
        }
        if (error) {
            throw new SoundPlayerException("SyntheticSoundPlayer.stop: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setVolume(int volume) throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, super.setVolume(volume), 62);
            }
        }
        if (error) {
            throw new SoundPlayerException("SyntheticSoundPlayer.setVolume: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCurrentBlockPosition(int position) throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, position, 60);
            }
        }
        if (error) {
            throw new SoundPlayerException("SyntheticSoundPlayer.setCurrentBlockPosition: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall((long)h, 59);
            }
        }
        if (error) {
            throw new SoundPlayerException("SyntheticSoundPlayer.getState: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVolume() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, -1, 62);
            }
        }
        if (error) {
            throw new SoundPlayerException("SyntheticSoundPlayer.getVolume: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    public int getCurrentBlockIndex() throws SoundPlayerException {
        if (this.handle == 0) {
            throw new SoundPlayerException("SyntheticSoundPlayer.getCurrentBlockIndex: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentBlockPosition() throws SoundPlayerException {
        int result;
        boolean error = false;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            int h = this.handle;
            if (h == 0) {
                error = true;
                result = 0;
            } else {
                result = (int)MalikSystem.syscall(h, 0, 61);
            }
        }
        if (error) {
            throw new SoundPlayerException("SyntheticSoundPlayer.getCurrentBlockPosition: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(int midiMessage) throws SoundPlayerException {
        DataDescriptor d;
        boolean error = false;
        DataDescriptor dataDescriptor = d = this.descriptor;
        synchronized (d) {
            int h = this.handle;
            if (h == 0) {
                error = true;
            } else {
                d.setDataInfo(midiMessage & 0xFFFFFF, 0);
                MalikSystem.syscall(h, d.getDescriptorAddress(), 57);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (error) {
                throw new SoundPlayerException("SyntheticSoundPlayer.sendMessage: \u043f\u0440\u043e\u0438\u0433\u0440\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            return;
        }
    }
}

