/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.util;

import malik.emulator.util.Queue;

public class RunnableQueue
extends Queue {
    protected Runnable[] runnables;

    public RunnableQueue() {
        this(16);
    }

    public RunnableQueue(int initialCapacity) {
        super(initialCapacity);
        initialCapacity = this.capacity;
        this.runnables = new Runnable[initialCapacity];
    }

    public void clear() {
        Runnable[] q = this.runnables;
        int c = this.capacity;
        int t = this.tail;
        int i = this.head;
        while (i != t) {
            q[i] = null;
            i = this.nextIndex(i, c);
        }
        super.clear();
    }

    public void removeHeadElement() {
        int h = this.head;
        if (h != this.tail) {
            this.runnables[h] = null;
            this.advanceHead(h);
        }
    }

    public void addTailElement(Runnable runnableElement) {
        Object[] q = this.runnables;
        if (this.freeElements() == 0) {
            int c = (this.capacity << 1) - 1;
            this.runnables = (Runnable[])this.expand(q, c);
            q = this.runnables;
            this.reset(c);
        }
        int t = this.tail;
        q[t] = runnableElement;
        this.advanceTail(t);
    }

    public final Runnable peekHeadRunnable() {
        return this.runnables[this.head];
    }
}

