/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends OutputStream
implements DataOutput {
    protected OutputStream out;

    public static int writeUTF(DataOutput stream, String src) throws IOException {
        char c1;
        if (stream == null) {
            throw new NullPointerException("DataOutputStream.writeUTF: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 stream \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (src == null) {
            throw new NullPointerException("DataOutputStream.writeUTF: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int strlen = src.length();
        char[] c = new char[strlen];
        src.getChars(0, strlen, c, 0);
        int length = 0;
        int i = strlen;
        while (i-- > 0) {
            c1 = c[i];
            length += c1 >= '\u0001' && c1 < '\u0080' ? 1 : (c1 < '\u0800' ? 2 : 3);
        }
        if (length >= 65536) {
            throw new UTFDataFormatException("DataOutputStream.writeUTF: \u0440\u0430\u0437\u043c\u0435\u0440 \u0434\u0430\u043d\u043d\u044b\u0445, \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u043e\u0439 UTF-8, \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c 64 \u041a\u0411.");
        }
        byte[] result = new byte[length];
        length = 0;
        i = 0;
        while (i < strlen) {
            c1 = c[i];
            if (c1 >= '\u0001' && c1 < '\u0080') {
                result[length++] = (byte)c1;
            } else if (c1 < '\u0800') {
                result[length++] = (byte)(0xC0 | c1 >> 6 & 0x1F);
                result[length++] = (byte)(0x80 | c1 & 0x3F);
            } else {
                result[length++] = (byte)(0xE0 | c1 >> 12 & 0xF);
                result[length++] = (byte)(0x80 | c1 >> 6 & 0x3F);
                result[length++] = (byte)(0x80 | c1 & 0x3F);
            }
            ++i;
        }
        stream.writeShort(length);
        stream.write(result, 0, length);
        return length + 2;
    }

    public DataOutputStream(OutputStream stream) {
        this.out = stream;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int src) throws IOException {
        this.out.write(src);
    }

    public void write(byte[] src) throws IOException {
        this.out.write(src);
    }

    public void write(byte[] src, int offset, int length) throws IOException {
        this.out.write(src, offset, length);
    }

    public final void writeBoolean(boolean src) throws IOException {
        this.writeByte(src ? 1 : 0);
    }

    public final void writeChar(int src) throws IOException {
        this.writeShort(src);
    }

    public final void writeFloat(float src) throws IOException {
        this.writeInt(Float.floatToIntBits(src));
    }

    public final void writeDouble(double src) throws IOException {
        this.writeLong(Double.doubleToLongBits(src));
    }

    public final void writeByte(int src) throws IOException {
        this.write(src);
    }

    public final void writeShort(int src) throws IOException {
        this.write(src >> 8);
        this.write(src);
    }

    public final void writeInt(int src) throws IOException {
        this.write(src >> 24);
        this.write(src >> 16);
        this.write(src >> 8);
        this.write(src);
    }

    public final void writeLong(long src) throws IOException {
        this.write((int)(src >> 56));
        this.write((int)(src >> 48));
        this.write((int)(src >> 40));
        this.write((int)(src >> 32));
        this.write((int)(src >> 24));
        this.write((int)(src >> 16));
        this.write((int)(src >> 8));
        this.write((int)src);
    }

    public final void writeUTF(String src) throws IOException {
        DataOutputStream.writeUTF(this, src);
    }

    public final void writeChars(String src) throws IOException {
        if (src == null) {
            throw new NullPointerException("DataOutputStream.writeChars: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int len = src.length();
        int i = 0;
        while (i < len) {
            this.writeShort(src.charAt(i));
            ++i;
        }
    }
}

