/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import malik.emulator.util.StringBuilder;

public final class Array {
    public static void copy(boolean[] src, int srcOffset, boolean[] dst, int dstOffset, int length) {
        int edi;
        if (length <= 0) {
            return;
        }
        if (src == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (dst == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLimit = srcOffset + length;
        int len = src.length;
        if (srcLimit > len || srcLimit < srcOffset || srcOffset > len || srcOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int dstLimit = dstOffset + length;
        len = dst.length;
        if (dstLimit > len || dstLimit < dstOffset || dstOffset > len || dstOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int esi = Array.getFirstElementAddress(src) + srcOffset;
        if (esi < (edi = Array.getFirstElementAddress(dst) + dstOffset)) {
            MalikSystem.arraycopyb_byte(src, srcLimit, dst, dstLimit, length);
            return;
        }
        MalikSystem.arraycopyf_byte(src, srcOffset, dst, dstOffset, length);
    }

    public static void copy(char[] src, int srcOffset, char[] dst, int dstOffset, int length) {
        int edi;
        if (length <= 0) {
            return;
        }
        if (src == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (dst == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLimit = srcOffset + length;
        int len = src.length;
        if (srcLimit > len || srcLimit < srcOffset || srcOffset > len || srcOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int dstLimit = dstOffset + length;
        len = dst.length;
        if (dstLimit > len || dstLimit < dstOffset || dstOffset > len || dstOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int esi = Array.getFirstElementAddress(src) + (srcOffset << 1);
        if (esi < (edi = Array.getFirstElementAddress(dst) + (dstOffset << 1))) {
            MalikSystem.arraycopyb_short(src, srcLimit, dst, dstLimit, length);
            return;
        }
        MalikSystem.arraycopyf_short(src, srcOffset, dst, dstOffset, length);
    }

    public static void copy(float[] src, int srcOffset, float[] dst, int dstOffset, int length) {
        int edi;
        if (length <= 0) {
            return;
        }
        if (src == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (dst == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLimit = srcOffset + length;
        int len = src.length;
        if (srcLimit > len || srcLimit < srcOffset || srcOffset > len || srcOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int dstLimit = dstOffset + length;
        len = dst.length;
        if (dstLimit > len || dstLimit < dstOffset || dstOffset > len || dstOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int esi = Array.getFirstElementAddress(src) + (srcOffset << 2);
        if (esi < (edi = Array.getFirstElementAddress(dst) + (dstOffset << 2))) {
            MalikSystem.arraycopyb_int(src, srcLimit, dst, dstLimit, length);
            return;
        }
        MalikSystem.arraycopyf_int(src, srcOffset, dst, dstOffset, length);
    }

    public static void copy(double[] src, int srcOffset, double[] dst, int dstOffset, int length) {
        int edi;
        if (length <= 0) {
            return;
        }
        if (src == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (dst == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLimit = srcOffset + length;
        int len = src.length;
        if (srcLimit > len || srcLimit < srcOffset || srcOffset > len || srcOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int dstLimit = dstOffset + length;
        len = dst.length;
        if (dstLimit > len || dstLimit < dstOffset || dstOffset > len || dstOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int esi = Array.getFirstElementAddress(src) + (srcOffset << 3);
        if (esi < (edi = Array.getFirstElementAddress(dst) + (dstOffset << 3))) {
            MalikSystem.arraycopyb_long(src, srcLimit, dst, dstLimit, length);
            return;
        }
        MalikSystem.arraycopyf_long(src, srcOffset, dst, dstOffset, length);
    }

    public static void copy(byte[] src, int srcOffset, byte[] dst, int dstOffset, int length) {
        int edi;
        if (length <= 0) {
            return;
        }
        if (src == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (dst == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLimit = srcOffset + length;
        int len = src.length;
        if (srcLimit > len || srcLimit < srcOffset || srcOffset > len || srcOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int dstLimit = dstOffset + length;
        len = dst.length;
        if (dstLimit > len || dstLimit < dstOffset || dstOffset > len || dstOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int esi = Array.getFirstElementAddress(src) + srcOffset;
        if (esi < (edi = Array.getFirstElementAddress(dst) + dstOffset)) {
            MalikSystem.arraycopyb_byte(src, srcLimit, dst, dstLimit, length);
            return;
        }
        MalikSystem.arraycopyf_byte(src, srcOffset, dst, dstOffset, length);
    }

    public static void copy(short[] src, int srcOffset, short[] dst, int dstOffset, int length) {
        int edi;
        if (length <= 0) {
            return;
        }
        if (src == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (dst == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLimit = srcOffset + length;
        int len = src.length;
        if (srcLimit > len || srcLimit < srcOffset || srcOffset > len || srcOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int dstLimit = dstOffset + length;
        len = dst.length;
        if (dstLimit > len || dstLimit < dstOffset || dstOffset > len || dstOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int esi = Array.getFirstElementAddress(src) + (srcOffset << 1);
        if (esi < (edi = Array.getFirstElementAddress(dst) + (dstOffset << 1))) {
            MalikSystem.arraycopyb_short(src, srcLimit, dst, dstLimit, length);
            return;
        }
        MalikSystem.arraycopyf_short(src, srcOffset, dst, dstOffset, length);
    }

    public static void copy(int[] src, int srcOffset, int[] dst, int dstOffset, int length) {
        int edi;
        if (length <= 0) {
            return;
        }
        if (src == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (dst == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLimit = srcOffset + length;
        int len = src.length;
        if (srcLimit > len || srcLimit < srcOffset || srcOffset > len || srcOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int dstLimit = dstOffset + length;
        len = dst.length;
        if (dstLimit > len || dstLimit < dstOffset || dstOffset > len || dstOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int esi = Array.getFirstElementAddress(src) + (srcOffset << 2);
        if (esi < (edi = Array.getFirstElementAddress(dst) + (dstOffset << 2))) {
            MalikSystem.arraycopyb_int(src, srcLimit, dst, dstLimit, length);
            return;
        }
        MalikSystem.arraycopyf_int(src, srcOffset, dst, dstOffset, length);
    }

    public static void copy(long[] src, int srcOffset, long[] dst, int dstOffset, int length) {
        int edi;
        if (length <= 0) {
            return;
        }
        if (src == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (dst == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLimit = srcOffset + length;
        int len = src.length;
        if (srcLimit > len || srcLimit < srcOffset || srcOffset > len || srcOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int dstLimit = dstOffset + length;
        len = dst.length;
        if (dstLimit > len || dstLimit < dstOffset || dstOffset > len || dstOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int esi = Array.getFirstElementAddress(src) + (srcOffset << 3);
        if (esi < (edi = Array.getFirstElementAddress(dst) + (dstOffset << 3))) {
            MalikSystem.arraycopyb_long(src, srcLimit, dst, dstLimit, length);
            return;
        }
        MalikSystem.arraycopyf_long(src, srcOffset, dst, dstOffset, length);
    }

    public static void copy(Object[] src, int srcOffset, Object[] dst, int dstOffset, int length) {
        int edi;
        if (length <= 0) {
            return;
        }
        if (src == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (dst == null) {
            throw new NullPointerException("Array.copy: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int srcLimit = srcOffset + length;
        int len = src.length;
        if (srcLimit > len || srcLimit < srcOffset || srcOffset > len || srcOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int dstLimit = dstOffset + length;
        len = dst.length;
        if (dstLimit > len || dstLimit < dstOffset || dstOffset > len || dstOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copy: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        Class dstType = dst.getClass().componentType;
        Class srcType = src.getClass().componentType;
        if (!dstType.isAssignableFrom(srcType)) {
            throw new ArrayStoreException("Array.copy", dstType, srcType, false);
        }
        int esi = Array.getFirstElementAddress(src) + (srcOffset << 2);
        if (esi < (edi = Array.getFirstElementAddress(dst) + (dstOffset << 2))) {
            MalikSystem.arraycopyb_object(src, srcLimit, dst, dstLimit, length);
            return;
        }
        MalikSystem.arraycopyf_object(src, srcOffset, dst, dstOffset, length);
    }

    public static void copyReferences(Object[] src, int srcOffset, Object[] dst, int dstOffset, int length) {
        int edi;
        if (length <= 0) {
            return;
        }
        if (src == null) {
            throw new NullPointerException("Array.copyReferences: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (dst == null) {
            throw new NullPointerException("Array.copyReferences: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = srcOffset + length;
        int len = src.length;
        if (lim > len || lim < srcOffset || srcOffset > len || srcOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copyReferences: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        lim = dstOffset + length;
        len = dst.length;
        if (lim > len || lim < dstOffset || dstOffset > len || dstOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.copyReferences: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        int esi = Array.getFirstElementAddress(src) + (srcOffset << 2);
        if (esi >= (edi = Array.getFirstElementAddress(dst) + (dstOffset << 2))) {
            while (length-- > 0) {
                dst[dstOffset++] = src[srcOffset++];
            }
            return;
        }
        srcOffset += length;
        dstOffset += length;
        while (length-- > 0) {
            dst[--dstOffset] = src[--srcOffset];
        }
    }

    public static void fill(boolean[] dst, int offset, int length, boolean value) {
        if (length <= 0) {
            return;
        }
        if (dst == null) {
            throw new NullPointerException("Array.fill: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.fill: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        MalikSystem.arrayfill_byte(dst, offset, length, value ? 1 : 0);
    }

    public static void fill(char[] dst, int offset, int length, int value) {
        if (length <= 0) {
            return;
        }
        if (dst == null) {
            throw new NullPointerException("Array.fill: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.fill: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        MalikSystem.arrayfill_short(dst, offset, length, value);
    }

    public static void fill(float[] dst, int offset, int length, float value) {
        if (length <= 0) {
            return;
        }
        if (dst == null) {
            throw new NullPointerException("Array.fill: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.fill: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        MalikSystem.arrayfill_int(dst, offset, length, Float.floatToIntBits(value));
    }

    public static void fill(double[] dst, int offset, int length, double value) {
        if (length <= 0) {
            return;
        }
        if (dst == null) {
            throw new NullPointerException("Array.fill: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.fill: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        MalikSystem.arrayfill_long(dst, offset, length, Double.doubleToLongBits(value));
    }

    public static void fill(byte[] dst, int offset, int length, int value) {
        if (length <= 0) {
            return;
        }
        if (dst == null) {
            throw new NullPointerException("Array.fill: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.fill: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        MalikSystem.arrayfill_byte(dst, offset, length, value);
    }

    public static void fill(short[] dst, int offset, int length, int value) {
        if (length <= 0) {
            return;
        }
        if (dst == null) {
            throw new NullPointerException("Array.fill: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.fill: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        MalikSystem.arrayfill_short(dst, offset, length, value);
    }

    public static void fill(int[] dst, int offset, int length, int value) {
        if (length <= 0) {
            return;
        }
        if (dst == null) {
            throw new NullPointerException("Array.fill: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.fill: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        MalikSystem.arrayfill_int(dst, offset, length, value);
    }

    public static void fill(long[] dst, int offset, int length, long value) {
        if (length <= 0) {
            return;
        }
        if (dst == null) {
            throw new NullPointerException("Array.fill: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.fill: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        MalikSystem.arrayfill_long(dst, offset, length, value);
    }

    public static void fill(Object[] dst, int offset, int length, Object value) {
        Class srcType;
        Class dstType;
        if (length <= 0) {
            return;
        }
        if (dst == null) {
            throw new NullPointerException("Array.fill: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array.fill: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        if (value != null && !(dstType = dst.getClass().componentType).isAssignableFrom(srcType = value.getClass())) {
            throw new ArrayStoreException("Array.fill", dstType, srcType, false);
        }
        MalikSystem.arrayfill_object(dst, offset, length, value);
    }

    public static void checkIndex(String method, int arrayLength, int index) throws ArrayIndexOutOfBoundsException {
        if (index < 0 || index >= arrayLength) {
            throw new ArrayIndexOutOfBoundsException(new StringBuilder().append(method != null ? method.concat(": \u0438\u043d\u0434\u0435\u043a\u0441 ") : "\u0418\u043d\u0434\u0435\u043a\u0441 ").append(index).append(" \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.").toString(), true);
        }
    }

    public static void checkBound(String method, int arrayLength, int offset, int length) throws ArrayIndexOutOfBoundsException {
        int lim = offset + length;
        if (lim > arrayLength || lim < offset || offset > arrayLength || offset < 0) {
            throw new ArrayIndexOutOfBoundsException(method != null ? method.concat(": \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.") : "\u0418\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.", true);
        }
    }

    public static boolean isBoundValid(int objectLength, int offset, int length) {
        int lim = offset + length;
        return lim <= objectLength && lim >= offset && offset <= objectLength && offset >= 0;
    }

    public static int findf(boolean[] src, int startFromIndex, boolean value) {
        if (startFromIndex < 0) {
            startFromIndex = 0;
        }
        if (startFromIndex >= (src == null ? 0 : src.length)) {
            return startFromIndex;
        }
        return MalikSystem.arrayfindf_byte(src, startFromIndex, value ? 1 : 0);
    }

    public static int findf(char[] src, int startFromIndex, int value) {
        if (startFromIndex < 0) {
            startFromIndex = 0;
        }
        if (startFromIndex >= (src == null ? 0 : src.length)) {
            return startFromIndex;
        }
        return MalikSystem.arrayfindf_short(src, startFromIndex, value);
    }

    public static int findf(float[] src, int startFromIndex, float value) {
        if (startFromIndex < 0) {
            startFromIndex = 0;
        }
        if (startFromIndex >= (src == null ? 0 : src.length)) {
            return startFromIndex;
        }
        return MalikSystem.arrayfindf_float(src, startFromIndex, value);
    }

    public static int findf(double[] src, int startFromIndex, double value) {
        if (startFromIndex < 0) {
            startFromIndex = 0;
        }
        if (startFromIndex >= (src == null ? 0 : src.length)) {
            return startFromIndex;
        }
        return MalikSystem.arrayfindf_double(src, startFromIndex, value);
    }

    public static int findf(byte[] src, int startFromIndex, int value) {
        if (startFromIndex < 0) {
            startFromIndex = 0;
        }
        if (startFromIndex >= (src == null ? 0 : src.length)) {
            return startFromIndex;
        }
        return MalikSystem.arrayfindf_byte(src, startFromIndex, value);
    }

    public static int findf(short[] src, int startFromIndex, int value) {
        if (startFromIndex < 0) {
            startFromIndex = 0;
        }
        if (startFromIndex >= (src == null ? 0 : src.length)) {
            return startFromIndex;
        }
        return MalikSystem.arrayfindf_short(src, startFromIndex, value);
    }

    public static int findf(int[] src, int startFromIndex, int value) {
        if (startFromIndex < 0) {
            startFromIndex = 0;
        }
        if (startFromIndex >= (src == null ? 0 : src.length)) {
            return startFromIndex;
        }
        return MalikSystem.arrayfindf_int(src, startFromIndex, value);
    }

    public static int findf(long[] src, int startFromIndex, long value) {
        if (startFromIndex < 0) {
            startFromIndex = 0;
        }
        if (startFromIndex >= (src == null ? 0 : src.length)) {
            return startFromIndex;
        }
        return MalikSystem.arrayfindf_long(src, startFromIndex, value);
    }

    public static int findf(Object[] src, int startFromIndex, Object value) {
        if (startFromIndex < 0) {
            startFromIndex = 0;
        }
        if (startFromIndex >= (src == null ? 0 : src.length)) {
            return startFromIndex;
        }
        return MalikSystem.arrayfindf_object(src, startFromIndex, value);
    }

    public static int findb(boolean[] src, int startFromIndex, boolean value) {
        int len = src == null ? 0 : src.length;
        if (startFromIndex >= len) {
            startFromIndex = len - 1;
        }
        return startFromIndex < 0 ? startFromIndex : MalikSystem.arrayfindb_byte(src, startFromIndex, value ? 1 : 0);
    }

    public static int findb(char[] src, int startFromIndex, int value) {
        int len = src == null ? 0 : src.length;
        if (startFromIndex >= len) {
            startFromIndex = len - 1;
        }
        return startFromIndex < 0 ? startFromIndex : MalikSystem.arrayfindb_short(src, startFromIndex, value);
    }

    public static int findb(float[] src, int startFromIndex, float value) {
        int len = src == null ? 0 : src.length;
        if (startFromIndex >= len) {
            startFromIndex = len - 1;
        }
        return startFromIndex < 0 ? startFromIndex : MalikSystem.arrayfindb_float(src, startFromIndex, value);
    }

    public static int findb(double[] src, int startFromIndex, double value) {
        int len = src == null ? 0 : src.length;
        if (startFromIndex >= len) {
            startFromIndex = len - 1;
        }
        return startFromIndex < 0 ? startFromIndex : MalikSystem.arrayfindb_double(src, startFromIndex, value);
    }

    public static int findb(byte[] src, int startFromIndex, int value) {
        int len = src == null ? 0 : src.length;
        if (startFromIndex >= len) {
            startFromIndex = len - 1;
        }
        return startFromIndex < 0 ? startFromIndex : MalikSystem.arrayfindb_byte(src, startFromIndex, value);
    }

    public static int findb(short[] src, int startFromIndex, int value) {
        int len = src == null ? 0 : src.length;
        if (startFromIndex >= len) {
            startFromIndex = len - 1;
        }
        return startFromIndex < 0 ? startFromIndex : MalikSystem.arrayfindb_short(src, startFromIndex, value);
    }

    public static int findb(int[] src, int startFromIndex, int value) {
        int len = src == null ? 0 : src.length;
        if (startFromIndex >= len) {
            startFromIndex = len - 1;
        }
        return startFromIndex < 0 ? startFromIndex : MalikSystem.arrayfindb_int(src, startFromIndex, value);
    }

    public static int findb(long[] src, int startFromIndex, long value) {
        int len = src == null ? 0 : src.length;
        if (startFromIndex >= len) {
            startFromIndex = len - 1;
        }
        return startFromIndex < 0 ? startFromIndex : MalikSystem.arrayfindb_long(src, startFromIndex, value);
    }

    public static int findb(Object[] src, int startFromIndex, Object value) {
        int len = src == null ? 0 : src.length;
        if (startFromIndex >= len) {
            startFromIndex = len - 1;
        }
        return startFromIndex < 0 ? startFromIndex : MalikSystem.arrayfindb_object(src, startFromIndex, value);
    }

    public static int getFirstElementAddress(Object array) {
        if (array == null) {
            throw new NullPointerException("Array.getFirstElementAddress: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 array \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Array.getFirstElementAddress: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 array \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u043c.");
        }
        return array.getArrayAddress();
    }

    public static int getFirstElementAddress(String string) {
        if (string == null) {
            throw new NullPointerException("Array.getFirstElementAddress: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 string \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        return string.getCharsAddress();
    }

    public static long intersectBound(int objectLength, int offset, int length) {
        int beginIndex = offset < 0 ? 0 : (offset > objectLength ? objectLength : offset);
        int limit = offset + length;
        int endIndex = limit < 0 ? 0 : (limit > objectLength ? objectLength : limit);
        return beginIndex > endIndex ? (long)endIndex : (long)beginIndex | (long)(endIndex - beginIndex) << 32;
    }

    public static byte[] createSystemByteArray(int address, int arrayLength) {
        if (arrayLength < 0) {
            throw new NegativeArraySizeException("Array.createSystemByteArray: \u0434\u043b\u0438\u043d\u0430 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0439.");
        }
        Memory.checkSize((long)arrayLength + 16L);
        if (Memory.isHeapAddress(address, address + arrayLength)) {
            throw new IllegalArgumentException("Array.createSystemByteArray: \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432, \u0437\u0430\u043d\u0438\u043c\u0430\u0435\u043c\u044b\u0445 \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u043c, \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0442\u044c\u0441\u044f \u0441 \u043a\u0443\u0447\u0435\u0439.");
        }
        byte[] result = (byte[])Memory.allocateInstanceOf(MalikSystem.getClassInstance("[B"), 16, arrayLength);
        int ref = MalikSystem.convertToReference(result);
        MalikSystem.setIntAt(ref + 12, address - ref - 16);
        return result;
    }

    public static short[] createSystemShortArray(int address, int arrayLength) {
        if (arrayLength < 0) {
            throw new NegativeArraySizeException("Array.createSystemShortArray: \u0434\u043b\u0438\u043d\u0430 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0439.");
        }
        Memory.checkSize(((long)arrayLength << 1) + 16L);
        if (Memory.isHeapAddress(address, address + (arrayLength << 1))) {
            throw new IllegalArgumentException("Array.createSystemShortArray: \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432, \u0437\u0430\u043d\u0438\u043c\u0430\u0435\u043c\u044b\u0445 \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u043c, \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0442\u044c\u0441\u044f \u0441 \u043a\u0443\u0447\u0435\u0439.");
        }
        short[] result = (short[])Memory.allocateInstanceOf(MalikSystem.getClassInstance("[S"), 16, arrayLength);
        int ref = MalikSystem.convertToReference(result);
        MalikSystem.setIntAt(ref + 12, address - ref - 16);
        return result;
    }

    public static int[] createSystemIntArray(int address, int arrayLength) {
        if (arrayLength < 0) {
            throw new NegativeArraySizeException("Array.createSystemIntArray: \u0434\u043b\u0438\u043d\u0430 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0439.");
        }
        Memory.checkSize(((long)arrayLength << 2) + 16L);
        if (Memory.isHeapAddress(address, address + (arrayLength << 2))) {
            throw new IllegalArgumentException("Array.createSystemIntArray: \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432, \u0437\u0430\u043d\u0438\u043c\u0430\u0435\u043c\u044b\u0445 \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u043c, \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0442\u044c\u0441\u044f \u0441 \u043a\u0443\u0447\u0435\u0439.");
        }
        int[] result = (int[])Memory.allocateInstanceOf(MalikSystem.getClassInstance("[I"), 16, arrayLength);
        int ref = MalikSystem.convertToReference(result);
        MalikSystem.setIntAt(ref + 12, address - ref - 16);
        return result;
    }

    public static long[] createSystemLongArray(int address, int arrayLength) {
        if (arrayLength < 0) {
            throw new NegativeArraySizeException("Array.createSystemLongArray: \u0434\u043b\u0438\u043d\u0430 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0439.");
        }
        Memory.checkSize(((long)arrayLength << 3) + 16L);
        if (Memory.isHeapAddress(address, address + (arrayLength << 3))) {
            throw new IllegalArgumentException("Array.createSystemLongArray: \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0430\u0434\u0440\u0435\u0441\u043e\u0432, \u0437\u0430\u043d\u0438\u043c\u0430\u0435\u043c\u044b\u0445 \u043c\u0430\u0441\u0441\u0438\u0432\u043e\u043c, \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0442\u044c\u0441\u044f \u0441 \u043a\u0443\u0447\u0435\u0439.");
        }
        long[] result = (long[])Memory.allocateInstanceOf(MalikSystem.getClassInstance("[J"), 16, arrayLength);
        int ref = MalikSystem.convertToReference(result);
        MalikSystem.setIntAt(ref + 12, address - ref - 16);
        return result;
    }

    public static Object create(int arrayLength, Class arrayType) {
        if (arrayType == null) {
            throw new NullPointerException("Array.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 arrayType \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Class arrayComponentType = arrayType.componentType;
        if (arrayComponentType == null) {
            throw new IllegalArgumentException("Array.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 arrayType \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u043b\u0430\u0441\u0441\u043e\u043c \u043c\u0430\u0441\u0441\u0438\u0432\u0430.");
        }
        if (arrayLength < 0) {
            throw new NegativeArraySizeException("Array.create: \u0434\u043b\u0438\u043d\u0430 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0439.");
        }
        long refSize = arrayComponentType == MalikSystem.getClassInstance("Z") || arrayComponentType == MalikSystem.getClassInstance("B") ? (long)arrayLength : (arrayComponentType == MalikSystem.getClassInstance("C") || arrayComponentType == MalikSystem.getClassInstance("S") ? (long)arrayLength << 1 : (arrayComponentType == MalikSystem.getClassInstance("F") || arrayComponentType == MalikSystem.getClassInstance("I") ? (long)arrayLength << 2 : (arrayComponentType == MalikSystem.getClassInstance("D") || arrayComponentType == MalikSystem.getClassInstance("J") ? (long)arrayLength << 3 : (long)arrayLength << 2)));
        Memory.checkSize(refSize += 16L);
        return Memory.allocateInstanceOf(arrayType, (int)refSize, arrayLength);
    }

    public static Object create(int[] arrayLengths, Class arrayType) {
        int len;
        if (arrayType == null) {
            throw new NullPointerException("Array.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 arrayType \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException("Array.create: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 arrayType \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u043b\u0430\u0441\u0441\u043e\u043c \u043c\u0430\u0441\u0441\u0438\u0432\u0430.");
        }
        if (arrayType.getArrayDimensionsQuantity() < (len = arrayLengths == null ? 0 : arrayLengths.length)) {
            throw new IllegalArgumentException("Array.create: \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0439 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0440\u0435\u0431\u0443\u0435\u043c\u043e\u043c\u0443.");
        }
        if (len <= 0) {
            throw new IllegalArgumentException("Array.create: \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0439 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0443\u043b\u0435\u0432\u044b\u043c.");
        }
        int[] dim = new int[len];
        MalikSystem.arraycopyf_int(arrayLengths, 0, dim, 0, len);
        int i = len;
        while (i-- > 0) {
            if (dim[i] >= 0) continue;
            throw new NegativeArraySizeException("Array.create: \u0434\u043b\u0438\u043d\u0430 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0439.");
        }
        return len > 1 ? Array.createSubArray(dim, len, arrayType) : Array.create(dim[0], arrayType);
    }

    private static Object createSubArray(int[] dim, int dimCount, Class arrayType) {
        if (dimCount == 1) {
            return Array.create(dim[dim.length - 1], arrayType);
        }
        int len = dim[dim.length - dimCount--];
        Object[] result = (Object[])Array.create(len, arrayType);
        Class component = arrayType.componentType;
        int i = len;
        while (i-- > 0) {
            result[i] = Array.createSubArray(dim, dimCount, component);
        }
        return result;
    }

    private Array() {
    }
}

