/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.TimerTask;

public final class TimerThread
extends Thread {
    private static final Object LOCK = new Object();
    private boolean terminated;
    private int count;
    private TimerTask[] queue = new TimerTask[16];
    private Object lock = new Object();

    TimerThread() {
        super("\u041f\u043e\u0442\u043e\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u0439 \u0442\u0430\u0439\u043c\u0435\u0440\u0430");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object monitor = this.lock;
        while (true) {
            boolean fixedRate;
            this.waitTimer();
            if (this.terminated) break;
            TimerTask task = this.extract();
            if (task == null) continue;
            boolean mustContinue = false;
            Object object = monitor;
            synchronized (object) {
                fixedRate = task.fixedRate;
                if (task.state != 1) {
                    task.owner = null;
                    mustContinue = true;
                } else {
                    task.shedExecutionTime = task.nextExecutionTime;
                    if (fixedRate) {
                        task.nextExecutionTime = System.currentTimeMillis() + task.period;
                    }
                    task.state = 2;
                }
            }
            if (mustContinue) continue;
            try {
                task.run();
            }
            catch (RuntimeException e) {
                e.printRealStackTrace();
            }
            object = monitor;
            synchronized (object) {
                if (task.state != 2) {
                    task.owner = null;
                } else {
                    if (!fixedRate) {
                        task.nextExecutionTime = System.currentTimeMillis() + task.period;
                    }
                    if (task.periodic) {
                        task.state = 1;
                        this.pushTask(task);
                    } else {
                        task.state = 3;
                        task.owner = null;
                    }
                }
            }
        }
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        Object monitor;
        Object object = monitor = this.lock;
        synchronized (monitor) {
            this.terminated = true;
            monitor.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(TimerTask task, long time) {
        Object monitor;
        boolean error = false;
        Object object = LOCK;
        synchronized (object) {
            if (task.state != 0) {
                error = true;
            } else {
                task.periodic = false;
                task.fixedRate = false;
                task.state = 1;
                task.period = 0L;
            }
        }
        if (error) {
            throw new IllegalStateException("Timer.schedule: \u0437\u0430\u0434\u0430\u0447\u0430 \u0443\u0436\u0435 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043b\u0430\u0441\u044c \u0440\u0430\u043d\u043d\u0435\u0435.");
        }
        object = monitor = this.lock;
        synchronized (monitor) {
            task.nextExecutionTime = time;
            task.owner = this;
            this.pushTask(task);
            monitor.notify();
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(TimerTask task, long time, long period, boolean fixedRate) {
        Object monitor;
        boolean error = false;
        Object object = LOCK;
        synchronized (object) {
            if (task.state != 0) {
                error = true;
            } else {
                task.periodic = true;
                task.fixedRate = fixedRate;
                task.state = 1;
                task.period = Math.max(0L, period);
            }
        }
        if (error) {
            throw new IllegalStateException((fixedRate ? "Timer.scheduleAtFixedRate" : "Timer.schedule").concat(": \u0437\u0430\u0434\u0430\u0447\u0430 \u0443\u0436\u0435 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043b\u0430\u0441\u044c \u0440\u0430\u043d\u043d\u0435\u0435."));
        }
        object = monitor = this.lock;
        synchronized (monitor) {
            task.nextExecutionTime = time;
            task.owner = this;
            this.pushTask(task);
            monitor.notify();
            // ** MonitorExit[var9_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancel(TimerTask task) {
        Object monitor;
        Object object = monitor = this.lock;
        synchronized (monitor) {
            boolean result;
            if (task.owner != this) {
                result = false;
            } else {
                result = task.periodic || task.state == 1;
                int index = this.indexOf(task);
                if (index < 0) {
                    task.state = 3;
                } else {
                    Object[] queue = this.queue;
                    int count = this.count;
                    if (index < count - 1) {
                        Array.copy(queue, index + 1, queue, index, count - index - 1);
                    }
                    this.count = count - 1;
                    queue[this.count] = null;
                    task.state = 3;
                    task.owner = null;
                    monitor.notify();
                }
            }
            // ** MonitorExit[var7_3] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitTimer() {
        Object monitor;
        Object object = monitor = this.lock;
        synchronized (monitor) {
            while (true) {
                int count = this.count;
                TimerTask[] queue = this.queue;
                try {
                    long millis;
                    if (count > 0 && (millis = queue[count - 1].nextExecutionTime - System.currentTimeMillis()) > 0L) {
                        monitor.wait(millis);
                        break;
                    }
                    if (count != 0) break;
                    monitor.wait();
                }
                catch (InterruptedException e) {
                    e.printRealStackTrace();
                    continue;
                }
                break;
            }
            // ** MonitorExit[var6_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        TimerTask[] queue = this.queue;
        Object object = this.lock;
        synchronized (object) {
            int i = this.count;
            while (i-- > 0) {
                TimerTask task = queue[i];
                queue[i].state = 3;
                task.owner = null;
                queue[i] = null;
            }
            this.count = 0;
        }
    }

    private void pushTask(TimerTask task) {
        int count = this.count;
        Object[] queue = this.queue;
        if (count == this.queue.length) {
            Object[] objectArray = queue;
            this.queue = new TimerTask[count << 1];
            queue = this.queue;
            Array.copy(objectArray, 0, this.queue, 0, count);
        }
        long time = task.nextExecutionTime;
        int index = count;
        int i = 0;
        while (i < count) {
            if (((TimerTask)queue[i]).nextExecutionTime <= time) {
                index = i;
                break;
            }
            ++i;
        }
        if (index < count) {
            Array.copy(queue, index, queue, index + 1, count - index);
        }
        queue[index] = task;
        this.count = count + 1;
    }

    private int indexOf(TimerTask task) {
        TimerTask[] queue = this.queue;
        int i = this.count;
        while (i-- > 0) {
            if (queue[i] != task) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TimerTask extract() {
        Object object = this.lock;
        synchronized (object) {
            int count = this.count;
            if (count <= 0) return null;
            TimerTask[] queue = this.queue;
            TimerTask result = this.queue[count - 1];
            if (result.nextExecutionTime > System.currentTimeMillis()) return null;
            this.count = count - 1;
            queue[this.count] = null;
            return result;
        }
    }
}

