/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import malik.emulator.util.DataDescriptor;

public class FileInputStream
extends InputStream {
    private static final int OPEN_ERROR_NO_ERROR = 0;
    private static final int OPEN_ERROR_FILE_NAME_NOT_SPECIFIED = 1;
    private static final int OPEN_ERROR_FILE_ACCESS_DENIED = 2;
    private int handle;
    private int openError;
    private long position;
    private long size;
    private Object lock;
    private String fileName;
    private DataDescriptor descriptor;

    public FileInputStream(String fileName) {
        int h;
        if (fileName == null || (h = fileName.length()) == 0) {
            this.handle = 0;
            this.openError = 1;
            this.position = 0L;
            this.size = 0L;
            this.lock = new Object();
            this.fileName = fileName;
            this.descriptor = null;
            return;
        }
        char[] fn = new char[h + 1];
        fileName.getChars(0, h, fn, 0);
        h = (int)MalikSystem.syscall(Array.getFirstElementAddress(fn), 1, 16);
        if (h == 0) {
            this.handle = 0;
            this.openError = 2;
            this.position = 0L;
            this.size = 0L;
            this.lock = new Object();
            this.fileName = fileName;
            this.descriptor = null;
            return;
        }
        this.handle = h;
        this.openError = 0;
        this.position = 0L;
        this.size = MalikSystem.syscall((long)h, 21);
        this.lock = new Object();
        this.fileName = fileName;
        this.descriptor = new DataDescriptor();
    }

    public String toString() {
        return (this.handle != 0 ? "\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b " : "\u0417\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u0444\u0430\u0439\u043b ").concat(this.fileName);
    }

    public void checkOpenError() throws IOException {
        switch (this.openError) {
            default: {
                if (this.handle != 0) {
                    return;
                }
                throw new IOException("FileInputStream: \u0444\u0430\u0439\u043b " + this.fileName + " \u0431\u044b\u043b \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 1: {
                throw new IOException("FileInputStream: \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e.");
            }
            case 2: 
        }
        throw new IOException("FileInputStream: \u0444\u0430\u0439\u043b " + this.fileName + " \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f.");
    }

    public boolean hasOpenError() {
        return this.openError != 0 || this.handle == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        boolean error = false;
        Object object = this.lock;
        synchronized (object) {
            int h = this.handle;
            if (h == 0) {
                error = true;
            } else {
                MalikSystem.syscall((long)h, 17);
                this.handle = 0;
            }
        }
        if (error) {
            throw new IOException("FileInputStream: \u0444\u0430\u0439\u043b " + this.fileName + " \u0431\u044b\u043b \u0437\u0430\u043a\u0440\u044b\u0442.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkOpenError();
            int h = this.handle;
            long z = 0L;
            z = this.position - MalikSystem.syscall(h, MalikSystem.getLocalVariableAddress(z), 20);
            MalikSystem.syscall(h, MalikSystem.getLocalVariableAddress(z), 20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mark(int readLimit) {
        Object object = this.lock;
        synchronized (object) {
            int h = this.handle;
            if (h != 0) {
                long z = 0L;
                this.position = MalikSystem.syscall(h, MalikSystem.getLocalVariableAddress(z), 20);
            }
        }
    }

    public final boolean markSupported() {
        return this.handle != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read() throws IOException {
        int result;
        Object object = this.lock;
        synchronized (object) {
            this.checkOpenError();
            result = 0;
            this.descriptor.setDataInfo(MalikSystem.getLocalVariableAddress(result), 1);
            if (this.readFile() != 1) {
                result = -1;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(byte[] dst) throws IOException {
        int result;
        if (dst == null) {
            throw new NullPointerException("FileInputStream.read: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkOpenError();
            int length = dst.length;
            if (length <= 0) {
                result = 0;
            } else {
                this.descriptor.setDataInfo(dst, 0, length);
                result = this.readFile();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int read(byte[] dst, int offset, int length) throws IOException {
        int result;
        if (dst == null) {
            throw new NullPointerException("FileInputStream.read: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 dst \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        int lim = offset + length;
        int len = dst.length;
        if (lim > len || lim < offset || offset > len || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("FileInputStream.read: \u0438\u043d\u0434\u0435\u043a\u0441 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0438\u0437 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkOpenError();
            if (length <= 0) {
                result = 0;
            } else {
                this.descriptor.setDataInfo(dst, offset, length);
                result = this.readFile();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int available() throws IOException {
        int result;
        Object object = this.lock;
        synchronized (object) {
            this.checkOpenError();
            long z = 0L;
            result = (int)Math.min(Integer.MAX_VALUE, this.size - MalikSystem.syscall(this.handle, MalikSystem.getLocalVariableAddress(z), 20));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long skip(long bytesCount) throws IOException {
        long result;
        Object object = this.lock;
        synchronized (object) {
            this.checkOpenError();
            result = 0L;
            if (bytesCount > 0L) {
                int h = this.handle;
                long z = 0L;
                result = -MalikSystem.syscall(h, MalikSystem.getLocalVariableAddress(z), 20) + MalikSystem.syscall(h, MalikSystem.getLocalVariableAddress(bytesCount), 20);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long seek(long offset) throws IOException {
        long result;
        Object object = this.lock;
        synchronized (object) {
            this.checkOpenError();
            result = MalikSystem.syscall(this.handle, MalikSystem.getLocalVariableAddress(offset), 20);
        }
        return result;
    }

    public final long getSize() {
        return this.size;
    }

    public final String getFileName() {
        return this.fileName;
    }

    protected void $finalize$() {
        int h = this.handle;
        if (h != 0) {
            MalikSystem.syscall((long)h, 17);
            this.handle = 0;
        }
    }

    private int readFile() throws InterruptedIOException {
        int h = this.handle;
        long z = 0L;
        DataDescriptor d = this.descriptor;
        int remaining = (int)Math.min(Integer.MAX_VALUE, this.size - MalikSystem.syscall(h, MalikSystem.getLocalVariableAddress(z), 20));
        int readed = (int)MalikSystem.syscall(h, d.getDescriptorAddress(), 18);
        int length = d.getLength();
        if (readed != remaining && readed != length) {
            throw new InterruptedIOException("FileInputStream.read: \u043f\u0440\u043e\u0446\u0435\u0441\u0441 \u0447\u0442\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 " + this.fileName + " \u0431\u044b\u043b \u043f\u0440\u0435\u0440\u0432\u0430\u043d. \u041f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043e \u0431\u0430\u0439\u0442: " + readed + " \u0438\u0437 " + Math.min(remaining, length) + ".", readed);
        }
        return remaining == 0 ? -1 : readed;
    }
}

