/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

final class StringPool {
    private static final int LENGTH;
    private static final byte[][] CODES;
    private static final String[] STRINGS;

    static {
        int address = Memory.getStringPoolOffset();
        int length = MalikSystem.getIntAt(address);
        address += 4;
        LENGTH = length;
        byte[][] codes = new byte[length][];
        CODES = codes;
        STRINGS = new String[length];
        int i = 0;
        while (i < length) {
            codes[i] = StringPool.readArray(address);
            int size = codes[i].length;
            address += size + (-size & 3) + 20;
            ++i;
        }
        Memory.completeInit();
        Thread.completeInit();
    }

    public static int getLength() {
        return LENGTH;
    }

    public static String getString(int index) {
        if (index >= LENGTH || index < 0) {
            return null;
        }
        String[] strings = STRINGS;
        String result = STRINGS[index];
        if (result != null) {
            return result;
        }
        boolean flag = MalikSystem.enterMonopolyAccess();
        try {
            if (strings[index] == null) {
                strings[index] = result = (String)Memory.internIgnore(new String(CODES[index]));
            }
        }
        finally {
            MalikSystem.leaveMonopolyAccess(flag);
        }
        return result;
    }

    static boolean isMyOwnedObject(Object obj) {
        return obj == CODES || obj == STRINGS || Array.findf(STRINGS, 0, obj) < LENGTH;
    }

    static String intern(String string) {
        String[] strings = STRINGS;
        String result = string;
        int index = LENGTH;
        while (index-- > 0) {
            String current = strings[index];
            if (current == null || !current.equals(string)) continue;
            result = current;
            break;
        }
        return result;
    }

    private static byte[] readArray(int address) {
        return (byte[])MalikSystem.convertToObject(address + 4);
    }

    private StringPool() {
    }
}

