/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.i18n.encoding.system;

import malik.emulator.i18n.TextCodec;

public class UTF_8_Codec
implements TextCodec {
    public char[] decode(byte[] src, int offset, int length) {
        int newlength = 0;
        char[] result = new char[length];
        int lim = offset + length;
        while (offset < lim) {
            int char1 = src[offset++] & 0xFF;
            switch (char1 >> 4) {
                default: {
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    result[newlength++] = (char)char1;
                    break;
                }
                case 12: 
                case 13: {
                    int char2;
                    int n = char2 = offset >= length ? 128 : src[offset++];
                    if ((char2 & 0xC0) != 128) {
                        --offset;
                        char2 = 0;
                    }
                    result[newlength++] = (char)((char1 & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    int char3;
                    int char2;
                    int n = char2 = offset >= length ? 128 : src[offset++];
                    if ((char2 & 0xC0) != 128) {
                        --offset;
                        char2 = 0;
                    }
                    int n2 = char3 = offset >= length ? 128 : src[offset++];
                    if ((char3 & 0xC0) != 128) {
                        --offset;
                        char3 = 0;
                    }
                    result[newlength++] = (char)((char1 & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                }
            }
        }
        if (newlength < result.length) {
            char[] cArray = result;
            result = new char[newlength];
            Array.copy(cArray, 0, result, 0, newlength);
        }
        return result;
    }

    public byte[] encode(char[] src, int offset, int length) {
        int newlength = 0;
        byte[] result = new byte[3 * length];
        int lim = offset + length;
        while (offset < lim) {
            char character = src[offset];
            if (character > '\u0000' && character <= '\u007f') {
                result[newlength++] = (byte)character;
            } else if (character <= '\u07ff') {
                result[newlength++] = (byte)(192 + (character >> 6 & 0x1F));
                result[newlength++] = (byte)(128 + (character & 0x3F));
            } else {
                result[newlength++] = (byte)(224 + (character >> 12 & 0xF));
                result[newlength++] = (byte)(128 + (character >> 6 & 0x3F));
                result[newlength++] = (byte)(128 + (character & 0x3F));
            }
            ++offset;
        }
        if (newlength < result.length) {
            byte[] byArray = result;
            result = new byte[newlength];
            Array.copy(byArray, 0, result, 0, newlength);
        }
        return result;
    }
}

