/*
 * Decompiled with CFR 0.152.
 */
package malik.emulator.io.cloud;

import java.io.IOException;
import java.io.OutputStream;
import malik.emulator.io.vfs.ClosedFileException;
import malik.emulator.io.vfs.FileCreationException;
import malik.emulator.io.vfs.FileNotFoundException;
import malik.emulator.util.DataDescriptor;
import malik.emulator.util.StringBuilder;

public abstract class HandleOutputStream
extends OutputStream {
    private static final int NO_ERROR = 0;
    private static final int FILE_NOT_FOUND = 1;
    private static final int FILE_UNABLE_TO_CREATE = 2;
    private static final int FILE_NAME_NOT_SPECIFIED = 3;
    private static final int BUFFER_SIZE = 512;
    private final int openError;
    private final int address;
    int handle;
    int position;
    private final byte[] buffer;
    private final String fileName;
    final DataDescriptor descriptor;

    HandleOutputStream(String fileName, int access) {
        int e;
        int h;
        int len;
        if (fileName == null || (len = fileName.length()) <= 0) {
            h = 0;
            e = 3;
        } else {
            char[] name = new char[len + 1];
            fileName.getChars(0, len, name, 0);
            h = (int)MalikSystem.syscall(Array.getFirstElementAddress(name), access, 16);
            e = h == 0 ? (access == 0 || access == 3 ? 1 : 2) : 0;
        }
        if (h == 0) {
            this.openError = e;
            this.address = 0;
            this.buffer = null;
            this.fileName = fileName;
            this.descriptor = null;
            return;
        }
        byte[] buffer = new byte[512];
        this.openError = 0;
        this.address = Array.getFirstElementAddress(buffer);
        this.handle = h;
        this.buffer = buffer;
        this.fileName = fileName;
        this.descriptor = new DataDescriptor();
    }

    HandleOutputStream(String fileName, DataDescriptor descriptor, int handle) {
        if (descriptor == null) {
            descriptor = new DataDescriptor();
        }
        byte[] buffer = new byte[512];
        this.openError = 0;
        this.address = Array.getFirstElementAddress(buffer);
        this.handle = handle;
        this.buffer = buffer;
        this.fileName = fileName;
        this.descriptor = descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        this.checkOpenError();
        int error = 0;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            if (this.handle == 0) {
                error = 1;
            } else {
                int bufferPosition = this.position;
                if (bufferPosition > 0) {
                    this.position = 0;
                    if (!this.writeFile(bufferPosition)) {
                        error = 2;
                    }
                }
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("HandleOutputStream.flush: \u0444\u0430\u0439\u043b\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0432\u044b\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IOException("HandleOutputStream.flush: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b\u0430.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int byteData) throws IOException {
        this.checkOpenError();
        int error = 0;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            if (this.handle == 0) {
                error = 1;
            } else {
                int bufferPosition = this.position;
                this.buffer[bufferPosition] = (byte)byteData;
                if ((this.position = ++bufferPosition) == 512) {
                    this.position = 0;
                    if (!this.writeFile(512)) {
                        error = 2;
                    }
                }
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("HandleOutputStream.write: \u0444\u0430\u0439\u043b\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0432\u044b\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IOException("HandleOutputStream.write: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b\u0430.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] src, int offset, int length) throws IOException {
        if (src == null) {
            throw new NullPointerException("HandleOutputStream.write: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 src \u0440\u0430\u0432\u0435\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0435.");
        }
        Array.checkBound("HandleOutputStream.write", src.length, offset, length);
        this.checkOpenError();
        int error = 0;
        DataDescriptor dataDescriptor = this.descriptor;
        synchronized (dataDescriptor) {
            block13: {
                if (this.handle == 0) {
                    error = 1;
                } else {
                    byte[] bufferContent = this.buffer;
                    int bufferPosition = this.position;
                    while (length > 0) {
                        int bufferRemainder = 512 - bufferPosition;
                        int writed = bufferRemainder <= length ? bufferRemainder : length;
                        Array.copy(src, offset, bufferContent, bufferPosition, writed);
                        if ((bufferPosition += writed) == 512) {
                            bufferPosition = 0;
                            if (!this.writeFile(512)) {
                                error = 2;
                                this.position = 0;
                                break block13;
                            }
                        }
                        offset += writed;
                        length -= writed;
                    }
                    this.position = bufferPosition;
                }
            }
        }
        switch (error) {
            case 1: {
                throw new ClosedFileException("HandleOutputStream.write: \u0444\u0430\u0439\u043b\u043e\u0432\u044b\u0439 \u043f\u043e\u0442\u043e\u043a \u0432\u044b\u0432\u043e\u0434\u0430 \u0437\u0430\u043a\u0440\u044b\u0442.");
            }
            case 2: {
                throw new IOException("HandleOutputStream.write: \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b\u0430.");
            }
        }
    }

    public String toString() {
        String name = this.fileName;
        return (this.handle != 0 ? "\u041e\u0442\u043a\u0440\u044b\u0442\u044b\u0439 \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438 \u0444\u0430\u0439\u043b " : "\u0417\u0430\u043a\u0440\u044b\u0442\u044b\u0439 \u0444\u0430\u0439\u043b ").concat(name != null && name.length() > 0 ? name : "<\u0438\u043c\u044f \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e>");
    }

    public void checkOpenError() throws IOException {
        String name = this.fileName;
        switch (this.openError) {
            case 1: {
                throw new FileNotFoundException(new StringBuilder().append("HandleOutputStream.checkOpenError: \u0444\u0430\u0439\u043b ").append(name).append(" \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u0437\u0430\u043d\u044f\u0442.").toString(), name);
            }
            case 2: {
                throw new FileCreationException(new StringBuilder().append("HandleOutputStream.checkOpenError: \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b ").append(name).append('.').toString(), name);
            }
            case 3: {
                throw new IOException("HandleOutputStream.checkOpenError: \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u043d\u0435 \u0431\u044b\u043b\u043e \u0437\u0430\u0434\u0430\u043d\u043e \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u044d\u0442\u043e\u0433\u043e \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440\u0430 HandleOutputStream.");
            }
        }
    }

    public boolean hasOpenError() {
        int e = this.openError;
        return e > 0 && e <= 3;
    }

    public final String getFileName() {
        return this.fileName;
    }

    final boolean writeFile(int length) {
        DataDescriptor descriptor = this.descriptor;
        descriptor.setDataInfo(this.address, length);
        return (int)MalikSystem.syscall(this.handle, descriptor.getDescriptorAddress(), 19) == length;
    }
}

